/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.adjustexch;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.arapcommon.service.adjustexch.AdjustExchHelper;
import kd.fi.arapcommon.service.adjustexch.BillHandler;
import kd.fi.arapcommon.service.adjustexch.BusApBillHandler;
import kd.fi.arapcommon.service.adjustexch.BusArBillHandler;
import kd.fi.arapcommon.service.adjustexch.FinApBillHandler;
import kd.fi.arapcommon.service.adjustexch.FinArBillHandler;
import kd.fi.arapcommon.service.adjustexch.PaidBillHandler;
import kd.fi.arapcommon.service.adjustexch.PaymentBillHandler;
import kd.fi.arapcommon.service.adjustexch.RecBillHandler;
import kd.fi.arapcommon.service.adjustexch.ReceivedBillHandler;

public class AdjExchBillHandlerFactory {
    public BillHandler getHandler(String entityKey) {
        switch (entityKey) {
            case "ap_finapbill": {
                return new FinApBillHandler();
            }
            case "ap_busbill": {
                return new BusApBillHandler();
            }
            case "ap_paidbill": {
                return new PaidBillHandler();
            }
            case "ar_finarbill": {
                return new FinArBillHandler();
            }
            case "ar_busbill": {
                return new BusArBillHandler();
            }
            case "ar_receivedbill": {
                return new ReceivedBillHandler();
            }
            case "cas_paybill": {
                return new PaymentBillHandler();
            }
            case "cas_recbill": {
                return new RecBillHandler();
            }
        }
        return null;
    }

    public static List<BillHandler> getExtBillHandler(Set<String> serviceName) {
        ArrayList<BillHandler> extHandlers = new ArrayList<BillHandler>(8);
        if (serviceName == null || serviceName.isEmpty()) {
            return extHandlers;
        }
        List<String> classNames = AdjustExchHelper.getExtHandlerClassName(serviceName);
        if (classNames.isEmpty()) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"%s\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u672a\u627e\u5230\u3002", (String)"AdjExchBillHandlerFactory_0", (String)"fi-arapcommon", (Object[])new Object[0]), serviceName));
        }
        try {
            for (String name : classNames) {
                extHandlers.add((BillHandler)Class.forName(name).newInstance());
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        return extHandlers;
    }
}

