/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.adjustexch;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.service.adjustexch.AdjustExchHelper;
import kd.fi.arapcommon.service.adjustexch.BillHandler;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.vo.adjexch.AdjustExchangeContext;
import kd.fi.arapcommon.vo.adjexch.CalculateVO;
import kd.fi.arapcommon.vo.adjexch.CommonBillVO;
import org.apache.commons.lang.StringUtils;

public class BusApBillHandler
extends BillHandler {
    protected static final Log logger = LogFactory.getLog(BusApBillHandler.class);

    public BusApBillHandler() {
    }

    public BusApBillHandler(AdjustExchangeContext context) {
        super(context);
    }

    @Override
    public List<CommonBillVO> getBillIds() {
        ArrayList<CommonBillVO> resultOfCommonBillVOS = new ArrayList<CommonBillVO>(32);
        HashMap<Object, CommonBillVO> temporaryVOMap = new HashMap<Object, CommonBillVO>(32);
        QFilter busFilter = this.getBusFilter();
        DataSet busDataSet = QueryServiceHelper.queryDataSet((String)"adjustexchange", (String)this.getEntityKey(), (String)"id,entry.id", (QFilter[])busFilter.toArray(), (String)"");
        String adjustBusSelector = this.getAdjustBusSelector();
        QFilter adjustBusFilter = this.getAdjustBusFilter();
        DataSet adjustBusDataSet = QueryServiceHelper.queryDataSet((String)"adjustexchange", (String)this.getEntityKey(), (String)adjustBusSelector, (QFilter[])adjustBusFilter.toArray(), (String)"");
        HashSet<Object> busbillIdSet = new HashSet<Object>(16);
        this.setInverseBills(this.convertAdjustBusBillToVO(adjustBusDataSet, busbillIdSet));
        DataSet unexpectedBusDataSet = null;
        if (EmptyUtils.isNotEmpty(busbillIdSet)) {
            QFilter unexpectedBusFilter = this.getUnexpectedBusFilter(busbillIdSet);
            unexpectedBusDataSet = QueryServiceHelper.queryDataSet((String)"adjustexchange", (String)this.getEntityKey(), (String)"id,entry.id", (QFilter[])unexpectedBusFilter.toArray(), (String)"");
        }
        String currentPeriodAdjustBusSelector = this.getCurrentPeriodAdjustBusSelector();
        QFilter currentPeriodAdjustBusFilter = this.getCurrentPeriodAdjustBusFliter(busbillIdSet);
        DataSet currentPeriodAdjustBusDataSet = QueryServiceHelper.queryDataSet((String)"adjustexchange", (String)this.getEntityKey(), (String)currentPeriodAdjustBusSelector, (QFilter[])currentPeriodAdjustBusFilter.toArray(), (String)"bizdate");
        this.getInverseBills().addAll(this.convertCurrentPeriodAdjustBusBillToVO(currentPeriodAdjustBusDataSet));
        QFilter specialBusFilter = this.getSpecialBusFilter();
        DataSet specialWoffBusEntryPKDataSet = QueryServiceHelper.queryDataSet((String)"adjustexchange", (String)this.getEntityKey(), (String)"id,entry.id,sourcebillid", (QFilter[])specialBusFilter.toArray(), (String)"bookdate");
        HashSet<Long> woffSourceBillIds = new HashSet<Long>(8);
        HashSet<Long> woffBillIds = new HashSet<Long>(8);
        this.handleIdSet(specialWoffBusEntryPKDataSet, woffSourceBillIds, woffBillIds);
        QFilter unexpectedSpecialBusFilter = this.getUnexpectedSpecialBusFilter(busbillIdSet);
        DataSet unexpectedSpecialBusDataSet = QueryServiceHelper.queryDataSet((String)"adjustexchange", (String)this.getEntityKey(), (String)"id,entry.id,sourcebillid", (QFilter[])unexpectedSpecialBusFilter.toArray(), (String)"");
        this.handleIdSet(unexpectedSpecialBusDataSet, woffSourceBillIds, woffBillIds);
        QFilter specialBusSourceFinBillFilter = this.getSpecialBusSourceFinBillFilter(woffSourceBillIds);
        DataSet specialBusEntryPKDataSet = QueryServiceHelper.queryDataSet((String)"adjustexchange", (String)this.getEntityKey(), (String)"id", (QFilter[])specialBusSourceFinBillFilter.toArray(), (String)"bizdate");
        Set<Object> busSourceBillIds = this.getBusSourceBillIds(specialBusEntryPKDataSet);
        QFilter needAdjExchSpecialBusFilter = this.getNeedAdjExchSpecialBusFilter(woffBillIds, busSourceBillIds);
        DataSet needAdjExchSpecialBusBill = QueryServiceHelper.queryDataSet((String)"adjustexchange", (String)this.getEntityKey(), (String)"id, entry.id", (QFilter[])needAdjExchSpecialBusFilter.toArray(), (String)"");
        this.buildCommonBillVOByBus(busDataSet, temporaryVOMap);
        this.buildCommonBillVOByBus(unexpectedBusDataSet, temporaryVOMap);
        this.buildCommonBillVOByBus(needAdjExchSpecialBusBill, temporaryVOMap);
        resultOfCommonBillVOS.addAll(new ArrayList(temporaryVOMap.values()));
        return resultOfCommonBillVOS;
    }

    @Override
    public Map<Object, CalculateVO> getBills(List<CommonBillVO> subBillIds) {
        List<String> selector = this.getSelector();
        QFilter idAndEntryIdFilter = this.getFilterByCommonBillVO(subBillIds);
        DataSet busDataSet = QueryServiceHelper.queryDataSet((String)"adjustexchange", (String)this.getEntityKey(), (String)AdjustExchHelper.generateSelector(selector), (QFilter[])idAndEntryIdFilter.toArray(), (String)"bizdate");
        return this.convertBusBillToVO(busDataSet);
    }

    @Override
    public Map<Object, CalculateVO> getProcessBills() {
        HashMap<Object, CalculateVO> processBillVOMap = new HashMap<Object, CalculateVO>(64);
        List<CalculateVO> calculateVOS = this.getInverseBills();
        for (CalculateVO calculateVO : calculateVOS) {
            CalculateVO vo = (CalculateVO)processBillVOMap.get(calculateVO.getBillEntryId());
            if (vo != null) {
                vo.getWoffBillEntryIdSet().add(calculateVO.getWoffBillEntryId());
                vo.setBalance(vo.getBalance().add(calculateVO.getBalance()));
                vo.setLocalBalance(vo.getLocalBalance().add(calculateVO.getLocalBalance()));
                continue;
            }
            processBillVOMap.put(calculateVO.getBillEntryId(), calculateVO);
        }
        for (Map.Entry entry : processBillVOMap.entrySet()) {
            CalculateVO calculateVO = (CalculateVO)entry.getValue();
            this.recursionWoffBill(processBillVOMap, calculateVO, calculateVO);
        }
        return processBillVOMap;
    }

    private void recursionWoffBill(Map<Object, CalculateVO> calculateVOMap, CalculateVO recursionVO, CalculateVO calculateVO) {
        Set<Long> woffBillEntryIdSet = recursionVO.getWoffBillEntryIdSet();
        woffBillEntryIdSet.add(recursionVO.getWoffBillEntryId());
        for (Long woffBillEntryId : woffBillEntryIdSet) {
            CalculateVO woffVO = calculateVOMap.get(woffBillEntryId);
            if (woffVO == null) continue;
            this.recursionWoffBill(calculateVOMap, woffVO, calculateVO);
            calculateVO.setBalance(calculateVO.getBalance().add(woffVO.getBalance()));
            calculateVO.setLocalBalance(calculateVO.getLocalBalance().add(woffVO.getLocalBalance()));
        }
    }

    @Override
    public List<String> getOriginSelector() {
        List<String> selector = BusApBillHandler.getBaseBillSelector();
        selector.add("isadjust");
        selector.add("entry.id");
        selector.add("entry.e_material");
        selector.add("entry.e_expenseitem");
        selector.add("entry.project");
        selector.add("entry.e_unwoffamt");
        selector.add("entry.e_unwofflocamt");
        return selector;
    }

    @Override
    public String getEntityKey() {
        return "ap_busbill";
    }

    private QFilter getBusFilter() {
        QFilter filter;
        if (this.context.isPeriod()) {
            filter = new QFilter("org", "=", (Object)this.context.getOrgId());
            filter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
            filter.and(new QFilter("currency", "<>", (Object)this.context.getStandardCurrencyId()));
            filter.and(new QFilter("isperiod", "=", (Object)Boolean.TRUE));
            filter.and(new QFilter("isadjust", "=", (Object)Boolean.FALSE));
            filter.and(new QFilter("entry.e_unwoffamt", "<>", (Object)0));
        } else {
            filter = new QFilter("org", "=", (Object)this.context.getOrgId());
            filter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
            filter.and(new QFilter("bookdate", "<=", (Object)this.context.getEndDate()));
            filter.and(new QFilter("currency", "<>", (Object)this.context.getStandardCurrencyId()));
            filter.and(new QFilter("isadjust", "=", (Object)Boolean.FALSE));
            filter.and(new QFilter("entry.e_unwoffamt", "<>", (Object)0));
        }
        return filter;
    }

    private String getAdjustBusSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("id");
        selector.add("entry.id");
        selector.add("entry.e_srcbillid");
        selector.add("entry.e_srcentryid");
        selector.add("entry.e_pricetaxtotal");
        selector.add("entry.e_pricetaxtotalbase");
        return StringUtils.join((Object[])selector.toArray(), (String)",");
    }

    private QFilter getAdjustBusFilter() {
        QFilter filter = new QFilter("org", "=", (Object)this.context.getOrgId());
        filter.and(new QFilter("isadjust", "=", (Object)Boolean.TRUE));
        filter.and(new QFilter("bookdate", ">", (Object)this.context.getEndDate()));
        filter.and(new QFilter("currency", "<>", (Object)this.context.getStandardCurrencyId()));
        filter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        return filter;
    }

    private QFilter getUnexpectedBusFilter(Set<Object> busbillIdSet) {
        QFilter filter = new QFilter("org", "=", (Object)this.context.getOrgId());
        filter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        filter.and(new QFilter("bookdate", "<=", (Object)this.context.getEndDate()));
        filter.and(new QFilter("isadjust", "=", (Object)Boolean.FALSE));
        filter.and(new QFilter("entry.id", "in", busbillIdSet));
        return filter;
    }

    private List<CalculateVO> convertAdjustBusBillToVO(DataSet adjustBusDataSet, Set<Object> busbillIdSet) {
        ArrayList<CalculateVO> voList = new ArrayList<CalculateVO>(8);
        if (adjustBusDataSet != null) {
            for (Row row : adjustBusDataSet) {
                CalculateVO vo = new CalculateVO();
                vo.setBillType("ap_busbill");
                vo.setWoffBillEntryId(row.getLong("entry.id"));
                vo.setBillId(row.getLong("entry.e_srcbillid"));
                vo.setBillEntryId(row.getLong("entry.e_srcentryid"));
                vo.setBalance(row.getBigDecimal("entry.e_pricetaxtotal"));
                vo.setLocalBalance(row.getBigDecimal("entry.e_pricetaxtotalbase"));
                voList.add(vo);
                busbillIdSet.add(row.get("entry.e_srcentryid"));
            }
        }
        return voList;
    }

    private String getCurrentPeriodAdjustBusSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("id");
        selector.add("entry.id");
        selector.add("entry.e_srcbillid");
        selector.add("entry.e_srcentryid");
        selector.add("entry.e_pricetaxtotal");
        selector.add("entry.e_pricetaxtotalbase");
        return StringUtils.join((Object[])selector.toArray(), (String)",");
    }

    private QFilter getCurrentPeriodAdjustBusFliter(Set<Object> busbillIdSet) {
        QFilter filter = new QFilter("org", "=", (Object)this.context.getOrgId());
        filter.and(new QFilter("entry.id", "in", busbillIdSet));
        filter.and(new QFilter("bookdate", "<=", (Object)this.context.getEndDate()));
        filter.and(new QFilter("isadjust", "=", (Object)Boolean.TRUE));
        filter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        return filter;
    }

    private Set<CalculateVO> convertCurrentPeriodAdjustBusBillToVO(DataSet currentPeriodAdjustBusDataSet) {
        HashSet<CalculateVO> voList = new HashSet<CalculateVO>(64);
        if (currentPeriodAdjustBusDataSet != null) {
            for (Row row : currentPeriodAdjustBusDataSet) {
                CalculateVO vo = new CalculateVO();
                vo.setBillType("ap_busbill");
                vo.setWoffBillEntryId(row.getLong("entry.id"));
                vo.setBillId(row.getLong("entry.e_srcbillid"));
                vo.setBillEntryId(row.getLong("entry.e_srcentryid"));
                vo.setBalance(BigDecimal.ZERO);
                vo.setLocalBalance(BigDecimal.ZERO);
                voList.add(vo);
            }
        }
        return voList;
    }

    private QFilter getSpecialBusFilter() {
        QFilter filter = new QFilter("org", "=", (Object)this.context.getOrgId());
        filter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        filter.and(new QFilter("bookdate", "<=", (Object)this.context.getEndDate()));
        filter.and(new QFilter("currency", "<>", (Object)this.context.getStandardCurrencyId()));
        filter.and(new QFilter("isadjust", "=", (Object)Boolean.TRUE));
        filter.and(new QFilter("entry.e_unwoffamt", "<>", (Object)0));
        return filter;
    }

    private void handleIdSet(DataSet dataSet, Set<Long> woffSourceBillIds, Set<Long> woffBillIds) {
        if (EmptyUtils.isNotEmpty(dataSet)) {
            for (Row row : dataSet) {
                Long woffBillId = row.getLong("id");
                woffBillIds.add(woffBillId);
                String sourcebillid = row.getString("sourcebillid");
                if (!EmptyUtils.isNotEmpty(sourcebillid)) continue;
                Long woffSourceBillId = Long.parseLong(sourcebillid);
                woffSourceBillIds.add(woffSourceBillId);
            }
        }
    }

    private QFilter getUnexpectedSpecialBusFilter(Set<Object> busbillIdSet) {
        QFilter filter = new QFilter("entry.id", "in", busbillIdSet);
        filter.and(new QFilter("org", "=", (Object)this.context.getOrgId()));
        filter.and(new QFilter("bookdate", "<=", (Object)this.context.getEndDate()));
        return filter;
    }

    private QFilter getSpecialBusSourceFinBillFilter(Set<Long> woffSourceBillIds) {
        QFilter filter = new QFilter("id", "in", woffSourceBillIds);
        filter.and(new QFilter("bookdate", ">", (Object)this.context.getEndDate()));
        filter.and(new QFilter("isadjust", "=", (Object)Boolean.FALSE));
        return filter;
    }

    private Set<Object> getBusSourceBillIds(DataSet specialBusEntryPKDataSet) {
        HashSet<Object> busSourceBillIds = new HashSet<Object>(16);
        if (EmptyUtils.isNotEmpty(specialBusEntryPKDataSet)) {
            for (Row row : specialBusEntryPKDataSet) {
                busSourceBillIds.add(row.get("id"));
            }
        }
        return busSourceBillIds;
    }

    private QFilter getNeedAdjExchSpecialBusFilter(Set<Long> woffBillIds, Set<Object> busSourceBillIds) {
        QFilter filter = new QFilter("id", "in", woffBillIds);
        filter.and("entry.e_srcbillid", "in", busSourceBillIds);
        return filter;
    }

    private List<CommonBillVO> buildCommonBillVOByBus(DataSet busDataSet, Map<Object, CommonBillVO> temporaryVOMap) {
        if (EmptyUtils.isNotEmpty(busDataSet)) {
            for (Row row : busDataSet) {
                Object billId = row.get("id");
                Object entryId = row.get("entry.id");
                if (EmptyUtils.isEmpty(temporaryVOMap.get(billId))) {
                    CommonBillVO commonBillVO = new CommonBillVO(Long.parseLong(billId.toString()));
                    commonBillVO.getEntryIds().add(Long.parseLong(entryId.toString()));
                    temporaryVOMap.put(billId, commonBillVO);
                    continue;
                }
                temporaryVOMap.get(billId).getEntryIds().add(Long.parseLong(entryId.toString()));
            }
        }
        return new ArrayList<CommonBillVO>(temporaryVOMap.values());
    }

    private QFilter getFilterByCommonBillVO(List<CommonBillVO> subbillids) {
        HashSet<Long> idSet = new HashSet<Long>(subbillids.size());
        HashSet<Long> entryIdSet = new HashSet<Long>(subbillids.size());
        for (CommonBillVO commonBillVO : subbillids) {
            idSet.add(commonBillVO.getId());
            entryIdSet.addAll(commonBillVO.getEntryIds());
        }
        QFilter filter = new QFilter("id", "in", idSet);
        filter.and(new QFilter("entry.id", "in", entryIdSet));
        return filter;
    }

    private Map<Object, CalculateVO> convertBusBillToVO(DataSet busDataSet) {
        HashMap<Object, CalculateVO> billVOMap = new HashMap<Object, CalculateVO>(64);
        if (busDataSet != null) {
            for (Row row : busDataSet) {
                CalculateVO vo = new CalculateVO();
                vo.setBillType("ap_busbill");
                vo.setBillId(row.getLong("id"));
                vo.setBillEntryId(row.getLong("entry.id"));
                vo.setBillNo(row.getString("billno"));
                vo.setAsstactType(row.getString("asstacttype"));
                vo.setAsstactId(row.getLong("asstact"));
                vo.setDepartmentId(row.getLong("department"));
                vo.setRemark(row.getString("remark"));
                vo.setBizDate(row.getDate("bizdate"));
                vo.setCurrencyId(row.getLong("currency"));
                vo.setExrateTableId(row.getLong("exratetable"));
                vo.setLocalBalance(row.getBigDecimal("entry.e_unwofflocamt"));
                vo.setMaterialId(row.getLong("entry.e_material"));
                vo.setExpenseItemId(row.getLong("entry.e_expenseitem"));
                vo.setProjectId(row.getLong("entry.project"));
                vo.setBalance(row.getBigDecimal("entry.e_unwoffamt"));
                vo.setExchangeRate(row.getBigDecimal("exchangerate"));
                vo.setQuotation(this.getQuotation(vo.getBillNo(), row.getLong("exratetable"), row.getLong("currency")));
                vo.setSrcBillQuotation(row.getString("quotation"));
                vo.setCurExchangeRate(this.getCurExchangeRate(vo.getBillNo(), vo.getExrateTableId(), vo.getCurrencyId(), vo.getQuotation()));
                this.extendFieldVoluation(vo, row);
                billVOMap.put(vo.getBillEntryId(), vo);
            }
        }
        return billVOMap;
    }
}

