/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.adjustexch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.service.adjustexch.AdjustExchHelper;
import kd.fi.arapcommon.service.adjustexch.BillHandler;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.vo.adjexch.AdjustExchangeContext;
import kd.fi.arapcommon.vo.adjexch.CalculateVO;
import kd.fi.arapcommon.vo.adjexch.CommonBillVO;
import org.apache.commons.lang.StringUtils;

public class RecBillHandler
extends BillHandler {
    protected static final Log logger = LogFactory.getLog(RecBillHandler.class);

    public RecBillHandler() {
    }

    public RecBillHandler(AdjustExchangeContext context) {
        super(context);
    }

    @Override
    public List<CommonBillVO> getBillIds() {
        ArrayList<CommonBillVO> resultOfCommonBillVOS = new ArrayList<CommonBillVO>(32);
        HashMap<Object, CommonBillVO> temporaryVOMap = new HashMap<Object, CommonBillVO>(32);
        QFilter recFilter = this.getRecFilter();
        DataSet recDataSet = QueryServiceHelper.queryDataSet((String)"adjustexchange", (String)this.getEntityKey(), (String)"id,entry.id", (QFilter[])recFilter.toArray(), (String)"bizdate");
        String settleSelector = this.getSettleSelector();
        QFilter settleMainFilter = this.getSettleMainFilter();
        Object[] settleMainDatas = BusinessDataServiceHelper.load((String)"ap_settlerecord", (String)settleSelector, (QFilter[])settleMainFilter.toArray());
        Set<Object> settleMainDataSetIds = this.getSettleMainDataSetIds((DynamicObject[])settleMainDatas);
        QFilter settleAssistFilter = this.getSettleAssistFilter(settleMainDataSetIds);
        Object[] settleAssistDatas = BusinessDataServiceHelper.load((String)"ap_settlerecord", (String)settleSelector, (QFilter[])settleAssistFilter.toArray());
        DynamicObject[] settleRecordArr = (DynamicObject[])ArrayUtils.addAll((Object[])settleMainDatas, (Object[])settleAssistDatas);
        Set<Object> recBillIdSet = this.getIdOrEntryIdBySettle(settleRecordArr);
        this.setInverseBills(this.convertSettleBillToVO(settleRecordArr));
        DataSet unexpectedRecDataSet = null;
        if (!recBillIdSet.isEmpty()) {
            QFilter unexpectedRecFilter = this.getUnexpectedRecFilter(recBillIdSet);
            unexpectedRecDataSet = QueryServiceHelper.queryDataSet((String)"adjustexchange", (String)this.getEntityKey(), (String)"id,entry.id", (QFilter[])unexpectedRecFilter.toArray(), (String)"");
        }
        this.buildCommonBillVOByRec(recDataSet, temporaryVOMap);
        this.buildCommonBillVOByRec(unexpectedRecDataSet, temporaryVOMap);
        resultOfCommonBillVOS.addAll(new ArrayList(temporaryVOMap.values()));
        return resultOfCommonBillVOS;
    }

    @Override
    public Map<Object, CalculateVO> getBills(List<CommonBillVO> subBillIds) {
        List<String> selector = this.getSelector();
        QFilter idAndEntryIdFilter = this.getFilterByCommonBillVO(subBillIds);
        DataSet recDataSet = QueryServiceHelper.queryDataSet((String)"adjustexchange", (String)this.getEntityKey(), (String)AdjustExchHelper.generateSelector(selector), (QFilter[])idAndEntryIdFilter.toArray(), (String)"bizdate");
        return this.convertRecBillToVO(recDataSet);
    }

    @Override
    public Map<Object, CalculateVO> getProcessBills() {
        HashMap<Object, CalculateVO> processBillVOMap = new HashMap<Object, CalculateVO>(64);
        List<CalculateVO> calculateVOS = this.getInverseBills();
        for (CalculateVO calculateVO : calculateVOS) {
            CalculateVO vo = (CalculateVO)processBillVOMap.get(calculateVO.getBillEntryId());
            if (vo != null) {
                vo.setBalance(vo.getBalance().add(calculateVO.getBalance()));
                vo.setLocalBalance(vo.getLocalBalance().add(calculateVO.getLocalBalance()));
                continue;
            }
            processBillVOMap.put(calculateVO.getBillEntryId(), calculateVO);
        }
        return processBillVOMap;
    }

    @Override
    public List<String> getOriginSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("id");
        selector.add("billno");
        selector.add("bizdate");
        selector.add("exratetable");
        selector.add("exchangerate");
        selector.add("currency");
        selector.add("payertype");
        selector.add("payer");
        selector.add("txt_description");
        selector.add("quotation");
        selector.add("entry.id");
        selector.add("entry.e_material");
        selector.add("entry.e_expenseitem");
        selector.add("entry.e_unsettledamt");
        selector.add("entry.e_unsettledlocalamt");
        selector.add("entry.project");
        return selector;
    }

    @Override
    public String getEntityKey() {
        return "cas_recbill";
    }

    private QFilter getRecFilter() {
        QFilter filter = new QFilter("billstatus", "=", (Object)"D");
        filter.and(new QFilter("bizdate", "<=", (Object)this.context.getEndDate()));
        filter.and(new QFilter("currency", "<>", (Object)this.context.getStandardCurrencyId()));
        filter.and(new QFilter("entry.e_receivingtype.biztype", "in", AdjustExchHelper.getBizType(false)));
        filter.and(new QFilter("entry.e_receivingtype.ispartreceivable", "=", (Object)"1"));
        filter.and(new QFilter("entry.e_settleorg", "=", (Object)this.context.getOrgId()));
        filter.and(new QFilter("entry.e_unsettledamt", "<>", (Object)0));
        return filter;
    }

    private String getSettleSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("billentity");
        selector.add("settledate");
        selector.add("totalsettleamt");
        selector.add("localtotalsettleamt");
        selector.add("mainbillid");
        selector.add("mainbillentryid");
        selector.add("settlerelation");
        selector.add("paypropertytype");
        selector.add("paypropertyfield");
        selector.add("entry.e_billentity");
        selector.add("entry.settleamt");
        selector.add("entry.localsettleamt");
        selector.add("entry.billid");
        selector.add("entry.billentryid");
        selector.add("entry.e_paypropertytype");
        selector.add("entry.e_paypropertyfield");
        return StringUtils.join((Object[])selector.toArray(), (String)",");
    }

    private QFilter getSettleMainFilter() {
        QFilter filter = new QFilter("org", "=", (Object)this.context.getOrgId());
        filter.and(new QFilter("settledate", ">", (Object)this.context.getEndDate()));
        filter.and(new QFilter("billentity", "=", (Object)this.getEntityKey()));
        filter.and(new QFilter("mainbizdate", "<=", (Object)this.context.getEndDate()));
        filter.and(new QFilter("maincurrency", "<>", (Object)this.context.getStandardCurrencyId()));
        return filter;
    }

    private Set<Object> getSettleMainDataSetIds(DynamicObject[] settleMainDatas) {
        HashSet<Object> set = new HashSet<Object>(16);
        if (EmptyUtils.isNotEmpty(settleMainDatas)) {
            for (DynamicObject data : settleMainDatas) {
                Object billId = data.getPkValue();
                set.add(billId);
            }
        }
        return set;
    }

    private QFilter getSettleAssistFilter(Set<Object> settleMainDataSetIds) {
        QFilter filter = new QFilter("org", "=", (Object)this.context.getOrgId());
        filter.and(new QFilter("id", "not in", settleMainDataSetIds));
        filter.and(new QFilter("settledate", ">", (Object)this.context.getEndDate()));
        filter.and(new QFilter("entry.e_billentity", "=", (Object)this.getEntityKey()));
        filter.and(new QFilter("entry.billdate", "<=", (Object)this.context.getEndDate()));
        filter.and(new QFilter("entry.currency", "<>", (Object)this.context.getStandardCurrencyId()));
        return filter;
    }

    private Set<Object> getIdOrEntryIdBySettle(DynamicObject[] settleRecordArr) {
        HashSet<Object> billIdSet = new HashSet<Object>();
        List<String> bizType = AdjustExchHelper.getBizType(false);
        for (DynamicObject settleRecord : settleRecordArr) {
            String paypropertyType;
            DynamicObject paypropertyfield;
            if ("cas_recbill".equals(settleRecord.get("billentity")) && this.isReceivedBillType(paypropertyfield = settleRecord.getDynamicObject("paypropertyfield"), paypropertyType = settleRecord.getString("paypropertytype"), bizType)) {
                billIdSet.add(settleRecord.get("mainbillentryid"));
            }
            DynamicObjectCollection entries = settleRecord.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                String paypropertyType2;
                DynamicObject paypropertyfield2 = entry.getDynamicObject("e_paypropertyfield");
                if (!this.isReceivedBillType(paypropertyfield2, paypropertyType2 = entry.getString("e_paypropertytype"), bizType)) continue;
                billIdSet.add(entry.get("billentryid"));
            }
        }
        return billIdSet;
    }

    private List<CalculateVO> convertSettleBillToVO(DynamicObject[] settleRecordArr) {
        ArrayList<CalculateVO> voList = new ArrayList<CalculateVO>(8);
        if (settleRecordArr != null) {
            List<String> bizType = AdjustExchHelper.getBizType(false);
            for (DynamicObject bill : settleRecordArr) {
                String paypropertyType;
                DynamicObject paypropertyfield;
                if ("cas_recbill".equals(bill.get("billentity")) && this.isReceivedBillType(paypropertyfield = bill.getDynamicObject("paypropertyfield"), paypropertyType = bill.getString("paypropertytype"), bizType)) {
                    CalculateVO vo = new CalculateVO();
                    vo.setBillType("ap_settlerecord");
                    vo.setBillId(bill.getLong("mainbillid"));
                    vo.setBillEntryId(bill.getLong("mainbillentryid"));
                    vo.setBalance(bill.getBigDecimal("totalsettleamt"));
                    vo.setLocalBalance(bill.getBigDecimal("localtotalsettleamt"));
                    voList.add(vo);
                }
                DynamicObjectCollection entries = bill.getDynamicObjectCollection("entry");
                for (DynamicObject entry : entries) {
                    String paypropertyType2;
                    DynamicObject paypropertyfield2;
                    if (!"cas_recbill".equals(entry.get("e_billentity")) || !this.isReceivedBillType(paypropertyfield2 = entry.getDynamicObject("e_paypropertyfield"), paypropertyType2 = entry.getString("e_paypropertytype"), bizType)) continue;
                    CalculateVO vo = new CalculateVO();
                    vo.setBillType("ap_settlerecord");
                    vo.setBillId(entry.getLong("billid"));
                    vo.setBillEntryId(entry.getLong("billentryid"));
                    vo.setBalance(entry.getBigDecimal("settleamt"));
                    vo.setLocalBalance(entry.getBigDecimal("localsettleamt"));
                    voList.add(vo);
                }
            }
        }
        return voList;
    }

    private QFilter getUnexpectedRecFilter(Set<Object> recBillIdSet) {
        QFilter filter = new QFilter("entry.id", "in", recBillIdSet);
        filter.and(new QFilter("bizdate", "<=", (Object)this.context.getEndDate()));
        filter.and(new QFilter("org", "=", (Object)this.context.getOrgId()));
        return filter;
    }

    private List<CommonBillVO> buildCommonBillVOByRec(DataSet recDataSet, Map<Object, CommonBillVO> temporaryVOMap) {
        if (EmptyUtils.isNotEmpty(recDataSet)) {
            for (Row row : recDataSet) {
                Object billId = row.get("id");
                Object entryId = row.get("entry.id");
                if (EmptyUtils.isEmpty(temporaryVOMap.get(billId))) {
                    CommonBillVO commonBillVO = new CommonBillVO(Long.parseLong(billId.toString()));
                    commonBillVO.getEntryIds().add(Long.parseLong(entryId.toString()));
                    temporaryVOMap.put(billId, commonBillVO);
                    continue;
                }
                temporaryVOMap.get(billId).getEntryIds().add(Long.parseLong(entryId.toString()));
            }
        }
        return new ArrayList<CommonBillVO>(temporaryVOMap.values());
    }

    private QFilter getFilterByCommonBillVO(List<CommonBillVO> subbillids) {
        HashSet<Long> idSet = new HashSet<Long>(subbillids.size());
        HashSet<Long> entryIdSet = new HashSet<Long>(subbillids.size());
        for (CommonBillVO commonBillVO : subbillids) {
            idSet.add(commonBillVO.getId());
            entryIdSet.addAll(commonBillVO.getEntryIds());
        }
        QFilter filter = new QFilter("id", "in", idSet);
        filter.and(new QFilter("entry.id", "in", entryIdSet));
        return filter;
    }

    private Map<Object, CalculateVO> convertRecBillToVO(DataSet recDataSet) {
        HashMap<Object, CalculateVO> billVOMap = new HashMap<Object, CalculateVO>(64);
        if (recDataSet != null) {
            for (Row row : recDataSet) {
                CalculateVO vo = new CalculateVO();
                vo.setBillType("cas_recbill");
                vo.setBillId(row.getLong("id"));
                vo.setBillEntryId(row.getLong("entry.id"));
                vo.setBillNo(row.getString("billno"));
                vo.setAsstactType(row.getString("payertype"));
                vo.setAsstactId(row.getLong("payer"));
                vo.setRemark(row.getString("txt_description"));
                vo.setBizDate(row.getDate("bizdate"));
                vo.setCurrencyId(row.getLong("currency"));
                vo.setExrateTableId(row.getLong("exratetable"));
                vo.setMaterialId(row.getLong("entry.e_material"));
                vo.setExpenseItemId(row.getLong("entry.e_expenseitem"));
                vo.setProjectId(row.getLong("entry.project"));
                vo.setBalance(row.getBigDecimal("entry.e_unsettledamt"));
                vo.setExchangeRate(row.getBigDecimal("exchangerate"));
                vo.setLocalBalance(row.getBigDecimal("entry.e_unsettledlocalamt"));
                vo.setQuotation(this.getQuotation(vo.getBillNo(), row.getLong("exratetable"), row.getLong("currency")));
                vo.setSrcBillQuotation(row.getString("quotation"));
                vo.setCurExchangeRate(this.getCurExchangeRate(vo.getBillNo(), row.getLong("exratetable"), row.getLong("currency"), vo.getQuotation()));
                this.extendFieldVoluation(vo, row);
                billVOMap.put(vo.getBillEntryId(), vo);
            }
        }
        return billVOMap;
    }

    private boolean isReceivedBillType(DynamicObject paypropertyfield, String paypropertyType, List<String> bizType) {
        return paypropertyfield != null && "cas_receivingbilltype".equals(paypropertyType) && bizType.contains(paypropertyfield.getString("number"));
    }
}

