/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.adjustexch;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.helper.PeriodHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;

public class RequireAdjExchRecordOpForAllPeriod
extends AbstractOperationServicePlugIn {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        boolean isExist;
        Long orgId;
        Boolean key;
        DynamicObject org;
        String selector = "id,org,standardcurrency,exratetable,curperiod,startperiod";
        QFilter finishFilter = new QFilter("isfinishinit", "=", (Object)Boolean.TRUE);
        DynamicObject[] apInitDatas = BusinessDataServiceHelper.load((String)"ap_init", (String)selector, (QFilter[])new QFilter[]{finishFilter});
        DynamicObject[] arInitDatas = BusinessDataServiceHelper.load((String)"ar_init", (String)selector, (QFilter[])new QFilter[]{finishFilter});
        List<Long> apOrgIds = this.getorgId(apInitDatas);
        List<Long> arOrgIds = this.getorgId(arInitDatas);
        Map<Long, Boolean> apOrgAndParamMap = this.getIsParticipateInAdjExchMap(apOrgIds, false);
        Map<Long, Boolean> arOrgAndParamMap = this.getIsParticipateInAdjExchMap(arOrgIds, true);
        for (DynamicObject apInitData : apInitDatas) {
            org = apInitData.getDynamicObject("org");
            if (org == null || (key = apOrgAndParamMap.get(orgId = Long.valueOf(org.getLong("id")))) == null || !key.booleanValue()) continue;
            isExist = this.insertPeriodAdjExchRecord(apInitData, false);
            this.insertAdjExchRecord(apInitData, false, isExist);
        }
        for (DynamicObject arInitData : arInitDatas) {
            org = arInitData.getDynamicObject("org");
            if (org == null || (key = arOrgAndParamMap.get(orgId = Long.valueOf(arInitData.getDynamicObject("org").getLong("id")))) == null || !key.booleanValue()) continue;
            isExist = this.insertPeriodAdjExchRecord(arInitData, true);
            this.insertAdjExchRecord(arInitData, true, isExist);
        }
    }

    private List<Long> getorgId(DynamicObject[] initDatas) {
        ArrayList<Long> orgIds = new ArrayList<Long>(32);
        for (DynamicObject init : initDatas) {
            DynamicObject org = init.getDynamicObject("org");
            if (org == null) continue;
            orgIds.add(org.getLong("id"));
        }
        return orgIds;
    }

    public Map<Long, Boolean> getIsParticipateInAdjExchMap(List<Long> orgIds, boolean isAr) {
        Map<Long, Object> appParameter = SystemParameterHelper.batchGetAppParameter(isAr, orgIds, isAr ? "ar_031" : "ap_031");
        HashMap<Long, Boolean> isParticipateInAdjExchMap = new HashMap<Long, Boolean>(appParameter.size());
        for (Map.Entry<Long, Object> entryMap : appParameter.entrySet()) {
            isParticipateInAdjExchMap.put(entryMap.getKey(), (Boolean)entryMap.getValue());
        }
        return isParticipateInAdjExchMap;
    }

    public void insertAdjExchRecord(DynamicObject info, boolean isAr, boolean existLastAdj) {
        DynamicObject standardcurrency = info.getDynamicObject("standardcurrency");
        DynamicObject exratetable = info.getDynamicObject("exratetable");
        DynamicObject curperiod = info.getDynamicObject("curperiod");
        DynamicObject needPeriod = info.getDynamicObject("startperiod");
        DynamicObject org = info.getDynamicObject("org");
        if (standardcurrency == null || exratetable == null || curperiod == null || needPeriod == null) {
            return;
        }
        while (!PeriodHelper.after(needPeriod, curperiod)) {
            QFilter bizFilter;
            QFilter periodFilter;
            QFilter orgFilter;
            DynamicObject[] adjExchBills = BusinessDataServiceHelper.load((String)(isAr ? "ar_adjustexchbill" : "ap_adjexchbill"), (String)"id,gainloss", (QFilter[])new QFilter[]{orgFilter = new QFilter("org", "=", (Object)org.getLong("id")), periodFilter = new QFilter("period", "=", (Object)needPeriod.getLong("id")), bizFilter = new QFilter("bizsystem", "=", (Object)(isAr ? "AR" : "AP"))});
            if (adjExchBills.length > 0 || existLastAdj) {
                existLastAdj = true;
                DynamicObject[] adjExchRecord = new DynamicObject[]{BusinessDataServiceHelper.newDynamicObject((String)(isAr ? "ar_adjustexch" : "ap_adjustexch"))};
                adjExchRecord[0].set("org", (Object)org);
                adjExchRecord[0].set("basecurrency", (Object)standardcurrency);
                adjExchRecord[0].set("exratetable", (Object)exratetable);
                adjExchRecord[0].set("isadjexch", (Object)Boolean.TRUE);
                adjExchRecord[0].set("isperiod", (Object)Boolean.FALSE);
                adjExchRecord[0].set("period", (Object)needPeriod);
                adjExchRecord[0].set("listperiod", (Object)adjExchRecord[0].getDynamicObject("period").getString("name"));
                adjExchRecord[0].set("adjexchmode", (Object)"realtime");
                adjExchRecord[0].set("adjexchdate", (Object)needPeriod.getDate("enddate"));
                BigDecimal gainLoss = BigDecimal.ZERO;
                for (DynamicObject adjExchBill : adjExchBills) {
                    gainLoss = gainLoss.add(adjExchBill.getBigDecimal("gainloss"));
                }
                adjExchRecord[0].set("gainloss", (Object)gainLoss);
                if (isAr) {
                    adjExchRecord[0].set("bizsystem", (Object)"AR");
                } else {
                    adjExchRecord[0].set("bizsystem", (Object)"AP");
                }
                if (!this.validateAdjExchRecord(adjExchRecord[0], false, isAr).booleanValue()) {
                    SaveServiceHelper.save((DynamicObject[])adjExchRecord);
                }
            }
            needPeriod = PeriodHelper.getNextPeriod(needPeriod.getLong("id"));
        }
    }

    private boolean insertPeriodAdjExchRecord(DynamicObject info, boolean isAr) {
        QFilter bizFilter;
        QFilter periodFilter;
        QFilter orgFilter;
        boolean isExist = false;
        DynamicObject standardcurrency = info.getDynamicObject("standardcurrency");
        DynamicObject exratetable = info.getDynamicObject("exratetable");
        DynamicObject curperiod = info.getDynamicObject("curperiod");
        DynamicObject startperiod = info.getDynamicObject("startperiod");
        DynamicObject org = info.getDynamicObject("org");
        if (standardcurrency == null || exratetable == null || curperiod == null || startperiod == null) {
            return isExist;
        }
        DynamicObject[] adjExchBills = BusinessDataServiceHelper.load((String)(isAr ? "ar_adjustexchbill" : "ap_adjexchbill"), (String)"id,gainloss", (QFilter[])new QFilter[]{orgFilter = new QFilter("org", "=", (Object)org.getLong("id")), periodFilter = new QFilter("period", "=", (Object)0L), bizFilter = new QFilter("bizsystem", "=", (Object)(isAr ? "AR" : "AP"))});
        if (adjExchBills.length > 0) {
            isExist = true;
            DynamicObject[] adjExchRecord = new DynamicObject[]{BusinessDataServiceHelper.newDynamicObject((String)(isAr ? "ar_adjustexch" : "ap_adjustexch"))};
            adjExchRecord[0].set("org", (Object)org);
            adjExchRecord[0].set("basecurrency", (Object)standardcurrency);
            adjExchRecord[0].set("exratetable", (Object)exratetable);
            adjExchRecord[0].set("isadjexch", (Object)Boolean.TRUE);
            adjExchRecord[0].set("isperiod", (Object)Boolean.TRUE);
            adjExchRecord[0].set("period", (Object)0L);
            adjExchRecord[0].set("listperiod", (Object)ResManager.loadKDString((String)"\u671f\u521d", (String)"BadDebtAccrueEdit_0", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            adjExchRecord[0].set("adjexchmode", (Object)"realtime");
            adjExchRecord[0].set("adjexchdate", (Object)DateUtils.getLastDay(startperiod.getDate("begindate"), 1));
            BigDecimal gainLoss = BigDecimal.ZERO;
            for (DynamicObject adjExchBill : adjExchBills) {
                gainLoss = gainLoss.add(adjExchBill.getBigDecimal("gainloss"));
            }
            adjExchRecord[0].set("gainloss", (Object)gainLoss);
            if (isAr) {
                adjExchRecord[0].set("bizsystem", (Object)"AR");
            } else {
                adjExchRecord[0].set("bizsystem", (Object)"AP");
            }
            if (!this.validateAdjExchRecord(adjExchRecord[0], true, isAr).booleanValue()) {
                SaveServiceHelper.save((DynamicObject[])adjExchRecord);
            }
        }
        return isExist;
    }

    public Boolean validateAdjExchRecord(DynamicObject adjExchRecord, boolean isPeriod, boolean isAr) {
        QFilter bizsystemfilter;
        QFilter periodfilter;
        QFilter filter;
        DynamicObject validateData;
        DynamicObject org = adjExchRecord.getDynamicObject("org");
        Long periodId = 0L;
        if (!isPeriod) {
            periodId = (Long)adjExchRecord.getDynamicObject("period").getPkValue();
        }
        if (EmptyUtils.isEmpty(validateData = BusinessDataServiceHelper.loadSingle((String)(isAr ? "ar_adjustexch" : "ap_adjustexch"), (String)"id", (QFilter[])new QFilter[]{filter = new QFilter("org", "=", org.get("id")), periodfilter = new QFilter("period", "=", (Object)periodId), bizsystemfilter = new QFilter("bizsystem", "=", (Object)(isAr ? "AR" : "AP"))}))) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

