/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.adjustexch;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class RequireBadDebtRecordOp
extends AbstractOperationServicePlugIn {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] arInitDatas;
        String selector = "id,org,standardcurrency,exratetable,curperiod";
        QFilter finishFilter = new QFilter("isfinishinit", "=", (Object)Boolean.TRUE);
        for (DynamicObject arInitData : arInitDatas = BusinessDataServiceHelper.load((String)"ar_init", (String)selector, (QFilter[])new QFilter[]{finishFilter})) {
            DynamicObject org = arInitData.getDynamicObject("org");
            DynamicObject curperiod = arInitData.getDynamicObject("curperiod");
            if (org == null || curperiod == null) continue;
            Long orgId = org.getLong("id");
            this.insertNextPeriodBadDebtAccrue(orgId, curperiod.getLong("id"), curperiod.getString("name"));
        }
    }

    private void insertNextPeriodBadDebtAccrue(Long orgId, Long periodId, String periodName) {
        DynamicObject badDebtAccrue = BusinessDataServiceHelper.newDynamicObject((String)"ar_baddebtaccrue");
        badDebtAccrue.set("org", (Object)orgId);
        badDebtAccrue.set("period", (Object)periodId);
        badDebtAccrue.set("preperiod", (Object)0L);
        badDebtAccrue.set("accrualstatus", (Object)"0");
        badDebtAccrue.set("isperiod", (Object)Boolean.FALSE);
        badDebtAccrue.set("listperiod", (Object)periodName);
        if (this.validateBadDebtRecord(orgId)) {
            QFilter qFilter = new QFilter("status", "=", (Object)"C");
            qFilter.and(new QFilter("enable", "=", (Object)"1"));
            DynamicObjectCollection schemes = BaseDataServiceHelper.queryBaseData((String)"ar_baddebtaccrualplan", (Long)orgId, (QFilter)qFilter, (String)"id");
            if (schemes != null && schemes.size() > 1) {
                badDebtAccrue.set("accrualscheme", schemes.get(0));
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{badDebtAccrue});
        }
    }

    private boolean validateBadDebtRecord(Long orgId) {
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        DynamicObject[] validateDatas = BusinessDataServiceHelper.load((String)"ar_baddebtaccrue", (String)"id,accrualstatus", (QFilter[])new QFilter[]{filter});
        return EmptyUtils.isEmpty(validateDatas);
    }
}

