/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.archi;

import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.service.archi.AbstractBillArchiPlugin;

public abstract class AbstractFinBillArchiPlugin
extends AbstractBillArchiPlugin {
    private static Log logger = LogFactory.getLog(AbstractFinBillArchiPlugin.class);

    public Iterator<Long> queryEntityIds() {
        HashSet<Long> idSet = new HashSet<Long>();
        try {
            Date archiveDate = this.getArchiveDate();
            logger.info("AbstractFinBillArchiPlugin-archiveDate:" + archiveDate);
            if (archiveDate == null) {
                return idSet.iterator();
            }
            QFilter srcFilter = this.getBillFilter(archiveDate);
            DataSet srcBillDS = QueryServiceHelper.queryDataSet((String)"queryFinIds", (String)this.getEntityKey(), (String)"id", (QFilter[])new QFilter[]{srcFilter}, (String)"");
            for (Row srcRow : srcBillDS) {
                idSet.add(srcRow.getLong("id"));
            }
            logger.info("AbstractFinBillArchiPlugin-idSet:" + idSet.size());
            if (!idSet.isEmpty()) {
                QFilter mainFilter = new QFilter("mainbillid", "in", idSet);
                mainFilter.and("settledate", ">=", (Object)archiveDate);
                DataSet mainDataSet = QueryServiceHelper.queryDataSet((String)"querySettleRecord", (String)this.getSettleRecordEntity(), (String)"id,mainbillid", (QFilter[])new QFilter[]{mainFilter}, (String)"");
                for (Row mainRow : mainDataSet) {
                    idSet.remove(mainRow.getLong("mainbillid"));
                }
                QFilter asstFilter = new QFilter("entry.billid", "in", idSet);
                asstFilter.and("settledate", ">=", (Object)archiveDate);
                DataSet asstDataSet = QueryServiceHelper.queryDataSet((String)"querySettleRecord", (String)this.getSettleRecordEntity(), (String)"id,mainbillid,entry.billid", (QFilter[])new QFilter[]{asstFilter}, (String)"");
                for (Row asstRow : asstDataSet) {
                    idSet.remove(asstRow.getLong("mainbillid"));
                    idSet.remove(asstRow.getLong("entry.billid"));
                }
            }
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        return idSet.iterator();
    }

    @Override
    public QFilter getBillFilter(Date archiveDate) {
        QFilter srcFilter = new QFilter("bizdate", "<", (Object)archiveDate);
        srcFilter.and("billstatus", "=", (Object)"C");
        srcFilter.and("settlestatus", "=", (Object)"settled");
        return srcFilter;
    }

    public abstract String getSettleRecordEntity();
}

