/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.audit;

import com.alibaba.fastjson.annotation.JSONField;
import java.util.LinkedList;
import java.util.List;
import kd.bos.audit.Auditable;
import kd.bos.context.RequestContext;
import kd.fi.arapcommon.service.audit.Audit;
import kd.fi.arapcommon.service.audit.BizAuditable;

public class CostItem
implements BizAuditable {
    @JSONField
    private String number;
    @JSONField
    private long beginTime;
    @JSONField
    private long endTime;
    @JSONField
    private long costTime;
    @JSONField
    private CostItem parent;
    @JSONField
    private List<CostItem> subItems = new LinkedList<CostItem>();
    private boolean auditOpen;
    private String traceId;
    private String description;
    private Auditable bosAudit;
    private boolean closed = false;

    public CostItem(String number) {
        this.number = number;
        this.bosAudit = kd.bos.audit.Audit.audit((String)number, (Object[])new Object[0]);
    }

    public CostItem(String number, String description) {
        this.number = number;
        this.description = description;
        this.bosAudit = kd.bos.audit.Audit.audit((String)number, (Object[])new Object[0]);
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    public void setBeginTime(long beginTime) {
        this.beginTime = beginTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public long getCostTime() {
        return this.costTime;
    }

    public void setCostTime(long costTime) {
        this.costTime = costTime;
    }

    public CostItem getParent() {
        return this.parent;
    }

    public void setParent(CostItem parent) {
        this.parent = parent;
    }

    public List<CostItem> getSubItems() {
        return this.subItems;
    }

    public void setSubItems(List<CostItem> subItems) {
        this.subItems = subItems;
    }

    public void addSubItem(CostItem subItem) {
        this.subItems.add(subItem);
    }

    public boolean isAuditOpen() {
        return this.auditOpen;
    }

    public void setAuditOpen(boolean auditOpen) {
        this.auditOpen = auditOpen;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void beginSubItem(String name) {
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.auditOpen) {
            this.endTime = System.currentTimeMillis();
            this.costTime = this.endTime - this.beginTime;
            if (this.parent == null) {
                this.traceId = RequestContext.get().getTraceId();
                Audit.presistent(this);
            } else {
                Audit.set(this.parent);
            }
        }
        if (this.bosAudit != null) {
            this.bosAudit.close();
        }
    }
}

