/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.buswoff;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.orm.query.QFilter;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.service.buswoff.AbstractBusWoffService;
import kd.fi.arapcommon.service.buswoff.BusWoffRecordVO;
import kd.fi.arapcommon.service.buswoff.BusWoffResult;

public abstract class AbstractBusBotpWoff
extends AbstractBusWoffService {
    @Override
    protected void initBusWoffParam(Set<Long> billIds) {
        if (this.busWoffParam == null) {
            this.initBusWoffParam(billIds, null);
        }
    }

    @Override
    public BusWoffResult busAssignWoff(Set<Long> finIds, Map<Long, BFRowId> sourceBusBFRowMap) {
        this.initBusWoffParam(finIds, sourceBusBFRowMap);
        return this.busWoff(finIds);
    }

    @Override
    protected QFilter getSrcBusQFilter(DataSet finDataSet) {
        HashMap finEntryIdToBillId = new HashMap(64);
        finDataSet.copy().forEach(row -> finEntryIdToBillId.put(row.getLong(this.finModel.ENTRY_PK), row.getLong("id")));
        Map<Long, BFRowId> sourceBusBFRowMap = this.busWoffParam.getSourceBusBFRowMap();
        if (ObjectUtils.isEmpty(sourceBusBFRowMap)) {
            sourceBusBFRowMap = BOTPHelper.loadNearSrcBFRowIdMap(this.busWoffParam.getFinEntity(), this.finModel.ENTRY, this.busWoffParam.getBillIds().toArray(new Long[0]), finEntryIdToBillId.keySet().toArray(new Long[0]), this.busWoffParam.getBusEntity());
            this.busWoffParam.setSourceBusBFRowMap(sourceBusBFRowMap);
        }
        if (ObjectUtils.isEmpty(sourceBusBFRowMap)) {
            return null;
        }
        HashSet<Long> srcBusIds = new HashSet<Long>(8);
        HashSet<Long> srcBusEntryIds = new HashSet<Long>(sourceBusBFRowMap.size());
        for (Map.Entry<Long, BFRowId> bfRowIdEntry : sourceBusBFRowMap.entrySet()) {
            BFRowId bfRowId = bfRowIdEntry.getValue();
            srcBusIds.add(bfRowId.getBillId());
            srcBusEntryIds.add(bfRowId.getEntryId());
        }
        return super.getSrcBusQFilter(finDataSet).and("id", "in", srcBusIds).and(this.busModel.ENTRY_PK, "in", srcBusEntryIds);
    }

    @Override
    protected List<BusWoffRecordVO> match(DataSet finDataSet, List<String> finMatchFields, DataSet busDataSet, List<String> busMatchFields) {
        ArrayList<BusWoffRecordVO> woffRecordListVO = new ArrayList<BusWoffRecordVO>(8);
        Map<Long, BFRowId> sourceBusBFRowMap = this.busWoffParam.getSourceBusBFRowMap();
        if (ObjectUtils.isEmpty(sourceBusBFRowMap)) {
            return woffRecordListVO;
        }
        HashMap<Long, Row> busRowMap = new HashMap<Long, Row>(8);
        for (Row row : busDataSet) {
            busRowMap.put(row.getLong(this.busModel.ENTRY_PK), row);
        }
        HashMap<Long, BusWoffRecordVO> finEnableInvoiceListVO = new HashMap<Long, BusWoffRecordVO>(2);
        HashMap<Long, BusWoffRecordVO> busEnableWoffRecordListVO = new HashMap<Long, BusWoffRecordVO>(2);
        for (Row finRow : finDataSet) {
            BusWoffRecordVO woffRecordVO;
            Long srcBusEntryId;
            BFRowId bfRowId = sourceBusBFRowMap.get(finRow.getLong(this.finModel.ENTRY_PK));
            if (bfRowId == null || ObjectUtils.isEmpty((Object)(srcBusEntryId = bfRowId.getEntryId())) || (woffRecordVO = this.dealWoffRecord(finEnableInvoiceListVO, finRow, busEnableWoffRecordListVO, (Row)busRowMap.get(srcBusEntryId))) == null) continue;
            woffRecordListVO.add(woffRecordVO);
        }
        return woffRecordListVO;
    }
}

