/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.buswoff;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.fi.arapcommon.service.buswoff.AbstractBusMatchWoff;
import kd.fi.arapcommon.service.buswoff.BusWoffRecordVO;

public abstract class AbstractBusCoreBillWoff
extends AbstractBusMatchWoff {
    @Override
    protected Map<String, String> getOtherMatchField() {
        Map<String, String> matchFieldMapCommon = super.getOtherMatchField();
        HashMap<String, String> matchFieldMap = new HashMap<String, String>(3);
        matchFieldMap.put(this.finModel.ENTRY + "." + this.finModel.E_COREBILLTYPE, this.busModel.ENTRY + "." + this.busModel.E_COREBILLTYPE);
        matchFieldMap.put(this.finModel.ENTRY + "." + this.finModel.E_COREBILLNO, this.busModel.ENTRY + "." + this.busModel.E_COREBILLNO);
        matchFieldMap.put(this.finModel.ENTRY + "." + this.finModel.E_COREBILLENTRYSEQ, this.busModel.ENTRY + "." + this.busModel.E_COREBILLENTRYSEQ);
        matchFieldMap.putAll(matchFieldMapCommon);
        return matchFieldMap;
    }

    @Override
    protected QFilter getSrcBusQFilter(DataSet finDataSet) {
        QFilter filter = super.getSrcBusQFilter(finDataSet);
        HashSet<String> coreBillTypeSet = new HashSet<String>(8);
        HashSet<String> coreBillNoSet = new HashSet<String>(8);
        HashSet<Integer> coreBillEntrySeqSet = new HashSet<Integer>(8);
        for (Row row : finDataSet.copy()) {
            String corebilltype = row.getString(this.finModel.ENTRY + "." + this.finModel.E_COREBILLTYPE);
            String corebillno = row.getString(this.finModel.ENTRY + "." + this.finModel.E_COREBILLNO);
            int corebillentryseq = row.getInteger(this.finModel.ENTRY + "." + this.finModel.E_COREBILLENTRYSEQ);
            if (StringUtils.isEmpty((CharSequence)corebilltype) || StringUtils.isEmpty((CharSequence)corebillno) || corebillentryseq == 0) continue;
            coreBillTypeSet.add(corebilltype);
            coreBillNoSet.add(corebillno);
            coreBillEntrySeqSet.add(corebillentryseq);
        }
        if (ObjectUtils.isEmpty(coreBillTypeSet) || ObjectUtils.isEmpty(coreBillNoSet) || ObjectUtils.isEmpty(coreBillEntrySeqSet)) {
            filter = null;
        } else {
            filter.and(this.busModel.ENTRY + "." + this.busModel.E_COREBILLTYPE, "in", coreBillTypeSet).and(this.busModel.ENTRY + "." + this.busModel.E_COREBILLNO, "in", coreBillNoSet).and(this.busModel.ENTRY + "." + this.busModel.E_COREBILLENTRYSEQ, "in", coreBillEntrySeqSet);
        }
        return filter;
    }

    @Override
    protected List<BusWoffRecordVO> match(DataSet finDataSet, List<String> finMatchFields, DataSet busDataSet, List<String> busMatchFields) {
        ArrayList<BusWoffRecordVO> woffRecordListVO = new ArrayList<BusWoffRecordVO>(64);
        if (finDataSet == null || busDataSet == null) {
            return woffRecordListVO;
        }
        Row firstFinRow = null;
        ArrayList<Row> finRows = new ArrayList<Row>(2);
        Row preBusRow = null;
        ArrayList<Row> busRows = new ArrayList<Row>(2);
        Iterator busIterator = busDataSet.iterator();
        StringBuilder isNullEquality = new StringBuilder("false");
        for (Row curFinRow : finDataSet) {
            if (ObjectUtils.isEmpty(finRows)) {
                firstFinRow = curFinRow;
                finRows.add(curFinRow);
                continue;
            }
            int comparator = this.compare(firstFinRow, finMatchFields, curFinRow, finMatchFields, isNullEquality);
            if (comparator == 0) {
                finRows.add(curFinRow);
                continue;
            }
            if (ObjectUtils.isEmpty((Object)isNullEquality)) {
                isNullEquality.append("false");
                firstFinRow = curFinRow;
                finRows.clear();
                finRows.add(curFinRow);
                continue;
            }
            if (preBusRow != null) {
                comparator = this.compare(firstFinRow, finMatchFields, preBusRow, busMatchFields, isNullEquality);
                if (comparator < 0) {
                    finRows.clear();
                    finRows.add(curFinRow);
                    firstFinRow = curFinRow;
                    continue;
                }
                if (!ObjectUtils.isEmpty((Object)isNullEquality) && comparator == 0) {
                    busRows.add(preBusRow);
                }
                isNullEquality.append("false");
                preBusRow = null;
            }
            while (busIterator.hasNext()) {
                Row curBusRow = (Row)busIterator.next();
                comparator = this.compare(firstFinRow, finMatchFields, curBusRow, busMatchFields, isNullEquality);
                if (ObjectUtils.isEmpty((Object)isNullEquality) || comparator > 0) {
                    isNullEquality.append("false");
                    continue;
                }
                if (comparator == 0) {
                    busRows.add(curBusRow);
                    continue;
                }
                if (!ObjectUtils.isEmpty(busRows)) {
                    woffRecordListVO.addAll(this.matchAmt(finRows, busRows));
                }
                busRows.clear();
                preBusRow = curBusRow;
                break;
            }
            if (!busIterator.hasNext() && !ObjectUtils.isEmpty(busRows)) {
                woffRecordListVO.addAll(this.matchAmt(finRows, busRows));
                busRows.clear();
            }
            firstFinRow = curFinRow;
            finRows.clear();
            finRows.add(curFinRow);
        }
        if (!ObjectUtils.isEmpty(finRows) && !ObjectUtils.isEmpty((Object)isNullEquality)) {
            if (preBusRow != null) {
                int comparator = this.compare(firstFinRow, finMatchFields, preBusRow, busMatchFields, isNullEquality);
                if (comparator < 0) {
                    return woffRecordListVO;
                }
                if (!ObjectUtils.isEmpty((Object)isNullEquality) && comparator == 0) {
                    busRows.add(preBusRow);
                }
                isNullEquality.append("false");
            }
            while (busIterator.hasNext()) {
                Row curBusRow = (Row)busIterator.next();
                int comparator = this.compare(firstFinRow, finMatchFields, curBusRow, busMatchFields, isNullEquality);
                if (comparator > 0) continue;
                if (comparator == 0) {
                    if (ObjectUtils.isEmpty((Object)isNullEquality)) {
                        return woffRecordListVO;
                    }
                    busRows.add(curBusRow);
                    continue;
                }
                if (!ObjectUtils.isEmpty(busRows)) {
                    woffRecordListVO.addAll(this.matchAmt(finRows, busRows));
                }
                busRows.clear();
                break;
            }
            if (!ObjectUtils.isEmpty(busRows)) {
                woffRecordListVO.addAll(this.matchAmt(finRows, busRows));
            }
        }
        return woffRecordListVO;
    }

    @Override
    protected List<BusWoffRecordVO> getWoffRecordListVO(List<Row> finRows, List<Row> busRows) {
        ArrayList<BusWoffRecordVO> woffRecordListVO = new ArrayList<BusWoffRecordVO>(2);
        if (ObjectUtils.isEmpty(finRows) || ObjectUtils.isEmpty(busRows)) {
            return woffRecordListVO;
        }
        HashMap<Long, BusWoffRecordVO> finEnableInvoiceListVO = new HashMap<Long, BusWoffRecordVO>(2);
        HashMap<Long, BusWoffRecordVO> busEnableWoffRecordListVO = new HashMap<Long, BusWoffRecordVO>(2);
        finRows = ((Stream)finRows.stream().parallel()).sorted(Comparator.comparing(row -> row.getDate("bookdate"), Comparator.nullsLast(Date::compareTo))).collect(Collectors.toList());
        busRows = ((Stream)busRows.stream().parallel()).sorted(Comparator.comparing(row -> row.getDate("bookdate"), Comparator.nullsLast(Date::compareTo))).collect(Collectors.toList());
        Iterator<Object> busIterator = busRows.iterator();
        Row curBusRow = null;
        block0: for (Row row2 : finRows) {
            BusWoffRecordVO woffRecordVO;
            if (ObjectUtils.isEmpty((Object)row2)) continue;
            if (!ObjectUtils.isEmpty(curBusRow) && (woffRecordVO = this.dealWoffRecord(finEnableInvoiceListVO, row2, busEnableWoffRecordListVO, curBusRow)) != null) {
                woffRecordListVO.add(woffRecordVO);
                if (woffRecordVO.isBusLastForAll()) {
                    curBusRow = null;
                }
                if (woffRecordVO.isFinAllWoffed()) continue;
            }
            while (busIterator.hasNext()) {
                Row busRow = (Row)busIterator.next();
                BusWoffRecordVO woffRecordVO2 = this.dealWoffRecord(finEnableInvoiceListVO, row2, busEnableWoffRecordListVO, busRow);
                if (woffRecordVO2 == null) continue;
                woffRecordListVO.add(woffRecordVO2);
                if (!woffRecordVO2.isBusLastForAll()) {
                    curBusRow = busRow;
                }
                if (!woffRecordVO2.isFinAllWoffed()) continue;
                continue block0;
            }
        }
        return woffRecordListVO;
    }
}

