/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.buswoff;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.service.buswoff.AbstractBusWoffService;
import kd.fi.arapcommon.service.buswoff.BusWoffHelper;
import kd.fi.arapcommon.service.buswoff.BusWoffRecordVO;
import kd.fi.arapcommon.service.buswoff.BusWoffResult;
import kd.fi.arapcommon.service.concurrency.ConcurrencyCtrlUtil;

public abstract class AbstractBusMatchWoff
extends AbstractBusWoffService {
    @Override
    public BusWoffResult busAssignWoff(Set<Long> finIds, Map<Long, BFRowId> sourceBusBFRowMap) {
        return this.busWoff(finIds);
    }

    protected abstract Map<Long, QFilter> getQFilterByAppParameters(List<Long> var1);

    @Override
    public BusWoffResult busWoff(Set<Long> finIds) {
        BusWoffResult result = new BusWoffResult();
        if (ObjectUtils.isEmpty(finIds)) {
            return result;
        }
        this.initBusWoffParam(finIds);
        this.idempotentValidator();
        Throwable throwable = null;
        try (TXHandle tx = TX.required((String)"buswoff");){
            logger.info("----------BusWoffService " + this.getClass().getSimpleName() + " start----------");
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"", (String)this.busWoffParam.getFinEntity(), (String)"id,org", (QFilter[])new QFilter[]{this.getFinQFilter()}, (String)"");
            if (!dataSet.hasNext()) {
                BusWoffResult busWoffResult = result;
                return busWoffResult;
            }
            ArrayList<Long> orgIds = new ArrayList<Long>(2);
            dataSet.forEach(row -> orgIds.add(row.getLong("org")));
            Map<Long, QFilter> filterByOrgId = this.getQFilterByAppParameters(orgIds);
            if (ObjectUtils.isEmpty(filterByOrgId)) {
                BusWoffResult busWoffResult = result;
                return busWoffResult;
            }
            ArrayList<String> finMatchFields = new ArrayList<String>(2);
            ArrayList<String> busMatchFields = new ArrayList<String>(2);
            this.initMatchSelector(finMatchFields, busMatchFields);
            for (Map.Entry<Long, QFilter> filterByOrgIdEntry : filterByOrgId.entrySet()) {
                DataSet finDataSet = this.getFinDataSet(filterByOrgIdEntry.getKey(), finMatchFields);
                if (ObjectUtils.isEmpty((Object)finDataSet)) {
                    BusWoffResult busWoffResult = result;
                    return busWoffResult;
                }
                QFilter srcBusQFilter = new QFilter(this.finModel.HEAD_ORG, "=", (Object)filterByOrgIdEntry.getKey()).and(this.getSrcBusQFilter(finDataSet)).and(filterByOrgIdEntry.getValue());
                Set<Long> srcBusIdSet = this.getBusIdSet(srcBusQFilter);
                if (ObjectUtils.isEmpty(srcBusIdSet)) {
                    BusWoffResult busWoffResult = result;
                    return busWoffResult;
                }
                logger.info("----------BusWoffService \u9700\u8981\u52a0\u9501\u63a7\u5236\u5e76\u53d1\u7684\u9700\u8981\u51b2\u56de\u7684\u6e90\u6682\u4f30\u5355ID\u96c6\u5408\uff1a" + srcBusIdSet);
                ConcurrencyCtrlUtil.addCtrlInTX(this.busWoffParam.getBusEntity(), "woff", srcBusIdSet);
                DataSet busDataSet = this.getBusDataSet(srcBusIdSet, busMatchFields);
                List<BusWoffRecordVO> woffRecordListV0 = this.match(finDataSet, finMatchFields, busDataSet, busMatchFields);
                List<Object> woffBillIds = this.batchBusWoff(woffRecordListV0);
                for (BusWoffRecordVO vo : woffRecordListV0) {
                    result.getFinBillIds().add(vo.getFinId());
                    result.getSrcBusBillIds().add(vo.getSrcBusId());
                }
                result.getWoffBillIds().addAll(woffBillIds);
            }
            BusWoffResult busWoffResult = result;
            return busWoffResult;
        }
        catch (Throwable e) {
            try {
                tx.markRollback();
                logger.error(e);
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    @Override
    protected void initFinMatchSelector(List<String> finMatchFields) {
        finMatchFields.add(this.finModel.HEAD_ORG);
        finMatchFields.add(this.finModel.HEAD_CURRENCY);
        finMatchFields.add(this.finModel.HEAD_ASSTACTTYPE);
        finMatchFields.add(this.finModel.HEAD_ASSTACT);
        finMatchFields.add("payproperty.isbasedonamt");
        finMatchFields.add(this.finModel.ENTRY + "." + this.finModel.E_ISPRESENT);
        finMatchFields.add(this.finModel.ENTRY + "." + this.finModel.E_LINETYPE);
        finMatchFields.add(this.finModel.ENTRY + "." + this.finModel.E_MATERIAL + ".masterid");
        finMatchFields.add(this.finModel.ENTRY + "." + this.finModel.E_MEASUREUNIT + ".masterid");
        finMatchFields.add(this.finModel.ENTRY + "." + this.finModel.E_EXPENSEITEM + ".masterid");
    }

    @Override
    protected List<String> getFinSelector(List<String> finMatchFields) {
        List<String> selector = super.getFinSelector(finMatchFields);
        selector.add("asstact.masterid");
        selector.add("currency.amtprecision");
        selector.add("basecurrency.amtprecision");
        selector.add(this.finModel.HEAD_EXCHANGERATE);
        selector.add(this.finModel.HEAD_QUOTATION);
        selector.add(this.finModel.HEAD_ISINCLUDETAX);
        selector.add(this.finModel.ENTRY + "." + this.finModel.E_TAXRATE);
        selector.add(this.finModel.ENTRY + "." + this.finModel.E_DISCOUNTMODE);
        selector.add(this.finModel.ENTRY + "." + this.finModel.E_DISCOUNTRATE);
        selector.add(this.finModel.ENTRY + "." + this.finModel.E_DISCOUNTAMOUNT);
        selector.add(this.finModel.ENTRY + "." + this.finModel.E_UNITPRICE);
        selector.add(this.finModel.ENTRY + "." + this.finModel.E_TAXUNITPRICE);
        return selector;
    }

    protected DataSet getFinDataSet(Long orgId, List<String> matchFields) {
        List<String> selector = this.getFinSelector(matchFields);
        HashSet<String> selectorSet = new HashSet<String>(selector);
        selector = new ArrayList<String>(selectorSet);
        QFilter filter = this.getFinQFilter().and(this.finModel.HEAD_ORG, "=", (Object)orgId);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryFin4Match", (String)this.busWoffParam.getFinEntity(), (String)String.join((CharSequence)",", selector), (QFilter[])new QFilter[]{filter}, (String)"");
        if (!dataSet.hasNext()) {
            return null;
        }
        Boolean isAr = "ar_finarbill".equals(this.busWoffParam.getFinEntity());
        String needDealAsstacttype = isAr != false ? "bd_supplier" : "bd_customer";
        HashSet<Long> needDealAsstactIdSet = new HashSet<Long>(2);
        for (Row row : dataSet.copy()) {
            if (!needDealAsstacttype.equals(row.getString("asstacttype"))) continue;
            needDealAsstactIdSet.add(row.getLong("asstact"));
        }
        if (matchFields.contains("asstact")) {
            dataSet = this.dealAsstactDataSet(needDealAsstacttype, needDealAsstactIdSet, dataSet, selector);
        }
        dataSet = dataSet.orderBy(this.getOrderByField(matchFields).toArray(new String[0]));
        return dataSet;
    }

    @Override
    protected DataSet dealAsstactDataSet(String asstacttype, Set<Long> asstactIdSet, DataSet dataSet, List<String> selector) {
        dataSet = BusWoffHelper.dealAsstactDataSet(asstacttype, asstactIdSet, dataSet, selector);
        return dataSet;
    }

    @Override
    protected void initBusMatchSelector(List<String> busMatchFields) {
        busMatchFields.add(this.busModel.HEAD_ORG);
        busMatchFields.add(this.busModel.HEAD_CURRENCY);
        busMatchFields.add(this.busModel.HEAD_ASSTACTTYPE);
        busMatchFields.add(this.busModel.HEAD_ASSTACT);
        busMatchFields.add("payproperty.isbasedonamt");
        busMatchFields.add(this.busModel.ENTRY + "." + this.busModel.E_ISPRESENT);
        busMatchFields.add(this.busModel.ENTRY + "." + this.busModel.E_LINETYPE);
        busMatchFields.add(this.busModel.ENTRY + "." + this.busModel.E_MATERIAL + ".masterid");
        busMatchFields.add(this.busModel.ENTRY + "." + this.busModel.E_MEASUREUNIT + ".masterid");
        busMatchFields.add(this.busModel.ENTRY + "." + this.busModel.E_EXPENSEITEM + ".masterid");
    }

    @Override
    protected List<String> getBusSelector(List<String> matchFields) {
        List<String> selector = super.getBusSelector(matchFields);
        selector.add(this.busModel.HEAD_SRCFINBILLID);
        selector.add(this.busModel.HEAD_BILLSRCTYPE);
        selector.add(this.busModel.ENTRY + "." + this.busModel.E_SOURCEBILLID);
        selector.add(this.busModel.ENTRY + "." + this.busModel.E_INVOICEDQTY);
        selector.add(this.busModel.ENTRY + "." + this.busModel.E_INVOICEDONOTAXAMT);
        return selector;
    }

    protected List<BusWoffRecordVO> matchAmt(List<Row> finRows, List<Row> busRows) {
        ArrayList<BusWoffRecordVO> woffRecordListVO = new ArrayList<BusWoffRecordVO>(2);
        if (ObjectUtils.isEmpty(finRows) || ObjectUtils.isEmpty(busRows)) {
            return woffRecordListVO;
        }
        List<Object> finZeroList = new ArrayList<Row>(2);
        List<Object> busZeroList = new ArrayList<Row>(2);
        ArrayList<Row> finPositiveList = new ArrayList<Row>(2);
        ArrayList<Row> busPositiveList = new ArrayList<Row>(2);
        ArrayList<Row> finNegativeList = new ArrayList<Row>(2);
        ArrayList<Row> busNegativeList = new ArrayList<Row>(2);
        for (Row finRow : finRows) {
            if (finRow.getBoolean("payproperty.isbasedonamt").booleanValue() && finRow.getBigDecimal(this.finModel.ENTRY + "." + this.finModel.E_AMOUNT).compareTo(BigDecimal.ZERO) == 0) {
                finZeroList.add(finRow);
                continue;
            }
            if (finRow.getBigDecimal(this.finModel.ENTRY + "." + this.finModel.E_QUANTITY).compareTo(BigDecimal.ZERO) > 0) {
                finPositiveList.add(finRow);
                continue;
            }
            finNegativeList.add(finRow);
        }
        for (Row busRow : busRows) {
            if (busRow.getBoolean("payproperty.isbasedonamt").booleanValue() && busRow.getBigDecimal(this.busModel.ENTRY + "." + this.busModel.E_AMOUNT).compareTo(BigDecimal.ZERO) == 0) {
                busZeroList.add(busRow);
                continue;
            }
            if (busRow.getBigDecimal(this.busModel.ENTRY + "." + this.busModel.E_QUANTITY).compareTo(BigDecimal.ZERO) > 0) {
                busPositiveList.add(busRow);
                continue;
            }
            busNegativeList.add(busRow);
        }
        HashMap<Long, BusWoffRecordVO> finEnableInvoiceListVO = new HashMap<Long, BusWoffRecordVO>(2);
        HashMap<Long, BusWoffRecordVO> busEnableWoffRecordListVO = new HashMap<Long, BusWoffRecordVO>(2);
        if (!ObjectUtils.isEmpty(finZeroList) && !ObjectUtils.isEmpty(busZeroList)) {
            finZeroList = ((Stream)finZeroList.stream().parallel()).sorted(Comparator.comparing(row -> row.getDate("bookdate"), Comparator.nullsLast(Date::compareTo))).collect(Collectors.toList());
            busZeroList = ((Stream)busZeroList.stream().parallel()).sorted(Comparator.comparing(row -> row.getDate("bookdate"), Comparator.nullsLast(Date::compareTo))).collect(Collectors.toList());
            for (int i = 0; i < finZeroList.size() && i < busZeroList.size(); ++i) {
                BusWoffRecordVO woffRecordVO = this.dealWoffRecord(finEnableInvoiceListVO, (Row)finZeroList.get(i), busEnableWoffRecordListVO, (Row)busZeroList.get(i));
                if (woffRecordVO == null) continue;
                woffRecordListVO.add(woffRecordVO);
            }
        }
        woffRecordListVO.addAll(this.getWoffRecordListVO(finPositiveList, busPositiveList));
        woffRecordListVO.addAll(this.getWoffRecordListVO(finNegativeList, busNegativeList));
        return woffRecordListVO;
    }

    protected abstract List<BusWoffRecordVO> getWoffRecordListVO(List<Row> var1, List<Row> var2);

    @Override
    protected void dealFinInvoice(Row finRow, BusWoffRecordVO finEnableInvoiceVO, BusWoffRecordVO busWoffRecordVO) {
        BusWoffHelper.calculatorFinInvoice(this.finModel, finRow, finEnableInvoiceVO, busWoffRecordVO);
    }

    @Override
    protected void writeBackSrcBusEntry(Set<Long> srcBusIdSet, List<BusWoffRecordVO> woffRecordListVO) {
        int batchSize = this.getBusWoffBatchSize();
        BusWoffHelper.writeBackSrcBusEntry(this.busWoffParam.getBusEntity(), srcBusIdSet, woffRecordListVO, batchSize);
    }

    @Override
    protected Object[] prepareDelWoff(BusWoffResult result) {
        HashSet<Long> delWoffIds = new HashSet<Long>(8);
        List<BusWoffRecordVO> woffRecordListVO = this.getWoffRecordVO(result, delWoffIds);
        if (woffRecordListVO.isEmpty()) {
            return null;
        }
        this.writeBackSrcBusEntry(woffRecordListVO);
        return delWoffIds.toArray();
    }

    private void writeBackSrcBusEntry(List<BusWoffRecordVO> woffRecordListVO) {
        if (ObjectUtils.isEmpty(woffRecordListVO)) {
            return;
        }
        Set<Long> srcBusIdSet = woffRecordListVO.stream().map(BusWoffRecordVO::getSrcBusId).collect(Collectors.toSet());
        logger.info("----------BusWoffService \u9700\u8981\u52a0\u9501\u63a7\u5236\u5e76\u53d1\u7684\u6700\u521d\u6e90\u6682\u4f30\u5355ID\u96c6\u5408 \uff1a" + srcBusIdSet);
        ConcurrencyCtrlUtil.addCtrlInTX(this.busWoffParam.getBusEntity(), "woff", srcBusIdSet);
        ArrayList<String> finMatchFields = new ArrayList<String>(2);
        ArrayList<String> busMatchFields = new ArrayList<String>(2);
        this.initMatchSelector(finMatchFields, busMatchFields);
        DataSet srcBusDataSet = this.getBusDataSet(srcBusIdSet, busMatchFields);
        if (ObjectUtils.isEmpty((Object)srcBusDataSet)) {
            return;
        }
        DataSet finDataSet = this.getFinDataSet(finMatchFields);
        if (ObjectUtils.isEmpty((Object)finDataSet)) {
            return;
        }
        this.woffMatch(finDataSet, finMatchFields, srcBusDataSet, busMatchFields, woffRecordListVO, true, true);
    }
}

