/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.buswoff;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.business.price.AbstractPriceCalculator;
import kd.fi.arapcommon.business.price.IPriceCalculate;
import kd.fi.arapcommon.business.price.PriceLocalCalculator;
import kd.fi.arapcommon.business.price.PriceTotalCalculator;
import kd.fi.arapcommon.business.price.TaxUnitPriceCalculator;
import kd.fi.arapcommon.business.price.UnitPriceCalculator;
import kd.fi.arapcommon.consts.BillTypeConsts;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.BOTPNewHelper;
import kd.fi.arapcommon.helper.BizExtendHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.helper.WriteOffBillWriteBackHelper;
import kd.fi.arapcommon.model.FinBillModel;
import kd.fi.arapcommon.service.bus.WoffModeEnum;
import kd.fi.arapcommon.service.buswoff.AbstractBusWrittenOffWoff;
import kd.fi.arapcommon.service.buswoff.BusBotpWoffFromFinap;
import kd.fi.arapcommon.service.buswoff.BusBotpWoffFromFinar;
import kd.fi.arapcommon.service.buswoff.BusCoreBillWoffFromFinap;
import kd.fi.arapcommon.service.buswoff.BusCoreBillWoffFromFinar;
import kd.fi.arapcommon.service.buswoff.BusGroupWoffFromFinap;
import kd.fi.arapcommon.service.buswoff.BusGroupWoffFromFinar;
import kd.fi.arapcommon.service.buswoff.BusPrepaidWoffFromFinAr;
import kd.fi.arapcommon.service.buswoff.BusSameSourceWoffFromFinap;
import kd.fi.arapcommon.service.buswoff.BusSameSourceWoffFromFinar;
import kd.fi.arapcommon.service.buswoff.BusWoffRecordVO;
import kd.fi.arapcommon.service.buswoff.BusWoffResult;
import kd.fi.arapcommon.service.buswoff.BusWrittenOffWoffFromFinap;
import kd.fi.arapcommon.service.buswoff.BusWrittenOffWoffFromFinar;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StdConfig;
import kd.fi.arapcommon.util.StringUtils;

public class BusWoffHelper {
    private static final Log logger = LogFactory.getLog(BusWoffHelper.class);

    public static Boolean woffServiceV2() {
        String woffServiceV2 = StdConfig.get("woffServiceV2");
        if (EmptyUtils.isEmpty(woffServiceV2)) {
            return Boolean.FALSE;
        }
        return Boolean.valueOf(woffServiceV2);
    }

    public static void matchSystemParameter(boolean isAr, List<Long> orgIds) {
        Map<Long, Object> orgMap = SystemParameterHelper.batchGetAppParameter(isAr, orgIds, isAr ? "ar_004" : "ap_004");
        for (Map.Entry<Long, Object> orgEntry : orgMap.entrySet()) {
            Object value = orgEntry.getValue();
            if (ObjectUtils.isEmpty((Object)value)) continue;
            if (value instanceof Boolean) {
                if (((Boolean)value).booleanValue()) continue;
                orgIds.remove(orgEntry.getKey());
                continue;
            }
            if (!(value instanceof String) || !"0".equals(value)) continue;
            orgIds.remove(orgEntry.getKey());
        }
    }

    public static Map<Long, QFilter> getQFilterByAppParameters(Boolean isAr, List<Long> orgIds, String param004, String param040, String paramConditionValue, String entityKey) {
        HashMap<Long, QFilter> filterByOrgId = new HashMap<Long, QFilter>(2);
        Map<Long, Map<String, Object>> orgMaps = SystemParameterHelper.batchGetAppParameters(isAr, orgIds, param004, param040, paramConditionValue);
        for (Map.Entry<Long, Map<String, Object>> orgMapsEntry : orgMaps.entrySet()) {
            Long orgId = orgMapsEntry.getKey();
            boolean needWoff = true;
            QFilter filter = null;
            for (Map.Entry<String, Object> parametersEntry : orgMapsEntry.getValue().entrySet()) {
                Object value = parametersEntry.getValue();
                switch (parametersEntry.getKey()) {
                    case "ar_004": 
                    case "ap_004": 
                    case "ar_0042": {
                        if (ObjectUtils.isEmpty((Object)value)) break;
                        if (value instanceof Boolean) {
                            if (((Boolean)value).booleanValue()) break;
                            needWoff = false;
                            break;
                        }
                        if (!(value instanceof String) || !"0".equals(value)) break;
                        needWoff = false;
                        break;
                    }
                    case "ar_0041": 
                    case "ap_0041": 
                    case "ap_0042": {
                        if (ObjectUtils.isEmpty((Object)value)) {
                            needWoff = false;
                            break;
                        }
                        if (((Boolean)value).booleanValue()) break;
                        needWoff = false;
                        break;
                    }
                    case "ar0042_conditionvalue": {
                        if (ObjectUtils.isEmpty((Object)value)) {
                            value = BusWoffHelper.getDefaultConditionValue("ar0042_conditionvalue");
                        }
                    }
                    case "ar0041_conditionvalue": 
                    case "ap0041_conditionvalue": 
                    case "ap0042_conditionvalue": {
                        if (ObjectUtils.isEmpty((Object)value) || !needWoff) break;
                        CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)String.valueOf(value), CRCondition.class);
                        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityKey);
                        FilterBuilder filterBuilder = new FilterBuilder(dataEntityType, condition.getFilterCondition(), true);
                        filterBuilder.buildFilter(false);
                        filter = filterBuilder.getQFilter();
                    }
                }
            }
            if (needWoff) {
                if (ObjectUtils.isEmpty(filter)) {
                    filter = new QFilter("1", "=", (Object)1);
                }
                filterByOrgId.put(orgId, filter);
                continue;
            }
            orgIds.remove(orgId);
        }
        return filterByOrgId;
    }

    public static String getDefaultConditionValue(String paramKey) {
        String conditionJson = "";
        if ("ar0042_conditionvalue".equals(paramKey)) {
            conditionJson = "{\"exprTran\":\"\u6e90\u5355\u7c7b\u578b \u7b49\u4e8e \u9500\u552e\u8ba2\u5355   and    \u5355\u636e\u7c7b\u578b.\u7f16\u7801 \u7b49\u4e8e ar_busbill_standard_BT_S\",\"description\":{\"zh_CN\":\"\"},\"filterCondition\":{\"filterRow\":[{\"id\":\"40GY388SD5=A\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"sourcebilltype\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"40GY388SD4M1\",\"value\":\"sm_salorder\"}],\"baseDataIds\":[]},{\"id\":\"40GY388SD5=B\",\"leftBracket\":\"\",\"compareType\":\"67\",\"fieldName\":\"billtype.number\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"40GY388SD4M2\",\"value\":\"ar_busbill_standard_BT_S\"}],\"baseDataIds\":[{\"id\":\"40GY388W/KGU\",\"value\":\"676495785168226304\"}]}],\"forList\":false},\"filterString\":\"{\\\"filterRow\\\":[{\\\"id\\\":\\\"40GY388SD5=A\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"105\\\",\\\"fieldName\\\":\\\"sourcebilltype\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"40GY388SD4M1\\\",\\\"value\\\":\\\"sm_salorder\\\"}],\\\"baseDataIds\\\":[]},{\\\"id\\\":\\\"40GY388SD5=B\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"67\\\",\\\"fieldName\\\":\\\"billtype.number\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"40GY388SD4M2\\\",\\\"value\\\":\\\"ar_busbill_standard_BT_S\\\"}],\\\"baseDataIds\\\":[{\\\"id\\\":\\\"40GY388W/KGU\\\",\\\"value\\\":\\\"676495785168226304\\\"}]}],\\\"forList\\\":false}\",\"initialized\":false,\"localeExprTran\":{\"zh_CN\":\"\u6e90\u5355\u7c7b\u578b \u7b49\u4e8e \u9500\u552e\u8ba2\u5355   and    \u5355\u636e\u7c7b\u578b.\u7f16\u7801 \u7b49\u4e8e ar_busbill_standard_BT_S\"},\"exprDesc\":\"\u6e90\u5355\u7c7b\u578b \u7b49\u4e8e \u9500\u552e\u8ba2\u5355   and    \u5355\u636e\u7c7b\u578b.\u7f16\u7801 \u7b49\u4e8e ar_busbill_standard_BT_S\"}";
        }
        return conditionJson;
    }

    public static void doBusWoffFromFinAr(DynamicObject[] finBills) {
        if (ObjectUtils.isEmpty((Object[])finBills)) {
            return;
        }
        logger.info("----------doBusWoffFromFinAr start");
        HashMap orgParamMap = new HashMap(2);
        HashSet<Long> prepaidFinIds = new HashSet<Long>(2);
        HashMap<Long, Long> entryIdToBillId = new HashMap<Long, Long>(finBills.length);
        for (DynamicObject finBill : finBills) {
            long billtypeId = finBill.getLong("billtype.id");
            if (finBill.getBoolean("iswrittenoff") || BillTypeConsts.ARFIN_BORROW.compareTo(billtypeId) == 0 || finBill.getBoolean("istransfer") || finBill.getBoolean("ispremium")) continue;
            Long orgId = finBill.getLong("org.id");
            Object ar004 = orgParamMap.get(orgId);
            if (ObjectUtils.isEmpty(ar004)) {
                ar004 = SystemParameterHelper.getAppParameter("/BBRH+122=39", orgId, "ar_004");
                if (ObjectUtils.isEmpty(ar004)) {
                    ar004 = "0";
                }
                orgParamMap.put(orgId, ar004);
            }
            if (!"1".equals(ar004)) continue;
            if (BillTypeConsts.ARFIN_STANDARD.compareTo(billtypeId) != 0 && BillTypeConsts.ARFIN_SERSAL.compareTo(billtypeId) != 0 && BillTypeConsts.ARFIN_EXPENSE.compareTo(billtypeId) != 0 && BillTypeConsts.ARFIN_BORROW.compareTo(billtypeId) != 0 && "ap_finapbill".equals(finBill.getString("sourcebilltype"))) {
                prepaidFinIds.add(finBill.getLong("id"));
            }
            for (DynamicObject entry : finBill.getDynamicObjectCollection("entry")) {
                entryIdToBillId.put(entry.getLong("id"), finBill.getLong("id"));
            }
        }
        if (ObjectUtils.isEmpty(entryIdToBillId)) {
            return;
        }
        Set<Long> finBillIds = entryIdToBillId.values().stream().collect(Collectors.toSet());
        logger.info("----------BusPrepaidWoffFromFinAr start");
        if (!ObjectUtils.isEmpty(prepaidFinIds)) {
            BusPrepaidWoffFromFinAr prepaidWoff = new BusPrepaidWoffFromFinAr();
            BusWoffResult result = prepaidWoff.busWoff(prepaidFinIds);
            finBillIds.removeAll(result.getFinBillIds());
        }
        logger.info("----------BusPrepaidWoffFromFinAr end");
        logger.info("----------BusBotpWoffFromFinar start");
        Map<Long, BFRowId> sourceBusBFRowMap = BOTPHelper.loadNearSrcBFRowIdMap("ar_finarbill", "entry", finBillIds.toArray(new Long[0]), entryIdToBillId.keySet().toArray(new Long[0]), "ar_busbill");
        HashSet<Long> needBotpWoffFinIdSet = new HashSet<Long>(8);
        for (Long finEntryId : sourceBusBFRowMap.keySet()) {
            needBotpWoffFinIdSet.add((Long)entryIdToBillId.get(finEntryId));
        }
        if (!ObjectUtils.isEmpty(needBotpWoffFinIdSet)) {
            BusBotpWoffFromFinar busBotpWoff = new BusBotpWoffFromFinar();
            BusWoffResult result = busBotpWoff.busAssignWoff(needBotpWoffFinIdSet, sourceBusBFRowMap);
            finBillIds.removeAll(result.getFinBillIds());
        }
        logger.info("----------BusBotpWoffFromFinar end");
        logger.info("----------BusSameSourceWoffFromFinar start");
        HashSet<Long> srcEntryIdSet = new HashSet<Long>(8);
        for (DynamicObject finBill : finBills) {
            if (!finBillIds.contains(finBill.getLong("id"))) continue;
            for (DynamicObject entry : finBill.getDynamicObjectCollection("entry")) {
                srcEntryIdSet.add(entry.getLong("e_srcentryid"));
            }
        }
        srcEntryIdSet.remove(0L);
        if (!ObjectUtils.isEmpty(srcEntryIdSet)) {
            BusSameSourceWoffFromFinar busSameSourceWoff = new BusSameSourceWoffFromFinar();
            BusWoffResult result = busSameSourceWoff.busWoff(finBillIds);
            finBillIds.removeAll(result.getFinBillIds());
        }
        logger.info("----------BusSameSourceWoffFromFinar end");
        logger.info("----------BusGroupWoffFromFinar start");
        BusGroupWoffFromFinar busGroupWoff = new BusGroupWoffFromFinar();
        BusWoffResult result = busGroupWoff.busWoff(finBillIds);
        finBillIds.removeAll(result.getFinBillIds());
        logger.info("----------BusGroupWoffFromFinar end");
        logger.info("----------BusCoreBillWoffFromFinar start");
        BusCoreBillWoffFromFinar busCoreBillWoff = new BusCoreBillWoffFromFinar();
        result = busCoreBillWoff.busWoff(finBillIds);
        finBillIds.removeAll(result.getFinBillIds());
        logger.info("----------BusCoreBillWoffFromFinar end");
        logger.info("----------doBusWoffFromFinAr end");
    }

    /*
     * WARNING - void declaration
     */
    public static void doBusWoffFromFinAp(DynamicObject[] finBills) {
        if (ObjectUtils.isEmpty((Object[])finBills)) {
            return;
        }
        logger.info("----------doBusWoffFromFinAp start");
        HashMap<Long, void> orgParamMap = new HashMap<Long, void>(2);
        HashMap<Long, Long> entryIdToBillId = new HashMap<Long, Long>(finBills.length);
        for (DynamicObject finBill : finBills) {
            void var8_10;
            if (finBill.getBoolean("iswrittenoff") || BillTypeConsts.ARFIN_BORROW.compareTo(finBill.getLong("billtypeid.id")) == 0 || finBill.getBoolean("istanspay") || finBill.getBoolean("ispremium")) continue;
            Long orgId = finBill.getLong("org.id");
            Object v = orgParamMap.get(orgId);
            if (ObjectUtils.isEmpty(v)) {
                void var8_14;
                Object object = SystemParameterHelper.getAppParameter("+HKZHSKFXOX", orgId, "ap_004");
                if (ObjectUtils.isEmpty((Object)object)) {
                    String string = "0";
                }
                orgParamMap.put(orgId, var8_14);
            }
            if (!"1".equals(var8_10)) continue;
            for (DynamicObject entry : finBill.getDynamicObjectCollection("detailentry")) {
                entryIdToBillId.put(entry.getLong("id"), finBill.getLong("id"));
            }
        }
        if (ObjectUtils.isEmpty(entryIdToBillId)) {
            return;
        }
        Set<Long> finBillIds = entryIdToBillId.values().stream().collect(Collectors.toSet());
        logger.info("----------BusBotpWoffFromFinap start");
        Map<Long, BFRowId> sourceBusBFRowMap = BOTPHelper.loadNearSrcBFRowIdMap("ap_finapbill", "detailentry", finBillIds.toArray(new Long[0]), entryIdToBillId.keySet().toArray(new Long[0]), "ap_busbill");
        HashSet<Long> needBotpWoffFinIdSet = new HashSet<Long>(8);
        for (Long finEntryId : sourceBusBFRowMap.keySet()) {
            needBotpWoffFinIdSet.add((Long)entryIdToBillId.get(finEntryId));
        }
        if (!ObjectUtils.isEmpty(needBotpWoffFinIdSet)) {
            BusBotpWoffFromFinap busBotpWoff = new BusBotpWoffFromFinap();
            BusWoffResult result = busBotpWoff.busAssignWoff(needBotpWoffFinIdSet, sourceBusBFRowMap);
            finBillIds.removeAll(result.getFinBillIds());
        }
        logger.info("----------BusBotpWoffFromFinap end");
        logger.info("----------BusSameSourceWoffFromFinap start");
        HashSet<Long> srcEntryIdSet = new HashSet<Long>(8);
        HashSet<Long> haveSrcEntryIdFinBillIds = new HashSet<Long>(16);
        for (DynamicObject dynamicObject : finBills) {
            if (!finBillIds.contains(dynamicObject.getLong("id"))) continue;
            for (DynamicObject entry : dynamicObject.getDynamicObjectCollection("detailentry")) {
                long srcEntryId = entry.getLong("e_sourcebillentryid");
                if (srcEntryId == 0L) continue;
                srcEntryIdSet.add(srcEntryId);
                haveSrcEntryIdFinBillIds.add(dynamicObject.getLong("id"));
            }
        }
        logger.info("samesourcefin:" + haveSrcEntryIdFinBillIds);
        if (!ObjectUtils.isEmpty(srcEntryIdSet) && haveSrcEntryIdFinBillIds.size() > 0) {
            BusSameSourceWoffFromFinap busSameSourceWoffFromFinap = new BusSameSourceWoffFromFinap();
            BusWoffResult result = busSameSourceWoffFromFinap.busWoff(haveSrcEntryIdFinBillIds);
            finBillIds.removeAll(result.getFinBillIds());
        }
        logger.info("----------BusSameSourceWoffFromFinap end");
        logger.info("----------BusGroupWoffFromFinap start");
        BusGroupWoffFromFinap busGroupWoffFromFinap = new BusGroupWoffFromFinap();
        BusWoffResult result = busGroupWoffFromFinap.busWoff(finBillIds);
        finBillIds.removeAll(result.getFinBillIds());
        logger.info("----------BusGroupWoffFromFinap end");
        logger.info("----------BusCoreBillWoffFromFinap start");
        BusCoreBillWoffFromFinap busCoreBillWoff = new BusCoreBillWoffFromFinap();
        result = busCoreBillWoff.busWoff(finBillIds);
        finBillIds.removeAll(result.getFinBillIds());
        logger.info("----------BusCoreBillWoffFromFinap end");
        logger.info("----------doBusWoffFromFinAp start");
    }

    public static void finWriteOffWriteBackBusForSave(boolean isAr, List<DynamicObject> writeOffBills) {
        if (BusWoffHelper.woffServiceV2().booleanValue()) {
            WriteOffBillWriteBackHelper.writeBackForSave(writeOffBills.toArray(new DynamicObject[0]), false);
        } else {
            HashMap<Long, DynamicObject> writtenOffMap = new HashMap<Long, DynamicObject>(2);
            for (DynamicObject writeOffBill : writeOffBills) {
                if (!writeOffBill.getBoolean("iswrittenoff")) continue;
                writtenOffMap.put(writeOffBill.getLong("id"), writeOffBill);
            }
            if (ObjectUtils.isEmpty(writtenOffMap)) {
                return;
            }
            AbstractBusWrittenOffWoff writtenOffWoff = isAr ? new BusWrittenOffWoffFromFinar() : new BusWrittenOffWoffFromFinap();
            BusWoffResult result = writtenOffWoff.busWoff(writtenOffMap.keySet());
            for (Long doneWriteOffBillId : result.getFinBillIds()) {
                writtenOffMap.remove(doneWriteOffBillId);
            }
            if (!ObjectUtils.isEmpty(writtenOffMap)) {
                WriteOffBillWriteBackHelper.writeBackForSave(writtenOffMap.values().toArray(new DynamicObject[0]), false);
            }
        }
    }

    public static void finWriteOffWriteBackBusForUnAudit(boolean isAr, DynamicObject[] writeOffBills) {
        if (BusWoffHelper.woffServiceV2().booleanValue()) {
            WriteOffBillWriteBackHelper.writeBackForUnAudit(writeOffBills, true);
        } else {
            HashMap<Long, DynamicObject> needWrittenOffMap = new HashMap<Long, DynamicObject>(2);
            for (DynamicObject bill : writeOffBills) {
                if (!bill.getBoolean("iswrittenoff")) continue;
                needWrittenOffMap.put(bill.getLong("id"), bill);
            }
            if (ObjectUtils.isEmpty(needWrittenOffMap)) {
                return;
            }
            AbstractBusWrittenOffWoff writtenOffWoff = isAr ? new BusWrittenOffWoffFromFinar() : new BusWrittenOffWoffFromFinap();
            BusWoffResult result = writtenOffWoff.busUnWoffBills(needWrittenOffMap.keySet());
            for (Long doneBillId : result.getFinBillIds()) {
                needWrittenOffMap.remove(doneBillId);
            }
            if (!ObjectUtils.isEmpty(needWrittenOffMap)) {
                WriteOffBillWriteBackHelper.writeBackForUnAudit(needWrittenOffMap.values().toArray(new DynamicObject[0]), true);
            }
        }
    }

    public static Map<String, String> getOtherMatchField(WoffModeEnum woffMode, String finEntityKey) {
        Map<String, String> matchField = BizExtendHelper.moreMatchField(woffMode.getValue(), finEntityKey);
        return matchField;
    }

    public static QFilter getFinArQFilter() {
        return new QFilter("iswrittenoff", "=", (Object)Boolean.FALSE).and("istransfer", "=", (Object)Boolean.FALSE).and("ispremium", "=", (Object)Boolean.FALSE).and("billtype.id", "!=", (Object)BillTypeConsts.ARFIN_BORROW);
    }

    public static QFilter getFinApQFilter() {
        return new QFilter("iswrittenoff", "=", (Object)Boolean.FALSE).and("istanspay", "=", (Object)Boolean.FALSE).and("ispremium", "=", (Object)Boolean.FALSE).and("billtypeid.id", "!=", (Object)BillTypeConsts.APFIN_BORROW);
    }

    public static DataSet dealAsstactDataSet(String asstacttype, Set<Long> asstactIdSet, DataSet dataSet, List<String> selector) {
        if (!ObjectUtils.isEmpty(asstactIdSet)) {
            DataSet asstactDataSet = QueryServiceHelper.queryDataSet((String)"buswoff_cs", (String)asstacttype, (String)"id,masterid as cs.masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", asstactIdSet)}, (String)"");
            ArrayList<String> selector1 = new ArrayList<String>(8);
            selector1.addAll(selector);
            selector1.remove("asstact.masterid");
            selector1.add("case when asstact.masterid is null and asstacttype='" + asstacttype + "' then cs.masterid else asstact.masterid end as asstact.masterid");
            dataSet = dataSet.leftJoin(asstactDataSet).on("asstact", "id").select(selector1.toArray(new String[0])).finish();
        }
        selector.add("case when asstact.masterid is null then asstact else asstact.masterid end as asstact");
        selector.remove("asstact");
        selector.remove("asstact.masterid");
        return dataSet.select(selector.toArray(new String[0]));
    }

    private static DataSet getSrcBusDataSet(String entity, Set<Long> srcBusIdSet) {
        String orderByDate = "bookdate";
        StringBuilder selector = new StringBuilder("id,billno,invoicedamt,uninvoicedamt,invoicedlocamt,uninvoicedlocamt,entry.id,entry.e_quantity,entry.e_amount,entry.e_invoicedqty,entry.e_uninvoicedqty,entry.e_invoicedamt,entry.e_uninvoicedamt,entry.e_invoicedlocamt,entry.e_uninvoicedlocamt,entry.e_invoicednotaxamt,entry.e_uninvnotaxamt,entry.e_invnotaxlocalamt,entry.e_uninvnotaxlocalamt");
        selector.append(',').append(orderByDate);
        selector.append(",payproperty.isbasedonamt");
        selector.append(",entry.e_ispresent");
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getSrcBusDataSet", (String)entity, (String)selector.toString(), (QFilter[])new QFilter[]{new QFilter("id", "in", srcBusIdSet)}, (String)"");
        dataSet = dataSet.orderBy(new String[]{orderByDate});
        return dataSet;
    }

    public static void writeBackSrcBusEntry(String busEntityKey, Set<Long> srcBusIdSet, List<BusWoffRecordVO> woffRecordListVO, int batchSize) {
        if (ObjectUtils.isEmpty(srcBusIdSet) || ObjectUtils.isEmpty(woffRecordListVO)) {
            return;
        }
        DataSet srcBusDataSet = BusWoffHelper.getSrcBusDataSet(busEntityKey, srcBusIdSet);
        if (ObjectUtils.isEmpty((Object)srcBusDataSet)) {
            return;
        }
        HashMap<Long, BigDecimal[]> headParamMap = new HashMap<Long, BigDecimal[]>(2);
        ArrayList<Object[]> entryParams = new ArrayList<Object[]>(8);
        ArrayList<Object[]> entryEParams = new ArrayList<Object[]>(8);
        Map<Long, List<BusWoffRecordVO>> woffRecordListVOMap = woffRecordListVO.stream().collect(Collectors.groupingBy(BusWoffRecordVO::getSrcBusEntryId));
        boolean isAr = "ar_busbill".equals(busEntityKey);
        for (Row srcBusRow : srcBusDataSet) {
            Long srcBusEntryId = srcBusRow.getLong("entry.id");
            List<BusWoffRecordVO> woffRecordListVOBySrcBusEntryId = woffRecordListVOMap.get(srcBusEntryId);
            if (ObjectUtils.isEmpty(woffRecordListVOBySrcBusEntryId)) continue;
            BigDecimal finQuantity = BigDecimal.ZERO;
            BigDecimal finAmount = BigDecimal.ZERO;
            BigDecimal finLocalAmt = BigDecimal.ZERO;
            BigDecimal finPriceTaxTotal = BigDecimal.ZERO;
            BigDecimal finPriceTaxTotalLocal = BigDecimal.ZERO;
            for (BusWoffRecordVO busWoffRecordVO : woffRecordListVOBySrcBusEntryId) {
                finQuantity = finQuantity.add(busWoffRecordVO.getInvoicedQty());
                finAmount = finAmount.add(busWoffRecordVO.getInvoicedNoTaxAmt());
                finLocalAmt = finLocalAmt.add(busWoffRecordVO.getInvNoTaxLocalAmt());
                finPriceTaxTotal = finPriceTaxTotal.add(busWoffRecordVO.getInvoicedAmt());
                finPriceTaxTotalLocal = finPriceTaxTotalLocal.add(busWoffRecordVO.getInvoicedLocAmt());
            }
            BusWoffHelper.dealSqlParams(headParamMap, entryParams, entryEParams, srcBusRow, false, finQuantity, finAmount, finLocalAmt, finPriceTaxTotal, finPriceTaxTotalLocal);
            if (entryParams.size() != batchSize) continue;
            BusWoffHelper.execSqlUpdate(isAr, headParamMap, entryParams, entryEParams);
            headParamMap.clear();
            entryParams.clear();
            entryEParams.clear();
        }
        if (entryParams.size() > 0) {
            BusWoffHelper.execSqlUpdate(isAr, headParamMap, entryParams, entryEParams);
        }
    }

    public static void dealSqlParams(Map<Long, BigDecimal[]> headParamMap, List<Object[]> entryParams, List<Object[]> entryEParams, Row srcBusRow, boolean isRevert, BigDecimal finQuantity, BigDecimal finAmount, BigDecimal finLocalAmt, BigDecimal finPriceTaxTotal, BigDecimal finPriceTaxTotalLocal) {
        if (isRevert) {
            finQuantity = finQuantity.negate();
            finAmount = finAmount.negate();
            finLocalAmt = finLocalAmt.negate();
            finPriceTaxTotal = finPriceTaxTotal.negate();
            finPriceTaxTotalLocal = finPriceTaxTotalLocal.negate();
        }
        Long srcBusId = srcBusRow.getLong("id");
        Long srcBusEntryId = srcBusRow.getLong("entry.id");
        BigDecimal[] headParams = headParamMap.get(srcBusId);
        if (headParams == null) {
            headParams = new BigDecimal[]{finPriceTaxTotal, finPriceTaxTotal, finPriceTaxTotalLocal, finPriceTaxTotalLocal};
        } else {
            headParams[0] = finPriceTaxTotal.add(headParams[0]);
            headParams[1] = finPriceTaxTotal.add(headParams[1]);
            headParams[2] = finPriceTaxTotalLocal.add(headParams[2]);
            headParams[3] = finPriceTaxTotalLocal.add(headParams[3]);
        }
        headParamMap.put(srcBusId, headParams);
        BigDecimal quantity = srcBusRow.getBigDecimal("entry.e_quantity");
        BigDecimal invoicedqty = srcBusRow.getBigDecimal("entry.e_invoicedqty").add(finQuantity);
        if (srcBusRow.getBoolean("payproperty.isbasedonamt").booleanValue()) {
            BigDecimal e_amount = srcBusRow.getBigDecimal("entry.e_amount");
            BigDecimal e_invoicednotaxamt = srcBusRow.getBigDecimal("entry.e_invoicednotaxamt").add(finAmount);
            invoicedqty = srcBusRow.getBoolean("entry.e_ispresent") != false || e_amount.compareTo(BigDecimal.ZERO) == 0 ? (isRevert ? BigDecimal.ZERO : quantity) : (e_invoicednotaxamt.compareTo(BigDecimal.ZERO) == 0 ? (isRevert ? BigDecimal.ZERO : quantity) : (e_amount.compareTo(e_invoicednotaxamt) > 0 && e_amount.abs().compareTo(e_invoicednotaxamt.abs()) > 0 ? BigDecimal.ZERO : quantity));
        }
        Object[] entryParam = new Object[]{invoicedqty, quantity.subtract(invoicedqty), finPriceTaxTotal, finPriceTaxTotal, finPriceTaxTotalLocal, finPriceTaxTotalLocal, srcBusEntryId};
        entryParams.add(entryParam);
        Object[] entryEParam = new Object[]{finAmount, finAmount, finLocalAmt, finLocalAmt, srcBusEntryId};
        entryEParams.add(entryEParam);
    }

    public static void execSqlUpdate(boolean isAr, Map<Long, BigDecimal[]> headParamMap, List<Object[]> entryParams, List<Object[]> entryEParams) {
        DBRoute dbRoute = isAr ? DBRouteConst.AR : DBRouteConst.AP;
        String headTable = isAr ? "t_ar_busbill" : "t_ap_busbill";
        String entryTable = isAr ? "t_ar_busbillentry" : "t_ap_busbillentry";
        String updateHeadSql = "UPDATE " + headTable + " SET finvoicedamt = finvoicedamt+?, funinvoicedamt = funinvoicedamt-?,finvoicedlocamt = finvoicedlocamt+?, funinvoicedlocamt = funinvoicedlocamt-? WHERE FID = ?;";
        String updateEntrySql = "UPDATE " + entryTable + " SET finvoicedqty = ?,funinvoicedqty = ?,finvoicedamt = finvoicedamt+?,funinvoicedamt = funinvoicedamt-?,finvoicedlocamt = finvoicedlocamt+?,funinvoicedlocamt = funinvoicedlocamt-? WHERE FENTRYID = ?;";
        String updateEntryESql = "UPDATE " + entryTable + "_e SET finvoicednotaxamt = finvoicednotaxamt+?,funinvnotaxamt = funinvnotaxamt-?,finvnotaxlocalamt = finvnotaxlocalamt+?,funinvnotaxlocalamt = funinvnotaxlocalamt-? WHERE FENTRYID = ?;";
        ArrayList<Object[]> headParams = new ArrayList<Object[]>(8);
        for (Map.Entry<Long, BigDecimal[]> headParamEntry : headParamMap.entrySet()) {
            Object[] headParam = new Object[5];
            BigDecimal[] amounts = headParamEntry.getValue();
            headParam[0] = amounts[0];
            headParam[1] = amounts[1];
            headParam[2] = amounts[2];
            headParam[3] = amounts[3];
            headParam[4] = headParamEntry.getKey();
            headParams.add(headParam);
        }
        DB.executeBatch((DBRoute)dbRoute, (String)updateHeadSql, headParams);
        DB.executeBatch((DBRoute)dbRoute, (String)updateEntrySql, entryParams);
        DB.executeBatch((DBRoute)dbRoute, (String)updateEntryESql, entryEParams);
    }

    public static void writeOffExecSqlUpdate(String busEntity, boolean isRevert, Set<Long> woffBusIdSet, Set<Long> woffBusEntryIdSet) {
        boolean isAr = "ar_busbill".equals(busEntity);
        DBRoute dbRoute = isAr ? DBRouteConst.AR : DBRouteConst.AP;
        String headTable = isAr ? "t_ar_busbill_e" : "t_ap_busbill_e";
        String entryTable = isAr ? "t_ar_busbillentry" : "t_ap_busbillentry";
        String updateHeadSql = "UPDATE " + headTable + " SET fwriteoffbusiness = " + (isRevert ? 1 : 0) + " WHERE FID in " + StringUtils.setToString(woffBusIdSet) + ";";
        String entryIdStr = StringUtils.setToString(woffBusEntryIdSet);
        String updateEntrySql = isRevert ? "UPDATE " + entryTable + " SET fiswriteoff = 1 WHERE FID in " + entryIdStr + " and funwoffqty = 0;" : "UPDATE " + entryTable + " SET fiswriteoff = 0 WHERE FID in " + entryIdStr + " and funwoffqty != 0;";
        DB.execute((DBRoute)dbRoute, (String)updateHeadSql);
        DB.execute((DBRoute)dbRoute, (String)updateEntrySql);
    }

    public static Map<Long, String> prepaidWoffMatch(FinBillModel finModel, DataSet finDataSet, DataSet srcBusDataSet, List<BusWoffRecordVO> woffRecordListVO, int batchSize, boolean isRevert, boolean execSqlUpdate) {
        List<BusWoffRecordVO> woffRecordListVOTemp;
        HashMap<Long, String> overfulfilBillnoMap = new HashMap<Long, String>(2);
        if (!finDataSet.hasNext() || !srcBusDataSet.hasNext()) {
            return overfulfilBillnoMap;
        }
        HashMap srcBusIdMap = new HashMap(2);
        srcBusDataSet.copy().forEach(row -> srcBusIdMap.put(row.getLong("entry.id"), row.getLong("id")));
        Map<Long, Long> srcBusToBusApRowIdsMap = BOTPNewHelper.loadNearSourceRowIds("ar_busbill", "entry", srcBusIdMap.values().toArray(new Long[0]), srcBusIdMap.keySet().toArray(new Long[0]), "ap_busbill");
        HashMap<Long, Long> busApToSrcBusArRowIdsMap = new HashMap<Long, Long>(srcBusToBusApRowIdsMap.size());
        for (Map.Entry<Long, Long> entry : srcBusToBusApRowIdsMap.entrySet()) {
            busApToSrcBusArRowIdsMap.put(entry.getValue(), entry.getKey());
        }
        HashMap finIdMap = new HashMap(2);
        finDataSet.copy().forEach(row -> finIdMap.put(row.getLong(finModel.ENTRY_PK), row.getLong("id")));
        Map<Long, Long> finToBusApRowIdsMap = BOTPNewHelper.loadNearSourceRowIds("ar_finarbill", "entry", finIdMap.values().toArray(new Long[0]), finIdMap.keySet().toArray(new Long[0]), "ap_busbill");
        HashMap srcBusEntryIdToFinId = new HashMap(2);
        HashMap<Long, BusWoffRecordVO> finEnableInvoiceListVO = new HashMap<Long, BusWoffRecordVO>(2);
        Map<Long, List<BusWoffRecordVO>> woffRecordListVOBySrcBusEntryId = woffRecordListVO.stream().collect(Collectors.groupingBy(BusWoffRecordVO::getSrcBusEntryId));
        for (Row finRow : finDataSet) {
            Long finEntryId = finRow.getLong(finModel.ENTRY_PK);
            Long busApEntryId = finToBusApRowIdsMap.get(finEntryId);
            Long srcBusEntryId = (Long)busApToSrcBusArRowIdsMap.get(busApEntryId);
            srcBusEntryIdToFinId.put(srcBusEntryId, finIdMap.get(finEntryId));
            BusWoffRecordVO finEnableInvoiceVO = BusWoffHelper.getFinEnableInvoiceListVO(finEnableInvoiceListVO, finRow, finModel);
            woffRecordListVOTemp = woffRecordListVOBySrcBusEntryId.get(srcBusEntryId);
            for (BusWoffRecordVO vo : woffRecordListVOTemp) {
                vo.setFinId(finRow.getLong("id"));
                vo.setFinEntryId(finEntryId);
                BusWoffHelper.calculatorFinInvoice(finModel, finRow, finEnableInvoiceVO, vo);
            }
        }
        HashMap<Long, BigDecimal[]> headParamMap = new HashMap<Long, BigDecimal[]>(2);
        ArrayList<Object[]> entryParams = new ArrayList<Object[]>(8);
        ArrayList<Object[]> entryEParams = new ArrayList<Object[]>(8);
        for (Row srcBusRow : srcBusDataSet) {
            Long srcBusEntryId = srcBusRow.getLong("entry.id");
            woffRecordListVOTemp = woffRecordListVOBySrcBusEntryId.get(srcBusEntryId);
            BigDecimal woffQuantity = BigDecimal.ZERO;
            BigDecimal woffAmount = BigDecimal.ZERO;
            BigDecimal finQuantity = BigDecimal.ZERO;
            BigDecimal finAmount = BigDecimal.ZERO;
            BigDecimal finLocalAmt = BigDecimal.ZERO;
            BigDecimal finPriceTaxTotal = BigDecimal.ZERO;
            BigDecimal finPriceTaxTotalLocal = BigDecimal.ZERO;
            for (BusWoffRecordVO vo : woffRecordListVOTemp) {
                woffQuantity = woffQuantity.add(vo.getQuantity());
                woffAmount = woffAmount.add(vo.getAmount());
                finQuantity = finQuantity.add(vo.getInvoicedQty());
                finAmount = finAmount.add(vo.getInvoicedNoTaxAmt());
                finLocalAmt = finLocalAmt.add(vo.getInvNoTaxLocalAmt());
                finPriceTaxTotal = finPriceTaxTotal.add(vo.getInvoicedAmt());
                finPriceTaxTotalLocal = finPriceTaxTotalLocal.add(vo.getInvoicedLocAmt());
            }
            Boolean isBasedonAmt = srcBusRow.getBoolean("payproperty.isbasedonamt");
            BigDecimal unWoffQty = srcBusRow.getBigDecimal("entry.e_unwoffqty");
            BigDecimal unWoffNoTaxAmt = srcBusRow.getBigDecimal("entry.e_unwoffnotaxamt");
            BigDecimal quantity = srcBusRow.getBigDecimal("entry.e_quantity");
            BigDecimal amount = srcBusRow.getBigDecimal("entry.e_amount");
            BigDecimal unInvocedQty = srcBusRow.getBigDecimal("entry.e_uninvoicedqty");
            BigDecimal unInvoiceNoTaxAmt = srcBusRow.getBigDecimal("entry.e_uninvnotaxamt");
            boolean overfulfil = false;
            if (isRevert) {
                unWoffQty = unWoffQty.subtract(woffQuantity);
                unWoffNoTaxAmt = unWoffNoTaxAmt.subtract(woffAmount);
                unInvocedQty = unInvocedQty.add(finQuantity);
                unInvoiceNoTaxAmt = unInvocedQty.add(finAmount);
            } else {
                unWoffQty = unWoffQty.add(woffQuantity);
                unWoffNoTaxAmt = unWoffNoTaxAmt.add(woffAmount);
                unInvocedQty = unInvocedQty.subtract(finQuantity);
                unInvoiceNoTaxAmt = unInvocedQty.subtract(finAmount);
            }
            if (isBasedonAmt.booleanValue()) {
                if (unWoffNoTaxAmt.multiply(amount).compareTo(BigDecimal.ZERO) < 0 || unInvoiceNoTaxAmt.multiply(amount).compareTo(BigDecimal.ZERO) < 0 || unWoffNoTaxAmt.abs().compareTo(amount.abs()) > 0 || unInvoiceNoTaxAmt.abs().compareTo(amount.abs()) > 0) {
                    overfulfil = true;
                }
            } else if (unWoffQty.multiply(quantity).compareTo(BigDecimal.ZERO) < 0 || unInvocedQty.multiply(quantity).compareTo(BigDecimal.ZERO) < 0 || unWoffQty.abs().compareTo(quantity.abs()) > 0 || unInvocedQty.abs().compareTo(quantity.abs()) > 0) {
                overfulfil = true;
            }
            if (overfulfil) {
                overfulfilBillnoMap.put((Long)srcBusEntryIdToFinId.get(srcBusEntryId), srcBusRow.getString("billno"));
                continue;
            }
            if (!execSqlUpdate) continue;
            BusWoffHelper.dealSqlParams(headParamMap, entryParams, entryEParams, srcBusRow, isRevert, finQuantity, finAmount, finLocalAmt, finPriceTaxTotal, finPriceTaxTotalLocal);
            if (entryParams.size() < batchSize) continue;
            BusWoffHelper.execSqlUpdate(true, headParamMap, entryParams, entryEParams);
            headParamMap.clear();
            entryParams.clear();
            entryEParams.clear();
        }
        if (execSqlUpdate && !entryParams.isEmpty()) {
            BusWoffHelper.execSqlUpdate(true, headParamMap, entryParams, entryEParams);
        }
        return overfulfilBillnoMap;
    }

    public static BusWoffRecordVO getFinEnableInvoiceListVO(Map<Long, BusWoffRecordVO> finEnableInvoiceListVO, Row finRow, FinBillModel finModel) {
        Long finEntryId = finRow.getLong(finModel.ENTRY_PK);
        BusWoffRecordVO finEnableInvoiceVO = finEnableInvoiceListVO.get(finEntryId);
        if (finEnableInvoiceVO == null) {
            finEnableInvoiceVO = new BusWoffRecordVO(finEntryId, finRow.getBigDecimal(finModel.ENTRY + "." + finModel.E_QUANTITY), finRow.getBigDecimal(finModel.ENTRY + "." + finModel.E_AMOUNT));
            finEnableInvoiceVO.setInvNoTaxLocalAmt(finRow.getBigDecimal(finModel.ENTRY + "." + finModel.E_LOCALAMT));
            finEnableInvoiceVO.setInvoicedAmt(finRow.getBigDecimal(finModel.ENTRY + "." + finModel.E_PRICETAXTOTAL));
            finEnableInvoiceVO.setInvoicedLocAmt(finRow.getBigDecimal(finModel.ENTRY + "." + finModel.E_PRICETAXTOTALLOC));
            finEnableInvoiceListVO.put(finEntryId, finEnableInvoiceVO);
        }
        return finEnableInvoiceVO;
    }

    public static void calculatorFinInvoice(FinBillModel finModel, Row finRow, BusWoffRecordVO finEnableInvoiceVO, BusWoffRecordVO busWoffRecordVO) {
        int precision = finRow.getInteger("currency.amtprecision");
        BigDecimal taxRate = finRow.getBigDecimal(finModel.ENTRY + "." + finModel.E_TAXRATE);
        String discountMode = finRow.getString(finModel.ENTRY + "." + finModel.E_DISCOUNTMODE);
        BigDecimal discountRate = finRow.getBigDecimal(finModel.ENTRY + "." + finModel.E_DISCOUNTRATE);
        BigDecimal discountAmount = finRow.getBigDecimal(finModel.ENTRY + "." + finModel.E_DISCOUNTAMOUNT);
        BigDecimal invoicedQty = busWoffRecordVO.getQuantity().negate();
        BigDecimal invoicedNoTaxAmt = busWoffRecordVO.getAmount().negate();
        AbstractPriceCalculator calculator = null;
        if (finRow.getBoolean("payproperty.isbasedonamt").booleanValue()) {
            BigDecimal finQuantity = finRow.getBigDecimal(finModel.ENTRY + "." + finModel.E_QUANTITY);
            if (finEnableInvoiceVO.getInvoicedNoTaxAmt().abs().compareTo(invoicedNoTaxAmt.abs()) > 0) {
                calculator = new PriceTotalCalculator(finQuantity, invoicedNoTaxAmt, taxRate, discountMode, discountRate, precision);
            }
            invoicedQty = busWoffRecordVO.isBusLastForAll() ? finQuantity : BigDecimal.ZERO;
        } else if (finEnableInvoiceVO.getInvoicedQty().abs().compareTo(invoicedQty.abs()) > 0) {
            if (finRow.getBoolean(finModel.HEAD_ISINCLUDETAX).booleanValue()) {
                if ("TOTAL".equals(discountMode)) {
                    discountAmount = discountRate.multiply(invoicedQty).setScale(precision, RoundingMode.HALF_UP);
                }
                calculator = new TaxUnitPriceCalculator(invoicedQty, finRow.getBigDecimal(finModel.ENTRY + "." + finModel.E_TAXUNITPRICE), taxRate, discountMode, discountRate, precision, BigDecimal.ZERO, discountAmount);
            } else {
                if ("TOTAL".equals(discountMode)) {
                    discountAmount = discountRate.multiply(invoicedQty).multiply(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L)))).setScale(precision, RoundingMode.HALF_UP);
                }
                calculator = new UnitPriceCalculator(invoicedQty, finRow.getBigDecimal(finModel.ENTRY + "." + finModel.E_UNITPRICE), taxRate, discountMode, discountRate, precision, BigDecimal.ZERO, discountAmount);
            }
        } else if (finRow.getBoolean(finModel.ENTRY + "." + finModel.E_ISALLVERIFY).booleanValue()) {
            invoicedQty = finEnableInvoiceVO.getInvoicedQty();
        }
        busWoffRecordVO.setInvoicedQty(invoicedQty);
        busWoffRecordVO.setInvoicedNoTaxAmt(invoicedNoTaxAmt);
        if (calculator != null) {
            PriceLocalCalculator localCalculator = new PriceLocalCalculator((IPriceCalculate)calculator, finRow.getBigDecimal(finModel.HEAD_EXCHANGERATE), (int)finRow.getInteger("basecurrency.amtprecision"), finRow.getString(finModel.HEAD_QUOTATION));
            localCalculator.calculate();
            invoicedNoTaxAmt = localCalculator.getAmount();
            BigDecimal invNoTaxLocalAmt = localCalculator.getAmountlocal();
            BigDecimal invoicedAmt = localCalculator.getPricetaxtotal();
            BigDecimal invoicedLocAmt = localCalculator.getPricetaxtotallocal();
            busWoffRecordVO.setInvoicedNoTaxAmt(invoicedNoTaxAmt);
            busWoffRecordVO.setInvNoTaxLocalAmt(invNoTaxLocalAmt);
            busWoffRecordVO.setInvoicedAmt(invoicedAmt);
            busWoffRecordVO.setInvoicedLocAmt(invoicedLocAmt);
            finEnableInvoiceVO.setInvoicedQty(finEnableInvoiceVO.getInvoicedQty().subtract(invoicedQty));
            finEnableInvoiceVO.setInvoicedNoTaxAmt(finEnableInvoiceVO.getInvoicedNoTaxAmt().subtract(invoicedNoTaxAmt));
            finEnableInvoiceVO.setInvNoTaxLocalAmt(finEnableInvoiceVO.getInvNoTaxLocalAmt().subtract(invNoTaxLocalAmt));
            finEnableInvoiceVO.setInvoicedAmt(finEnableInvoiceVO.getInvoicedAmt().subtract(invoicedAmt));
            finEnableInvoiceVO.setInvoicedLocAmt(finEnableInvoiceVO.getInvoicedLocAmt().subtract(invoicedLocAmt));
        } else {
            finEnableInvoiceVO.setFinAllWoffed(true);
            busWoffRecordVO.setFinAllWoffed(true);
            busWoffRecordVO.setInvoicedNoTaxAmt(finEnableInvoiceVO.getInvoicedNoTaxAmt());
            busWoffRecordVO.setInvNoTaxLocalAmt(finEnableInvoiceVO.getInvNoTaxLocalAmt());
            busWoffRecordVO.setInvoicedAmt(finEnableInvoiceVO.getInvoicedAmt());
            busWoffRecordVO.setInvoicedLocAmt(finEnableInvoiceVO.getInvoicedLocAmt());
        }
    }
}

