/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.check.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.plugin.support.util.ObjectUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.service.check.AbstractBillCheck;
import kd.fi.arapcommon.service.check.info.CheckInfo;
import kd.fi.arapcommon.util.DateUtils;

public class FinApSameInfoCheck
extends AbstractBillCheck {
    public FinApSameInfoCheck(String entityKey, IDataModel model) {
        super(entityKey, model);
    }

    @Override
    public CheckInfo check(DynamicObject item) {
        CheckInfo info = null;
        DynamicObjectCollection bills = this.query();
        if (!ObjectUtils.isEmpty((Object)bills)) {
            info = this.buildCheckInfo(item);
        }
        return info;
    }

    private DynamicObjectCollection query() {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(6);
        filters.add(new QFilter("org", "=", ((DynamicObject)this.model.getValue(this.m.HEAD_ORG)).getPkValue()));
        filters.add(new QFilter("bizdate", ">=", (Object)DateUtils.getNextDay((Date)this.model.getValue(this.m.HEAD_BIZDATE), -30)));
        filters.add(new QFilter("asstacttype", "=", this.model.getValue(this.m.HEAD_ASSTACTTYPE)));
        filters.add(new QFilter("asstact", "=", ((DynamicObject)this.model.getValue(this.m.HEAD_ASSTACT)).getPkValue()));
        filters.add(new QFilter("currency", "=", ((DynamicObject)this.model.getValue(this.m.HEAD_CURRENCY)).getPkValue()));
        filters.add(new QFilter("pricetaxtotal", "=", this.model.getValue(this.m.HEAD_PRICETAXTOTAL)));
        filters.add(new QFilter("id", "!=", this.model.getValue(this.m.HEAD_PK)));
        return QueryServiceHelper.query((String)this.entityKey, (String)this.m.HEAD_PK, (QFilter[])filters.toArray(new QFilter[0]));
    }

    @Override
    protected boolean isHyperLink() {
        return true;
    }

    @Override
    public FormShowParameter forward(Long itemPk) {
        DynamicObjectCollection bills = this.query();
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId(this.entityKey);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        QFilter qFilter = new QFilter("id", "in", bills.stream().map(b -> b.getLong(this.m.HEAD_PK)).collect(Collectors.toList()));
        parameter.getListFilterParameter().setFilter(qFilter);
        return parameter;
    }
}

