/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.concurrency;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.dlock.DLockUtil;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.IAppCache;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.service.concurrency.AppCacheLockParam;
import kd.fi.arapcommon.service.concurrency.BillConcuControlParam;
import kd.fi.arapcommon.service.concurrency.BillConcuCtrlStrategyFactory;
import kd.fi.arapcommon.service.concurrency.BizCtrlContext;
import kd.fi.arapcommon.service.concurrency.ConcuCtrlBizEnum;
import kd.fi.arapcommon.service.concurrency.IBillConcurrencyCtrlStrategy;
import kd.fi.arapcommon.util.StringUtils;

public class ConcurrencyCtrlUtil {
    private static final Log logger = LogFactory.getLog(ConcurrencyCtrlUtil.class);

    public static IBillConcurrencyCtrlStrategy addCtrl(String billEntity, String biz, Set<Long> billIds) {
        BillConcuControlParam param = new BillConcuControlParam(billEntity, biz, billIds);
        return ConcurrencyCtrlUtil.addCtrl(param);
    }

    public static IBillConcurrencyCtrlStrategy addCtrl(String billEntity, String biz, Set<Long> billIds, boolean needWait) {
        BillConcuControlParam param = new BillConcuControlParam(billEntity, biz, billIds, needWait);
        return ConcurrencyCtrlUtil.addCtrl(param);
    }

    public static IBillConcurrencyCtrlStrategy addCtrl(String biz, String mainEntity, String asstEntity, Set<Long> mainBillIds, Set<Long> asstBillIds, boolean needWait) {
        ArrayList<BillConcuControlParam> params = new ArrayList<BillConcuControlParam>(2);
        if (!mainBillIds.isEmpty()) {
            BillConcuControlParam mainParam = new BillConcuControlParam(mainEntity, biz, mainBillIds, needWait);
            params.add(mainParam);
        }
        if (!asstBillIds.isEmpty()) {
            BillConcuControlParam asstParam = new BillConcuControlParam(asstEntity, biz, asstBillIds, needWait);
            params.add(asstParam);
        }
        IBillConcurrencyCtrlStrategy ctrlStrategy = BillConcuCtrlStrategyFactory.getCtrlStrategy(params);
        ctrlStrategy.addCtrl();
        return ctrlStrategy;
    }

    public static IBillConcurrencyCtrlStrategy addCtrl(BillConcuControlParam param) {
        ArrayList<BillConcuControlParam> params = new ArrayList<BillConcuControlParam>(1);
        params.add(param);
        IBillConcurrencyCtrlStrategy ctrlStrategy = BillConcuCtrlStrategyFactory.getCtrlStrategy(params);
        ctrlStrategy.addCtrl();
        return ctrlStrategy;
    }

    public static void addCtrlInTX(String billEntity, String biz, Set<Long> billIds) {
        BillConcuControlParam param = new BillConcuControlParam(billEntity, biz, billIds);
        ConcurrencyCtrlUtil.addCtrlInTX(param);
    }

    public static void addCtrlInTX(String billEntity, String biz, Set<Long> billIds, boolean needWait) {
        BillConcuControlParam param = new BillConcuControlParam(billEntity, biz, billIds, needWait);
        ConcurrencyCtrlUtil.addCtrlInTX(param);
    }

    public static void addCtrlInTX(BillConcuControlParam param) {
        if (!TX.inTX()) {
            logger.info("\u672c\u5730\u4e8b\u52a1\u6ca1\u6709\u5f00\u542f");
            return;
        }
        Set<Long> needAddCtrlBillIds = param.getBillIds();
        if (needAddCtrlBillIds == null || needAddCtrlBillIds.isEmpty()) {
            return;
        }
        HashSet<Long> lockBillIds = new HashSet<Long>(needAddCtrlBillIds);
        if (lockBillIds.isEmpty()) {
            return;
        }
        String biz = param.getBiz();
        Set<Long> ctrlIds = BizCtrlContext.getCtrlIds(biz);
        if (ctrlIds != null && !ctrlIds.isEmpty()) {
            lockBillIds.removeAll(ctrlIds);
        }
        if (lockBillIds.isEmpty()) {
            return;
        }
        ArrayList<BillConcuControlParam> params = new ArrayList<BillConcuControlParam>(1);
        param.setBillIds(lockBillIds);
        params.add(param);
        final IBillConcurrencyCtrlStrategy ctrlStrategy = BillConcuCtrlStrategyFactory.getCtrlStrategy(params);
        ctrlStrategy.addCtrl();
        BizCtrlContext.setCtrlIds(lockBillIds, biz);
        TX.addCommitListener((CommitListener)new CommitListener(){

            public void onEnded(boolean rollbacked) {
                ctrlStrategy.releaseCtrl();
                BizCtrlContext.remove();
            }
        });
    }

    public static String getConCuCtrlMsg(String billEntity, String biz, Set<Long> ctrlIds) {
        logger.info("billEntity:" + billEntity + ",biz:" + biz + ",ctrlIds:" + ctrlIds);
        if (StringUtils.isEmpty(billEntity) || StringUtils.isEmpty(biz) || ObjectUtils.isEmpty(ctrlIds)) {
            return "getConCuCtrlMsg-param is null";
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billEntity);
        String bizDesc = biz;
        if (ConcuCtrlBizEnum.SETTLE.getValue().equals(biz)) {
            bizDesc = ConcuCtrlBizEnum.SETTLE.getName();
        } else if (ConcuCtrlBizEnum.VERIFY.getValue().equals(biz)) {
            bizDesc = ConcuCtrlBizEnum.VERIFY.getName();
        } else if (ConcuCtrlBizEnum.WOFF.getValue().equals(biz)) {
            bizDesc = ConcuCtrlBizEnum.WOFF.getName();
        } else if (ConcuCtrlBizEnum.WRITEOFF.getValue().equals(biz)) {
            bizDesc = ConcuCtrlBizEnum.WRITEOFF.getName();
        }
        int count = 0;
        HashSet<Long> showIds = new HashSet<Long>(8);
        for (Long id : ctrlIds) {
            showIds.add(id);
            if (++count < 5) continue;
            break;
        }
        StringBuilder showBillsInfo = new StringBuilder();
        MainEntityType dt = MetadataServiceHelper.getDataEntityType((String)billEntity);
        if (dt != null && dt.getProperty("billno") != null) {
            DataSet rows = QueryServiceHelper.queryDataSet((String)"queryBillno", (String)billEntity, (String)"billno", (QFilter[])new QFilter[]{new QFilter("id", "in", showIds)}, (String)"");
            for (Row row : rows) {
                showBillsInfo.append(row.getString("billno")).append(',');
            }
            if (!ObjectUtils.isEmpty((Object)showBillsInfo.toString())) {
                showBillsInfo.deleteCharAt(showBillsInfo.length() - 1);
            }
            if (ctrlIds.size() > 5) {
                showBillsInfo.append("......");
            }
        }
        String msg = String.format(ResManager.loadKDString((String)"\u5e76\u53d1\u51b2\u7a81\uff0c\u7533\u8bf7\u4e92\u65a5\u9501\u5931\u8d25\uff0c\u5f53\u524d\u5b58\u5728\u6b63\u5728\u8fdb\u884c%1$s\u76f8\u5173\u4e1a\u52a1\u7684%2$s[%3$s]\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"LightLockCtrlStrategy_0", (String)"fi-arapcommon", (Object[])new Object[0]), bizDesc, dataEntityType.getDisplayName(), showBillsInfo);
        return msg;
    }

    public static List<AppCacheLockParam> buildLockParamListByIds(Set<Long> lockIds) {
        if (ObjectUtils.isEmpty(lockIds)) {
            return Collections.emptyList();
        }
        ArrayList<AppCacheLockParam> paramList = new ArrayList<AppCacheLockParam>(lockIds.size());
        String traceId = RequestContext.get().getTraceId();
        Date lockTime = new Date();
        String instanceId = Instance.getInstanceId();
        for (Long lockId : lockIds) {
            AppCacheLockParam param = new AppCacheLockParam(lockId, traceId, lockTime, instanceId);
            paramList.add(param);
        }
        return paramList;
    }

    public static Map<String, List<AppCacheLockParam>> getCacheLockMapByBiz(IAppCache cache, String biz) {
        Map<String, List<AppCacheLockParam>> lockMap = new HashMap<String, List<AppCacheLockParam>>(4);
        if (cache == null || StringUtils.isEmpty(biz)) {
            return lockMap;
        }
        String cacheLocks = null;
        try {
            cacheLocks = (String)cache.get(biz, String.class);
        }
        catch (Exception e) {
            Map historyLockMap = (Map)cache.get(biz, Map.class);
            for (Map.Entry entry : historyLockMap.entrySet()) {
                List value = (List)entry.getValue();
                if (ObjectUtils.isEmpty((Object)value)) continue;
                String key = (String)entry.getKey();
                ArrayList<AppCacheLockParam> newLockParamList = new ArrayList<AppCacheLockParam>(value.size());
                for (Long id : value) {
                    AppCacheLockParam lockParam = new AppCacheLockParam();
                    lockParam.setId(id);
                    newLockParamList.add(lockParam);
                }
                lockMap.put(key, newLockParamList);
            }
            cache.put(biz, (Object)SerializationUtils.toJsonString(lockMap), 86400);
            return lockMap;
        }
        if (StringUtils.isEmpty(cacheLocks)) {
            return lockMap;
        }
        Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss").create();
        lockMap = (Map)gson.fromJson(cacheLocks, new TypeToken<Hashtable<String, List<AppCacheLockParam>>>(){}.getType());
        ConcurrencyCtrlUtil.processInstanceAlive(lockMap);
        return lockMap;
    }

    private static void processInstanceAlive(Map<String, List<AppCacheLockParam>> lockMap) {
        if (!ObjectUtils.isEmpty(lockMap)) {
            HashMap<String, Boolean> instanceAliveMap = new HashMap<String, Boolean>(4);
            ArrayList<AppCacheLockParam> removeParamList = new ArrayList<AppCacheLockParam>(10);
            for (Map.Entry<String, List<AppCacheLockParam>> mapEntry : lockMap.entrySet()) {
                List<AppCacheLockParam> lockParamList = mapEntry.getValue();
                if (ObjectUtils.isEmpty(lockParamList)) continue;
                for (int i = lockParamList.size() - 1; i >= 0; --i) {
                    AppCacheLockParam appCacheLockParam = lockParamList.get(i);
                    String instanceId = appCacheLockParam.getInstanceId();
                    if (StringUtils.isEmpty(instanceId)) continue;
                    Boolean exist = (Boolean)instanceAliveMap.get(instanceId);
                    if (exist == null) {
                        exist = DLockUtil.isInstanceAlive((String)instanceId);
                    }
                    instanceAliveMap.put(instanceId, exist);
                    if (exist.booleanValue()) continue;
                    lockParamList.remove(i);
                    removeParamList.add(appCacheLockParam);
                }
            }
            if (!removeParamList.isEmpty()) {
                logger.info("removeParamList:" + removeParamList);
            }
        }
    }
}

