/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.concurrency;

import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.arapcommon.service.concurrency.BillConcuControlParam;
import kd.fi.arapcommon.service.concurrency.IBillConcurrencyCtrlStrategy;
import kd.fi.arapcommon.util.StringUtils;

public class HeavyLockCtrlStrategy
implements IBillConcurrencyCtrlStrategy {
    private static final Log logger = LogFactory.getLog(HeavyLockCtrlStrategy.class);
    private DLock lock;
    private final List<BillConcuControlParam> params;

    public HeavyLockCtrlStrategy(BillConcuControlParam param) {
        ArrayList<BillConcuControlParam> params = new ArrayList<BillConcuControlParam>(1);
        params.add(param);
        this.params = params;
    }

    public HeavyLockCtrlStrategy(List<BillConcuControlParam> params) {
        this.params = params;
    }

    @Override
    public void addCtrl() {
        if (this.params == null || this.params.isEmpty()) {
            return;
        }
        if (this.lock == null) {
            String biz = this.params.get(0).getBiz();
            if (StringUtils.isEmpty(biz)) {
                logger.info("HeavyLockCtrlStrategy biz is null");
                return;
            }
            String lockKey = RequestContext.get().getAccountId() + "-" + biz;
            this.lock = DLock.createReentrant((String)lockKey);
            this.lock.fastMode();
            this.lock.lock();
            logger.info("HeavyLockCtrlStrategy lock:" + lockKey + "-traceid:" + RequestContext.get().getTraceId());
        }
    }

    @Override
    public void releaseCtrl() {
        if (this.lock != null) {
            this.lock.unlock();
            logger.info("HeavyLockCtrlStrategy unlock:" + this.lock + "-traceid:" + RequestContext.get().getTraceId());
        }
    }
}

