/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.concurrency;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.fi.arapcommon.service.concurrency.BillConcuControlParam;
import kd.fi.arapcommon.service.concurrency.IBillConcurrencyCtrlStrategy;

public class SettleLockCtrlContext {
    private static ThreadLocal<List<IBillConcurrencyCtrlStrategy>> threadLocal = ThreadLocal.withInitial(() -> new ArrayList(2));

    public static List<IBillConcurrencyCtrlStrategy> getSettleLockCtrl() {
        return threadLocal.get();
    }

    public static void setSettleLockCtrl(IBillConcurrencyCtrlStrategy ctrl) {
        threadLocal.get().add(ctrl);
    }

    public static void remove() {
        threadLocal.remove();
    }

    public static Set<Long> currentLockIds() {
        HashSet<Long> currentLockIds = new HashSet<Long>(16);
        List<IBillConcurrencyCtrlStrategy> ctrlList = SettleLockCtrlContext.getSettleLockCtrl();
        if (ctrlList.isEmpty()) {
            return currentLockIds;
        }
        for (IBillConcurrencyCtrlStrategy ctrl : ctrlList) {
            List<BillConcuControlParam> ctrlParams;
            if (ctrl == null || (ctrlParams = ctrl.getCtrlParams()) == null || ctrlParams.isEmpty()) continue;
            for (BillConcuControlParam ctrlParam : ctrlParams) {
                Set<Long> billIds = ctrlParam.getBillIds();
                if (billIds == null || billIds.size() <= 0) continue;
                currentLockIds.addAll(billIds);
            }
        }
        return currentLockIds;
    }
}

