/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.expenses;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.ext.provider.BaseECService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.service.concurrency.ConcurrencyCtrlUtil;
import kd.fi.arapcommon.service.concurrency.IBillConcurrencyCtrlStrategy;
import kd.fi.arapcommon.vo.expenses.ExpenseVO;

public class PerformanceCostsDisposeFeeShareECService
extends BaseECService {
    protected static final Log logger = LogFactory.getLog(PerformanceCostsDisposeFeeShareECService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DtxResponse doExecute(Object param, Object lastParam) throws Exception {
        CommonParam ecParam = (CommonParam)param;
        Set saloutIds = (Set)ecParam.get((Object)"ids");
        Set saloutEntryIds = (Set)ecParam.get((Object)"entryids");
        Set shareRecordIds = (Set)ecParam.get((Object)"recordids");
        Boolean isReserve = (Boolean)ecParam.get((Object)"isreserve");
        if (saloutIds == null || saloutEntryIds == null || saloutIds.size() < 1 || saloutEntryIds.size() < 1) {
            return null;
        }
        logger.info("PerformanceCostsDisposeFeeShareECService.doExecute.param.saloutIds:" + saloutIds + "\nsaloutEntryIds:" + saloutEntryIds + "\nshareRecordIds:" + shareRecordIds + "\nisReserve:" + isReserve);
        IBillConcurrencyCtrlStrategy ctrlStrategy = null;
        ctrlStrategy = ConcurrencyCtrlUtil.addCtrl("im_saloutbill", "feesharedispose", saloutIds, true);
        try {
            BigDecimal costs;
            QFilter feeFilter = new QFilter("entry.billid", "in", (Object)saloutIds);
            feeFilter.and(new QFilter("entry.billentryid", "in", (Object)saloutEntryIds));
            if (!isReserve.booleanValue()) {
                feeFilter.and(new QFilter("id", "not in", (Object)shareRecordIds));
            }
            HashMap<Long, BigDecimal> saloutEntryIdAndShareAmtSum = new HashMap<Long, BigDecimal>(8);
            HashMap<Long, Integer> saloutEntryIdAndPrecision = new HashMap<Long, Integer>(8);
            HashSet<Long> feeShareRecordEntryIdsTemp = new HashSet<Long>(8);
            DynamicObjectCollection feeShareRecords = QueryServiceHelper.query((String)"cal_sale_feeshare_record", (String)"id,entry.id,entry.billid,entry.billentryid,entry.curwfamount,entry.currencyfield.amtprecision", (QFilter[])new QFilter[]{feeFilter}, (String)"sharedate desc");
            for (DynamicObject feeShareRecord : feeShareRecords) {
                feeShareRecordEntryIdsTemp.add(feeShareRecord.getLong("entry.id"));
                Long saloutEntryId = feeShareRecord.getLong("entry.billentryid");
                BigDecimal shareAmt = feeShareRecord.getBigDecimal("entry.curwfamount");
                saloutEntryIdAndShareAmtSum.merge(saloutEntryId, shareAmt, BigDecimal::add);
                int precision = feeShareRecord.getInt("entry.currencyfield.amtprecision");
                if (precision == 0) {
                    precision = shareAmt.scale();
                }
                saloutEntryIdAndPrecision.put(saloutEntryId, precision);
            }
            logger.info("PerformanceCostsDisposeFeeShareECService.saloutEntryIdAndShareAmtSum.1:" + saloutEntryIdAndShareAmtSum);
            logger.info("PerformanceCostsDisposeFeeShareECService.saloutEntryIdAndPrecision.1:" + saloutEntryIdAndPrecision);
            logger.info("PerformanceCostsDisposeFeeShareECService.feeShareRecordEntryIdsTemp.1:" + feeShareRecordEntryIdsTemp);
            HashSet<String> verifyRelations = new HashSet<String>(2);
            verifyRelations.add("arsalout");
            verifyRelations.add("arsalreturn");
            QFilter verifyFilter = new QFilter("billid", "in", (Object)saloutIds);
            verifyFilter.and(new QFilter("billentryid", "in", (Object)saloutEntryIds));
            verifyFilter.and(new QFilter("verifyrelation", "in", verifyRelations));
            verifyFilter.and(new QFilter("entry.e_iswrittenoff", "=", (Object)Boolean.FALSE));
            verifyFilter.and(new QFilter("entry.e_hadwrittenoff", "=", (Object)Boolean.FALSE));
            DynamicObjectCollection verifyRecords = QueryServiceHelper.query((String)"cal_salwfrecord", (String)"id,billid,billentryid,verifybaseqty,baseqty,entry.id,entry.e_billentryid,entry.e_billid", (QFilter[])new QFilter[]{verifyFilter}, (String)"verifydate desc");
            HashMap<String, ExpenseVO> expenseVOMap = new HashMap<String, ExpenseVO>(8);
            HashMap<Object, BigDecimal> saloutEntryIAndRemainBaseQty = new HashMap<Object, BigDecimal>(8);
            HashSet<Long> revcfmIds = new HashSet<Long>(8);
            HashSet<Long> revcfmEntryIds = new HashSet<Long>(8);
            HashSet<Long> verifyRecordEntryIdsTemp = new HashSet<Long>(8);
            for (DynamicObject verifyRecord : verifyRecords) {
                verifyRecordEntryIdsTemp.add(verifyRecord.getLong("entry.id"));
                Long saloutEntryId = verifyRecord.getLong("billentryid");
                BigDecimal verifyBaseQty = verifyRecord.getBigDecimal("verifybaseqty");
                BigDecimal baseQty = verifyRecord.getBigDecimal("baseqty");
                Long revcfmEntryId = verifyRecord.getLong("entry.e_billentryid");
                String key = saloutEntryId + "_" + revcfmEntryId;
                ExpenseVO vo = expenseVOMap.getOrDefault(key, new ExpenseVO());
                vo.setSaloutEntryId(saloutEntryId);
                vo.setVerifyBaseQty(verifyBaseQty.add(vo.getVerifyBaseQty()));
                vo.setBillBaseQty(baseQty);
                vo.setRevcfmEntryId(revcfmEntryId);
                vo.setShareAmtLocalSum((BigDecimal)saloutEntryIdAndShareAmtSum.get(saloutEntryId));
                expenseVOMap.put(key, vo);
                saloutEntryIAndRemainBaseQty.put(saloutEntryId, baseQty);
                Long revcfmId = verifyRecord.getLong("entry.e_billid");
                revcfmIds.add(revcfmId);
                revcfmEntryIds.add(revcfmEntryId);
            }
            logger.info("PerformanceCostsDisposeFeeShareECService.expenseVOMap.2:" + expenseVOMap);
            logger.info("PerformanceCostsDisposeFeeShareECService.saloutEntryIAndRemainBaseQty.2:" + saloutEntryIAndRemainBaseQty);
            logger.info("PerformanceCostsDisposeFeeShareECService.revcfmIds.2:" + revcfmIds);
            logger.info("PerformanceCostsDisposeFeeShareECService.revcfmEntryIds.2:" + revcfmEntryIds);
            logger.info("PerformanceCostsDisposeFeeShareECService.verifyRecordEntryIdsTemp.2:" + verifyRecordEntryIdsTemp);
            QFilter filterForSalBill = new QFilter("entry.id", "not in", verifyRecordEntryIdsTemp);
            filterForSalBill.and(new QFilter("entry.e_billid", "in", revcfmIds));
            filterForSalBill.and(new QFilter("entry.e_billentryid", "in", revcfmEntryIds));
            filterForSalBill.and(new QFilter("verifyrelation", "in", verifyRelations));
            filterForSalBill.and(new QFilter("entry.e_iswrittenoff", "=", (Object)Boolean.FALSE));
            filterForSalBill.and(new QFilter("entry.e_hadwrittenoff", "=", (Object)Boolean.FALSE));
            DynamicObjectCollection verifyRecordsForSalBill = QueryServiceHelper.query((String)"cal_salwfrecord", (String)"id,billid,billentryid,verifybaseqty,baseqty,entry.e_billentryid,entry.e_billid", (QFilter[])new QFilter[]{filterForSalBill}, (String)"verifydate desc");
            HashSet<Long> saloutIdsTemp = new HashSet<Long>(8);
            HashSet<Long> saloutEntryIdsTemp = new HashSet<Long>(8);
            for (DynamicObject verifyRecord : verifyRecordsForSalBill) {
                saloutIdsTemp.add(verifyRecord.getLong("billid"));
                saloutEntryIdsTemp.add(verifyRecord.getLong("billentryid"));
                Long saloutEntryId = verifyRecord.getLong("billentryid");
                BigDecimal verifyBaseQty = verifyRecord.getBigDecimal("verifybaseqty");
                BigDecimal baseQty = verifyRecord.getBigDecimal("baseqty");
                Long revcfmEntryId = verifyRecord.getLong("entry.e_billentryid");
                String key = saloutEntryId + "_" + revcfmEntryId;
                ExpenseVO vo = expenseVOMap.getOrDefault(key, new ExpenseVO());
                vo.setSaloutEntryId(saloutEntryId);
                vo.setVerifyBaseQty(verifyBaseQty.add(vo.getVerifyBaseQty()));
                vo.setBillBaseQty(baseQty);
                vo.setRevcfmEntryId(revcfmEntryId);
                vo.setShareAmtLocalSum((BigDecimal)saloutEntryIdAndShareAmtSum.get(saloutEntryId));
                expenseVOMap.put(key, vo);
                saloutEntryIAndRemainBaseQty.put(saloutEntryId, baseQty);
            }
            logger.info("PerformanceCostsDisposeFeeShareECService.expenseVOMap.3:" + expenseVOMap);
            logger.info("PerformanceCostsDisposeFeeShareECService.saloutEntryIAndRemainBaseQty.3:" + saloutEntryIAndRemainBaseQty);
            QFilter filterForRevcfm = new QFilter("entry.id", "not in", feeShareRecordEntryIdsTemp);
            filterForRevcfm.and(new QFilter("entry.billid", "in", saloutIdsTemp));
            filterForRevcfm.and(new QFilter("entry.billentryid", "in", saloutEntryIdsTemp));
            if (!isReserve.booleanValue()) {
                filterForRevcfm.and(new QFilter("id", "not in", (Object)shareRecordIds));
            }
            DynamicObjectCollection feeShareRecordsByRevcfm = QueryServiceHelper.query((String)"cal_sale_feeshare_record", (String)"id,entry.billid,entry.billentryid,entry.curwfamount,entry.currencyfield.amtprecision", (QFilter[])new QFilter[]{filterForRevcfm}, (String)"sharedate desc");
            for (DynamicObject feeShareRecord : feeShareRecordsByRevcfm) {
                Long saloutEntryId = feeShareRecord.getLong("entry.billentryid");
                BigDecimal shareAmt = feeShareRecord.getBigDecimal("entry.curwfamount");
                saloutEntryIdAndShareAmtSum.merge(saloutEntryId, shareAmt, BigDecimal::add);
                int precision = feeShareRecord.getInt("entry.currencyfield.amtprecision");
                if (precision == 0) {
                    precision = shareAmt.scale();
                }
                saloutEntryIdAndPrecision.put(saloutEntryId, precision);
            }
            logger.info("PerformanceCostsDisposeFeeShareECService.saloutEntryIdAndShareAmtSum.4:" + saloutEntryIdAndShareAmtSum);
            logger.info("PerformanceCostsDisposeFeeShareECService.saloutEntryIdAndPrecision.4:" + saloutEntryIdAndPrecision);
            Collection values = expenseVOMap.values();
            HashMap<Long, BigDecimal> revcfmEntryIdAndCosts = new HashMap<Long, BigDecimal>(8);
            for (ExpenseVO value : values) {
                Long saloutEntryId = value.getSaloutEntryId();
                Long revcfmEntryId = value.getRevcfmEntryId();
                BigDecimal shareAmtSum = value.getShareAmtLocalSum();
                BigDecimal verifyBaseQty = value.getVerifyBaseQty();
                BigDecimal billBaseQty = value.getBillBaseQty();
                BigDecimal remainBaseQty = (BigDecimal)saloutEntryIAndRemainBaseQty.get(saloutEntryId);
                BigDecimal remainShareAmt = (BigDecimal)saloutEntryIdAndShareAmtSum.get(saloutEntryId);
                if (remainBaseQty == null || remainShareAmt == null) continue;
                if (remainBaseQty.compareTo(verifyBaseQty) == 0) {
                    costs = remainShareAmt;
                    revcfmEntryIdAndCosts.merge(revcfmEntryId, costs, BigDecimal::add);
                    logger.info("PerformanceCostsDisposeFeeShareECService.last.revcfmEntryId:" + revcfmEntryId + "\ncosts:" + costs);
                    continue;
                }
                int precision = (Integer)saloutEntryIdAndPrecision.get(saloutEntryId);
                costs = shareAmtSum.multiply(verifyBaseQty).divide(billBaseQty, precision, RoundingMode.DOWN);
                revcfmEntryIdAndCosts.merge(revcfmEntryId, costs, BigDecimal::add);
                saloutEntryIAndRemainBaseQty.put(saloutEntryId, remainBaseQty.subtract(verifyBaseQty));
                saloutEntryIdAndShareAmtSum.put(saloutEntryId, remainShareAmt.subtract(costs));
            }
            DynamicObject[] revcfmBills = BusinessDataServiceHelper.load((String)"ar_revcfmbill", (String)"id,entry.id,entry.e_performancecosts", (QFilter[])new QFilter[]{new QFilter("id", "in", revcfmIds)});
            if (revcfmBills == null || revcfmBills.length < 1) {
                DynamicObject[] dynamicObjectArray = null;
                return dynamicObjectArray;
            }
            logger.info("PerformanceCostsDisposeFeeShareECService.revcfmEntryIdAndCosts:" + revcfmEntryIdAndCosts);
            for (DynamicObject revcfmBill : revcfmBills) {
                DynamicObjectCollection entries = revcfmBill.getDynamicObjectCollection("entry");
                for (DynamicObject entry : entries) {
                    Long entryId = entry.getLong("id");
                    costs = (BigDecimal)revcfmEntryIdAndCosts.get(entryId);
                    if (!revcfmEntryIds.contains(entryId)) continue;
                    if (costs != null) {
                        entry.set("e_performancecosts", (Object)costs);
                        continue;
                    }
                    entry.set("e_performancecosts", (Object)BigDecimal.ZERO);
                }
            }
            SaveServiceHelper.save((DynamicObject[])revcfmBills);
        }
        finally {
            if (ctrlStrategy != null) {
                ctrlStrategy.releaseCtrl();
            }
        }
        logger.info("PerformanceCostsDisposeFeeShareECService.end");
        return null;
    }
}

