/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.expenses;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.ext.provider.BaseECService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.service.concurrency.ConcurrencyCtrlUtil;
import kd.fi.arapcommon.service.concurrency.IBillConcurrencyCtrlStrategy;
import kd.fi.arapcommon.vo.expenses.ExpenseVO;

public class PerformanceCostsDisposeVerifyECService
extends BaseECService {
    protected static final Log logger = LogFactory.getLog(PerformanceCostsDisposeVerifyECService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DtxResponse doExecute(Object param, Object lastParam) throws Exception {
        CommonParam ecParam = (CommonParam)param;
        Set saloutIds = (Set)ecParam.get((Object)"ids");
        Set saloutEntryIds = (Set)ecParam.get((Object)"entryids");
        Set revcfmIds = (Set)ecParam.get((Object)"revcfmids");
        Set revcfmEntryIds = (Set)ecParam.get((Object)"revcfmentryids");
        Set verifyRecordIds = (Set)ecParam.get((Object)"recordids");
        Boolean isReserve = (Boolean)ecParam.get((Object)"isreserve");
        if (saloutIds == null || saloutEntryIds == null || revcfmIds == null || revcfmEntryIds == null || saloutIds.size() < 1 || saloutEntryIds.size() < 1 || revcfmIds.size() < 1 || revcfmEntryIds.size() < 1) {
            return null;
        }
        logger.info("PerformanceCostsDisposeVerifyECService.doExecute.param.saloutIds:" + saloutIds + "\nsaloutEntryIds:" + saloutEntryIds + "\nrevcfmIds:" + revcfmIds + "\nrevcfmEntryIds:" + revcfmEntryIds + "\nverifyRecordIds:" + verifyRecordIds + "\nisReserve:" + isReserve);
        IBillConcurrencyCtrlStrategy ctrlStrategy = null;
        ctrlStrategy = ConcurrencyCtrlUtil.addCtrl("im_saloutbill", "feesharedispose", saloutIds, true);
        try {
            int precision;
            BigDecimal costs;
            BigDecimal remainShareAmt;
            BigDecimal remainBaseQty;
            BigDecimal billBaseQty;
            BigDecimal verifyBaseQty;
            BigDecimal shareAmtSum;
            Long saloutEntryId;
            Long revcfmEntryId;
            QFilter feeFilter = new QFilter("entry.billid", "in", (Object)saloutIds);
            feeFilter.and(new QFilter("entry.billentryid", "in", (Object)saloutEntryIds));
            HashMap<Long, BigDecimal> saloutEntryIdAndShareAmtSum = new HashMap<Long, BigDecimal>(8);
            HashMap<Long, Integer> saloutEntryIdAndPrecision = new HashMap<Long, Integer>(8);
            HashSet<Long> feeShareRecordEntryIdsTemp = new HashSet<Long>(8);
            DynamicObjectCollection feeShareRecords = QueryServiceHelper.query((String)"cal_sale_feeshare_record", (String)"id,entry.id,entry.billid,entry.billentryid,entry.curwfamount,entry.currencyfield.amtprecision", (QFilter[])new QFilter[]{feeFilter}, (String)"sharedate desc");
            for (DynamicObject feeShareRecord : feeShareRecords) {
                feeShareRecordEntryIdsTemp.add(feeShareRecord.getLong("entry.id"));
                Long saloutEntryId2 = feeShareRecord.getLong("entry.billentryid");
                if (!saloutEntryIds.contains(saloutEntryId2)) continue;
                BigDecimal shareAmt = feeShareRecord.getBigDecimal("entry.curwfamount");
                saloutEntryIdAndShareAmtSum.merge(saloutEntryId2, shareAmt, BigDecimal::add);
                int precision2 = feeShareRecord.getInt("entry.currencyfield.amtprecision");
                if (precision2 == 0) {
                    precision2 = shareAmt.scale();
                }
                saloutEntryIdAndPrecision.put(saloutEntryId2, precision2);
            }
            logger.info("PerformanceCostsDisposeVerifyECService.saloutEntryIdAndShareAmtSum.1:" + saloutEntryIdAndShareAmtSum);
            logger.info("PerformanceCostsDisposeVerifyECService.saloutEntryIdAndPrecision.1:" + saloutEntryIdAndPrecision);
            logger.info("PerformanceCostsDisposeVerifyECService.feeShareRecordEntryIdsTemp.1:" + feeShareRecordEntryIdsTemp);
            HashSet<String> verifyRelations = new HashSet<String>(2);
            verifyRelations.add("arsalout");
            verifyRelations.add("arsalreturn");
            QFilter verifyFilter = new QFilter("verifyrelation", "in", verifyRelations);
            verifyFilter.and(new QFilter("entry.e_billid", "in", (Object)revcfmIds));
            verifyFilter.and(new QFilter("entry.e_billentryid", "in", (Object)revcfmEntryIds));
            verifyFilter.and(new QFilter("entry.e_iswrittenoff", "=", (Object)Boolean.FALSE));
            verifyFilter.and(new QFilter("entry.e_hadwrittenoff", "=", (Object)Boolean.FALSE));
            if (!isReserve.booleanValue()) {
                verifyFilter.and(new QFilter("id", "not in", (Object)verifyRecordIds));
            }
            DynamicObjectCollection verifyRecords = QueryServiceHelper.query((String)"cal_salwfrecord", (String)"id,billid,billentryid,verifybaseqty,baseqty,entry.id,entry.e_billentryid,entry.e_billid", (QFilter[])new QFilter[]{verifyFilter}, (String)"verifydate desc");
            HashMap<String, ExpenseVO> expenseVOMap = new HashMap<String, ExpenseVO>(8);
            HashMap<Long, BigDecimal> saloutEntryIAndRemainBaseQty = new HashMap<Long, BigDecimal>(8);
            HashSet<Long> verifyRecordEntryIdsTemp = new HashSet<Long>(8);
            HashSet<Long> saloutIdsTemp = new HashSet<Long>(8);
            HashSet<Long> saloutEntryIdsTemp = new HashSet<Long>(8);
            for (DynamicObject verifyRecord : verifyRecords) {
                verifyRecordEntryIdsTemp.add(verifyRecord.getLong("entry.id"));
                saloutIdsTemp.add(verifyRecord.getLong("billid"));
                saloutEntryIdsTemp.add(verifyRecord.getLong("billentryid"));
                Long revcfmEntryId2 = verifyRecord.getLong("entry.e_billentryid");
                Long saloutEntryId3 = verifyRecord.getLong("billentryid");
                BigDecimal verifyBaseQty2 = verifyRecord.getBigDecimal("verifybaseqty");
                BigDecimal baseQty = verifyRecord.getBigDecimal("baseqty");
                String key = saloutEntryId3 + "_" + revcfmEntryId2;
                ExpenseVO vo = expenseVOMap.getOrDefault(key, new ExpenseVO());
                vo.setSaloutEntryId(saloutEntryId3);
                vo.setVerifyBaseQty(verifyBaseQty2.add(vo.getVerifyBaseQty()));
                vo.setBillBaseQty(baseQty);
                vo.setRevcfmEntryId(revcfmEntryId2);
                vo.setShareAmtLocalSum((BigDecimal)saloutEntryIdAndShareAmtSum.get(saloutEntryId3));
                expenseVOMap.put(key, vo);
                saloutEntryIAndRemainBaseQty.put(saloutEntryId3, baseQty);
            }
            logger.info("PerformanceCostsDisposeVerifyECService.expenseVOMap.2:" + expenseVOMap);
            logger.info("PerformanceCostsDisposeVerifyECService.saloutEntryIAndRemainBaseQty.2:" + saloutEntryIAndRemainBaseQty);
            logger.info("PerformanceCostsDisposeVerifyECService.revcfmIds.2:" + revcfmIds);
            logger.info("PerformanceCostsDisposeVerifyECService.revcfmEntryIds.2:" + revcfmEntryIds);
            logger.info("PerformanceCostsDisposeVerifyECService.verifyRecordEntryIdsTemp.2:" + verifyRecordEntryIdsTemp);
            QFilter filterForRevcfm = new QFilter("entry.id", "not in", feeShareRecordEntryIdsTemp);
            filterForRevcfm.and(new QFilter("entry.billid", "in", saloutIdsTemp));
            filterForRevcfm.and(new QFilter("entry.billentryid", "in", saloutEntryIdsTemp));
            DynamicObjectCollection feeShareRecordsByRevcfm = QueryServiceHelper.query((String)"cal_sale_feeshare_record", (String)"id,entry.billid,entry.billentryid,entry.curwfamount,entry.currencyfield.amtprecision", (QFilter[])new QFilter[]{filterForRevcfm}, (String)"sharedate desc");
            for (DynamicObject feeShareRecord : feeShareRecordsByRevcfm) {
                Long saloutEntryId4 = feeShareRecord.getLong("entry.billentryid");
                BigDecimal shareAmt = feeShareRecord.getBigDecimal("entry.curwfamount");
                saloutEntryIdAndShareAmtSum.merge(saloutEntryId4, shareAmt, BigDecimal::add);
                int precision3 = feeShareRecord.getInt("entry.currencyfield.amtprecision");
                if (precision3 == 0) {
                    precision3 = shareAmt.scale();
                }
                saloutEntryIdAndPrecision.put(saloutEntryId4, precision3);
            }
            QFilter filterForSalBill = new QFilter("entry.id", "not in", verifyRecordEntryIdsTemp);
            filterForSalBill.and(new QFilter("billid", "in", saloutIdsTemp));
            filterForSalBill.and(new QFilter("billentryid", "in", saloutEntryIdsTemp));
            filterForSalBill.and(new QFilter("verifyrelation", "in", verifyRelations));
            filterForSalBill.and(new QFilter("entry.e_iswrittenoff", "=", (Object)Boolean.FALSE));
            filterForSalBill.and(new QFilter("entry.e_hadwrittenoff", "=", (Object)Boolean.FALSE));
            if (!isReserve.booleanValue()) {
                filterForSalBill.and(new QFilter("id", "not in", (Object)verifyRecordIds));
            }
            DynamicObjectCollection verifyRecordsForSalBill = QueryServiceHelper.query((String)"cal_salwfrecord", (String)"id,billid,billentryid,verifybaseqty,baseqty,entry.e_billentryid,entry.e_billid", (QFilter[])new QFilter[]{filterForSalBill}, (String)"verifydate desc");
            for (DynamicObject verifyRecord : verifyRecordsForSalBill) {
                Long saloutEntryId5 = verifyRecord.getLong("billentryid");
                BigDecimal verifyBaseQty3 = verifyRecord.getBigDecimal("verifybaseqty");
                BigDecimal baseQty = verifyRecord.getBigDecimal("baseqty");
                revcfmEntryId = verifyRecord.getLong("entry.e_billentryid");
                String key = saloutEntryId5 + "_" + revcfmEntryId;
                ExpenseVO vo = expenseVOMap.getOrDefault(key, new ExpenseVO());
                vo.setSaloutEntryId(saloutEntryId5);
                vo.setVerifyBaseQty(verifyBaseQty3.add(vo.getVerifyBaseQty()));
                vo.setBillBaseQty(baseQty);
                vo.setRevcfmEntryId(revcfmEntryId);
                vo.setShareAmtLocalSum((BigDecimal)saloutEntryIdAndShareAmtSum.get(saloutEntryId5));
                expenseVOMap.put(key, vo);
                saloutEntryIAndRemainBaseQty.put(saloutEntryId5, baseQty);
            }
            logger.info("PerformanceCostsDisposeVerifyECService.expenseVOMap.3:" + expenseVOMap);
            logger.info("PerformanceCostsDisposeVerifyECService.saloutEntryIAndRemainBaseQty.3:" + saloutEntryIAndRemainBaseQty);
            Collection values = expenseVOMap.values();
            HashMap<Long, BigDecimal> revcfmEntryIdAndCosts = new HashMap<Long, BigDecimal>(8);
            for (ExpenseVO value : values) {
                saloutEntryId = value.getSaloutEntryId();
                revcfmEntryId = value.getRevcfmEntryId();
                if (revcfmEntryIds.contains(revcfmEntryId)) continue;
                shareAmtSum = value.getShareAmtLocalSum();
                verifyBaseQty = value.getVerifyBaseQty();
                billBaseQty = value.getBillBaseQty();
                remainBaseQty = (BigDecimal)saloutEntryIAndRemainBaseQty.get(saloutEntryId);
                remainShareAmt = (BigDecimal)saloutEntryIdAndShareAmtSum.get(saloutEntryId);
                if (remainBaseQty == null || remainShareAmt == null) continue;
                if (remainBaseQty.compareTo(verifyBaseQty) == 0) {
                    costs = remainShareAmt;
                    logger.info("PerformanceCostsDisposeVerifyECService.lasttemp.revcfmEntryId:" + revcfmEntryId + "\ncosts:" + costs);
                } else {
                    precision = (Integer)saloutEntryIdAndPrecision.get(saloutEntryId);
                    costs = shareAmtSum.multiply(verifyBaseQty).divide(billBaseQty, precision, RoundingMode.DOWN);
                }
                saloutEntryIAndRemainBaseQty.put(saloutEntryId, remainBaseQty.subtract(verifyBaseQty));
                saloutEntryIdAndShareAmtSum.put(saloutEntryId, remainShareAmt.subtract(costs));
            }
            logger.info("PerformanceCostsDisposeVerifyECService.processtemp.saloutEntryIAndRemainBaseQty:" + saloutEntryIAndRemainBaseQty);
            logger.info("PerformanceCostsDisposeVerifyECService.processtemp.saloutEntryIdAndShareAmtSum:" + saloutEntryIdAndShareAmtSum);
            for (ExpenseVO value : values) {
                saloutEntryId = value.getSaloutEntryId();
                revcfmEntryId = value.getRevcfmEntryId();
                if (!revcfmEntryIds.contains(revcfmEntryId)) continue;
                shareAmtSum = value.getShareAmtLocalSum();
                verifyBaseQty = value.getVerifyBaseQty();
                billBaseQty = value.getBillBaseQty();
                remainBaseQty = (BigDecimal)saloutEntryIAndRemainBaseQty.get(saloutEntryId);
                remainShareAmt = (BigDecimal)saloutEntryIdAndShareAmtSum.get(saloutEntryId);
                if (remainBaseQty == null || remainShareAmt == null) continue;
                if (remainBaseQty.compareTo(verifyBaseQty) == 0) {
                    costs = remainShareAmt;
                    revcfmEntryIdAndCosts.merge(revcfmEntryId, costs, BigDecimal::add);
                    logger.info("PerformanceCostsDisposeVerifyECService.last.revcfmEntryId:" + revcfmEntryId + "\ncosts:" + costs);
                    continue;
                }
                precision = (Integer)saloutEntryIdAndPrecision.get(saloutEntryId);
                costs = shareAmtSum.multiply(verifyBaseQty).divide(billBaseQty, precision, RoundingMode.DOWN);
                revcfmEntryIdAndCosts.merge(revcfmEntryId, costs, BigDecimal::add);
                saloutEntryIAndRemainBaseQty.put(saloutEntryId, remainBaseQty.subtract(verifyBaseQty));
                saloutEntryIdAndShareAmtSum.put(saloutEntryId, remainShareAmt.subtract(costs));
            }
            DynamicObject[] revcfmBills = BusinessDataServiceHelper.load((String)"ar_revcfmbill", (String)"id,entry.id,entry.e_performancecosts", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)revcfmIds)});
            if (revcfmBills == null || revcfmBills.length < 1) {
                DynamicObject[] dynamicObjectArray = null;
                return dynamicObjectArray;
            }
            logger.info("PerformanceCostsDisposeVerifyECService.revcfmEntryIdAndCosts:" + revcfmEntryIdAndCosts);
            for (DynamicObject revcfmBill : revcfmBills) {
                DynamicObjectCollection entries = revcfmBill.getDynamicObjectCollection("entry");
                for (DynamicObject entry : entries) {
                    Long entryId = entry.getLong("id");
                    if (!revcfmEntryIds.contains(entryId)) continue;
                    costs = (BigDecimal)revcfmEntryIdAndCosts.get(entryId);
                    if (costs != null) {
                        entry.set("e_performancecosts", (Object)costs);
                        continue;
                    }
                    entry.set("e_performancecosts", (Object)BigDecimal.ZERO);
                }
            }
            SaveServiceHelper.save((DynamicObject[])revcfmBills);
        }
        finally {
            if (ctrlStrategy != null) {
                ctrlStrategy.releaseCtrl();
            }
        }
        logger.info("PerformanceCostsDisposeVerifyECService.end");
        return null;
    }
}

