/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.ext;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.service.ext.SettleExtDataFilterKeyVO;
import kd.fi.arapcommon.service.ext.SettleExtDataListKeyVO;
import kd.fi.arapcommon.service.ext.SettleRecordExtDataListKeyVO;

public class SettleExtDataLoader {
    public static List<String> loadManualSettleFilterKeys(String number) {
        Map billdata = BusinessDataServiceHelper.loadFromCache((String)"ap_settle_ext_setting", (String)"entry_settle_filter.e_fieldkey", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
        ArrayList<String> keys = new ArrayList<String>(64);
        billdata.forEach((key, value) -> {
            DynamicObjectCollection entrys = value.getDynamicObjectCollection("entry_settle_filter");
            entrys.forEach(entry -> keys.add(entry.getString("e_fieldkey")));
        });
        return keys;
    }

    public static List<SettleExtDataFilterKeyVO> loadManualSettleFilterInfo(String number) {
        Map billdata = BusinessDataServiceHelper.loadFromCache((String)"ap_settle_ext_setting", (String)"entry_settle_filter.e_fieldkey,entry_settle_filter.e_matchfieldkey", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
        ArrayList<SettleExtDataFilterKeyVO> keys = new ArrayList<SettleExtDataFilterKeyVO>(64);
        billdata.forEach((key, value) -> {
            DynamicObjectCollection entrys = value.getDynamicObjectCollection("entry_settle_filter");
            entrys.forEach(entry -> {
                SettleExtDataFilterKeyVO vo = new SettleExtDataFilterKeyVO();
                vo.setFiledKey(entry.getString("e_fieldkey"));
                vo.setMatchFieldKey(entry.getString("e_matchfieldkey"));
                keys.add(vo);
            });
        });
        return keys;
    }

    public static List<SettleExtDataListKeyVO> loadManualSettleListKeys(String number) {
        Map billdata = BusinessDataServiceHelper.loadFromCache((String)"ap_settle_ext_setting", (String)"entry_settle_list.e_billkey,entry_settle_list.e_billkeyname,entry_settle_list.e_settle_billkeyname, entry_settle_list.e_billkey_keyplace", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
        ArrayList<SettleExtDataListKeyVO> voList = new ArrayList<SettleExtDataListKeyVO>(64);
        billdata.forEach((key, value) -> {
            DynamicObjectCollection entrys = value.getDynamicObjectCollection("entry_settle_list");
            entrys.forEach(entry -> {
                SettleExtDataListKeyVO vo = new SettleExtDataListKeyVO();
                vo.setBillKey(entry.getString("e_billkey"));
                vo.setBillKeyName(entry.getString("e_billkeyname"));
                vo.setSettleBillKeyName(entry.getString("e_settle_billkeyname"));
                vo.setBillKeyPlace(entry.getString("e_billkey_keyplace"));
                voList.add(vo);
            });
        });
        return voList;
    }

    public static QFilter loadSchemeSettleDefaultFilterKeys(String number) {
        Row row;
        String json;
        String querySql = "SELECT frunconditionvalue_tag FROM t_ap_settle_ext where fnumber = ?";
        DataSet dataSet = DB.queryDataSet((String)"AP.QUERYSETTLEEXT", (DBRoute)DBRouteConst.AP, (String)querySql, (Object[])new Object[]{number});
        QFilter filter = null;
        Iterator iterator = dataSet.iterator();
        while (iterator.hasNext() && !StringUtils.isBlank((String)(json = (row = (Row)iterator.next()).getString("frunconditionvalue_tag")))) {
            CRCondition formula = (CRCondition)SerializationUtils.fromJsonString((String)json, CRCondition.class);
            FilterCondition filterCondition = formula.getFilterCondition();
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)number);
            FilterBuilder filterBuilder = new FilterBuilder(dataEntityType, filterCondition, true);
            filterBuilder.buildFilter(false);
            filter = filterBuilder.getQFilter();
        }
        return filter;
    }

    public static List<SettleRecordExtDataListKeyVO> loadSettleRecordExtListKeys(String number) {
        Map billdata = BusinessDataServiceHelper.loadFromCache((String)"ap_settle_ext_setting", (String)"entry_settle_record.e_record_billkey,entry_settle_record.e_record_keyplace, entry_settle_record.e_record_settlekey", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
        ArrayList<SettleRecordExtDataListKeyVO> voList = new ArrayList<SettleRecordExtDataListKeyVO>(64);
        billdata.forEach((key, value) -> {
            DynamicObjectCollection entrys = value.getDynamicObjectCollection("entry_settle_record");
            entrys.forEach(entry -> {
                SettleRecordExtDataListKeyVO vo = new SettleRecordExtDataListKeyVO();
                vo.setBillKey(entry.getString("e_record_billkey"));
                vo.setKeyPlace(entry.getString("e_record_keyplace"));
                vo.setSettleRecordKey(entry.getString("e_record_settlekey"));
                voList.add(vo);
            });
        });
        return voList;
    }
}

