/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.fin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.arapcommon.service.fin.ProportionateEntryDisposerTemplate;

public class ApMaterialEntryDisposer
extends ProportionateEntryDisposerTemplate {
    @Override
    protected BigDecimal getBillUnlockAmount(DynamicObject finBill) {
        DynamicObjectCollection planEntry = this.getDisposeEntry(finBill);
        BigDecimal billUnlockAmount = BigDecimal.ZERO;
        for (DynamicObject row : planEntry) {
            BigDecimal rowUnlockAmount = row.getBigDecimal(this.getEntryUnlockAmountKey());
            billUnlockAmount = billUnlockAmount.add(rowUnlockAmount);
        }
        return billUnlockAmount;
    }

    @Override
    protected BigDecimal getBillLockedAmount(DynamicObject finBill) {
        DynamicObjectCollection planEntry = this.getDisposeEntry(finBill);
        BigDecimal billLockedAmount = BigDecimal.ZERO;
        for (DynamicObject row : planEntry) {
            BigDecimal rowLockedAmount = row.getBigDecimal(this.getEntryLockedAmountKey());
            billLockedAmount = billLockedAmount.add(rowLockedAmount);
        }
        return billLockedAmount;
    }

    @Override
    protected BigDecimal getBillAmount(DynamicObject finBill) {
        return finBill.getBigDecimal("pricetaxtotal");
    }

    @Override
    protected DynamicObjectCollection getDisposeEntry(DynamicObject finBill) {
        return finBill.getDynamicObjectCollection("detailentry");
    }

    @Override
    protected BigDecimal getEntryAmount(DynamicObject row) {
        return row.getBigDecimal("e_pricetaxtotal");
    }

    @Override
    protected String getEntryUnlockAmountKey() {
        return "unlockamt";
    }

    @Override
    protected String getEntryLockedAmountKey() {
        return "lockedamt";
    }

    @Override
    protected int getPrecision(DynamicObject finBill) {
        return finBill.getInt("currency.amtprecision");
    }

    @Override
    public Collection<String> getSelectors() {
        ArrayList<String> selectors = new ArrayList<String>(10);
        selectors.add("pricetaxtotal");
        selectors.add("e_pricetaxtotal");
        selectors.add("unlockamt");
        selectors.add("lockedamt");
        selectors.add("planentity");
        selectors.add("unplanlockamt");
        selectors.add("planlockedamt");
        selectors.add("currency");
        return selectors;
    }
}

