/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.fin;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.arapcommon.dev.BeanFactory;
import kd.fi.arapcommon.service.fin.OrdinalEntryDisposerTemplate;
import kd.fi.arapcommon.service.fin.PlanEntryProportDisposer;

public class ArPlanEntryDisposer
extends OrdinalEntryDisposerTemplate {
    @Override
    public void saveDispose(DynamicObject finBill, BigDecimal disposeAmount) {
        boolean isZeroAmountBill;
        DynamicObjectCollection disposeEntry = this.getDisposeEntry(finBill);
        boolean bl = isZeroAmountBill = finBill.getBigDecimal("recamount").compareTo(BigDecimal.ZERO) == 0;
        if (disposeEntry.size() > 0 && isZeroAmountBill) {
            String unlockAmountKey = this.getEntryUnlockAmountKey();
            String lockedAmountKey = this.getEntryLockedAmountKey();
            DynamicObject row = (DynamicObject)disposeEntry.get(0);
            this.increaseAmount(row, lockedAmountKey, disposeAmount);
            this.reduceAmount(row, unlockAmountKey, disposeAmount);
        } else {
            super.saveDispose(finBill, disposeAmount);
        }
    }

    @Override
    public void deleteDispose(DynamicObject finBill, BigDecimal disposeAmount) {
        boolean isZeroAmountBill;
        DynamicObjectCollection disposeEntry = this.getDisposeEntry(finBill);
        boolean bl = isZeroAmountBill = finBill.getBigDecimal("recamount").compareTo(BigDecimal.ZERO) == 0;
        if (!disposeEntry.isEmpty() && isZeroAmountBill) {
            DynamicObject row = (DynamicObject)disposeEntry.get(0);
            String unlockAmountKey = this.getEntryUnlockAmountKey();
            String lockedAmountKey = this.getEntryLockedAmountKey();
            this.increaseAmount(row, unlockAmountKey, disposeAmount);
            this.reduceAmount(row, lockedAmountKey, disposeAmount);
        } else if (this.isPremiumSrcBill(finBill)) {
            this.premiumSrcBillDeleteDispose(finBill, disposeAmount);
        } else {
            super.deleteDispose(finBill, disposeAmount);
        }
    }

    protected boolean isPremiumSrcBill(DynamicObject finBill) {
        return finBill.getBigDecimal("premiumamt").compareTo(BigDecimal.ZERO) != 0;
    }

    protected void premiumSrcBillDeleteDispose(DynamicObject finBill, BigDecimal disposeAmount) {
        BigDecimal premiumamt = finBill.getBigDecimal("premiumamt");
        PlanEntryProportDisposer prePlanDis = BeanFactory.getBean(PlanEntryProportDisposer.class, new Object[0]);
        prePlanDis.deleteDispose(finBill, premiumamt);
        super.deleteDispose(finBill, disposeAmount);
        prePlanDis.saveDispose(finBill, premiumamt);
    }

    @Override
    protected DynamicObjectCollection getDisposeEntry(DynamicObject finBill) {
        return finBill.getDynamicObjectCollection("planentity");
    }

    @Override
    protected String getEntryUnlockAmountKey() {
        return "unplanlockamt";
    }

    @Override
    protected String getEntryLockedAmountKey() {
        return "planlockedamt";
    }
}

