/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.fin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.ConvertRuleCache;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.fi.arapcommon.consts.BillTypeConsts;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.BizPartnerHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.kdtx.ec.ECServiceHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import org.apache.commons.lang.StringUtils;

public class FinCoordinationService {
    private static final Log logger = LogFactory.getLog(FinCoordinationService.class);
    private boolean isAr = false;

    public FinCoordinationService(boolean isAr) {
        this.isAr = isAr;
    }

    public void coordination(DynamicObject[] finBills) {
        List<Long> finPks = this.getCanPushPks(finBills, new HashSet<String>(8));
        logger.info("FinCoordinationService:coordination finPks : " + finPks);
        if (!finPks.isEmpty()) {
            String entityKey = this.isAr ? "ar_finarbill" : "ap_finapbill";
            try {
                ThreadPools.executeOnceIncludeRequestContext((String)"push.coordintion", () -> {
                    logger.info("FinCoordinationService:coordination begin executeOnceIncludeRequestContext");
                    OperationResult opResult = OperationServiceHelper.executeOperate((String)"recpaycoordination", (String)entityKey, (Object[])finPks.toArray(), (OperateOption)OperateOption.create());
                    logger.info("FinCoordinationService:coordination end executeOnceIncludeRequestContext : " + opResult.isSuccess());
                    OperationHelper.assertResult(opResult);
                });
            }
            catch (Exception e) {
                AppLogInfo log = new AppLogInfo();
                log.setBizAppID(this.isAr ? "/BBRH+122=39" : "+HKZHSKFXOX");
                log.setBizObjID(entityKey);
                log.setOpName("audit");
                log.setOpDescription("coordintion:" + e.getMessage());
                LogServiceHelper.addLog((AppLogInfo)log);
            }
        }
    }

    public void kdtxCoordination(DynamicObject[] finBills) {
        Set<DynamicObject> bills;
        String entityKey = "ar_finarbill";
        if (!this.isAr) {
            entityKey = "ap_finapbill";
            bills = Arrays.stream(finBills).filter(t -> !t.getBoolean("ispremium") && !"ApFin_product_BT_S".equals(t.getString("billtypeid.number")) && !BillSrcTypeEnum.COORDINATEADJUST.getValue().equals(t.getString("billsrctype")) && !"bos_user".equals(t.getString("asstacttype"))).collect(Collectors.toSet());
        } else {
            bills = Arrays.stream(finBills).filter(t -> !"bos_user".equals(t.getString("asstacttype")) && !t.getBoolean("ispremium") && !BillSrcTypeEnum.COORDINATEADJUST.getValue().equals(t.getString("billsrctype"))).collect(Collectors.toSet());
        }
        if (!bills.isEmpty()) {
            HashSet<String> finBillnos = new HashSet<String>(8);
            List<Long> coordFinPks = this.getCanPushPks(bills.toArray(new DynamicObject[0]), finBillnos);
            if (coordFinPks.size() > 0) {
                String billnos = StringUtils.join((Object[])finBillnos.toArray(), (String)",");
                String ruleId = this.isAr ? "595323465825798144" : "570132152377676800";
                ConvertRuleElement convertRuleElement = ConvertRuleCache.loadRule((String)ruleId);
                if (!convertRuleElement.isNormual()) {
                    if (this.isAr) {
                        throw new KDBizException(ResManager.loadKDString((String)"%s\uff1a\u5355\u636e\u7b26\u5408\u534f\u540c\u751f\u6210\u8d22\u52a1\u5e94\u4ed8\u5355\u7684\u6761\u4ef6\uff0c\u4f46\u7531\u4e8e\u8f6c\u6362\u89c4\u5219\u7981\u7528\uff0c\u5ba1\u6838\u540e\u5c06\u65e0\u6cd5\u534f\u540c\u3002\n \u82e5\u9700\u7ee7\u7eed\u534f\u540c\u751f\u6210\uff0c\u8bf7\u524d\u5f80\u201c\u5f00\u53d1\u670d\u52a1\u4e91>\u5355\u636e\u8f6c\u6362\u5f00\u53d1>\u8f6c\u6362\u89c4\u5219\u201d\u542f\u7528\u8d22\u52a1\u5e94\u6536\u5355\u5173\u8054\u751f\u6210\u8d22\u52a1\u5e94\u4ed8\u5355\u7684\u8f6c\u6362\u89c4\u5219\uff1b\u82e5\u65e0\u9700\u534f\u540c\u751f\u6210\uff0c\u8bf7\u524d\u5f80\u201c\u516c\u5171\u8bbe\u7f6e>\u53c2\u6570\u914d\u7f6e>\u7cfb\u7edf\u53c2\u6570>\u5e94\u7528>\u5e94\u6536\u201d\u5173\u95ed\u53c2\u6570\u201c\u8de8\u7ec4\u7ec7\u5e94\u6536\u5e94\u4ed8\u534f\u540c\u751f\u6210\u201d\u3002", (String)"FinCoordinationService_0", (String)"fi-arapcommon", (Object[])new Object[]{billnos}));
                    }
                    throw new KDBizException(ResManager.loadKDString((String)"%s\uff1a\u5355\u636e\u7b26\u5408\u534f\u540c\u751f\u6210\u8d22\u52a1\u5e94\u6536\u5355\u7684\u6761\u4ef6\uff0c\u4f46\u7531\u4e8e\u8f6c\u6362\u89c4\u5219\u7981\u7528\uff0c\u5ba1\u6838\u540e\u5c06\u65e0\u6cd5\u534f\u540c\u3002\n \u82e5\u9700\u7ee7\u7eed\u534f\u540c\u751f\u6210\uff0c\u8bf7\u524d\u5f80\u201c\u5f00\u53d1\u670d\u52a1\u4e91>\u5355\u636e\u8f6c\u6362\u5f00\u53d1>\u8f6c\u6362\u89c4\u5219\u201d\u542f\u7528\u8d22\u52a1\u5e94\u4ed8\u5355\u5173\u8054\u751f\u6210\u8d22\u52a1\u5e94\u6536\u5355\u7684\u8f6c\u6362\u89c4\u5219\uff1b\u82e5\u65e0\u9700\u534f\u540c\u751f\u6210\uff0c\u8bf7\u524d\u5f80\u201c\u516c\u5171\u8bbe\u7f6e>\u53c2\u6570\u914d\u7f6e>\u7cfb\u7edf\u53c2\u6570>\u5e94\u7528>\u5e94\u4ed8\u201d\u5173\u95ed\u53c2\u6570\u201c\u8de8\u7ec4\u7ec7\u5e94\u6536\u5e94\u4ed8\u534f\u540c\u751f\u6210\u201d\u3002", (String)"FinCoordinationService_1", (String)"fi-arapcommon", (Object[])new Object[]{billnos}));
                }
            }
            logger.info("FinCoordinationService:coordination finPks : " + coordFinPks);
            if (!coordFinPks.isEmpty()) {
                CommonParam commonParam = new CommonParam();
                commonParam.put((Object)"coordFinPks", coordFinPks);
                commonParam.put((Object)"entityKey", (Object)entityKey);
                ECServiceHelper.beginAndRegisterWithBusInfo("ap_coordination_push", "coordination_push", "fi", "ap", "CoordAndPrepaidECService", (Param)commonParam, "", new ArrayList<Object>(coordFinPks));
            }
        }
    }

    private List<Long> getCanPushPks(DynamicObject[] finBills, Set<String> finBillnos) {
        ArrayList<Long> finPks = new ArrayList<Long>(finBills.length);
        HashMap<Long, Map<String, Boolean>> orgMap = new HashMap<Long, Map<String, Boolean>>();
        List<Object> batchInternalAsst = this.getBatchInternalAssts(finBills);
        logger.info("FinCoordinationService:getCanPushPks batchInternalAsst : " + batchInternalAsst);
        if (batchInternalAsst.isEmpty()) {
            return finPks;
        }
        for (DynamicObject finBill : finBills) {
            String asstActType = finBill.getString("asstacttype");
            boolean c_asst = this.isAr ? "bos_user".equals(asstActType) || "bos_org".equals(asstActType) : "bos_user".equals(asstActType);
            String sourcebilltype = finBill.getString("sourcebilltype");
            boolean c_srcbill = this.isAr ? !"ap_finapbill".equals(sourcebilltype) : !"ar_finarbill".equals(sourcebilltype);
            DynamicObject asstact = finBill.getDynamicObject("asstact");
            boolean isInternalOrg = batchInternalAsst.contains(asstact.getPkValue());
            if (!c_srcbill || c_asst || !isInternalOrg) continue;
            Long orgPk = (Long)finBill.getDynamicObject("org").getPkValue();
            boolean p002 = false;
            Map<String, Boolean> cMap = new HashMap();
            if (!orgMap.containsKey(orgPk)) {
                Object v = ArApHelper.getParameter(orgPk, this.isAr ? "ar_002" : "ap_002", this.isAr);
                if (!ObjectUtils.isEmpty((Object)v)) {
                    p002 = (Boolean)v;
                }
                boolean isPush = false;
                if (p002) {
                    isPush = this.isPush(finBill, orgPk);
                }
                cMap.put("p002", p002);
                cMap.put("isPush", isPush);
                orgMap.put(orgPk, cMap);
            } else {
                cMap = (Map)orgMap.get(orgPk);
            }
            if (!((Boolean)cMap.get("p002")).booleanValue() || !((Boolean)cMap.get("isPush")).booleanValue() || !this.executeCondition(finBill)) continue;
            finPks.add((Long)finBill.getPkValue());
            finBillnos.add(finBill.getString("billno"));
        }
        return finPks;
    }

    private List<Object> getBatchInternalAssts(DynamicObject[] finBills) {
        ArrayList<Object> internalAsstActList = new ArrayList<Object>(finBills.length);
        HashSet<Long> customerIdSet = new HashSet<Long>(finBills.length);
        HashSet<Long> supplierIdSet = new HashSet<Long>(finBills.length);
        for (DynamicObject finBill : finBills) {
            String asstactType = finBill.getString("asstacttype");
            DynamicObject asstact = finBill.getDynamicObject("asstact");
            if (asstact == null) continue;
            if ("bd_customer".equals(asstactType)) {
                customerIdSet.add(asstact.getLong("id"));
                continue;
            }
            if (!"bd_supplier".equals(asstactType)) continue;
            supplierIdSet.add(asstact.getLong("id"));
        }
        if (!customerIdSet.isEmpty()) {
            List internalCusPkList = QueryServiceHelper.queryPrimaryKeys((String)"bd_customer", (QFilter[])new QFilter[]{new QFilter("id", "in", customerIdSet), new QFilter("internal_company", ">", (Object)0L)}, (String)"id", (int)customerIdSet.size());
            internalAsstActList.addAll(internalCusPkList);
        }
        if (!supplierIdSet.isEmpty()) {
            List internalSupPkList = QueryServiceHelper.queryPrimaryKeys((String)"bd_supplier", (QFilter[])new QFilter[]{new QFilter("id", "in", supplierIdSet), new QFilter("internal_company", ">", (Object)0L)}, (String)"id", (int)supplierIdSet.size());
            internalAsstActList.addAll(internalSupPkList);
        }
        return internalAsstActList;
    }

    private boolean executeCondition(DynamicObject finBill) {
        Long orgPk = (Long)finBill.getDynamicObject("org").getPkValue();
        Object conditionvalue = ArApHelper.getParameter(orgPk, this.isAr ? "ar002_conditionvalue" : "ap002_conditionvalue", this.isAr);
        if (EmptyUtils.isEmpty(conditionvalue)) {
            return true;
        }
        CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)conditionvalue.toString(), CRCondition.class);
        String billEntityName = this.isAr ? "ar_finarbill" : "ap_finapbill";
        FilterCondition filterCondition = condition.getFilterCondition();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billEntityName);
        FilterBuilder filterBuilder = new FilterBuilder(dataEntityType, filterCondition, true);
        filterBuilder.buildFilter(false);
        QFilter qfilter = filterBuilder.getQFilter();
        if (qfilter == null) {
            return true;
        }
        qfilter.and("id", "=", finBill.get("id"));
        return QueryServiceHelper.exists((String)billEntityName, (QFilter[])new QFilter[]{qfilter});
    }

    private boolean isPush(DynamicObject finBill, long orgPk) {
        long internalOrgPk;
        InitHelper init;
        DynamicObject partner;
        boolean isPush = false;
        boolean isbizPartner = false;
        Long billtype4otr = this.isAr ? BillTypeConsts.ARFIN_OTR : BillTypeConsts.APFIN_OTR;
        isbizPartner = billtype4otr.equals(finBill.getDynamicObject(this.isAr ? "billtype" : "billtypeid").getPkValue()) ? BizPartnerHelper.isbizPartner(orgPk) : BizPartnerHelper.isbizPartner(orgPk, this.isAr ? "issupplier" : "iscustomer");
        if (isbizPartner && (partner = BizPartnerHelper.getinternalOrg(finBill.getDynamicObject("asstact"))) != null && !ObjectUtils.isEmpty((Object)(init = new InitHelper(internalOrgPk = ((Long)partner.getPkValue()).longValue(), this.isAr ? "ap_init" : "ar_init")).getInitId())) {
            isPush = true;
        }
        return isPush;
    }
}

