/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.fin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.consts.BillTypeConsts;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.exception.OperationException;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.service.woff.AbstractWriteOff;
import kd.fi.arapcommon.service.woff.impl.BusPushImpl;
import kd.fi.arapcommon.service.woff.impl.SrcSame4VerifyImpl;
import kd.fi.arapcommon.service.woff.info.BusEntryInfo;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.vo.ErrorInfo;

public class FinWoffService {
    private static final Log logger = LogFactory.getLog(FinWoffService.class);
    private static final String AR004 = "ar_004";
    private static final String AP004 = "ap_004";
    private static Set<String> busEntityKeys = new HashSet<String>();
    private boolean isAr = false;
    private String busEntityKey;
    private Map<Long, BigDecimal> entryAmountMap = new HashMap<Long, BigDecimal>(0);
    private Map<Long, BigDecimal> entryNoTaxAmtMap = new HashMap<Long, BigDecimal>(0);
    private Map<Long, BigDecimal> entryNoTaxLocAmtMap = new HashMap<Long, BigDecimal>(0);
    private Map<Long, BigDecimal> entryLocAmtMap = new HashMap<Long, BigDecimal>(0);
    private Map<Long, BigDecimal> entryQuantityMap = new HashMap<Long, BigDecimal>(0);
    private Map<Long, Set<Long>> entryPkGroup = new HashMap<Long, Set<Long>>(0);
    private Set<Long> allVerifyIds = new HashSet<Long>(0);

    public FinWoffService(boolean isAr) {
        this.isAr = isAr;
    }

    public void genWoffBill(DynamicObject[] finBills) {
        String entryKey = this.isAr ? "entry" : "detailentry";
        String srcEntryIdEntity = this.isAr ? "e_srcentryid" : "e_sourcebillentryid";
        this.busEntityKey = this.isAr ? "ar_busbill" : "ap_busbill";
        List<DynamicObject> finList = this.getFinBillList(finBills);
        finList = this.mergeFinBill(finList);
        ArrayList busEntryInfos = new ArrayList(0);
        if (!finList.isEmpty()) {
            ArrayList<DynamicObject> woffList = new ArrayList<DynamicObject>();
            ArrayList<BusEntryInfo> lastBusBills = new ArrayList<BusEntryInfo>();
            ArrayList<BusEntryInfo> lastPreWoffs = new ArrayList<BusEntryInfo>();
            ArrayList<BusEntryInfo> lastGenWoffs = new ArrayList<BusEntryInfo>();
            for (DynamicObject finbill : finList) {
                boolean isAmt = finbill.getBoolean("payproperty.isbasedonamt");
                String sourcebilltype = finbill.getString("sourcebilltype");
                AbstractWriteOff iWoff = null;
                DynamicObjectCollection entryList = finbill.getDynamicObjectCollection(entryKey);
                List entrySrcIds = entryList.stream().map(entry -> entry.getLong(srcEntryIdEntity)).collect(Collectors.toList());
                Set<Object> tmpVerifyIds = new HashSet(0);
                if (this.isScmcBill(sourcebilltype)) {
                    if (this.allVerifyIds.containsAll(entrySrcIds)) continue;
                    tmpVerifyIds = this.addVerifyValue(srcEntryIdEntity, entryList);
                    iWoff = new SrcSame4VerifyImpl(this.isAr, sourcebilltype, isAmt);
                    finbill.getDynamicObjectCollection(entryKey).removeIf(entry -> this.allVerifyIds.contains(entry.getLong(srcEntryIdEntity)));
                    this.allVerifyIds.addAll(tmpVerifyIds);
                } else {
                    iWoff = new BusPushImpl(this.isAr, isAmt);
                }
                Tuple<List<DynamicObject>, List<BusEntryInfo>> genResult = iWoff.genWoffBill(finbill, lastBusBills, lastPreWoffs, lastGenWoffs);
                List woffBills = (List)genResult.item1;
                List busEntrys = (List)genResult.item2;
                if (EmptyUtils.isNotEmpty(busEntrys)) {
                    Set woffSmEntryPks = busEntrys.stream().filter(info -> info.isWoff() && Objects.nonNull(info.getSrcImEntryPk())).map(BusEntryInfo::getSrcImEntryPk).collect(Collectors.toSet());
                    this.allVerifyIds.addAll(woffSmEntryPks);
                    busEntryInfos.addAll(busEntrys);
                }
                if (ObjectUtils.isEmpty((Object)woffBills)) continue;
                woffList.addAll(woffBills);
            }
            this.entryPkGroup = busEntryInfos.stream().collect(Collectors.groupingBy(BusEntryInfo::getSrcEntryPk, Collectors.mapping(BusEntryInfo::getPk, Collectors.toSet())));
            if (!woffList.isEmpty()) {
                this.setTargetBillsNo(woffList);
                this.doOperation(woffList, lastBusBills);
            }
        }
    }

    private Set<Long> addVerifyValue(String srcEntryIdEntity, DynamicObjectCollection entryList) {
        String recamountKey = this.isAr ? "e_recamount" : "e_pricetaxtotal";
        String reclocalamtKey = this.isAr ? "e_reclocalamt" : "e_pricetaxtotalbase";
        String localamtKey = this.isAr ? "e_localamt" : "e_amountbase";
        String quantityKey = this.isAr ? "e_quantity" : "quantity";
        HashSet<Long> tmpVerifyIds = new HashSet<Long>(0);
        for (DynamicObject entry : entryList) {
            long srcEntryId = entry.getLong(srcEntryIdEntity);
            boolean isallverify = entry.getBoolean("e_isallverify");
            if (isallverify) {
                tmpVerifyIds.add(srcEntryId);
            }
            BigDecimal existReamount = this.entryAmountMap.get(srcEntryId);
            BigDecimal existQuantity = this.entryQuantityMap.get(srcEntryId);
            if (this.allVerifyIds.contains(srcEntryId)) continue;
            if (Objects.isNull(existReamount)) {
                this.entryAmountMap.put(srcEntryId, entry.getBigDecimal(recamountKey));
                this.entryLocAmtMap.put(srcEntryId, entry.getBigDecimal(reclocalamtKey));
                this.entryNoTaxAmtMap.put(srcEntryId, entry.getBigDecimal("e_amount"));
                this.entryNoTaxLocAmtMap.put(srcEntryId, entry.getBigDecimal(localamtKey));
            } else {
                this.entryAmountMap.put(srcEntryId, existReamount.add(entry.getBigDecimal(recamountKey)));
                this.entryLocAmtMap.put(srcEntryId, this.entryLocAmtMap.get(srcEntryId).add(entry.getBigDecimal(reclocalamtKey)));
                this.entryNoTaxAmtMap.put(srcEntryId, this.entryNoTaxAmtMap.get(srcEntryId).add(entry.getBigDecimal("e_amount")));
                this.entryNoTaxLocAmtMap.put(srcEntryId, this.entryNoTaxLocAmtMap.get(srcEntryId).add(entry.getBigDecimal(localamtKey)));
            }
            if (Objects.isNull(existQuantity)) {
                this.entryQuantityMap.put(srcEntryId, entry.getBigDecimal(quantityKey));
                continue;
            }
            this.entryQuantityMap.put(srcEntryId, existQuantity.add(entry.getBigDecimal(quantityKey)));
        }
        return tmpVerifyIds;
    }

    private boolean isVerify(DynamicObject finbill) {
        String entryKey = this.isAr ? "entry" : "detailentry";
        boolean anyMatch = finbill.getDynamicObjectCollection(entryKey).stream().anyMatch(entry -> entry.getBoolean("e_isallverify"));
        return anyMatch;
    }

    private void setTargetBillsNo(List<DynamicObject> trgBills) {
        Map<String, List<DynamicObject>> orgPkGroup = trgBills.stream().collect(Collectors.groupingBy(bill -> bill.getDynamicObject("org").getPkValue().toString()));
        orgPkGroup.entrySet().forEach(entry -> {
            List targetBills = (List)entry.getValue();
            int size = targetBills.size();
            Object[] numbers = CodeRuleServiceHelper.getBatchNumber((String)this.busEntityKey, (DynamicObject)((DynamicObject)targetBills.get(0)), (String)((String)entry.getKey()), (int)size);
            if (ObjectUtils.isEmpty((Object[])numbers) || numbers.length < size) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6682\u4f30\u5355\u7f16\u7801\u751f\u6210\u5f02\u5e38\uff0c\u8bf7\u542f\u7528\u7f16\u7801\u89c4\u5219\u3002", (String)"FinWoffService_0", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
            int i = 0;
            for (DynamicObject trgBusBill : targetBills) {
                trgBusBill.set("billno", numbers[i]);
                ++i;
            }
        });
    }

    protected void doOperation(List<DynamicObject> woffList, List<BusEntryInfo> lastBusBills) {
        ArrayList<Long> busPks = new ArrayList<Long>();
        ArrayList<Long> busEntryPks = new ArrayList<Long>();
        for (BusEntryInfo beInfo : lastBusBills) {
            long srcEntryPk;
            long busPk = beInfo.getPk();
            if (!busPks.contains(busPk)) {
                busPks.add(busPk);
            }
            if (!beInfo.isWoff() || busEntryPks.contains(srcEntryPk = beInfo.getEntryPk())) continue;
            busEntryPks.add(srcEntryPk);
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("iswoff", "true");
        option.setVariableValue("WF", "false");
        option.setVariableValue("mutex_writeback", "false");
        OperationResult result = OperationServiceHelper.executeOperate((String)"nocontrolsubmit", (String)this.busEntityKey, (DynamicObject[])woffList.toArray(new DynamicObject[0]), (OperateOption)option);
        if (result.isSuccess()) {
            List successPkIds = result.getSuccessPkIds();
            if (successPkIds.size() > 0) {
                OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)this.busEntityKey, (Object[])successPkIds.toArray(), (OperateOption)option);
                OperationHelper.assertResult(auditResult);
            }
            this.updateSrcBusEntry(busPks, busEntryPks, true);
        } else {
            logger.info("------operationResult.Message------" + result.getMessage());
            try {
                OperationHelper.assertResult(result);
            }
            catch (Exception e) {
                List validateInfos = result.getAllErrorOrValidateInfo();
                StringBuilder sb = new StringBuilder();
                if (validateInfos.isEmpty()) {
                    sb.append(result.getMessage());
                } else {
                    for (IOperateInfo err : validateInfos) {
                        sb.append(err.getMessage()).append('\n');
                    }
                }
                ErrorCode errorCode = new ErrorCode("submit_err", sb.toString());
                throw new OperationException(errorCode);
            }
        }
    }

    private List<DynamicObject> getFinBillList(DynamicObject[] finBills) {
        ArrayList<DynamicObject> finList = new ArrayList<DynamicObject>();
        Long billtypeID = this.isAr ? BillTypeConsts.ARFIN_BORROW : BillTypeConsts.APFIN_BORROW;
        HashMap<Long, Boolean> orgMap = new HashMap<Long, Boolean>();
        for (DynamicObject finBill : finBills) {
            QFilter fixFilter;
            QFilter qFilter;
            HashSet srcPks;
            long finPk;
            Long orgPk = finBill.getLong("org.id");
            boolean p004 = false;
            if (!orgMap.containsKey(orgPk)) {
                p004 = this.getBizParam(orgPk, this.isAr ? AR004 : AP004);
                orgMap.put(orgPk, p004);
            } else {
                p004 = (Boolean)orgMap.get(orgPk);
            }
            boolean flag = finBill.getBoolean(this.isAr ? "istransfer" : "istanspay") || finBill.getBoolean("iswrittenoff") || !this.isAr && finBill.getBoolean("ispremium") || billtypeID.compareTo(finBill.getDynamicObject(this.isAr ? "billtype" : "billtypeid").getLong("id")) == 0;
            String sourcebilltype = finBill.getString("sourcebilltype");
            if (!p004 || flag || EmptyUtils.isEmpty(sourcebilltype)) continue;
            if (busEntityKeys.contains(sourcebilltype)) {
                finList.add(finBill);
                continue;
            }
            Map linkBills = BFTrackerServiceHelper.findSourceBills((String)(this.isAr ? "ar_finarbill" : "ap_finapbill"), (Long[])new Long[]{finPk = ((Long)finBill.getPkValue()).longValue()});
            if (this.containsBusKey(linkBills)) {
                finList.add(finBill);
                continue;
            }
            if (!this.isScmcBill(sourcebilltype) || (srcPks = (HashSet)linkBills.get(sourcebilltype)) == null || srcPks.isEmpty()) continue;
            ArrayList imSrcPks = new ArrayList(srcPks);
            Long orgId = finBill.getDynamicObject("org").getLong("id");
            QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
            if (!QueryServiceHelper.exists((String)this.busEntityKey, (QFilter[])new QFilter[]{orgFilter, qFilter = new QFilter("entry.e_srcbillid", "in", imSrcPks), fixFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue())})) continue;
            finList.add(finBill);
        }
        return finList;
    }

    private boolean isScmcBill(String sourceBillType) {
        boolean isScmc = false;
        if (sourceBillType.startsWith("im_") || sourceBillType.startsWith("pm_") || sourceBillType.startsWith("sm_") || sourceBillType.startsWith("conm_")) {
            isScmc = true;
        }
        return isScmc;
    }

    private boolean getBizParam(Object orgPk, String param) {
        boolean p = false;
        Object v = ArApHelper.getParameter(orgPk, param, this.isAr);
        if (!ObjectUtils.isEmpty((Object)v)) {
            if (v instanceof Boolean) {
                p = (Boolean)v;
            } else if (v instanceof String) {
                p = "1".equals(v);
            }
        }
        return p;
    }

    private boolean containsBusKey(Map<String, HashSet<Long>> linkBills) {
        boolean contain = false;
        for (String srcKey : linkBills.keySet()) {
            if (!busEntityKeys.contains(srcKey)) continue;
            contain = true;
            break;
        }
        return contain;
    }

    public List<ErrorInfo> delWoffBill(DynamicObject[] finbills) {
        List<ErrorInfo> errList = null;
        this.busEntityKey = this.isAr ? "ar_busbill" : "ap_busbill";
        QFilter qFilter = new QFilter("srcfinbillid", "in", ArApHelper.getPks(finbills));
        String sql4woff = "id, srcfinbillid, sourcebillid, entry.e_srcbillid, entry.e_srcentryid";
        DynamicObject[] woffBills = BusinessDataServiceHelper.load((String)this.busEntityKey, (String)sql4woff, (QFilter[])new QFilter[]{qFilter});
        ArrayList<Long> delWoffPks = new ArrayList<Long>(64);
        ArrayList<Long> srcPks = new ArrayList<Long>(64);
        ArrayList<Long> finPks = new ArrayList<Long>(64);
        for (DynamicObject woffBill : woffBills) {
            delWoffPks.add(woffBill.getLong("id"));
            finPks.add(woffBill.getLong("srcfinbillid"));
            for (DynamicObject woffEntry : woffBill.getDynamicObjectCollection("entry")) {
                long srcPk = woffEntry.getLong("e_srcbillid");
                if (EmptyUtils.isEmpty(srcPk)) {
                    srcPk = woffBill.getLong("sourcebillid");
                }
                if (srcPks.contains(srcPk)) continue;
                srcPks.add(srcPk);
            }
        }
        if (!delWoffPks.isEmpty()) {
            ArrayList<DynamicObject> finbillList = new ArrayList<DynamicObject>();
            for (DynamicObject finbill : finbills) {
                if (!finPks.contains(finbill.getPkValue())) continue;
                finbillList.add(finbill);
            }
            String entryAmt = this.isAr ? "e_recamount" : "e_pricetaxtotal";
            String sql4bus = "id, sourcebillid, entry.id, e_quantity, e_invoicedqty, e_unwoffqty, e_unwoffamt, e_srcentryid, e_iswriteoff, e_srcbillid, e_invoicedamt, e_ispresent," + entryAmt;
            QFilter filter = new QFilter("id", "in", srcPks);
            DynamicObject[] busBills = BusinessDataServiceHelper.load((String)this.busEntityKey, (String)sql4bus, (QFilter[])new QFilter[]{filter});
            List<DynamicObject> srcBusEntries = this.getSrcBusEntries(finbillList, busBills);
            this.setAfterVerifyValue(finbills, woffBills, busBills);
            errList = this.doOperation4Del(delWoffPks, woffBills, srcBusEntries);
        }
        return errList;
    }

    private void setAfterVerifyValue(DynamicObject[] finbills, DynamicObject[] woffBills, DynamicObject[] busBills) {
        String entryKey = this.isAr ? "entry" : "detailentry";
        String finSrcEntryKey = this.isAr ? "e_srcentryid" : "e_sourcebillentryid";
        String quantityKey = this.isAr ? "e_quantity" : "quantity";
        String recamountKey = this.isAr ? "e_recamount" : "e_pricetaxtotal";
        String locRecamtKey = this.isAr ? "e_reclocalamt" : "e_pricetaxtotalbase";
        String localamtKey = this.isAr ? "e_localamt" : "e_amountbase";
        Map<Long, Long> busBillIdMap = Stream.of(busBills).map(busbill -> busbill.getDynamicObjectCollection("entry")).flatMap(Collection::stream).collect(Collectors.toMap(entry -> entry.getLong("id"), entry -> entry.getLong("e_srcentryid")));
        List selfWriteFinBills = Stream.of(finbills).filter(finbill -> this.isScmcBill(finbill.getString("sourcebilltype"))).collect(Collectors.toList());
        List verifyFinBillIds = selfWriteFinBills.stream().map(bill -> bill.getLong("id")).collect(Collectors.toList());
        List busbill2 = Stream.of(woffBills).filter(bill -> verifyFinBillIds.contains(bill.getLong("srcfinbillid"))).collect(Collectors.toList());
        HashMap finBillPkMap = new HashMap(busbill2.size());
        for (DynamicObject bill2 : busbill2) {
            HashSet<Long> srcfinbillid = (HashSet<Long>)finBillPkMap.get(bill2.getLong("srcfinbillid"));
            DynamicObjectCollection entries = bill2.getDynamicObjectCollection("entry");
            if (srcfinbillid == null) {
                srcfinbillid = new HashSet<Long>(entries.size());
            }
            for (DynamicObject entry2 : entries) {
                srcfinbillid.add(busBillIdMap.get(entry2.getLong("e_srcentryid")));
            }
            finBillPkMap.put(bill2.getLong("srcfinbillid"), srcfinbillid);
        }
        for (DynamicObject selfWriteFinBill : selfWriteFinBills) {
            Set srcEntryIds = (Set)finBillPkMap.get(selfWriteFinBill.getLong("id"));
            if (!EmptyUtils.isNotEmpty(srcEntryIds)) continue;
            Map<Long, List<DynamicObject>> srcEntryKeyGroup = selfWriteFinBill.getDynamicObjectCollection(entryKey).stream().collect(Collectors.groupingBy(entry -> entry.getLong(finSrcEntryKey)));
            for (Long srcEntryId : srcEntryIds) {
                List<DynamicObject> srcEntrys = srcEntryKeyGroup.get(srcEntryId);
                if (!EmptyUtils.isNotEmpty(srcEntrys)) continue;
                for (DynamicObject srcEntry : srcEntrys) {
                    BigDecimal amount = srcEntry.getBigDecimal(recamountKey).negate();
                    BigDecimal locAmount = srcEntry.getBigDecimal(locRecamtKey).negate();
                    BigDecimal noTaxAmt = srcEntry.getBigDecimal("e_amount").negate();
                    BigDecimal noTaxLocAmt = srcEntry.getBigDecimal(localamtKey).negate();
                    BigDecimal quantity = srcEntry.getBigDecimal(quantityKey).negate();
                    BigDecimal existAmount = this.entryAmountMap.get(srcEntryId);
                    BigDecimal existQuantity = this.entryQuantityMap.get(srcEntryId);
                    if (Objects.isNull(existAmount)) {
                        this.entryAmountMap.put(srcEntryId, amount);
                        this.entryLocAmtMap.put(srcEntryId, locAmount);
                        this.entryNoTaxAmtMap.put(srcEntryId, noTaxAmt);
                        this.entryNoTaxLocAmtMap.put(srcEntryId, noTaxLocAmt);
                    } else {
                        this.entryAmountMap.put(srcEntryId, existAmount.add(amount));
                        this.entryLocAmtMap.put(srcEntryId, this.entryLocAmtMap.get(srcEntryId).add(locAmount));
                        this.entryNoTaxAmtMap.put(srcEntryId, this.entryNoTaxAmtMap.get(srcEntryId).add(noTaxAmt));
                        this.entryNoTaxLocAmtMap.put(srcEntryId, this.entryNoTaxLocAmtMap.get(srcEntryId).add(noTaxLocAmt));
                    }
                    if (Objects.isNull(existQuantity)) {
                        this.entryQuantityMap.put(srcEntryId, quantity);
                        continue;
                    }
                    this.entryQuantityMap.put(srcEntryId, existQuantity.add(quantity));
                }
            }
        }
    }

    private List<ErrorInfo> doOperation4Del(List<Long> delWoffPks, DynamicObject[] woffBills, List<DynamicObject> srcBusEntries) {
        List successPkIds;
        List<ErrorInfo> errList = null;
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("mutex_writeback", "false");
        OperationResult unauditResult = OperationServiceHelper.executeOperate((String)"noprotocolunaudit", (String)this.busEntityKey, (Object[])delWoffPks.toArray(), (OperateOption)option);
        OperationHelper.assertResult(unauditResult);
        if (!unauditResult.isSuccess()) {
            logger.info("------unauditResult.Message------" + unauditResult.getMessage());
            errList = this.setErrorMsgList(errList, woffBills, unauditResult);
        }
        if (!(successPkIds = unauditResult.getSuccessPkIds()).isEmpty()) {
            ArrayList<Long> busPks = new ArrayList<Long>(woffBills.length);
            for (DynamicObject woffBill : woffBills) {
                if (ObjectUtils.isEmpty((Object)successPkIds) || !successPkIds.contains(woffBill.getPkValue())) continue;
                DynamicObjectCollection entries = woffBill.getDynamicObjectCollection("entry");
                for (DynamicObject entry : entries) {
                    long srcPk = entry.getLong("e_srcbillid");
                    if (busPks.contains(srcPk)) continue;
                    busPks.add(srcPk);
                }
            }
            if (!busPks.isEmpty()) {
                ArrayList<Long> srcEntryIdList = new ArrayList<Long>();
                for (DynamicObject busEntryByFin : srcBusEntries) {
                    if (busEntryByFin.getBoolean("e_iswriteoff")) continue;
                    srcEntryIdList.add(busEntryByFin.getLong("id"));
                }
                this.updateSrcBusEntry(busPks, srcEntryIdList, false);
            }
            option.setVariableValue("isStrict", "false");
            option.setVariableValue("ignoreValidation", "true");
            OperationResult deleteResult = OperationServiceHelper.executeOperate((String)"delete", (String)this.busEntityKey, (Object[])successPkIds.toArray(), (OperateOption)option);
            OperationHelper.assertResult(deleteResult);
        }
        return errList;
    }

    private List<DynamicObject> getSrcBusEntries(List<DynamicObject> finbillList, DynamicObject[] busBills) {
        ArrayList<DynamicObject> srcBusEntriesByFin = new ArrayList<DynamicObject>();
        String entryKey = this.isAr ? "entry" : "detailentry";
        for (DynamicObject finbill : finbillList) {
            boolean isAmt = finbill.getBoolean("payproperty.isbasedonamt");
            boolean isScmc = this.isScmcBill(finbill.getString("sourcebilltype"));
            DynamicObjectCollection finEntries = finbill.getDynamicObjectCollection(entryKey);
            for (DynamicObject finEntry : finEntries) {
                long e_srcId = finEntry.getLong(this.isAr ? "e_srcid" : "e_sourcebillid");
                long finSrcEntryId = finEntry.getLong(this.isAr ? "e_srcentryid" : "e_sourcebillentryid");
                ArrayList<DynamicObject> srcBusEntryList = new ArrayList<DynamicObject>(8);
                block2: for (DynamicObject busBill : busBills) {
                    DynamicObjectCollection busEntries = busBill.getDynamicObjectCollection("entry");
                    for (DynamicObject busEntry : busEntries) {
                        boolean compare;
                        boolean same = isScmc ? Long.valueOf(busEntry.getLong("e_srcbillid")).equals(e_srcId) : busBill.getPkValue().equals(e_srcId);
                        if (!same) continue;
                        boolean bl = compare = isScmc ? busEntry.get("e_srcentryid").equals(finSrcEntryId) : busEntry.getPkValue().equals(finSrcEntryId);
                        if (!busEntry.getBoolean("e_iswriteoff") || !compare) continue;
                        srcBusEntryList.add(busEntry);
                        continue block2;
                    }
                }
                for (DynamicObject srcBusEntry : srcBusEntryList) {
                    if (isScmc) {
                        srcBusEntry.set("e_iswriteoff", (Object)Boolean.FALSE);
                        srcBusEntriesByFin.add(srcBusEntry);
                        continue;
                    }
                    if (isAmt) {
                        boolean ispresent = srcBusEntry.getBoolean("e_ispresent");
                        BigDecimal amt = srcBusEntry.getBigDecimal("e_unwoffamt").add(finEntry.getBigDecimal(this.isAr ? "e_recamount" : "e_pricetaxtotal"));
                        if (BigDecimal.ZERO.compareTo(amt.abs()) >= 0 && !ispresent) continue;
                        srcBusEntry.set("e_iswriteoff", (Object)Boolean.FALSE);
                        srcBusEntriesByFin.add(srcBusEntry);
                        continue;
                    }
                    BigDecimal qty = srcBusEntry.getBigDecimal("e_unwoffqty").add(finEntry.getBigDecimal(this.isAr ? "e_quantity" : "quantity"));
                    if (BigDecimal.ZERO.compareTo(qty.abs()) >= 0) continue;
                    srcBusEntry.set("e_iswriteoff", (Object)Boolean.FALSE);
                    srcBusEntriesByFin.add(srcBusEntry);
                }
            }
        }
        return srcBusEntriesByFin;
    }

    private List<ErrorInfo> setErrorMsgList(List<ErrorInfo> errList, DynamicObject[] woffBills, OperationResult opResult) {
        if (errList == null) {
            errList = new ArrayList<ErrorInfo>();
        }
        HashMap<Object, Long> woffIdMap = new HashMap<Object, Long>(64);
        for (DynamicObject woffBill : woffBills) {
            woffIdMap.put(woffBill.getPkValue(), woffBill.getLong("srcfinbillid"));
        }
        StringBuffer sb = new StringBuffer();
        List validateErrors = opResult.getValidateResult().getValidateErrors();
        for (ValidateResult vr : validateErrors) {
            List allErrorInfo = vr.getAllErrorInfo();
            for (OperateErrorInfo errInfo : allErrorInfo) {
                sb.append(errInfo.getPkValue());
                sb.append(" -- ");
                sb.append(errInfo.getMessage()).append(',');
                ErrorInfo error = new ErrorInfo();
                error.setPk(woffIdMap.get(errInfo.getPkValue()));
                error.setMsg(errInfo.getMessage());
                errList.add(error);
            }
        }
        logger.info(sb.append("------opResult.OperateErrors------").toString());
        return errList;
    }

    private void updateSrcBusEntry(List<Long> srcPks, List<Long> srcEntryIdList, boolean iswoff) {
        Set<Long> selfWbEntrySrcIds = this.entryAmountMap.keySet();
        Set addSrcPks = this.entryPkGroup.entrySet().stream().filter(entry -> selfWbEntrySrcIds.contains(entry.getKey())).map(entry -> (Set)entry.getValue()).flatMap(Collection::stream).collect(Collectors.toSet());
        addSrcPks.addAll(srcPks);
        if (EmptyUtils.isNotEmpty(addSrcPks)) {
            DynamicObject[] srcBills;
            QFilter qFilter = new QFilter("id", "in", addSrcPks);
            for (DynamicObject srcBill : srcBills = BusinessDataServiceHelper.load((String)this.busEntityKey, (String)"billno,invoicedamt,uninvoicedamt,invoicedlocamt,uninvoicedlocamt,payproperty.isbasedonamt,entry.e_iswriteoff,entry.e_invoicedqty,entry.e_uninvoicedqty,entry.e_invoicedamt,entry.e_uninvoicedamt,entry.e_invoicedlocamt,entry.e_uninvoicedlocamt,entry.e_srcentryid,entry.e_ispresent,e_invoicednotaxamt,e_invnotaxlocalamt,e_uninvnotaxamt,e_uninvnotaxlocalamt", (QFilter[])new QFilter[]{qFilter})) {
                DynamicObjectCollection srcEntries = srcBill.getDynamicObjectCollection("entry");
                for (DynamicObject srcEntry : srcEntries) {
                    long sourceEntryId = srcEntry.getLong("e_srcentryid");
                    if (!srcEntryIdList.contains(srcEntry.getLong("id")) && !selfWbEntrySrcIds.contains(sourceEntryId)) continue;
                    if (srcEntryIdList.contains(srcEntry.getLong("id"))) {
                        srcEntry.set("e_iswriteoff", (Object)iswoff);
                    }
                    this.retifyImBusData(srcBill, srcEntry, sourceEntryId);
                }
            }
            SaveServiceHelper.save((DynamicObject[])srcBills);
        }
    }

    private void retifyImBusData(DynamicObject srcBill, DynamicObject srcEntry, long sourceEntryId) {
        boolean isAmt = srcBill.getBoolean("payproperty.isbasedonamt");
        BigDecimal finAmount = this.entryAmountMap.get(sourceEntryId);
        BigDecimal quantity = this.entryQuantityMap.get(sourceEntryId);
        if (Objects.nonNull(finAmount)) {
            BigDecimal finLocAmt = this.entryLocAmtMap.get(sourceEntryId);
            BigDecimal finNoTaxAmt = this.entryNoTaxAmtMap.get(sourceEntryId);
            BigDecimal finNoTaxLocAmt = this.entryNoTaxLocAmtMap.get(sourceEntryId);
            srcEntry.set("e_invoicedamt", (Object)srcEntry.getBigDecimal("e_invoicedamt").add(finAmount));
            srcEntry.set("e_uninvoicedamt", (Object)srcEntry.getBigDecimal("e_uninvoicedamt").subtract(finAmount));
            srcEntry.set("e_invoicedlocamt", (Object)srcEntry.getBigDecimal("e_invoicedlocamt").add(finLocAmt));
            srcEntry.set("e_uninvoicedlocamt", (Object)srcEntry.getBigDecimal("e_uninvoicedlocamt").subtract(finLocAmt));
            srcEntry.set("e_invoicednotaxamt", (Object)srcEntry.getBigDecimal("e_invoicednotaxamt").add(finNoTaxAmt));
            srcEntry.set("e_invnotaxlocalamt", (Object)srcEntry.getBigDecimal("e_invnotaxlocalamt").add(finNoTaxLocAmt));
            srcEntry.set("e_uninvnotaxamt", (Object)srcEntry.getBigDecimal("e_uninvnotaxamt").subtract(finNoTaxAmt));
            srcEntry.set("e_uninvnotaxlocalamt", (Object)srcEntry.getBigDecimal("e_uninvnotaxlocalamt").subtract(finNoTaxLocAmt));
            srcBill.set("invoicedamt", (Object)srcBill.getBigDecimal("invoicedamt").add(finAmount));
            srcBill.set("uninvoicedamt", (Object)srcBill.getBigDecimal("uninvoicedamt").subtract(finAmount));
            srcBill.set("invoicedlocamt", (Object)srcBill.getBigDecimal("invoicedlocamt").add(finLocAmt));
            srcBill.set("uninvoicedlocamt", (Object)srcBill.getBigDecimal("uninvoicedlocamt").subtract(finLocAmt));
        }
        if (Objects.nonNull(quantity)) {
            boolean isPresent = srcEntry.getBoolean("e_ispresent");
            if (Objects.nonNull(isAmt) && isAmt && !isPresent) {
                int compareTo = srcEntry.getBigDecimal("e_uninvoicedamt").compareTo(BigDecimal.ZERO);
                switch (compareTo) {
                    case 1: {
                        srcEntry.set("e_invoicedqty", (Object)0);
                        srcEntry.set("e_uninvoicedqty", (Object)1);
                        break;
                    }
                    case 0: {
                        if (srcEntry.getBigDecimal("e_invoicedamt").compareTo(BigDecimal.ZERO) > 0) {
                            srcEntry.set("e_invoicedqty", (Object)1);
                            srcEntry.set("e_uninvoicedqty", (Object)0);
                            break;
                        }
                        srcEntry.set("e_invoicedqty", (Object)-1);
                        srcEntry.set("e_uninvoicedqty", (Object)0);
                        break;
                    }
                    case -1: {
                        srcEntry.set("e_invoicedqty", (Object)0);
                        srcEntry.set("e_uninvoicedqty", (Object)-1);
                        break;
                    }
                }
            } else if (Objects.nonNull(isAmt) && isAmt && isPresent) {
                int compareTo = srcEntry.getBigDecimal("e_uninvoicedqty").compareTo(BigDecimal.ZERO);
                switch (compareTo) {
                    case 1: {
                        srcEntry.set("e_invoicedqty", (Object)1);
                        srcEntry.set("e_uninvoicedqty", (Object)0);
                        break;
                    }
                    case 0: {
                        if (srcEntry.getBigDecimal("e_invoicedqty").compareTo(BigDecimal.ZERO) > 0) {
                            srcEntry.set("e_invoicedqty", (Object)0);
                            srcEntry.set("e_uninvoicedqty", (Object)1);
                            break;
                        }
                        srcEntry.set("e_invoicedqty", (Object)0);
                        srcEntry.set("e_uninvoicedqty", (Object)-1);
                        break;
                    }
                    case -1: {
                        srcEntry.set("e_invoicedqty", (Object)-1);
                        srcEntry.set("e_uninvoicedqty", (Object)0);
                        break;
                    }
                }
            } else {
                srcEntry.set("e_invoicedqty", (Object)srcEntry.getBigDecimal("e_invoicedqty").add(quantity));
                srcEntry.set("e_uninvoicedqty", (Object)srcEntry.getBigDecimal("e_uninvoicedqty").subtract(quantity));
            }
        }
    }

    private List<DynamicObject> mergeFinBill(List<DynamicObject> tmpFinBills) {
        ArrayList<DynamicObject> finBills = new ArrayList<DynamicObject>(tmpFinBills.size());
        String srcIdEntity = this.isAr ? "e_srcid" : "e_sourcebillid";
        String srcEntryIdEntity = this.isAr ? "e_srcentryid" : "e_sourcebillentryid";
        String entryEntity = this.isAr ? "entry" : "detailentry";
        String quantityKey = this.isAr ? "e_quantity" : "quantity";
        String isallverify = "e_isallverify";
        String recamount = this.isAr ? "e_recamount" : "e_pricetaxtotal";
        String invEntityKey = this.isAr ? "ar_invoice" : "ap_invoice";
        HashMap<String, DynamicObject> entryMap = new HashMap<String, DynamicObject>();
        for (DynamicObject tmpFinBill : tmpFinBills) {
            DynamicObjectCollection tmpFinEntrys;
            int size;
            if (invEntityKey.equals(tmpFinBill.getString("sourcebilltype")) && (size = (tmpFinEntrys = tmpFinBill.getDynamicObjectCollection(entryEntity)).size()) > 1) {
                DynamicObjectCollection finEntrys = new DynamicObjectCollection();
                for (int i = 0; i < size; ++i) {
                    DynamicObject tmpFinEntry = (DynamicObject)tmpFinEntrys.get(i);
                    long tmp_e_srcId = tmpFinEntry.getLong(srcIdEntity);
                    long tmp_e_srcEntryId = tmpFinEntry.getLong(srcEntryIdEntity);
                    if (entryMap.containsKey(tmp_e_srcId + "_" + tmp_e_srcEntryId)) continue;
                    for (int j = i + 1; j < size; ++j) {
                        DynamicObject finEntry = (DynamicObject)tmpFinEntrys.get(j);
                        long e_srcId = finEntry.getLong(srcIdEntity);
                        long e_srcEntryId = finEntry.getLong(srcEntryIdEntity);
                        if (tmp_e_srcId != e_srcId || tmp_e_srcEntryId != e_srcEntryId) continue;
                        tmpFinEntry.set(quantityKey, (Object)tmpFinEntry.getBigDecimal(quantityKey).add(finEntry.getBigDecimal(quantityKey)));
                        tmpFinEntry.set(recamount, (Object)tmpFinEntry.getBigDecimal(recamount).add(finEntry.getBigDecimal(recamount)));
                        if (finEntry.getBoolean(isallverify)) {
                            tmpFinEntry.set(isallverify, (Object)Boolean.TRUE);
                        }
                        entryMap.put(tmp_e_srcId + "_" + tmp_e_srcEntryId, tmpFinEntry);
                    }
                    finEntrys.add((Object)tmpFinEntry);
                }
                tmpFinBill.set(entryEntity, (Object)finEntrys);
            }
            finBills.add(tmpFinBill);
        }
        return finBills;
    }

    static {
        busEntityKeys.add("ar_busbill");
        busEntityKeys.add("ap_busbill");
    }
}

