/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.fin;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class FinWriteBackRevertService {
    public void revertByInvoice(DynamicObject invoice) {
        Set<Long> sBillIds = this.revertPushByInvoice(invoice);
        this.revertAppointByInvoice(invoice, sBillIds);
    }

    public Set<Long> revertPushByInvoice(DynamicObject invoice) {
        DynamicObject[] srcFins;
        if (invoice == null || !"ar_finarbill".equals(invoice.getString("sourcebilltype"))) {
            return new HashSet<Long>();
        }
        DynamicObjectCollection entrys = invoice.getDynamicObjectCollection("entry");
        HashMap<Long, BigDecimal> amtMap = new HashMap<Long, BigDecimal>(64);
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            Long entryId = entry.getLong("id");
            amtMap.put(entryId, entry.getBigDecimal("e_recamount"));
        }
        Long[] entryIds = amtMap.keySet().toArray(new Long[entrys.size()]);
        List sourceRowIds = BFTrackerServiceHelper.loadSourceRowIds((String)"ar_invoice", (String)"entry", (Long[])entryIds);
        HashMap<Long, HashMap<Long, Long>> sIdMap = new HashMap<Long, HashMap<Long, Long>>();
        for (BFRow row : sourceRowIds) {
            BFRowId sId = row.getSId();
            Long sBillId = sId.getBillId();
            HashMap<Long, Long> entryIdMap = (HashMap<Long, Long>)sIdMap.get(sBillId);
            if (ObjectUtils.isEmpty((Object)entryIdMap)) {
                entryIdMap = new HashMap<Long, Long>();
                sIdMap.put(sBillId, entryIdMap);
            }
            entryIdMap.put(sId.getEntryId(), row.getId().getEntryId());
        }
        Set<Long> sBillIds = sIdMap.keySet();
        for (DynamicObject srcFin : srcFins = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"id,invoicedamt,uninvoicedamt,entry.e_invoicedamt,entry.e_uninvoicedamt", (QFilter[])new QFilter[]{new QFilter("id", "in", sBillIds)})) {
            Map entryIdMap = (Map)sIdMap.get(srcFin.getLong("id"));
            Set srcEntryIds = entryIdMap.keySet();
            DynamicObjectCollection srcEntrys = srcFin.getDynamicObjectCollection("entry");
            for (DynamicObject srcEntry : srcEntrys) {
                Long srcEntryId = srcEntry.getLong("id");
                if (!srcEntryIds.contains(srcEntryId)) continue;
                BigDecimal disposerAmt = (BigDecimal)amtMap.get(entryIdMap.get(srcEntryId));
                srcEntry.set("e_invoicedamt", (Object)srcEntry.getBigDecimal("e_invoicedamt").subtract(disposerAmt));
                srcEntry.set("e_uninvoicedamt", (Object)srcEntry.getBigDecimal("e_uninvoicedamt").add(disposerAmt));
                srcFin.set("invoicedamt", (Object)srcFin.getBigDecimal("invoicedamt").subtract(disposerAmt));
                srcFin.set("uninvoicedamt", (Object)srcFin.getBigDecimal("uninvoicedamt").add(disposerAmt));
            }
        }
        SaveServiceHelper.save((DynamicObject[])srcFins);
        return sBillIds;
    }

    public void revertAppointByInvoice(DynamicObject invoice, Set<Long> sBillIds) {
        Map sourceBillIds = BFTrackerServiceHelper.findSourceBills((String)"ar_invoice", (Long[])new Long[]{invoice.getLong("id")});
        if (sourceBillIds == null) {
            return;
        }
        HashSet srcIds = (HashSet)sourceBillIds.get("ar_finarbill");
        if (srcIds == null) {
            return;
        }
        Iterator iterator = srcIds.iterator();
        while (iterator.hasNext()) {
            Long srcId = (Long)iterator.next();
            if (!sBillIds.contains(srcId)) continue;
            iterator.remove();
        }
        if (srcIds.size() <= 0) {
            return;
        }
        DynamicObject[] sourceBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"id,invoicedamt,uninvoicedamt,entry.e_invoicedamt,entry.e_uninvoicedamt", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)srcIds)});
        this.reverseSourceAmt(invoice, sourceBills);
    }

    private void reverseSourceAmt(DynamicObject invoice, DynamicObject[] sourceBills) {
        BigDecimal restofAmt = invoice.getBigDecimal("recamount");
        for (DynamicObject sourceBill : sourceBills) {
            BigDecimal billDisposeAmt = BigDecimal.ZERO;
            DynamicObjectCollection entry = sourceBill.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                BigDecimal invoicedAmt = row.getBigDecimal("e_invoicedamt");
                BigDecimal entryRowDisposeAmt = BigDecimal.ZERO;
                entryRowDisposeAmt = restofAmt.compareTo(invoicedAmt) >= 0 ? invoicedAmt : restofAmt;
                row.set("e_uninvoicedamt", (Object)row.getBigDecimal("e_uninvoicedamt").add(entryRowDisposeAmt));
                row.set("e_invoicedamt", (Object)row.getBigDecimal("e_invoicedamt").subtract(entryRowDisposeAmt));
                billDisposeAmt = billDisposeAmt.add(entryRowDisposeAmt);
                restofAmt = restofAmt.subtract(entryRowDisposeAmt);
            }
            sourceBill.set("uninvoicedamt", (Object)sourceBill.getBigDecimal("uninvoicedamt").add(billDisposeAmt));
            sourceBill.set("invoicedamt", (Object)sourceBill.getBigDecimal("invoicedamt").subtract(billDisposeAmt));
        }
        SaveServiceHelper.save((DynamicObject[])sourceBills);
        invoice.set("associatedamt", (Object)BigDecimal.ZERO);
        DynamicObjectCollection invoiceEntry = invoice.getDynamicObjectCollection("entry");
        for (DynamicObject row : invoiceEntry) {
            row.set("e_associatedamt", (Object)BigDecimal.ZERO);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoice});
    }
}

