/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.fin;

import java.math.BigDecimal;
import java.util.ListIterator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.arapcommon.service.fin.EntryDisposer;

public abstract class OrdinalEntryDisposerTemplate
implements EntryDisposer {
    @Override
    public void saveDispose(DynamicObject finBill, BigDecimal disposeAmount) {
        DynamicObjectCollection disposeEntry = this.getDisposeEntry(finBill);
        String unlockAmountKey = this.getEntryUnlockAmountKey();
        String lockedAmountKey = this.getEntryLockedAmountKey();
        boolean isSameDirection = true;
        if (disposeEntry.size() > 0) {
            BigDecimal rowUnlockAmount = ((DynamicObject)disposeEntry.get(0)).getBigDecimal(unlockAmountKey);
            BigDecimal rowLockedAmount = ((DynamicObject)disposeEntry.get(0)).getBigDecimal(lockedAmountKey);
            if (rowUnlockAmount.compareTo(BigDecimal.ZERO) < 0 || rowLockedAmount.compareTo(BigDecimal.ZERO) < 0) {
                isSameDirection = disposeAmount.compareTo(BigDecimal.ZERO) < 0;
            } else {
                boolean bl = isSameDirection = disposeAmount.compareTo(BigDecimal.ZERO) > 0;
            }
        }
        if (isSameDirection) {
            for (DynamicObject row : disposeEntry) {
                BigDecimal rowUnlockAmount = row.getBigDecimal(unlockAmountKey);
                BigDecimal rowDisposeAmount = rowUnlockAmount;
                if (rowDisposeAmount.abs().compareTo(disposeAmount.abs()) > 0) {
                    rowDisposeAmount = disposeAmount;
                }
                this.increaseAmount(row, this.getEntryLockedAmountKey(), rowDisposeAmount);
                this.reduceAmount(row, this.getEntryUnlockAmountKey(), rowDisposeAmount);
                if ((disposeAmount = disposeAmount.subtract(rowDisposeAmount)).compareTo(BigDecimal.ZERO) != 0) continue;
                break;
            }
        } else {
            this.deleteDispose(finBill, disposeAmount.negate());
        }
    }

    @Override
    public void deleteDispose(DynamicObject finBill, BigDecimal disposeAmount) {
        DynamicObjectCollection disposeEntry = this.getDisposeEntry(finBill);
        String lockedAmountKey = this.getEntryLockedAmountKey();
        ListIterator entryIterator = disposeEntry.listIterator(disposeEntry.size());
        while (entryIterator.hasPrevious()) {
            BigDecimal rowLockedAmount;
            DynamicObject row = (DynamicObject)entryIterator.previous();
            BigDecimal rowDisposeAmount = rowLockedAmount = row.getBigDecimal(lockedAmountKey);
            if (rowLockedAmount.multiply(disposeAmount).compareTo(BigDecimal.ZERO) <= 0) continue;
            if (rowLockedAmount.abs().compareTo(disposeAmount.abs()) > 0) {
                rowDisposeAmount = disposeAmount;
            }
            this.increaseAmount(row, this.getEntryUnlockAmountKey(), rowDisposeAmount);
            this.reduceAmount(row, this.getEntryLockedAmountKey(), rowDisposeAmount);
            if ((disposeAmount = disposeAmount.subtract(rowDisposeAmount)).compareTo(BigDecimal.ZERO) != 0) continue;
            break;
        }
    }

    protected void increaseAmount(DynamicObject row, String amountKey, BigDecimal amount) {
        BigDecimal originalAmount = row.getBigDecimal(amountKey);
        BigDecimal result = originalAmount.add(amount);
        row.set(amountKey, (Object)result);
    }

    protected void reduceAmount(DynamicObject row, String amountKey, BigDecimal amount) {
        BigDecimal originalAmount = row.getBigDecimal(amountKey);
        BigDecimal result = originalAmount.subtract(amount);
        row.set(amountKey, (Object)result);
    }

    protected abstract DynamicObjectCollection getDisposeEntry(DynamicObject var1);

    protected abstract String getEntryUnlockAmountKey();

    protected abstract String getEntryLockedAmountKey();
}

