/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.fin;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.arapcommon.service.fin.ProportionateEntryDisposerTemplate;

public class PlanEntryProportDisposer
extends ProportionateEntryDisposerTemplate {
    @Override
    protected BigDecimal getBillUnlockAmount(DynamicObject finBill) {
        DynamicObjectCollection planEntry = finBill.getDynamicObjectCollection("planentity");
        BigDecimal billUnlockAmount = BigDecimal.ZERO;
        for (DynamicObject row : planEntry) {
            BigDecimal rowUnlockAmount = row.getBigDecimal(this.getEntryUnlockAmountKey());
            billUnlockAmount = billUnlockAmount.add(rowUnlockAmount);
        }
        return billUnlockAmount;
    }

    @Override
    protected BigDecimal getBillLockedAmount(DynamicObject finBill) {
        DynamicObjectCollection planEntry = finBill.getDynamicObjectCollection("planentity");
        BigDecimal billLockedAmount = BigDecimal.ZERO;
        for (DynamicObject row : planEntry) {
            BigDecimal rowLockedAmount = row.getBigDecimal(this.getEntryLockedAmountKey());
            billLockedAmount = billLockedAmount.add(rowLockedAmount);
        }
        return billLockedAmount;
    }

    @Override
    protected BigDecimal getBillAmount(DynamicObject finBill) {
        String billEntity = finBill.getDataEntityType().getName();
        if (billEntity.startsWith("ap_")) {
            return finBill.getBigDecimal("pricetaxtotal");
        }
        return finBill.getBigDecimal("recamount");
    }

    @Override
    protected DynamicObjectCollection getDisposeEntry(DynamicObject finBill) {
        return finBill.getDynamicObjectCollection("planentity");
    }

    @Override
    protected BigDecimal getEntryAmount(DynamicObject row) {
        return row.getBigDecimal("planpricetax");
    }

    @Override
    protected String getEntryUnlockAmountKey() {
        return "unplanlockamt";
    }

    @Override
    protected String getEntryLockedAmountKey() {
        return "planlockedamt";
    }

    @Override
    protected int getPrecision(DynamicObject finBill) {
        return finBill.getInt("currency.amtprecision");
    }
}

