/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.freeze;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.api.freeze.FinApBillFreezeService;
import kd.fi.arapcommon.api.freeze.IFreezeService;
import kd.fi.arapcommon.api.param.FreezeParam;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.util.StdConfig;

public abstract class AbstractFinApPrePayFreezeService {
    protected IFreezeService freezeService = new FinApBillFreezeService();
    protected Map<Long, Integer> settleModelMap = new HashMap<Long, Integer>(16);
    protected Map<Long, Long> supplierMasterIds = new HashMap<Long, Long>(16);
    protected static final Log logger = LogFactory.getLog(AbstractFinApPrePayFreezeService.class);

    public void freeze(Set<Long> ids, boolean freeze) {
        String ignorePreTransit = StdConfig.get("ignorepretransit");
        if ("true".equals(ignorePreTransit)) {
            logger.info("ignorepretransit\uff1a" + ignorePreTransit);
            return;
        }
        Map<Long, Set<Long>> needFreezeBillToCoreBillIdMap = this.findNeedFreezeBill(ids, freeze);
        Map<Long, Set<Long>> finBlllIdToEntryIds = this.queryFinBillNeedFreezeEntry(needFreezeBillToCoreBillIdMap, freeze);
        Map<Long, Set<Long>> canFreezeBills = this.filterCanFreezeData(finBlllIdToEntryIds, freeze);
        List<FreezeParam> billParams = this.buildFreezeParams(canFreezeBills, freeze);
        this.freezeService.freeze(billParams, freeze);
    }

    protected abstract Map<Long, Set<Long>> findNeedFreezeBill(Set<Long> var1, boolean var2);

    public Map<Long, BigDecimal> queryHadPrePayInTranSit(Set<Long> purOrderBillIds, Set<Long> conBillIds, Set<Long> scpoBillIds, Set<Long> pmomBillIds, boolean freeze) {
        BigDecimal purPerAmt;
        QFilter filter;
        HashMap<Long, BigDecimal> coreBillPrePayAmt = new HashMap<Long, BigDecimal>(16);
        if (purOrderBillIds != null && purOrderBillIds.size() > 0) {
            filter = new QFilter("id", "in", purOrderBillIds);
            filter.and("isallowoverpay", "=", (Object)Boolean.FALSE);
            filter.and(new QFilter("purbillentry_pay.payamount", ">", (Object)BigDecimal.ZERO));
            filter.and(new QFilter("purbillentry_pay.isprepay", "=", (Object)Boolean.TRUE));
            DataSet purDataSet = QueryServiceHelper.queryDataSet((String)"finapfreeze", (String)"pm_purorderbill", (String)"id,isallowoverpay,purbillentry_pay.payamount", (QFilter[])new QFilter[]{filter}, null);
            for (Row row : purDataSet) {
                Long purBillId = row.getLong("id");
                purPerAmt = (BigDecimal)coreBillPrePayAmt.get(purBillId);
                if (purPerAmt == null) {
                    coreBillPrePayAmt.put(purBillId, row.getBigDecimal("purbillentry_pay.payamount"));
                    continue;
                }
                coreBillPrePayAmt.put(purBillId, purPerAmt.add(row.getBigDecimal("purbillentry_pay.payamount")));
            }
        }
        if (conBillIds != null && conBillIds.size() > 0) {
            filter = new QFilter("id", "in", conBillIds);
            filter.and("isallowoverpay", "=", (Object)Boolean.FALSE);
            filter.and(new QFilter("payentry.payamount", ">", (Object)BigDecimal.ZERO));
            filter.and(new QFilter("payentry.isprepay", "=", (Object)Boolean.TRUE));
            DataSet conDataSet = QueryServiceHelper.queryDataSet((String)"finapfreeze", (String)"conm_purcontract", (String)"id,payentry.payamount", (QFilter[])new QFilter[]{filter}, null);
            for (Row row : conDataSet) {
                Long conBillId = row.getLong("id");
                purPerAmt = (BigDecimal)coreBillPrePayAmt.get(conBillId);
                if (purPerAmt == null) {
                    coreBillPrePayAmt.put(conBillId, row.getBigDecimal("payentry.payamount"));
                    continue;
                }
                coreBillPrePayAmt.put(conBillId, purPerAmt.add(row.getBigDecimal("payentry.payamount")));
            }
        }
        if (scpoBillIds != null && scpoBillIds.size() > 0) {
            filter = new QFilter("id", "in", scpoBillIds);
            filter.and("isallowoverpay", "=", (Object)Boolean.FALSE);
            filter.and(new QFilter("billentry_pay.payamount", ">", (Object)BigDecimal.ZERO));
            filter.and(new QFilter("billentry_pay.isprepay", "=", (Object)Boolean.TRUE));
            DataSet scpoDataSet = QueryServiceHelper.queryDataSet((String)"finapfreeze", (String)"sctm_scpo", (String)"id,billentry_pay.payamount", (QFilter[])new QFilter[]{filter}, null);
            for (Row row : scpoDataSet) {
                Long scpoBillId = row.getLong("id");
                purPerAmt = (BigDecimal)coreBillPrePayAmt.get(scpoBillId);
                if (purPerAmt == null) {
                    coreBillPrePayAmt.put(scpoBillId, row.getBigDecimal("billentry_pay.payamount"));
                    continue;
                }
                coreBillPrePayAmt.put(scpoBillId, purPerAmt.add(row.getBigDecimal("billentry_pay.payamount")));
            }
        }
        if (pmomBillIds != null && pmomBillIds.size() > 0) {
            filter = new QFilter("id", "in", pmomBillIds);
            filter.and("isallowoverpay", "=", (Object)Boolean.FALSE);
            filter.and(new QFilter("purbillentry_pay.payamount", ">", (Object)BigDecimal.ZERO));
            filter.and(new QFilter("purbillentry_pay.isprepay", "=", (Object)Boolean.TRUE));
            DataSet pmomDataSet = QueryServiceHelper.queryDataSet((String)"finapfreeze", (String)"pm_om_purorderbill", (String)"id,purbillentry_pay.payamount", (QFilter[])new QFilter[]{filter}, null);
            for (Row row : pmomDataSet) {
                Long pmomBillId = row.getLong("id");
                purPerAmt = (BigDecimal)coreBillPrePayAmt.get(pmomBillId);
                if (purPerAmt == null) {
                    coreBillPrePayAmt.put(pmomBillId, row.getBigDecimal("purbillentry_pay.payamount"));
                    continue;
                }
                coreBillPrePayAmt.put(pmomBillId, purPerAmt.add(row.getBigDecimal("purbillentry_pay.payamount")));
            }
        }
        return coreBillPrePayAmt;
    }

    public Map<Long, String> getCoreBillMatchKey(Set<Long> purOrderBillIds, Set<Long> conBillIds, Set<Long> scpoBillIds, Set<Long> pmomBillIds) {
        DynamicObject supplier;
        Long masterId;
        Long supplierId;
        Long billId;
        DataSet hadPrePurDataSet;
        HashMap<Long, String> coreBillMapKey = new HashMap<Long, String>(16);
        if (purOrderBillIds.size() > 0) {
            hadPrePurDataSet = QueryServiceHelper.queryDataSet((String)"finapfreeze", (String)"pm_purorderbill", (String)"id,invoicesupplier,billentry.entrysettleorg", (QFilter[])new QFilter[]{new QFilter("id", "in", purOrderBillIds)}, null);
            for (Row row : hadPrePurDataSet) {
                billId = row.getLong("id");
                supplierId = row.getLong("invoicesupplier");
                masterId = this.supplierMasterIds.get(supplierId);
                if (masterId == null) {
                    supplier = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_supplier", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)supplierId)});
                    if (supplier == null) continue;
                    masterId = supplier.getLong("masterid");
                    this.supplierMasterIds.put(supplier.getLong("id"), masterId);
                }
                if (coreBillMapKey.get(billId) != null) continue;
                coreBillMapKey.put(billId, billId + "_" + row.getLong("billentry.entrysettleorg") + "_" + masterId);
            }
        }
        if (conBillIds.size() > 0) {
            hadPrePurDataSet = QueryServiceHelper.queryDataSet((String)"finapfreeze", (String)"conm_purcontract", (String)"id,invoicesupplier,billentry.entrysettleorg", (QFilter[])new QFilter[]{new QFilter("id", "in", conBillIds)}, null);
            for (Row row : hadPrePurDataSet) {
                billId = row.getLong("id");
                supplierId = row.getLong("invoicesupplier");
                masterId = this.supplierMasterIds.get(supplierId);
                if (masterId == null) {
                    supplier = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_supplier", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)supplierId)});
                    if (supplier == null) continue;
                    masterId = supplier.getLong("masterid");
                    this.supplierMasterIds.put(supplier.getLong("id"), masterId);
                }
                if (coreBillMapKey.get(billId) != null) continue;
                coreBillMapKey.put(billId, billId + "_" + row.getLong("billentry.entrysettleorg") + "_" + masterId);
            }
        }
        if (scpoBillIds.size() > 0) {
            hadPrePurDataSet = QueryServiceHelper.queryDataSet((String)"finapfreeze", (String)"sctm_scpo", (String)"id,invoicesupplier,billentry.entrysettleorg", (QFilter[])new QFilter[]{new QFilter("id", "in", scpoBillIds)}, null);
            for (Row row : hadPrePurDataSet) {
                billId = row.getLong("id");
                supplierId = row.getLong("invoicesupplier");
                masterId = this.supplierMasterIds.get(supplierId);
                if (masterId == null) {
                    supplier = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_supplier", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)supplierId)});
                    if (supplier == null) continue;
                    masterId = supplier.getLong("masterid");
                    this.supplierMasterIds.put(supplier.getLong("id"), masterId);
                }
                if (coreBillMapKey.get(billId) != null) continue;
                coreBillMapKey.put(billId, billId + "_" + row.getLong("billentry.entrysettleorg") + "_" + masterId);
            }
        }
        if (pmomBillIds.size() > 0) {
            hadPrePurDataSet = QueryServiceHelper.queryDataSet((String)"finapfreeze", (String)"pm_om_purorderbill", (String)"id,invoicesupplier,billentry.entrysettleorg", (QFilter[])new QFilter[]{new QFilter("id", "in", pmomBillIds)}, null);
            for (Row row : hadPrePurDataSet) {
                billId = row.getLong("id");
                supplierId = row.getLong("invoicesupplier");
                masterId = this.supplierMasterIds.get(supplierId);
                if (masterId == null) {
                    supplier = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_supplier", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)supplierId)});
                    if (supplier == null) continue;
                    masterId = supplier.getLong("masterid");
                    this.supplierMasterIds.put(supplier.getLong("id"), masterId);
                }
                if (coreBillMapKey.get(billId) != null) continue;
                coreBillMapKey.put(billId, billId + "_" + row.getLong("billentry.entrysettleorg") + "_" + masterId);
            }
        }
        return coreBillMapKey;
    }

    public Map<Long, BigDecimal> queryPrePayBillByCoreBillId(Set<Long> coreBillIds) {
        HashMap<Long, BigDecimal> hadPayPreAmt = new HashMap<Long, BigDecimal>(16);
        QFilter payBillFilter = new QFilter("entry.e_corebillid", "in", coreBillIds);
        payBillFilter.and("billstatus", "in", (Object)new String[]{"D", "F", "I"});
        payBillFilter.and("paymenttype.biztype", "=", (Object)"202");
        DataSet prePayBills = QueryServiceHelper.queryDataSet((String)"finapfreezepay", (String)"cas_paybill", (String)"entry.e_corebillid,entry.e_payableamt,entry.e_refundamt", (QFilter[])new QFilter[]{payBillFilter}, null);
        for (Row row : prePayBills) {
            Long coreBillId = row.getLong("entry.e_corebillid");
            BigDecimal currentPayAmt = row.getBigDecimal("entry.e_payableamt").subtract(row.getBigDecimal("entry.e_refundamt"));
            BigDecimal coreBillSumPrePayAmt = (BigDecimal)hadPayPreAmt.get(coreBillId);
            if (coreBillSumPrePayAmt == null) {
                hadPayPreAmt.put(coreBillId, currentPayAmt);
                continue;
            }
            hadPayPreAmt.put(coreBillId, coreBillSumPrePayAmt.add(currentPayAmt));
        }
        return hadPayPreAmt;
    }

    public Map<Long, Set<Long>> queryFinBillNeedFreezeEntry(Map<Long, Set<Long>> finIdToNeedFreezeCoreBillIds, boolean freeze) {
        Integer settleModle;
        Long orgId;
        HashMap<Long, Set<Long>> finBlllIdToPlanEntryIds = new HashMap<Long, Set<Long>>(16);
        if (finIdToNeedFreezeCoreBillIds.size() == 0) {
            return finBlllIdToPlanEntryIds;
        }
        logger.info("needfreebillid_corebillids:" + finIdToNeedFreezeCoreBillIds.toString());
        Set<Long> finApBillIds = finIdToNeedFreezeCoreBillIds.keySet();
        HashMap<Long, Long> finOrgMap = new HashMap<Long, Long>(16);
        HashSet<Long> curCoreBillIds = new HashSet<Long>(16);
        DataSet finDataSet = QueryServiceHelper.queryDataSet((String)"finfreeze", (String)"ap_finapbill", (String)"id,asstacttype,asstact.id,billno,org.id,planentity.id,planentity.plancorebillid,planentity.seq,planentity.planpricetax,planentity.plansettledamt", (QFilter[])new QFilter[]{new QFilter("id", "in", finApBillIds), new QFilter("billstatus", "=", (Object)"C")}, null);
        for (Row row : finDataSet) {
            Set<Long> coreBillIds;
            Long billId = row.getLong("id");
            BigDecimal planpricetax = row.getBigDecimal("planentity.planpricetax");
            BigDecimal plansettledamt = row.getBigDecimal("planentity.plansettledamt");
            finOrgMap.put(billId, row.getLong("org.id"));
            if (planpricetax.compareTo(BigDecimal.ZERO) < 0 || freeze && plansettledamt.compareTo(planpricetax) == 0 || (coreBillIds = finIdToNeedFreezeCoreBillIds.get(billId)) == null) continue;
            curCoreBillIds.addAll(coreBillIds);
            Long planCoreBillId = row.getLong("planentity.plancorebillid");
            if (planCoreBillId == 0L) {
                finBlllIdToPlanEntryIds.put(billId, new HashSet(2));
            }
            if (!coreBillIds.contains(planCoreBillId)) continue;
            HashSet<Long> entryIds = (HashSet<Long>)finBlllIdToPlanEntryIds.get(billId);
            if (entryIds == null) {
                entryIds = new HashSet<Long>(16);
                entryIds.add(row.getLong("planentity.id"));
                finBlllIdToPlanEntryIds.put(billId, entryIds);
                continue;
            }
            entryIds.add(row.getLong("planentity.id"));
        }
        HashSet<Long> materialSettleBillIds = new HashSet<Long>(16);
        Iterator iterator = finBlllIdToPlanEntryIds.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entrySet = iterator.next();
            Long billId = (Long)entrySet.getKey();
            orgId = (Long)finOrgMap.get(billId);
            settleModle = this.settleModelMap.get(orgId);
            if (settleModle == null) {
                settleModle = ArApHelper.getApSettleParam(orgId);
                this.settleModelMap.put(orgId, settleModle);
            }
            if (settleModle == 1) {
                materialSettleBillIds.add(billId);
                ((Set)entrySet.getValue()).clear();
                continue;
            }
            if (((Set)entrySet.getValue()).size() != 0) continue;
            iterator.remove();
        }
        for (Long id : finApBillIds) {
            orgId = (Long)finOrgMap.get(id);
            if (orgId == null) continue;
            settleModle = this.settleModelMap.get(orgId);
            if (settleModle == null) {
                settleModle = ArApHelper.getApSettleParam(orgId);
                this.settleModelMap.put(orgId, settleModle);
            }
            if (settleModle != 1) continue;
            materialSettleBillIds.add(id);
            finBlllIdToPlanEntryIds.put(id, new HashSet(2));
        }
        if (!freeze && materialSettleBillIds.size() > 0) {
            HashSet<Long> purOrderBillIds = new HashSet<Long>(16);
            HashSet<Long> conBillIds = new HashSet<Long>(16);
            HashSet<Long> scpoBillIds = new HashSet<Long>(16);
            HashSet<Long> pmomBillIds = new HashSet<Long>(16);
            HashSet<Long> otherCoreBillIds = new HashSet<Long>(16);
            DynamicObjectCollection finApBills = QueryServiceHelper.query((String)"ap_finapbill", (String)"id,org.id,asstact.id,detailentry.corebillid,detailentry.e_conbillid,detailentry.e_pricetaxtotal,detailentry.corebilltype", (QFilter[])new QFilter[]{new QFilter("id", "in", materialSettleBillIds)});
            for (DynamicObject bill : finApBills) {
                BigDecimal pricetaxtotal;
                String coreBillType = bill.getString("detailentry.corebilltype");
                Long coreBillId = bill.getLong("detailentry.corebillid");
                Long conBillId = bill.getLong("detailentry.e_conbillid");
                if (coreBillId == 0L || (pricetaxtotal = bill.getBigDecimal("detailentry.e_pricetaxtotal")).compareTo(BigDecimal.ZERO) < 0) continue;
                if ("pm_purorderbill".equals(coreBillType)) {
                    if (!curCoreBillIds.contains(coreBillId)) {
                        purOrderBillIds.add(coreBillId);
                        otherCoreBillIds.add(coreBillId);
                    }
                    if (conBillId == 0L || curCoreBillIds.contains(conBillId)) continue;
                    conBillIds.add(conBillId);
                    otherCoreBillIds.add(conBillId);
                    continue;
                }
                if (curCoreBillIds.contains(coreBillId)) continue;
                otherCoreBillIds.add(coreBillId);
                if ("conm_purcontract".equals(coreBillType)) {
                    conBillIds.add(coreBillId);
                    continue;
                }
                if ("sctm_scpo".equals(coreBillType)) {
                    scpoBillIds.add(coreBillId);
                    continue;
                }
                if (!"pm_om_purorderbill".equals(coreBillType)) continue;
                pmomBillIds.add(coreBillId);
            }
            HashSet<Long> hadPreInTransitBillIds = new HashSet<Long>(16);
            Map<Long, BigDecimal> corePremAmtMap = this.queryHadPrePayInTranSit(purOrderBillIds, conBillIds, scpoBillIds, pmomBillIds, freeze);
            Map<Long, String> coreBillMatchKeys = this.getCoreBillMatchKey(purOrderBillIds, conBillIds, scpoBillIds, pmomBillIds);
            Map<Long, BigDecimal> prePayBillAmtMap = this.queryPrePayBillByCoreBillId(otherCoreBillIds);
            for (DynamicObject bill : finApBills) {
                BigDecimal corePreHadPayAmt;
                String matchKey;
                Long id = bill.getLong("id");
                if (hadPreInTransitBillIds.contains(id)) continue;
                String coreBillType = bill.getString("detailentry.corebilltype");
                Long coreBillId = bill.getLong("detailentry.corebillid");
                if (coreBillId == 0L) continue;
                Long conBillId = bill.getLong("detailentry.e_conbillid");
                Long orgId2 = bill.getLong("org.id");
                Long asstactId = bill.getLong("asstact.id");
                Long masterId = this.supplierMasterIds.get(asstactId);
                if (masterId == null) {
                    DynamicObject supplier = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_supplier", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)asstactId)});
                    if (supplier == null) continue;
                    masterId = supplier.getLong("masterid");
                    this.supplierMasterIds.put(supplier.getLong("id"), masterId);
                }
                if (!(matchKey = coreBillId + "_" + orgId2 + "_" + masterId).equals(coreBillMatchKeys.get(coreBillId))) continue;
                BigDecimal coreBillPreAmt = corePremAmtMap.get(coreBillId);
                BigDecimal conBillPreAmt = corePremAmtMap.get(conBillId);
                if (coreBillPreAmt == null && conBillPreAmt == null || (corePreHadPayAmt = prePayBillAmtMap.get(coreBillId)) != null && corePreHadPayAmt.compareTo(coreBillPreAmt) >= 0) continue;
                if ("pm_purorderbill".equals(coreBillType)) {
                    if (conBillId == 0L) {
                        hadPreInTransitBillIds.add(id);
                        continue;
                    }
                    BigDecimal conSumPreAmt = prePayBillAmtMap.get(conBillId);
                    if (conBillPreAmt != null && conSumPreAmt != null && conSumPreAmt.compareTo(conBillPreAmt) >= 0) continue;
                    hadPreInTransitBillIds.add(id);
                    continue;
                }
                hadPreInTransitBillIds.add(id);
            }
            for (Long billId : hadPreInTransitBillIds) {
                finBlllIdToPlanEntryIds.remove(billId);
            }
        }
        return finBlllIdToPlanEntryIds;
    }

    public Map<Long, Set<Long>> filterCanFreezeData(Map<Long, Set<Long>> finBillIdToPlanEntryIds, boolean freeze) {
        HashSet<Long> canFreezeEntryIds;
        Set<Long> entryIds;
        Long billId;
        HashMap<Long, Set<Long>> canFreezeBill = new HashMap<Long, Set<Long>>(16);
        if (finBillIdToPlanEntryIds.size() == 0) {
            return canFreezeBill;
        }
        logger.info("freebillid_freebillentryids" + finBillIdToPlanEntryIds.toString());
        HashSet<Long> billIds = new HashSet<Long>(16);
        HashSet<Long> billEntryIds = new HashSet<Long>(16);
        HashSet<String> billIdStrs = new HashSet<String>(16);
        HashSet billEntryIdStrs = new HashSet(16);
        for (Map.Entry<Long, Set<Long>> entrySet : finBillIdToPlanEntryIds.entrySet()) {
            Set<Long> entryIds2 = entrySet.getValue();
            if (entryIds2.size() == 0) {
                Long billId2 = entrySet.getKey();
                billIds.add(billId2);
                billIdStrs.add(String.valueOf(billId2));
                continue;
            }
            billEntryIds.addAll(entryIds2);
            billEntryIdStrs.addAll(entryIds2.stream().map(String::valueOf).collect(Collectors.toSet()));
        }
        HashMap<Long, Boolean> billFreezeStatus = new HashMap<Long, Boolean>(16);
        HashMap<Long, Boolean> entryFreezeStatus = new HashMap<Long, Boolean>(16);
        DynamicObjectCollection materialSettleBill = QueryServiceHelper.query((String)"ap_finapbill", (String)"id,freezestate", (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
        for (Object bill : materialSettleBill) {
            if ("unfreeze".equals(bill.getString("freezestate"))) {
                billFreezeStatus.put(bill.getLong("id"), Boolean.FALSE);
                continue;
            }
            billFreezeStatus.put(bill.getLong("id"), Boolean.TRUE);
        }
        DynamicObjectCollection planSettleBill = QueryServiceHelper.query((String)"ap_finapbill", (String)"id,planentity.id,planentity.e_freezestate", (QFilter[])new QFilter[]{new QFilter("planentity.id", "in", billEntryIds)});
        for (DynamicObject bill : planSettleBill) {
            if ("unfreeze".equals(bill.getString("planentity.e_freezestate"))) {
                entryFreezeStatus.put(bill.getLong("planentity.id"), Boolean.FALSE);
                continue;
            }
            entryFreezeStatus.put(bill.getLong("planentity.id"), Boolean.TRUE);
        }
        HashMap<Long, Tuple> billLastFreezeLogs = new HashMap<Long, Tuple>(16);
        HashMap<Long, Tuple> entryLastFreezeLogs = new HashMap<Long, Tuple>(16);
        DynamicObjectCollection materialSettleBillFreezeLogs = QueryServiceHelper.query((String)"ap_freezelog", (String)"billid,optype,businessop", (QFilter[])new QFilter[]{new QFilter("billid", "in", billIdStrs)}, (String)"billid,optime desc");
        for (DynamicObject log : materialSettleBillFreezeLogs) {
            Long billId3 = Long.valueOf(log.getString("billid"));
            if (billLastFreezeLogs.get(billId3) != null) continue;
            String opType = log.getString("optype");
            String businessOp = log.getString("businessop");
            billLastFreezeLogs.put(billId3, Tuple.create((Object)businessOp, (Object)opType));
        }
        DynamicObjectCollection planSettleBillFreezeLogs = QueryServiceHelper.query((String)"ap_freezelog", (String)"billid,billentryid,optype,businessop", (QFilter[])new QFilter[]{new QFilter("billentryid", "in", billEntryIdStrs)}, (String)"billentryid,optime desc");
        for (DynamicObject log : planSettleBillFreezeLogs) {
            Long billEntryId = Long.valueOf(log.getString("billentryid"));
            if (entryLastFreezeLogs.get(billEntryId) != null) continue;
            String opType = log.getString("optype");
            String businessOp = log.getString("businessop");
            entryLastFreezeLogs.put(billEntryId, Tuple.create((Object)businessOp, (Object)opType));
        }
        if (freeze) {
            for (Map.Entry<Long, Set<Long>> entrySet : finBillIdToPlanEntryIds.entrySet()) {
                billId = entrySet.getKey();
                entryIds = entrySet.getValue();
                canFreezeEntryIds = new HashSet<Long>(16);
                if (entryIds.size() == 0) {
                    Boolean freezeState = (Boolean)billFreezeStatus.get(billId);
                    if (freezeState.booleanValue()) continue;
                    canFreezeBill.put(billId, new HashSet(2));
                    continue;
                }
                for (Long entryId : entryIds) {
                    Boolean entryFreezeState = (Boolean)entryFreezeStatus.get(entryId);
                    if (entryFreezeState.booleanValue()) continue;
                    canFreezeEntryIds.add(entryId);
                }
                if (canFreezeEntryIds.size() == 0) continue;
                canFreezeBill.put(billId, canFreezeEntryIds);
            }
        } else {
            for (Map.Entry<Long, Set<Long>> entrySet : finBillIdToPlanEntryIds.entrySet()) {
                billId = entrySet.getKey();
                entryIds = entrySet.getValue();
                canFreezeEntryIds = new HashSet(16);
                if (entryIds.size() == 0) {
                    Tuple freezeLogTuple;
                    Boolean freezeState = (Boolean)billFreezeStatus.get(billId);
                    if (!freezeState.booleanValue() || (freezeLogTuple = (Tuple)billLastFreezeLogs.get(billId)) != null && (!"allfreeze".equals(freezeLogTuple.item1) || !"auto".equals(freezeLogTuple.item2))) continue;
                    canFreezeBill.put(billId, new HashSet(2));
                    continue;
                }
                for (Long entryId : entryIds) {
                    Tuple freezeLogTuple;
                    Boolean entryFreezeState = (Boolean)entryFreezeStatus.get(entryId);
                    if (!entryFreezeState.booleanValue() || (freezeLogTuple = (Tuple)entryLastFreezeLogs.get(entryId)) == null || !"allfreeze".equals(freezeLogTuple.item1) || !"auto".equals(freezeLogTuple.item2)) continue;
                    canFreezeEntryIds.add(entryId);
                }
                if (canFreezeEntryIds.size() == 0) continue;
                canFreezeBill.put(billId, canFreezeEntryIds);
            }
        }
        return canFreezeBill;
    }

    public List<FreezeParam> buildFreezeParams(Map<Long, Set<Long>> canFreezeBills, boolean freeze) {
        ArrayList<FreezeParam> params = new ArrayList<FreezeParam>(16);
        if (canFreezeBills.size() == 0) {
            return params;
        }
        logger.info("canfreezebills" + canFreezeBills.toString());
        String freezeReason = freeze ? ResManager.loadKDString((String)"\u91c7\u8d2d\u4e1a\u52a1\u5b58\u5728\u5728\u9014\u9884\u4ed8\uff0c\u81ea\u52a8\u51bb\u7ed3\u3002", (String)"AbstractFinApPrePayFreezeService_0", (String)"fi-arapcommon", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u91c7\u8d2d\u4e1a\u52a1\u6309\u5c65\u7ea6\u652f\u4ed8\u4e3a\u201c\u5426\u201d\u4e14\u5df2\u5168\u90e8\u9884\u4ed8\uff0c\u6216\u91c7\u8d2d\u4e1a\u52a1\u6309\u5c65\u7ea6\u652f\u4ed8\u4e3a\u201c\u662f\u201d\uff0c\u81ea\u52a8\u89e3\u51bb\u3002", (String)"AbstractFinApPrePayFreezeService_1", (String)"fi-arapcommon", (Object[])new Object[0]);
        for (Map.Entry<Long, Set<Long>> entrySet : canFreezeBills.entrySet()) {
            Long finApBillId = entrySet.getKey();
            Set<Long> entryIds = entrySet.getValue();
            FreezeParam param = new FreezeParam();
            param.setBillId(finApBillId);
            param.setFreezeReason(freezeReason);
            param.setOpType("auto");
            if (entryIds.size() != 0) {
                param.setEntryFreeze(true);
                param.setEntryIds(entryIds);
            }
            params.add(param);
        }
        return params;
    }
}

