/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.freeze;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.service.freeze.AbstractFinApPrePayFreezeService;

public class ConfirmPayFreezeService
extends AbstractFinApPrePayFreezeService {
    @Override
    protected Map<Long, Set<Long>> findNeedFreezeBill(Set<Long> ids, boolean freeze) {
        Map<String, Set<Long>> coreBillMap = this.getFreezeCoreBillIds(ids, freeze);
        return this.findNeedFreezeBillIdByCoreBill(coreBillMap, freeze);
    }

    public Map<String, Set<Long>> getFreezeCoreBillIds(Set<Long> ids, boolean freeze) {
        HashMap<String, HashSet<Long>> hadPrePayCoreBillMap = new HashMap<String, HashSet<Long>>(16);
        HashMap<String, Set<Long>> hadFinishPayPreBillMap = new HashMap<String, Set<Long>>(16);
        HashMap<Long, BigDecimal> coreBillSumPrePayMap = new HashMap<Long, BigDecimal>(16);
        HashSet<Long> hadPrePayAmtCoreBillIds = new HashSet<Long>(16);
        DynamicObjectCollection payBills = QueryServiceHelper.query((String)"cas_paybill", (String)"entry.e_corebillid,entry.e_corebilltype,entry.e_payableamt,entry.e_refundamt", (QFilter[])new QFilter[]{new QFilter("id", "in", ids), new QFilter("paymenttype.biztype", "=", (Object)"202")});
        for (DynamicObject bill : payBills) {
            String coreBillType;
            Long coreBillId = bill.getLong("entry.e_corebillid");
            if (coreBillId == 0L || !"pm_purorderbill".equals(coreBillType = bill.getString("entry.e_corebilltype")) && !"conm_purcontract".equals(coreBillType) && !"sctm_scpo".equals(coreBillType) && !"pm_om_purorderbill".equals(coreBillType)) continue;
            hadPrePayAmtCoreBillIds.add(coreBillId);
            HashSet<Long> coreBillIds = (HashSet<Long>)hadPrePayCoreBillMap.get(coreBillType);
            if (coreBillIds == null) {
                coreBillIds = new HashSet<Long>(16);
                coreBillIds.add(coreBillId);
                hadPrePayCoreBillMap.put(coreBillType, coreBillIds);
            } else {
                coreBillIds.add(coreBillId);
            }
            BigDecimal curBillPreAmt = bill.getBigDecimal("entry.e_payableamt").subtract(bill.getBigDecimal("entry.e_refundamt"));
            BigDecimal coreBillSumPreAmt = (BigDecimal)coreBillSumPrePayMap.get(coreBillId);
            if (coreBillSumPreAmt == null) {
                coreBillSumPrePayMap.put(coreBillId, curBillPreAmt);
                continue;
            }
            coreBillSumPrePayMap.put(coreBillId, coreBillSumPreAmt.add(curBillPreAmt));
        }
        Map<Long, BigDecimal> coreBillPrePayAmt = this.queryHadPrePayInTranSit((Set)hadPrePayCoreBillMap.get("pm_purorderbill"), (Set)hadPrePayCoreBillMap.get("conm_purcontract"), (Set)hadPrePayCoreBillMap.get("sctm_scpo"), (Set)hadPrePayCoreBillMap.get("pm_om_purorderbill"), freeze);
        QFilter payBillFilter = new QFilter("entry.e_corebillid", "in", hadPrePayAmtCoreBillIds);
        payBillFilter.and("billstatus", "in", (Object)new String[]{"D", "F", "I"});
        DataSet prePayBills = QueryServiceHelper.queryDataSet((String)"finapfreezepay", (String)"cas_paybill", (String)"id,entry.e_corebillid,entry.e_payableamt,entry.e_refundamt", (QFilter[])new QFilter[]{payBillFilter}, null);
        for (Row row : prePayBills) {
            Long payBillId = row.getLong("id");
            if (ids.contains(payBillId)) continue;
            Long coreBillId = row.getLong("entry.e_corebillid");
            BigDecimal currentPayAmt = row.getBigDecimal("entry.e_payableamt").subtract(row.getBigDecimal("entry.e_refundamt"));
            BigDecimal coreBillSumPrePayAmt = (BigDecimal)coreBillSumPrePayMap.get(coreBillId);
            if (coreBillSumPrePayAmt == null) continue;
            coreBillSumPrePayMap.put(coreBillId, coreBillSumPrePayAmt.add(currentPayAmt));
        }
        for (Map.Entry entrySet : hadPrePayCoreBillMap.entrySet()) {
            String coreBillType = (String)entrySet.getKey();
            Set coreBillIds = (Set)entrySet.getValue();
            for (Long coreBillId : coreBillIds) {
                BigDecimal coreSumPayPreAmt;
                BigDecimal corePreAmt = coreBillPrePayAmt.get(coreBillId);
                if (corePreAmt == null || (coreSumPayPreAmt = (BigDecimal)coreBillSumPrePayMap.get(coreBillId)).compareTo(corePreAmt) < 0) continue;
                HashSet<Long> hadFinishPrecoreBillIds = (HashSet<Long>)hadFinishPayPreBillMap.get(coreBillType);
                if (hadFinishPrecoreBillIds == null) {
                    hadFinishPrecoreBillIds = new HashSet<Long>(16);
                    hadFinishPrecoreBillIds.add(coreBillId);
                    hadFinishPayPreBillMap.put(coreBillType, hadFinishPrecoreBillIds);
                    continue;
                }
                hadFinishPrecoreBillIds.add(coreBillId);
            }
        }
        return hadFinishPayPreBillMap;
    }

    public Map<Long, Set<Long>> findNeedFreezeBillIdByCoreBill(Map<String, Set<Long>> coreBillIdMap, boolean freeze) {
        HashMap<Long, Set<Long>> finApFreezeInfo = new HashMap<Long, Set<Long>>(16);
        HashMap<Long, String> coreBillKeys = new HashMap<Long, String>(16);
        for (Map.Entry<String, Set<Long>> entry : coreBillIdMap.entrySet()) {
            String coreBillType = entry.getKey();
            Set<Long> coreBillIds = entry.getValue();
            DataSet coreBillDataSet = QueryServiceHelper.queryDataSet((String)"finapfreeze", (String)coreBillType, (String)"id,invoicesupplier,billentry.entrysettleorg", (QFilter[])new QFilter[]{new QFilter("id", "in", coreBillIds)}, null);
            for (Row row : coreBillDataSet) {
                Long billId = row.getLong("id");
                if (coreBillKeys.get(billId) != null) continue;
                Long asstactId = row.getLong("invoicesupplier");
                Long masterId = (Long)this.supplierMasterIds.get(asstactId);
                if (masterId == null) {
                    DynamicObject supplier = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_supplier", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)asstactId)});
                    if (supplier == null) continue;
                    masterId = supplier.getLong("masterid");
                    this.supplierMasterIds.put(supplier.getLong("id"), masterId);
                }
                coreBillKeys.put(billId, billId + "_" + row.getLong("billentry.entrysettleorg") + "_" + masterId);
            }
        }
        DataSet finApBills = QueryServiceHelper.queryDataSet((String)"apfreeze", (String)"ap_finapbill", (String)"id,org.id,asstact.id,detailentry.corebillid,detailentry.e_conbillid,detailentry.e_expensebillids_tag,detailentry.e_pricetaxtotal,detailentry.unsettleamt", (QFilter[])new QFilter[]{new QFilter("detailentry.corebillid", "in", coreBillKeys.keySet()), new QFilter("iswrittenoff", "=", (Object)Boolean.FALSE), new QFilter("hadwrittenoff", "=", (Object)Boolean.FALSE), new QFilter("billstatus", "=", (Object)"C")}, null);
        for (Row row : finApBills) {
            String matchKey;
            String expenseBillIds;
            BigDecimal pricetaxtotal = row.getBigDecimal("detailentry.e_pricetaxtotal");
            if (pricetaxtotal.compareTo(BigDecimal.ZERO) < 0 || (expenseBillIds = row.getString("detailentry.e_expensebillids_tag")) != null && !"".equals(expenseBillIds)) continue;
            Long orgId = row.getLong("org.id");
            BigDecimal unSettleAmt = row.getBigDecimal("detailentry.unsettleamt");
            Integer settleModel = (Integer)this.settleModelMap.get(orgId);
            if (settleModel == null) {
                settleModel = ArApHelper.getApSettleParam(orgId);
                this.settleModelMap.put(orgId, settleModel);
            }
            if (freeze && 1 == settleModel && unSettleAmt.compareTo(BigDecimal.ZERO) <= 0) continue;
            Long finApBillId = row.getLong("id");
            Long coreBillId = row.getLong("detailentry.corebillid");
            Long asstactId = row.getLong("asstact.id");
            Long masterId = (Long)this.supplierMasterIds.get(asstactId);
            if (masterId == null) {
                DynamicObject supplier = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_supplier", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)asstactId)});
                if (supplier == null) continue;
                masterId = supplier.getLong("masterid");
                this.supplierMasterIds.put(supplier.getLong("id"), masterId);
            }
            if (!(matchKey = coreBillId + "_" + orgId + "_" + masterId).equals(coreBillKeys.get(coreBillId))) continue;
            HashSet<Long> coreBillIds = (HashSet<Long>)finApFreezeInfo.get(finApBillId);
            if (coreBillIds == null) {
                coreBillIds = new HashSet<Long>(16);
                coreBillIds.add(coreBillId);
                finApFreezeInfo.put(finApBillId, coreBillIds);
                continue;
            }
            coreBillIds.add(coreBillId);
        }
        Set<Long> set = coreBillIdMap.get("conm_purcontract");
        if (set != null) {
            finApBills = QueryServiceHelper.queryDataSet((String)"apfreeze", (String)"ap_finapbill", (String)"id,org.id,asstact.id,detailentry.corebillid,detailentry.e_conbillid,detailentry.e_expensebillids_tag,detailentry.e_pricetaxtotal,detailentry.unsettleamt", (QFilter[])new QFilter[]{new QFilter("detailentry.e_conbillid", "in", coreBillKeys.keySet()), new QFilter("iswrittenoff", "=", (Object)Boolean.FALSE), new QFilter("hadwrittenoff", "=", (Object)Boolean.FALSE)}, null);
            for (Row row : finApBills) {
                String matchKey;
                String expenseBillIds;
                BigDecimal pricetaxtotal = row.getBigDecimal("detailentry.e_pricetaxtotal");
                if (pricetaxtotal.compareTo(BigDecimal.ZERO) < 0 || (expenseBillIds = row.getString("detailentry.e_expensebillids_tag")) != null && !"".equals(expenseBillIds)) continue;
                Long finApBillId = row.getLong("id");
                Long coreBillId = row.getLong("detailentry.corebillid");
                Long conBillId = row.getLong("detailentry.e_conbillid");
                Long orgId = row.getLong("org.id");
                BigDecimal unSettleAmt = row.getBigDecimal("detailentry.unsettleamt");
                Integer settleModel = (Integer)this.settleModelMap.get(orgId);
                if (settleModel == null) {
                    settleModel = ArApHelper.getApSettleParam(orgId);
                    this.settleModelMap.put(orgId, settleModel);
                }
                if (freeze && 1 == settleModel && unSettleAmt.compareTo(BigDecimal.ZERO) <= 0) continue;
                Long asstactId = row.getLong("asstact.id");
                Long masterId = (Long)this.supplierMasterIds.get(asstactId);
                if (masterId == null) {
                    DynamicObject supplier = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_supplier", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)asstactId)});
                    if (supplier == null) continue;
                    masterId = supplier.getLong("masterid");
                    this.supplierMasterIds.put(supplier.getLong("id"), masterId);
                }
                if (!(matchKey = conBillId + "_" + orgId + "_" + masterId).equals(coreBillKeys.get(conBillId))) continue;
                HashSet<Long> coreBillIds = (HashSet<Long>)finApFreezeInfo.get(finApBillId);
                if (coreBillIds == null) {
                    coreBillIds = new HashSet<Long>(16);
                    coreBillIds.add(coreBillId);
                    finApFreezeInfo.put(finApBillId, coreBillIds);
                    continue;
                }
                coreBillIds.add(coreBillId);
            }
        }
        return finApFreezeInfo;
    }
}

