/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.freeze;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.service.freeze.AbstractFinApPrePayFreezeService;

public class FinApAuditFreezeService
extends AbstractFinApPrePayFreezeService {
    @Override
    protected Map<Long, Set<Long>> findNeedFreezeBill(Set<Long> ids, boolean freeze) {
        DynamicObjectCollection finApBills = QueryServiceHelper.query((String)"ap_finapbill", (String)"id,org.id,asstact.id,detailentry.corebilltype,detailentry.corebillid,detailentry.e_pricetaxtotal,detailentry.e_conbillid,detailentry.unsettleamt,detailentry.e_expensebillids_tag", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        HashMap<Long, Set<Long>> finApFreezeInfo = new HashMap<Long, Set<Long>>(16);
        HashSet<Long> purOrderBillIds = new HashSet<Long>(16);
        HashSet<Long> conBillIds = new HashSet<Long>(16);
        HashSet<Long> scpoBillIds = new HashSet<Long>(16);
        HashSet<Long> pmomBillIds = new HashSet<Long>(16);
        for (DynamicObject bill : finApBills) {
            BigDecimal pricetaxtotal;
            boolean isExpenseBill;
            String expenseBillIds = bill.getString("detailentry.e_expensebillids_tag");
            boolean bl = isExpenseBill = expenseBillIds != null && !"".equals(expenseBillIds);
            if (isExpenseBill) continue;
            String coreBillType = bill.getString("detailentry.corebilltype");
            Long coreBillId = bill.getLong("detailentry.corebillid");
            if (coreBillId == 0L || (pricetaxtotal = bill.getBigDecimal("detailentry.e_pricetaxtotal")).compareTo(BigDecimal.ZERO) < 0) continue;
            if ("pm_purorderbill".equals(coreBillType)) {
                purOrderBillIds.add(coreBillId);
                Long conBillId = bill.getLong("detailentry.e_conbillid");
                if (conBillId == 0L) continue;
                conBillIds.add(conBillId);
                continue;
            }
            if ("conm_purcontract".equals(coreBillType)) {
                conBillIds.add(coreBillId);
                continue;
            }
            if ("sctm_scpo".equals(coreBillType)) {
                scpoBillIds.add(coreBillId);
                continue;
            }
            if (!"pm_om_purorderbill".equals(coreBillType)) continue;
            pmomBillIds.add(coreBillId);
        }
        Map<Long, BigDecimal> coreBillPrePayAmt = this.queryHadPrePayInTranSit(purOrderBillIds, conBillIds, scpoBillIds, pmomBillIds, freeze);
        if (coreBillPrePayAmt.size() == 0) {
            return finApFreezeInfo;
        }
        logger.info("corebillInfo" + coreBillPrePayAmt.toString());
        Map<Long, String> coreBillKeys = this.getCoreBillMatchKey(purOrderBillIds, conBillIds, scpoBillIds, pmomBillIds);
        Set<Long> hadPreBillIds = coreBillPrePayAmt.keySet();
        Map<Long, BigDecimal> hadPayPreAmt = this.queryPrePayBillByCoreBillId(hadPreBillIds);
        for (DynamicObject bill : finApBills) {
            Long id = bill.getLong("id");
            Long orgId = bill.getLong("org.id");
            Long asstactId = bill.getLong("asstact.id");
            String expenseBillIds = bill.getString("detailentry.e_expensebillids_tag");
            boolean isExpenseBill = expenseBillIds != null && !"".equals(expenseBillIds);
            if (isExpenseBill) continue;
            Long masterId = (Long)this.supplierMasterIds.get(asstactId);
            if (masterId == null) {
                DynamicObject supplier = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_supplier", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)asstactId)});
                if (supplier == null) continue;
                masterId = supplier.getLong("masterid");
                this.supplierMasterIds.put(supplier.getLong("id"), masterId);
            }
            boolean needFreeze = false;
            String coreBillType = bill.getString("detailentry.corebilltype");
            Long coreBillId = bill.getLong("detailentry.corebillid");
            if (coreBillId == 0L) continue;
            Integer settleModel = (Integer)this.settleModelMap.get(orgId);
            if (settleModel == null) {
                settleModel = ArApHelper.getApSettleParam(orgId);
                this.settleModelMap.put(orgId, settleModel);
            }
            BigDecimal unsettleamt = bill.getBigDecimal("detailentry.unsettleamt");
            if (freeze && 1 == settleModel && unsettleamt.compareTo(BigDecimal.ZERO) <= 0) continue;
            String curCoreBillKey = coreBillId + "_" + orgId + "_" + masterId;
            if (curCoreBillKey.equals(coreBillKeys.get(coreBillId))) {
                BigDecimal corePreAmt = coreBillPrePayAmt.get(coreBillId);
                Long conBillId = bill.getLong("detailentry.e_conbillid");
                BigDecimal conBillPreAmt = coreBillPrePayAmt.get(conBillId);
                if (corePreAmt == null && conBillPreAmt == null) continue;
                BigDecimal coreSumPreAmt = hadPayPreAmt.get(coreBillId);
                if (coreSumPreAmt == null || coreSumPreAmt.compareTo(corePreAmt) < 0) {
                    if ("pm_purorderbill".equals(coreBillType)) {
                        if (conBillId == 0L) {
                            needFreeze = true;
                        } else {
                            BigDecimal conSumPreAmt = hadPayPreAmt.get(conBillId);
                            if (conBillPreAmt == null || conSumPreAmt == null || conSumPreAmt.compareTo(conBillPreAmt) < 0) {
                                needFreeze = true;
                            }
                        }
                    } else {
                        needFreeze = true;
                    }
                }
            }
            if (!needFreeze) continue;
            HashSet<Long> coreBillIds = (HashSet<Long>)finApFreezeInfo.get(id);
            if (coreBillIds == null) {
                coreBillIds = new HashSet<Long>(16);
                coreBillIds.add(coreBillId);
                finApFreezeInfo.put(id, coreBillIds);
                continue;
            }
            coreBillIds.add(coreBillId);
        }
        return finApFreezeInfo;
    }
}

