/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.freeze;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.enums.FreezeStateEnum;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.OperationConfirmHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.service.freeze.selector.FreezeListFactory;
import kd.fi.arapcommon.service.freeze.selector.IFreezeListProvider;
import kd.fi.arapcommon.service.freeze.vo.FreezeVO;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StdConfig;

public class FreezeServiceHelper {
    protected IFormView view;

    public FreezeServiceHelper(IFormView view) {
        this.view = view;
    }

    public void setBillFeezeState(FreezeVO freezeVO, String headFreezeStateEntity, String entryEntity, String entryFreezeStateEntity) {
        if (!freezeVO.isEntryFreeze()) {
            if ("ap_payapply".equals(freezeVO.getBillEntity()) && "freeze".equals(freezeVO.getFreezeOpKey())) {
                for (DynamicObject bill : freezeVO.getBills()) {
                    boolean isAllFreeze = true;
                    DynamicObjectCollection entrys = bill.getDynamicObjectCollection(entryEntity);
                    for (DynamicObject entry : entrys) {
                        if ("A".equals(entry.getString("e_closestatus"))) {
                            entry.set(entryFreezeStateEntity, (Object)freezeVO.getFreezeState());
                        }
                        String entryFreezeState = entry.getString(entryFreezeStateEntity);
                        if (!isAllFreeze || entryFreezeState.equals(freezeVO.getFreezeState())) continue;
                        isAllFreeze = false;
                    }
                    String currentFreezeState = isAllFreeze ? freezeVO.getFreezeState() : FreezeStateEnum.PARTFREEZE.getValue();
                    bill.set(headFreezeStateEntity, (Object)currentFreezeState);
                }
            } else {
                for (DynamicObject bill : freezeVO.getBills()) {
                    bill.set(headFreezeStateEntity, (Object)freezeVO.getFreezeState());
                    DynamicObjectCollection entrys = bill.getDynamicObjectCollection(entryEntity);
                    for (DynamicObject entry : entrys) {
                        entry.set(entryFreezeStateEntity, (Object)freezeVO.getFreezeState());
                    }
                }
            }
            return;
        }
        for (DynamicObject bill : freezeVO.getBills()) {
            boolean isAllFreeze = true;
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection(entryEntity);
            for (DynamicObject entry : entrys) {
                if (freezeVO.getEntryIds().contains(entry.getLong("id"))) {
                    entry.set(entryFreezeStateEntity, (Object)freezeVO.getFreezeState());
                }
                String entryFreezeState = entry.getString(entryFreezeStateEntity);
                if (!isAllFreeze || entryFreezeState.equals(freezeVO.getFreezeState())) continue;
                isAllFreeze = false;
            }
            String currentFreezeState = isAllFreeze ? freezeVO.getFreezeState() : FreezeStateEnum.PARTFREEZE.getValue();
            bill.set(headFreezeStateEntity, (Object)currentFreezeState);
        }
    }

    public void updateBillAndSaveFreezeLog(FreezeVO freezeVO) {
        SaveServiceHelper.update((DynamicObject[])freezeVO.getBills().toArray(new DynamicObject[freezeVO.getBills().size()]));
        IFreezeListProvider freezeListProvider = FreezeListFactory.getFreezeListProvider(freezeVO.getBillEntity());
        List<DynamicObject> freezeLogs = freezeListProvider.billConvertFreezeLog(freezeVO);
        SaveServiceHelper.save((DynamicObject[])freezeLogs.toArray(new DynamicObject[0]));
    }

    public void reloadBill(FreezeVO freezeVO, String orgEntity) {
        IFreezeListProvider freezeListProvider = FreezeListFactory.getFreezeListProvider(freezeVO.getBillEntity());
        List<String> selector = freezeListProvider.billConvertLogSelector(freezeVO.isEntryFreeze());
        QFilter qFilter = new QFilter("id", "in", freezeVO.getPkIds());
        if (freezeVO.isEntryFreeze()) {
            qFilter.and(freezeVO.getEntryEntity() + ".id", "in", freezeVO.getEntryIds());
        }
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)freezeVO.getBillEntity(), (String)String.join((CharSequence)",", selector), (QFilter[])new QFilter[]{qFilter});
        freezeVO.setBills(Arrays.asList(bills));
    }

    public void freezeDispose(FreezeVO freezeVO, String freezeEntityNumber, String unFreezeEntityNumber, OperationResult operationResult, IFormPlugin plugin) {
        boolean isUnFreezeOp;
        boolean freezeWhySysParam = this.getFreezeWhySysParam(freezeVO.getOrgId(), freezeEntityNumber, false);
        boolean unfreezeWhySysParam = this.getUnFreezeWhySysParam(freezeVO.getOrgId(), unFreezeEntityNumber, false);
        boolean isFreezeOp = "freeze".equals(freezeVO.getFreezeOpKey()) || "m_freeze".equals(freezeVO.getFreezeOpKey());
        boolean bl = isUnFreezeOp = "unfreeze".equals(freezeVO.getFreezeOpKey()) || "m_unfreeze".equals(freezeVO.getFreezeOpKey());
        if (isFreezeOp && freezeWhySysParam || isUnFreezeOp && unfreezeWhySysParam) {
            if (operationResult != null) {
                operationResult.setShowMessage(freezeVO.isShowMessage());
            }
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("ap_freezelist");
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            fsp.setCustomParam("freezeVO", (Object)freezeVO);
            if (FreezeStateEnum.UNFREEZE.getValue().equals(freezeVO.getFreezeState())) {
                fsp.setCaption(ResManager.loadKDString((String)"\u89e3\u51bb\u4fe1\u606f", (String)"FreezeServiceHelper_0", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
            CloseCallBack closeCallBack = new CloseCallBack(plugin, "bar_freeze");
            fsp.setCloseCallBack(closeCallBack);
            this.view.showForm(fsp);
            freezeVO.setNext(false);
        }
    }

    public void convertFreezeVO(FreezeVO freezeVO, String key, List<Object> ids, String billEntityNumber) {
        boolean isFreezeOp = "freeze".equals(key) || "m_freeze".equals(key);
        String freezeState = isFreezeOp ? FreezeStateEnum.ALLFREEZE.getValue() : FreezeStateEnum.UNFREEZE.getValue();
        boolean isEntryShow = "ap_payapply".equals(billEntityNumber);
        freezeVO.setFreezeState(freezeState);
        freezeVO.setEntryFreeze(false);
        freezeVO.setFreezeOpKey(key);
        freezeVO.setEntryShow(isEntryShow);
        freezeVO.setPkIds(ids);
        freezeVO.setOpType("manual");
        freezeVO.setBillEntity(billEntityNumber);
    }

    public void searchFreezeLog(List<String> ids) {
        QFilter qfilter = new QFilter("billid", "in", ids);
        DynamicObject[] freezeLogs = BusinessDataServiceHelper.load((String)"ap_freezelog", (String)"id,org", (QFilter[])new QFilter[]{qfilter});
        if (freezeLogs.length < 1) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u51bb\u7ed3\u65e5\u5fd7\u3002", (String)"FreezeServiceHelper_1", (String)"fi-arapcommon", (Object[])new Object[0]));
            return;
        }
        if (EmptyUtils.isEmpty(freezeLogs[0].get("org"))) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u51bb\u7ed3\u65e5\u5fd7\u7684\u201c\u64cd\u4f5c\u7ec4\u7ec7\u201d\u4e3a\u7a7a\u3002", (String)"FreezeServiceHelper_2", (String)"fi-arapcommon", (Object[])new Object[0]));
            return;
        }
        Long userId = RequestContext.get().getCurrUserId();
        int hasPermResult = PermissionServiceHelper.checkPermission((Long)userId, (Long)freezeLogs[0].getLong("org.id"), (String)"+HKZHSKFXOX", (String)"ap_freezelog", (String)"47150e89000000ac");
        if (hasPermResult != 1) {
            this.view.showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u4e1a\u52a1\u5bf9\u8c61\u201c\u51bb\u7ed3\u65e5\u5fd7\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FreezeServiceHelper_3", (String)"fi-arapcommon", (Object[])new Object[0]));
            return;
        }
        ListShowParameter lsp = new ListShowParameter();
        ListFilterParameter lfp = new ListFilterParameter();
        lsp.setBillFormId("ap_freezelog");
        lfp.setFilter(qfilter);
        lsp.setCustomParam("initOrg", freezeLogs[0].get("org.id"));
        lsp.setListFilterParameter(lfp);
        lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        lsp.setHasRight(true);
        this.view.showForm((FormShowParameter)lsp);
    }

    public boolean unAuditOpConfirm(IFormPlugin plugin, DynamicObject[] bills, String orgEntity, String freezeStateEntity, String unAuditAutoUnFreezeSysParamEntity) {
        HashSet<Long> orgIds = new HashSet<Long>(bills.length);
        boolean existFreezeBill = false;
        for (DynamicObject dynamicObject : bills) {
            orgIds.add(dynamicObject.getLong(orgEntity + ".id"));
            if (existFreezeBill || !dynamicObject.getString(freezeStateEntity).equals(FreezeStateEnum.ALLFREEZE.getValue()) && !dynamicObject.getString(freezeStateEntity).equals(FreezeStateEnum.PARTFREEZE.getValue()) || !BillStatusEnum.AUDIT.getValue().equals(dynamicObject.getString("billstatus"))) continue;
            existFreezeBill = true;
        }
        if (!existFreezeBill) {
            return false;
        }
        HashSet<Long> openOrgId = new HashSet<Long>(bills.length);
        boolean allUnauditAutoUnfreeze = false;
        for (Long l : orgIds) {
            int unauditAutoUnfreeze = this.getUnAuditAutoUnFreezeSysParam(l, unAuditAutoUnFreezeSysParamEntity, false);
            if (unauditAutoUnfreeze == 0) continue;
            allUnauditAutoUnfreeze = true;
            openOrgId.add(l);
        }
        if (!allUnauditAutoUnfreeze) {
            return false;
        }
        ArrayList<String> msgs = new ArrayList<String>(bills.length);
        for (DynamicObject bill : bills) {
            if (!openOrgId.contains(bill.getLong(orgEntity + ".id"))) continue;
            if (bill.getString(freezeStateEntity).equals(FreezeStateEnum.ALLFREEZE.getValue())) {
                msgs.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u5df2\u51bb\u7ed3\uff0c\u5c06\u5728\u53cd\u5ba1\u6838\u540e\u81ea\u52a8\u89e3\u51bb\u3002", (String)"FreezeServiceHelper_4", (String)"fi-arapcommon", (Object[])new Object[0]), bill.getString("billno")));
            }
            if (!bill.getString(freezeStateEntity).equals(FreezeStateEnum.PARTFREEZE.getValue())) continue;
            msgs.add(String.format(ResManager.loadKDString((String)"%s\uff1a\u90e8\u5206\u51bb\u7ed3\u5c06\u5728\u53cd\u5ba1\u6838\u540e\u81ea\u52a8\u89e3\u51bb\u3002", (String)"FreezeServiceHelper_5", (String)"fi-arapcommon", (Object[])new Object[0]), bill.getString("billno")));
        }
        if (msgs == null || msgs.size() < 1) {
            return false;
        }
        String string = ResManager.loadKDString((String)"\u51bb\u7ed3\u5355\u636e\u53cd\u5ba1\u6838\u81ea\u52a8\u89e3\u51bb", (String)"FreezeServiceHelper_6", (String)"fi-arapcommon", (Object[])new Object[0]);
        OperationConfirmHelper operationConfirmHelper = new OperationConfirmHelper(this.view, plugin);
        operationConfirmHelper.openOperationConfirm(string, msgs, false);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean unAuditOpConfirm(IFormPlugin plugin, DynamicObjectCollection freezeBills, String orgEntity, String freezeStateEntity, String unAuditAutoUnFreezeSysParamEntity) {
        if (freezeBills.isEmpty()) {
            return false;
        }
        HashMap billMapByOrg = new HashMap(8);
        for (DynamicObject freezeBill : freezeBills) {
            void var10_10;
            Long orgId = freezeBill.getLong(orgEntity);
            List list = (List)billMapByOrg.get(orgId);
            if (list == null || list.isEmpty()) {
                ArrayList arrayList = new ArrayList(freezeBills.size());
                billMapByOrg.put(orgId, arrayList);
            }
            var10_10.add(freezeBill);
        }
        Map<Long, Object> paramMap = SystemParameterHelper.batchGetAppParameter(Boolean.FALSE, new ArrayList<Long>(billMapByOrg.keySet()), unAuditAutoUnFreezeSysParamEntity);
        ArrayList<String> msgs = new ArrayList<String>(freezeBills.size());
        for (Map.Entry entry : billMapByOrg.entrySet()) {
            if (!((Boolean)paramMap.get(entry.getKey())).booleanValue()) continue;
            for (DynamicObject bill : (List)entry.getValue()) {
                msgs.add(String.format(ResManager.loadKDString((String)"%1$s\uff1a%2$s\u5c06\u5728\u53cd\u5ba1\u6838\u540e\u81ea\u52a8\u89e3\u51bb\u3002", (String)"FreezeServiceHelper_7", (String)"fi-arapcommon", (Object[])new Object[0]), bill.getString("billno"), FreezeStateEnum.getName(bill.getString(freezeStateEntity))));
            }
        }
        if (msgs.isEmpty()) {
            return false;
        }
        String title = ResManager.loadKDString((String)"\u51bb\u7ed3\u5355\u636e\u53cd\u5ba1\u6838\u81ea\u52a8\u89e3\u51bb", (String)"FreezeServiceHelper_6", (String)"fi-arapcommon", (Object[])new Object[0]);
        OperationConfirmHelper operationConfirmHelper = new OperationConfirmHelper(this.view, plugin);
        operationConfirmHelper.openOperationConfirm(title, msgs, false);
        return true;
    }

    public boolean getFreezeWhySysParam(long orgId, String freezeEntityNumber, boolean isAr) {
        Object object = ArApHelper.getParameter(orgId, freezeEntityNumber, isAr);
        return (Boolean)object;
    }

    public boolean getUnFreezeWhySysParam(long orgId, String unFreezeEntityNumber, boolean isAr) {
        Object object = ArApHelper.getParameter(orgId, unFreezeEntityNumber, isAr);
        return (Boolean)object;
    }

    public boolean getUnAuditAutoUnFreezeSysParam(long orgId, String unFreezeWhySysParamEntity, boolean isAr) {
        Object object = ArApHelper.getParameter(orgId, unFreezeWhySysParamEntity, isAr);
        return (Boolean)object;
    }

    public static Map<Long, String> findNeedFreezeBill(Set<Long> ids) {
        HashMap<Long, String> finApFreezeInfo = new HashMap<Long, String>(16);
        String ignorePreTransit = StdConfig.get("ignorepretransit");
        if ("true".equals(ignorePreTransit)) {
            return finApFreezeInfo;
        }
        DynamicObjectCollection finApBills = QueryServiceHelper.query((String)"ap_finapbill", (String)"id,org.id,asstact.id,detailentry.corebilltype,detailentry.corebillid,detailentry.e_pricetaxtotal,detailentry.e_conbillid,detailentry.unsettleamt,detailentry.e_expensebillids_tag", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        HashSet<Long> asstactIds = new HashSet<Long>(16);
        HashSet<Long> purOrderBillIds = new HashSet<Long>(16);
        HashSet<Long> conBillIds = new HashSet<Long>(16);
        HashSet<Long> scpoBillIds = new HashSet<Long>(16);
        HashSet<Long> pmomBillIds = new HashSet<Long>(16);
        for (DynamicObject bill : finApBills) {
            BigDecimal pricetaxtotal;
            boolean isExpenseBill;
            String expenseBillIds = bill.getString("detailentry.e_expensebillids_tag");
            boolean bl = isExpenseBill = expenseBillIds != null && !"".equals(expenseBillIds);
            if (isExpenseBill) continue;
            asstactIds.add(bill.getLong("asstact.id"));
            String coreBillType = bill.getString("detailentry.corebilltype");
            Long coreBillId = bill.getLong("detailentry.corebillid");
            if (coreBillId == 0L || (pricetaxtotal = bill.getBigDecimal("detailentry.e_pricetaxtotal")).compareTo(BigDecimal.ZERO) < 0) continue;
            if ("pm_purorderbill".equals(coreBillType)) {
                purOrderBillIds.add(coreBillId);
                Long conBillId = bill.getLong("detailentry.e_conbillid");
                if (conBillId == 0L) continue;
                conBillIds.add(conBillId);
                continue;
            }
            if ("conm_purcontract".equals(coreBillType)) {
                conBillIds.add(coreBillId);
                continue;
            }
            if ("sctm_scpo".equals(coreBillType)) {
                scpoBillIds.add(coreBillId);
                continue;
            }
            if (!"pm_om_purorderbill".equals(coreBillType)) continue;
            pmomBillIds.add(coreBillId);
        }
        Map<Long, BigDecimal> coreBillPrePayAmt = FreezeServiceHelper.queryHadPrePayInTranSit(purOrderBillIds, conBillIds, scpoBillIds, pmomBillIds);
        if (coreBillPrePayAmt.size() == 0) {
            return finApFreezeInfo;
        }
        Map<Long, String> coreBillKeys = FreezeServiceHelper.getCoreBillMatchKey(purOrderBillIds, conBillIds, scpoBillIds, pmomBillIds);
        Set<Long> hadPreBillIds = coreBillPrePayAmt.keySet();
        Map<Long, BigDecimal> hadPayPreAmt = FreezeServiceHelper.queryPrePayBillByCoreBillId(hadPreBillIds);
        DynamicObjectCollection suppliers = QueryServiceHelper.query((String)"bd_supplier", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", asstactIds)});
        Map<Long, Long> supplierMasterIds = suppliers.stream().collect(Collectors.toMap(v -> v.getLong("id"), v -> v.getLong("masterid")));
        for (DynamicObject bill : finApBills) {
            BigDecimal coreSumPreAmt;
            String coreBillType = bill.getString("detailentry.corebilltype");
            Long coreBillId = bill.getLong("detailentry.corebillid");
            Long asstactId = bill.getLong("asstact.id");
            Long masterId = supplierMasterIds.getOrDefault(asstactId, asstactId);
            if (coreBillId == 0L) continue;
            Long orgId = bill.getLong("org.id");
            String curCoreBillKey = coreBillId + "_" + orgId + "_" + masterId;
            if (!curCoreBillKey.equals(coreBillKeys.get(coreBillId))) continue;
            BigDecimal corePreAmt = coreBillPrePayAmt.get(coreBillId);
            Long conBillId = bill.getLong("detailentry.e_conbillid");
            BigDecimal conBillPreAmt = coreBillPrePayAmt.get(conBillId);
            if (corePreAmt == null && conBillPreAmt == null || (coreSumPreAmt = hadPayPreAmt.get(coreBillId)) != null && coreSumPreAmt.compareTo(corePreAmt) >= 0) continue;
            if ("pm_purorderbill".equals(coreBillType)) {
                if (conBillId == 0L) {
                    finApFreezeInfo.put(coreBillId, curCoreBillKey);
                    continue;
                }
                BigDecimal conSumPreAmt = hadPayPreAmt.get(conBillId);
                if (conBillPreAmt == null) {
                    finApFreezeInfo.put(coreBillId, curCoreBillKey);
                    continue;
                }
                if (conSumPreAmt != null && conSumPreAmt.compareTo(conBillPreAmt) >= 0) continue;
                if (coreSumPreAmt != null) {
                    finApFreezeInfo.put(coreBillId, curCoreBillKey);
                    continue;
                }
                finApFreezeInfo.put(conBillId, conBillId + "_" + orgId + "_" + masterId);
                continue;
            }
            finApFreezeInfo.put(coreBillId, curCoreBillKey);
        }
        return finApFreezeInfo;
    }

    public static Map<Long, BigDecimal> queryHadPrePayInTranSit(Set<Long> purOrderBillIds, Set<Long> conBillIds, Set<Long> scpoBillIds, Set<Long> pmomBillIds) {
        BigDecimal purPerAmt;
        QFilter filter;
        HashMap<Long, BigDecimal> coreBillPrePayAmt = new HashMap<Long, BigDecimal>(16);
        if (purOrderBillIds != null && purOrderBillIds.size() > 0) {
            filter = new QFilter("id", "in", purOrderBillIds);
            filter.and(new QFilter("purbillentry_pay.payamount", ">", (Object)BigDecimal.ZERO));
            filter.and(new QFilter("purbillentry_pay.isprepay", "=", (Object)Boolean.TRUE));
            DataSet purDataSet = QueryServiceHelper.queryDataSet((String)"finapfreeze", (String)"pm_purorderbill", (String)"id,purbillentry_pay.payamount", (QFilter[])new QFilter[]{filter}, null);
            for (Row row : purDataSet) {
                Long purBillId = row.getLong("id");
                purPerAmt = (BigDecimal)coreBillPrePayAmt.get(purBillId);
                if (purPerAmt == null) {
                    coreBillPrePayAmt.put(purBillId, row.getBigDecimal("purbillentry_pay.payamount"));
                    continue;
                }
                coreBillPrePayAmt.put(purBillId, purPerAmt.add(row.getBigDecimal("purbillentry_pay.payamount")));
            }
        }
        if (conBillIds != null && conBillIds.size() > 0) {
            filter = new QFilter("id", "in", conBillIds);
            filter.and(new QFilter("payentry.payamount", ">", (Object)BigDecimal.ZERO));
            filter.and(new QFilter("payentry.isprepay", "=", (Object)Boolean.TRUE));
            DataSet conDataSet = QueryServiceHelper.queryDataSet((String)"finapfreeze", (String)"conm_purcontract", (String)"id,payentry.payamount", (QFilter[])new QFilter[]{filter}, null);
            for (Row row : conDataSet) {
                Long conBillId = row.getLong("id");
                purPerAmt = (BigDecimal)coreBillPrePayAmt.get(conBillId);
                if (purPerAmt == null) {
                    coreBillPrePayAmt.put(conBillId, row.getBigDecimal("payentry.payamount"));
                    continue;
                }
                coreBillPrePayAmt.put(conBillId, purPerAmt.add(row.getBigDecimal("payentry.payamount")));
            }
        }
        if (scpoBillIds != null && scpoBillIds.size() > 0) {
            filter = new QFilter("id", "in", scpoBillIds);
            filter.and(new QFilter("billentry_pay.payamount", ">", (Object)BigDecimal.ZERO));
            filter.and(new QFilter("billentry_pay.isprepay", "=", (Object)Boolean.TRUE));
            DataSet scpoDataSet = QueryServiceHelper.queryDataSet((String)"finapfreeze", (String)"sctm_scpo", (String)"id,billentry_pay.payamount", (QFilter[])new QFilter[]{filter}, null);
            for (Row row : scpoDataSet) {
                Long scpoBillId = row.getLong("id");
                purPerAmt = (BigDecimal)coreBillPrePayAmt.get(scpoBillId);
                if (purPerAmt == null) {
                    coreBillPrePayAmt.put(scpoBillId, row.getBigDecimal("billentry_pay.payamount"));
                    continue;
                }
                coreBillPrePayAmt.put(scpoBillId, purPerAmt.add(row.getBigDecimal("billentry_pay.payamount")));
            }
        }
        if (pmomBillIds != null && pmomBillIds.size() > 0) {
            filter = new QFilter("id", "in", pmomBillIds);
            filter.and(new QFilter("purbillentry_pay.payamount", ">", (Object)BigDecimal.ZERO));
            filter.and(new QFilter("purbillentry_pay.isprepay", "=", (Object)Boolean.TRUE));
            DataSet pmomDataSet = QueryServiceHelper.queryDataSet((String)"finapfreeze", (String)"pm_om_purorderbill", (String)"id,purbillentry_pay.payamount", (QFilter[])new QFilter[]{filter}, null);
            for (Row row : pmomDataSet) {
                Long pmomBillId = row.getLong("id");
                purPerAmt = (BigDecimal)coreBillPrePayAmt.get(pmomBillId);
                if (purPerAmt == null) {
                    coreBillPrePayAmt.put(pmomBillId, row.getBigDecimal("purbillentry_pay.payamount"));
                    continue;
                }
                coreBillPrePayAmt.put(pmomBillId, purPerAmt.add(row.getBigDecimal("purbillentry_pay.payamount")));
            }
        }
        return coreBillPrePayAmt;
    }

    private static Map<Long, String> getCoreBillMatchKey(Set<Long> purOrderBillIds, Set<Long> conBillIds, Set<Long> scpoBillIds, Set<Long> pmomBillIds) {
        DynamicObject supplier;
        Long masterId;
        Long supplierId;
        Long billId;
        DataSet hadPrePurDataSet;
        HashMap<Long, String> coreBillMapKey = new HashMap<Long, String>(16);
        HashMap<Long, Long> supplierMasterIds = new HashMap<Long, Long>(16);
        if (purOrderBillIds.size() > 0) {
            hadPrePurDataSet = QueryServiceHelper.queryDataSet((String)"finapfreeze", (String)"pm_purorderbill", (String)"id,invoicesupplier,billentry.entrysettleorg", (QFilter[])new QFilter[]{new QFilter("id", "in", purOrderBillIds)}, null);
            for (Row row : hadPrePurDataSet) {
                billId = row.getLong("id");
                supplierId = row.getLong("invoicesupplier");
                masterId = (Long)supplierMasterIds.get(supplierId);
                if (masterId == null) {
                    supplier = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_supplier", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)supplierId)});
                    if (supplier == null) continue;
                    masterId = supplier.getLong("masterid");
                    supplierMasterIds.put(supplier.getLong("id"), masterId);
                }
                if (coreBillMapKey.get(billId) != null) continue;
                coreBillMapKey.put(billId, billId + "_" + row.getLong("billentry.entrysettleorg") + "_" + masterId);
            }
        }
        if (conBillIds.size() > 0) {
            hadPrePurDataSet = QueryServiceHelper.queryDataSet((String)"finapfreeze", (String)"conm_purcontract", (String)"id,invoicesupplier,billentry.entrysettleorg", (QFilter[])new QFilter[]{new QFilter("id", "in", conBillIds)}, null);
            for (Row row : hadPrePurDataSet) {
                billId = row.getLong("id");
                supplierId = row.getLong("invoicesupplier");
                masterId = (Long)supplierMasterIds.get(supplierId);
                if (masterId == null) {
                    supplier = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_supplier", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)supplierId)});
                    if (supplier == null) continue;
                    masterId = supplier.getLong("masterid");
                    supplierMasterIds.put(supplier.getLong("id"), masterId);
                }
                if (coreBillMapKey.get(billId) != null) continue;
                coreBillMapKey.put(billId, billId + "_" + row.getLong("billentry.entrysettleorg") + "_" + masterId);
            }
        }
        if (scpoBillIds.size() > 0) {
            hadPrePurDataSet = QueryServiceHelper.queryDataSet((String)"finapfreeze", (String)"sctm_scpo", (String)"id,invoicesupplier,billentry.entrysettleorg", (QFilter[])new QFilter[]{new QFilter("id", "in", scpoBillIds)}, null);
            for (Row row : hadPrePurDataSet) {
                billId = row.getLong("id");
                supplierId = row.getLong("invoicesupplier");
                masterId = (Long)supplierMasterIds.get(supplierId);
                if (masterId == null) {
                    supplier = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_supplier", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)supplierId)});
                    if (supplier == null) continue;
                    masterId = supplier.getLong("masterid");
                    supplierMasterIds.put(supplier.getLong("id"), masterId);
                }
                if (coreBillMapKey.get(billId) != null) continue;
                coreBillMapKey.put(billId, billId + "_" + row.getLong("billentry.entrysettleorg") + "_" + masterId);
            }
        }
        if (pmomBillIds.size() > 0) {
            hadPrePurDataSet = QueryServiceHelper.queryDataSet((String)"finapfreeze", (String)"pm_om_purorderbill", (String)"id,invoicesupplier,billentry.entrysettleorg", (QFilter[])new QFilter[]{new QFilter("id", "in", pmomBillIds)}, null);
            for (Row row : hadPrePurDataSet) {
                billId = row.getLong("id");
                supplierId = row.getLong("invoicesupplier");
                masterId = (Long)supplierMasterIds.get(supplierId);
                if (masterId == null) {
                    supplier = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_supplier", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)supplierId)});
                    if (supplier == null) continue;
                    masterId = supplier.getLong("masterid");
                    supplierMasterIds.put(supplier.getLong("id"), masterId);
                }
                if (coreBillMapKey.get(billId) != null) continue;
                coreBillMapKey.put(billId, billId + "_" + row.getLong("billentry.entrysettleorg") + "_" + masterId);
            }
        }
        return coreBillMapKey;
    }

    public static Map<Long, BigDecimal> queryPrePayBillByCoreBillId(Set<Long> coreBillIds) {
        HashMap<Long, BigDecimal> hadPayPreAmt = new HashMap<Long, BigDecimal>(16);
        QFilter payBillFilter = new QFilter("entry.e_corebillid", "in", coreBillIds);
        payBillFilter.and("billstatus", "in", (Object)new String[]{"D", "F", "I"});
        payBillFilter.and("paymenttype.biztype", "=", (Object)"202");
        DataSet prePayBills = QueryServiceHelper.queryDataSet((String)"finapfreezepay", (String)"cas_paybill", (String)"entry.e_corebillid,entry.e_payableamt,entry.e_refundamt", (QFilter[])new QFilter[]{payBillFilter}, null);
        for (Row row : prePayBills) {
            Long coreBillId = row.getLong("entry.e_corebillid");
            BigDecimal currentPayAmt = row.getBigDecimal("entry.e_payableamt").subtract(row.getBigDecimal("entry.e_refundamt"));
            BigDecimal coreBillSumPrePayAmt = (BigDecimal)hadPayPreAmt.get(coreBillId);
            if (coreBillSumPrePayAmt == null) {
                hadPayPreAmt.put(coreBillId, currentPayAmt);
                continue;
            }
            hadPayPreAmt.put(coreBillId, coreBillSumPrePayAmt.add(currentPayAmt));
        }
        return hadPayPreAmt;
    }
}

