/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.freeze;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.service.freeze.AbstractFinApPrePayFreezeService;

public class PurOrderBillIsOverPayChangeFreeze
extends AbstractFinApPrePayFreezeService {
    @Override
    protected Map<Long, Set<Long>> findNeedFreezeBill(Set<Long> ids, boolean freeze) {
        HashSet<Long> needFreezePurBillIds = new HashSet<Long>(16);
        Map<Long, String> coreMatchKeys = this.coreMatchKeys(ids, "pm_purorderbill");
        HashSet<Long> conmBillIds = new HashSet<Long>(16);
        HashMap purId2ConmIds = new HashMap(16);
        DataSet purBills = QueryServiceHelper.queryDataSet((String)"purchange", (String)"pm_purorderbill", (String)"id,billentry.conbillid", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)}, null);
        for (Row row : purBills) {
            Long conmBillId = row.getLong("billentry.conbillid");
            if (conmBillId == 0L) continue;
            conmBillIds.add(conmBillId);
            Long purBillId = row.getLong("id");
            HashSet<Long> currPurBillUpConmIds = (Set)purId2ConmIds.get(purBillId);
            if (currPurBillUpConmIds == null) {
                currPurBillUpConmIds = new HashSet<Long>(16);
                currPurBillUpConmIds.add(conmBillId);
                purId2ConmIds.put(purBillId, currPurBillUpConmIds);
                continue;
            }
            currPurBillUpConmIds.add(conmBillId);
        }
        HashSet<Long> purAndConmBillIds = new HashSet<Long>(16);
        purAndConmBillIds.addAll(ids);
        purAndConmBillIds.addAll(conmBillIds);
        Map<Long, BigDecimal> purPrePayAmtMap = this.getBillPrePayAmt(ids, "pm_purorderbill");
        Map<Long, BigDecimal> conmPrePayAmtMap = this.getBillPrePayAmt(conmBillIds, "conm_purcontract");
        Map<Long, BigDecimal> sumPrePayBills = this.loadPayedPreBillAmt(purAndConmBillIds);
        if (freeze) {
            for (Long id : ids) {
                BigDecimal purPayAmt = purPrePayAmtMap.get(id);
                if (purPayAmt == null) continue;
                BigDecimal purSumPreAmt = sumPrePayBills.get(id);
                if (purSumPreAmt == null) {
                    Set upConmBillIds = (Set)purId2ConmIds.get(id);
                    if (upConmBillIds == null) {
                        needFreezePurBillIds.add(id);
                        continue;
                    }
                    BigDecimal conmHadPayPreAmt = BigDecimal.ZERO;
                    BigDecimal conmSumPreAmt = BigDecimal.ZERO;
                    boolean upConmHadPushPrePayBill = false;
                    for (Long conmId : upConmBillIds) {
                        BigDecimal conmPreAmt = conmPrePayAmtMap.getOrDefault(conmId, BigDecimal.ZERO);
                        conmSumPreAmt = conmSumPreAmt.add(conmPreAmt);
                        BigDecimal conmPushedPreAmt = sumPrePayBills.get(conmId);
                        if (conmPushedPreAmt == null) continue;
                        upConmHadPushPrePayBill = true;
                        conmHadPayPreAmt = conmHadPayPreAmt.add(conmPushedPreAmt);
                    }
                    if (upConmHadPushPrePayBill) {
                        if (conmHadPayPreAmt.compareTo(conmSumPreAmt) >= 0) continue;
                        needFreezePurBillIds.add(id);
                        continue;
                    }
                    needFreezePurBillIds.add(id);
                    continue;
                }
                if (purSumPreAmt.compareTo(purPayAmt) >= 0) continue;
                needFreezePurBillIds.add(id);
            }
        } else {
            HashMap<Long, Boolean> conmIsAllowOveryPay = new HashMap<Long, Boolean>(16);
            DataSet conmBills = QueryServiceHelper.queryDataSet((String)"purorderchange", (String)"conm_purcontract", (String)"id,isallowoverpay", (QFilter[])new QFilter[]{new QFilter("id", "in", conmBillIds)}, null);
            for (Row row : conmBills) {
                conmIsAllowOveryPay.put(row.getLong("id"), row.getBoolean("isallowoverpay"));
            }
            for (Long id : ids) {
                Set upConmBillIds = (Set)purId2ConmIds.get(id);
                if (upConmBillIds == null) {
                    needFreezePurBillIds.add(id);
                    continue;
                }
                boolean allUpConmAllowOver = true;
                for (Long conmId : upConmBillIds) {
                    allUpConmAllowOver = allUpConmAllowOver && conmIsAllowOveryPay.getOrDefault(conmId, Boolean.TRUE) != false;
                }
                if (!allUpConmAllowOver) continue;
                needFreezePurBillIds.add(id);
            }
        }
        return this.getNeedFreezeApBillInfo(needFreezePurBillIds, freeze, coreMatchKeys);
    }

    protected Map<Long, BigDecimal> getBillPrePayAmt(Set<Long> ids, String coreBillEntity) {
        HashMap<Long, BigDecimal> coreBillPrePayAmt = new HashMap<Long, BigDecimal>(16);
        QFilter filter = new QFilter("id", "in", ids);
        String selectors = "pm_purorderbill".equals(coreBillEntity) ? "id,purbillentry_pay.payamount payamount,purbillentry_pay.isprepay isprepay" : "id,payentry.payamount payamount,payentry.isprepay isprepay";
        DataSet purDataSet = QueryServiceHelper.queryDataSet((String)"finapfreeze", (String)coreBillEntity, (String)selectors, (QFilter[])new QFilter[]{filter}, null);
        for (Row row : purDataSet) {
            BigDecimal curPreAmt;
            Long purBillId = row.getLong("id");
            BigDecimal sumPurPerAmt = (BigDecimal)coreBillPrePayAmt.get(purBillId);
            BigDecimal bigDecimal = curPreAmt = row.getBoolean("isprepay") != false ? row.getBigDecimal("payamount") : BigDecimal.ZERO;
            if (sumPurPerAmt == null) {
                coreBillPrePayAmt.put(purBillId, curPreAmt);
                continue;
            }
            coreBillPrePayAmt.put(purBillId, sumPurPerAmt.add(curPreAmt));
        }
        return coreBillPrePayAmt;
    }

    protected Map<Long, Set<Long>> getNeedFreezeApBillInfo(Set<Long> purBillIds, boolean freeze, Map<Long, String> coreBillKeys) {
        HashMap<Long, Set<Long>> finApFreezeInfo = new HashMap<Long, Set<Long>>(16);
        if (coreBillKeys.size() == 0 || purBillIds.size() == 0) {
            return finApFreezeInfo;
        }
        DataSet finApBills = QueryServiceHelper.queryDataSet((String)"apfreeze", (String)"ap_finapbill", (String)"id,org.id,asstact.id,detailentry.corebillid,detailentry.e_conbillid,detailentry.e_expensebillids_tag,detailentry.e_pricetaxtotal,detailentry.unsettleamt", (QFilter[])new QFilter[]{new QFilter("detailentry.corebillid", "in", purBillIds), new QFilter("iswrittenoff", "=", (Object)Boolean.FALSE), new QFilter("hadwrittenoff", "=", (Object)Boolean.FALSE), new QFilter("billstatus", "=", (Object)"C")}, null);
        for (Row row : finApBills) {
            String matchKey;
            String expenseBillIds;
            BigDecimal pricetaxtotal = row.getBigDecimal("detailentry.e_pricetaxtotal");
            if (pricetaxtotal.compareTo(BigDecimal.ZERO) < 0 || (expenseBillIds = row.getString("detailentry.e_expensebillids_tag")) != null && !"".equals(expenseBillIds)) continue;
            Long orgId = row.getLong("org.id");
            BigDecimal unSettleAmt = row.getBigDecimal("detailentry.unsettleamt");
            Integer settleModel = (Integer)this.settleModelMap.get(orgId);
            if (settleModel == null) {
                settleModel = ArApHelper.getApSettleParam(orgId);
                this.settleModelMap.put(orgId, settleModel);
            }
            if (freeze && 1 == settleModel && unSettleAmt.compareTo(BigDecimal.ZERO) <= 0) continue;
            Long finApBillId = row.getLong("id");
            Long coreBillId = row.getLong("detailentry.corebillid");
            Long asstactId = row.getLong("asstact.id");
            Long masterId = (Long)this.supplierMasterIds.get(asstactId);
            if (masterId == null) {
                DynamicObject supplier = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_supplier", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)asstactId)});
                if (supplier == null) continue;
                masterId = supplier.getLong("masterid");
                this.supplierMasterIds.put(supplier.getLong("id"), masterId);
            }
            if (!(matchKey = coreBillId + "_" + orgId + "_" + masterId).equals(coreBillKeys.get(coreBillId))) continue;
            HashSet<Long> coreBillIds = (HashSet<Long>)finApFreezeInfo.get(finApBillId);
            if (coreBillIds == null) {
                coreBillIds = new HashSet<Long>(16);
                coreBillIds.add(coreBillId);
                finApFreezeInfo.put(finApBillId, coreBillIds);
                continue;
            }
            coreBillIds.add(coreBillId);
        }
        return finApFreezeInfo;
    }

    protected Map<Long, String> coreMatchKeys(Set<Long> coreBillIds, String coreBillEntity) {
        HashMap<Long, String> coreBillKeys = new HashMap<Long, String>(16);
        if (coreBillIds.size() == 0) {
            return coreBillKeys;
        }
        DataSet coreBillDataSet = QueryServiceHelper.queryDataSet((String)"purchange", (String)coreBillEntity, (String)"id,invoicesupplier,billentry.entrysettleorg", (QFilter[])new QFilter[]{new QFilter("id", "in", coreBillIds)}, null);
        for (Row row : coreBillDataSet) {
            Long billId = row.getLong("id");
            if (coreBillKeys.get(billId) != null) continue;
            Long asstactId = row.getLong("invoicesupplier");
            Long masterId = (Long)this.supplierMasterIds.get(asstactId);
            if (masterId == null) {
                DynamicObject supplier = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_supplier", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)asstactId)});
                if (supplier == null) continue;
                masterId = supplier.getLong("masterid");
                this.supplierMasterIds.put(supplier.getLong("id"), masterId);
            }
            coreBillKeys.put(billId, billId + "_" + row.getLong("billentry.entrysettleorg") + "_" + masterId);
        }
        return coreBillKeys;
    }

    protected Map<Long, BigDecimal> loadPayedPreBillAmt(Set<Long> coreBillIds) {
        HashMap<Long, BigDecimal> coreBillSumPrePayMap = new HashMap<Long, BigDecimal>(16);
        QFilter payBillFilter = new QFilter("entry.e_corebillid", "in", coreBillIds);
        payBillFilter.and("paymenttype.biztype", "=", (Object)"202");
        DataSet prePayBills = QueryServiceHelper.queryDataSet((String)"finapfreezepay", (String)"cas_paybill", (String)"id,entry.e_corebillid,entry.e_payableamt,entry.e_refundamt,billstatus", (QFilter[])new QFilter[]{payBillFilter}, null);
        for (Row row : prePayBills) {
            BigDecimal coreBillSumPrePayAmt;
            Long coreBillId = row.getLong("entry.e_corebillid");
            String billStatus = row.getString("billstatus");
            BigDecimal currentPayAmt = BigDecimal.ZERO;
            if ("D".equals(billStatus) || "F".equals(billStatus) || "I".equals(billStatus)) {
                currentPayAmt = row.getBigDecimal("entry.e_payableamt").subtract(row.getBigDecimal("entry.e_refundamt"));
            }
            if ((coreBillSumPrePayAmt = (BigDecimal)coreBillSumPrePayMap.get(coreBillId)) != null) {
                coreBillSumPrePayMap.put(coreBillId, coreBillSumPrePayAmt.add(currentPayAmt));
                continue;
            }
            coreBillSumPrePayMap.put(coreBillId, currentPayAmt);
        }
        return coreBillSumPrePayMap;
    }
}

