/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.freeze;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.service.freeze.AbstractFinApPrePayFreezeService;

public class PurorderBillPrePayChangeFreeze
extends AbstractFinApPrePayFreezeService {
    @Override
    protected Map<Long, Set<Long>> findNeedFreezeBill(Set<Long> ids, boolean freeze) {
        HashMap<Long, String> coreBillKeys = new HashMap<Long, String>(16);
        DataSet coreBillDataSet = QueryServiceHelper.queryDataSet((String)"finapfreeze", (String)this.getBillEntity(), (String)"id,invoicesupplier,billentry.entrysettleorg", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)}, null);
        for (Row row : coreBillDataSet) {
            Long billId = row.getLong("id");
            if (coreBillKeys.get(billId) != null) continue;
            Long asstactId = row.getLong("invoicesupplier");
            Long masterId = (Long)this.supplierMasterIds.get(asstactId);
            if (masterId == null) {
                DynamicObject supplier = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_supplier", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)asstactId)});
                if (supplier == null) continue;
                masterId = supplier.getLong("masterid");
                this.supplierMasterIds.put(supplier.getLong("id"), masterId);
            }
            coreBillKeys.put(billId, billId + "_" + row.getLong("billentry.entrysettleorg") + "_" + masterId);
        }
        HashMap<Long, Set<Long>> finApFreezeInfo = new HashMap<Long, Set<Long>>(16);
        DataSet finApBills = QueryServiceHelper.queryDataSet((String)"apfreeze", (String)"ap_finapbill", (String)"id,org.id,asstact.id,detailentry.corebillid,detailentry.e_conbillid,detailentry.e_expensebillids_tag,detailentry.e_pricetaxtotal,detailentry.unsettleamt", (QFilter[])new QFilter[]{new QFilter("detailentry.corebillid", "in", coreBillKeys.keySet()), new QFilter("iswrittenoff", "=", (Object)Boolean.FALSE), new QFilter("hadwrittenoff", "=", (Object)Boolean.FALSE)}, null);
        for (Row row : finApBills) {
            String matchKey;
            String expenseBillIds;
            BigDecimal pricetaxtotal = row.getBigDecimal("detailentry.e_pricetaxtotal");
            if (pricetaxtotal.compareTo(BigDecimal.ZERO) < 0 || (expenseBillIds = row.getString("detailentry.e_expensebillids_tag")) != null && !"".equals(expenseBillIds)) continue;
            Long orgId = row.getLong("org.id");
            BigDecimal unSettleAmt = row.getBigDecimal("detailentry.unsettleamt");
            Integer settleModel = (Integer)this.settleModelMap.get(orgId);
            if (settleModel == null) {
                settleModel = ArApHelper.getApSettleParam(orgId);
                this.settleModelMap.put(orgId, settleModel);
            }
            if (freeze && 1 == settleModel && unSettleAmt.compareTo(BigDecimal.ZERO) <= 0) continue;
            Long finApBillId = row.getLong("id");
            Long coreBillId = row.getLong("detailentry.corebillid");
            Long asstactId = row.getLong("asstact.id");
            Long masterId = (Long)this.supplierMasterIds.get(asstactId);
            if (masterId == null) {
                DynamicObject supplier = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_supplier", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)asstactId)});
                if (supplier == null) continue;
                masterId = supplier.getLong("masterid");
                this.supplierMasterIds.put(supplier.getLong("id"), masterId);
            }
            if (!(matchKey = coreBillId + "_" + orgId + "_" + masterId).equals(coreBillKeys.get(coreBillId))) continue;
            HashSet<Long> coreBillIds = (HashSet<Long>)finApFreezeInfo.get(finApBillId);
            if (coreBillIds == null) {
                coreBillIds = new HashSet<Long>(16);
                coreBillIds.add(coreBillId);
                finApFreezeInfo.put(finApBillId, coreBillIds);
                continue;
            }
            coreBillIds.add(coreBillId);
        }
        return finApFreezeInfo;
    }

    protected String getBillEntity() {
        return "pm_purorderbill";
    }
}

