/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.freeze.selector;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.enums.OpRangeEnum;
import kd.fi.arapcommon.service.freeze.selector.IFreezeListProvider;
import kd.fi.arapcommon.service.freeze.vo.FreezeVO;

public class ApplyPayBillProvider
implements IFreezeListProvider {
    private String userId = String.valueOf(RequestContext.get().getCurrUserId());

    @Override
    public List<String> getSelector(boolean isEntryFreeze) {
        ArrayList<String> selector = new ArrayList<String>();
        selector.add("0 e_billentity");
        selector.add("0 e_freezestate");
        selector.add("id e_billid");
        selector.add("settleorg e_orge_org");
        selector.add("billno e_billno");
        selector.add("entry.e_asstacttype e_asstacttype");
        selector.add("entry.e_asstact e_asstact");
        selector.add("entry.e_asstact e_asstact_number");
        selector.add("paycurrency e_currency");
        selector.add("settlecurrency e_settlecurrency");
        selector.add("entry.seq e_lineno");
        selector.add("entry.e_approvedamt e_amount");
        selector.add("entry.e_approvedseleamt e_seleamount");
        selector.add("entry.e_approvedseleamt e_freezeamt");
        selector.add("entry.lockedamt e_lockedamt");
        if (isEntryFreeze) {
            selector.add("entry.id e_billentryid");
        }
        return selector;
    }

    @Override
    public List<String> billConvertLogSelector(boolean isEntryFreeze) {
        ArrayList<String> selector = new ArrayList<String>();
        selector.add("id");
        selector.add("billno");
        selector.add("freezestate");
        selector.add("settleorg");
        selector.add("entry");
        selector.add("entry.id");
        selector.add("entry.seq");
        selector.add("entry.e_asstacttype");
        selector.add("entry.e_asstact");
        selector.add("entry.e_freezestate");
        selector.add("entry.e_closestatus");
        return selector;
    }

    @Override
    public List<DynamicObject> billConvertFreezeLog(FreezeVO freezeVO) {
        ArrayList<DynamicObject> freezeLogs = new ArrayList<DynamicObject>(freezeVO.getBills().size());
        for (DynamicObject bill : freezeVO.getBills()) {
            DynamicObjectCollection dynamicObjectCollection = bill.getDynamicObjectCollection("entry");
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                if (freezeVO.isEntryFreeze() && !freezeVO.getEntryIds().contains(dynamicObject.get("id"))) continue;
                DynamicObject freezelogObject = BusinessDataServiceHelper.newDynamicObject((String)"ap_freezelog");
                freezelogObject.set("billstatus", (Object)"A");
                freezelogObject.set("creator", (Object)this.userId);
                if (freezeVO.isEntryFreeze()) {
                    freezelogObject.set("businessop", dynamicObject.get("e_freezestate"));
                    freezelogObject.set("oprange", (Object)OpRangeEnum.DETAIL.getValue());
                } else {
                    freezelogObject.set("businessop", bill.get("freezestate"));
                    freezelogObject.set("oprange", (Object)OpRangeEnum.WHOLEORDER.getValue());
                }
                freezelogObject.set("billtype", (Object)bill.getDataEntityType().getName());
                freezelogObject.set("billno", bill.get("billno"));
                freezelogObject.set("asstacttype", dynamicObject.get("e_asstacttype"));
                freezelogObject.set("asstact", dynamicObject.get("e_asstact.id"));
                freezelogObject.set("lineno", dynamicObject.get("seq"));
                freezelogObject.set("freezereason", (Object)freezeVO.getFreezeMsg());
                freezelogObject.set("optime", (Object)new Date());
                freezelogObject.set("org", bill.get("settleorg.id"));
                freezelogObject.set("optype", (Object)freezeVO.getOpType());
                freezelogObject.set("billid", bill.get("id"));
                freezelogObject.set("billentryid", dynamicObject.get("id"));
                freezeLogs.add(freezelogObject);
            }
        }
        return freezeLogs;
    }

    @Override
    public LocaleString getAmountColumnProperty() {
        return new LocaleString(ResManager.loadKDString((String)"\u6838\u51c6\u91d1\u989d", (String)"ApplyPayBillProvider_0", (String)"fi-arapcommon", (Object[])new Object[0]));
    }

    @Override
    public LocaleString getLockAmtColumnProperty() {
        return new LocaleString(ResManager.loadKDString((String)"\u5173\u8054\u4ed8\u6b3e\u91d1\u989d", (String)"ApplyPayBillProvider_1", (String)"fi-arapcommon", (Object[])new Object[0]));
    }
}

