/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.freeze.template;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.arapcommon.enums.FreezeStateEnum;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.service.freeze.selector.FreezeListFactory;
import kd.fi.arapcommon.service.freeze.selector.IFreezeListProvider;
import kd.fi.arapcommon.service.freeze.vo.FreezeVO;
import kd.fi.arapcommon.util.EmptyUtils;

@Deprecated
public abstract class AbstractBillFreezeBase
extends AbstractBillPlugIn {
    protected void freezeDispose(FreezeVO freezeVO) {
        boolean isFreezeOp = "freeze".equals(freezeVO.getFreezeOpKey()) || "m_freeze".equals(freezeVO.getFreezeOpKey());
        String freezeState = isFreezeOp ? FreezeStateEnum.ALLFREEZE.getValue() : FreezeStateEnum.UNFREEZE.getValue();
        freezeVO.setFreezeState(freezeState);
        if (("freeze".equals(freezeVO.getFreezeOpKey()) || "m_freeze".equals(freezeVO.getFreezeOpKey())) && this.getFreezeWhySysParam(freezeVO.getOrgId()) || ("unfreeze".equals(freezeVO.getFreezeOpKey()) || "m_unfreeze".equals(freezeVO.getFreezeOpKey())) && this.getUnFreezeWhySysParam(freezeVO.getOrgId())) {
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("ap_freezelist");
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            fsp.setCustomParam("freezeVO", (Object)freezeVO);
            if (FreezeStateEnum.UNFREEZE.getValue().equals(freezeState)) {
                fsp.setCaption(ResManager.loadKDString((String)"\u89e3\u51bb\u4fe1\u606f", (String)"AbstractBillFreezeBase_0", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bar_freeze");
            fsp.setCloseCallBack(closeCallBack);
            this.getView().showForm(fsp);
            return;
        }
        this.handleBillWriteBack(freezeVO);
    }

    public void handleBillWriteBack(FreezeVO freezeVO) {
        IFreezeListProvider freezeListProvider = FreezeListFactory.getFreezeListProvider(freezeVO.getBillEntity());
        List<String> selector = freezeListProvider.billConvertLogSelector(freezeVO.isEntryFreeze());
        QFilter qFilter = new QFilter("id", "in", freezeVO.getPkIds());
        if (freezeVO.isEntryFreeze()) {
            qFilter.and(freezeVO.getEntryEntity() + ".id", "in", freezeVO.getEntryIds());
        }
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)freezeVO.getBillEntity(), (String)String.join((CharSequence)",", selector), (QFilter[])new QFilter[]{qFilter});
        freezeVO.setBills(Arrays.asList(bills));
        if (!freezeVO.isEntryFreeze()) {
            for (DynamicObject bill : freezeVO.getBills()) {
                bill.set(this.getFreezeStateEntity(), (Object)freezeVO.getFreezeState());
                DynamicObjectCollection entrys = bill.getDynamicObjectCollection(this.getEntryEntity());
                for (DynamicObject entry : entrys) {
                    entry.set(this.getEntryFreezeStateEntity(), (Object)freezeVO.getFreezeState());
                }
            }
        } else {
            for (DynamicObject bill : freezeVO.getBills()) {
                boolean isAllFreeze = true;
                DynamicObjectCollection entrys = bill.getDynamicObjectCollection(this.getEntryEntity());
                for (DynamicObject entry : entrys) {
                    if (freezeVO.getEntryIds().contains(entry.getLong("id"))) {
                        entry.set(this.getEntryFreezeStateEntity(), (Object)freezeVO.getFreezeState());
                    }
                    String entryFreezeState = entry.getString(this.getEntryFreezeStateEntity());
                    if (!isAllFreeze || entryFreezeState.equals(freezeVO.getFreezeState())) continue;
                    isAllFreeze = false;
                }
                String currentFreezeState = isAllFreeze ? freezeVO.getFreezeState() : FreezeStateEnum.PARTFREEZE.getValue();
                bill.set(this.getFreezeStateEntity(), (Object)currentFreezeState);
            }
        }
        this.updateBillFreezeState(freezeVO);
    }

    protected void updateBillFreezeState(FreezeVO freezeVO) {
        Throwable throwable = null;
        try (TXHandle h = TX.required((String)"billFreeze");){
            this.beginHandelDataTransaction(freezeVO);
            if (!freezeVO.isSuccess()) {
                this.getView().showErrorNotification(freezeVO.getMsg());
                return;
            }
            if (freezeVO.isNext()) {
                SaveServiceHelper.update((DynamicObject[])freezeVO.getBills().toArray(new DynamicObject[freezeVO.getBills().size()]));
                IFreezeListProvider freezeListProvider = FreezeListFactory.getFreezeListProvider(freezeVO.getBillEntity());
                List<DynamicObject> freezeLogs = freezeListProvider.billConvertFreezeLog(freezeVO);
                SaveServiceHelper.save((DynamicObject[])freezeLogs.toArray(new DynamicObject[0]));
            }
            this.endHandelDataTransaction(freezeVO);
            if (!freezeVO.isSuccess()) {
                this.getView().showErrorNotification(freezeVO.getMsg());
                return;
            }
        }
        catch (Exception ex) {
            this.rollbackHandelData(freezeVO);
            h.markRollback();
            throw ex;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        freezeVO.setMsg(ResManager.loadKDString((String)"\u51bb\u7ed3\u6210\u529f\u3002", (String)"AbstractBillFreezeBase_1", (String)"fi-arapcommon", (Object[])new Object[0]));
        if (FreezeStateEnum.UNFREEZE.getValue().equals(freezeVO.getFreezeState())) {
            freezeVO.setMsg(ResManager.loadKDString((String)"\u89e3\u51bb\u6210\u529f\u3002", (String)"AbstractBillFreezeBase_2", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        this.getView().showSuccessNotification(freezeVO.getMsg(), Integer.valueOf(5000));
        this.getView().invokeOperation("refresh");
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        String actionId = closedCallBackEvent.getActionId();
        if (returnData == null) {
            return;
        }
        if ("bar_freeze".equals(actionId)) {
            FreezeVO freezeVO = (FreezeVO)returnData.get("freezeVO");
            this.handleBillWriteBack(freezeVO);
        }
    }

    protected void searchFreezeLog(List<String> ids) {
        QFilter qfilter = new QFilter("billid", "in", ids);
        DynamicObject[] freezeLogs = BusinessDataServiceHelper.load((String)"ap_freezelog", (String)"id,org", (QFilter[])new QFilter[]{qfilter});
        if (freezeLogs.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u51bb\u7ed3\u65e5\u5fd7\u3002", (String)"AbstractBillFreezeBase_3", (String)"fi-arapcommon", (Object[])new Object[0]));
            return;
        }
        if (EmptyUtils.isEmpty(freezeLogs[0].get("org"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u4e1a\u52a1\u7ec4\u7ec7\u4e3a\u7a7a\u3002", (String)"AbstractBillFreezeBase_4", (String)"fi-arapcommon", (Object[])new Object[0]));
            return;
        }
        Long userId = RequestContext.get().getCurrUserId();
        int hasPermResult = PermissionServiceHelper.checkPermission((Long)userId, (Long)freezeLogs[0].getLong("org.id"), (String)"+HKZHSKFXOX", (String)"ap_freezelog", (String)"47150e89000000ac");
        if (hasPermResult != 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u4e1a\u52a1\u5bf9\u8c61\u201c\u51bb\u7ed3\u65e5\u5fd7\u201d\u7684\u201c\u67e5\u8be2\u201d\u529f\u80fd\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AbstractBillFreezeBase_5", (String)"fi-arapcommon", (Object[])new Object[0]));
            return;
        }
        ListShowParameter lsp = new ListShowParameter();
        ListFilterParameter lfp = new ListFilterParameter();
        lsp.setBillFormId("ap_freezelog");
        lfp.setFilter(qfilter);
        lsp.setCustomParam("initOrg", freezeLogs[0].get("org.id"));
        lsp.setListFilterParameter(lfp);
        lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        lsp.setHasRight(true);
        this.getView().showForm((FormShowParameter)lsp);
    }

    protected abstract String getBarFreezeEntity();

    protected abstract String getBarUnFreezeEntity();

    protected abstract String getBarSearchLogEntity();

    protected abstract String getOrgEntity();

    protected abstract String getFreezeStateEntity();

    protected abstract String getEntryFreezeStateEntity();

    protected abstract String getFreezeWhySysParamEntity();

    protected abstract String getUnFreezeWhySysParamEntity();

    protected abstract String getEntryEntity();

    protected boolean getFreezeWhySysParam(long orgId) {
        Object settleParam = ArApHelper.getParameter(orgId, this.getFreezeWhySysParamEntity(), false);
        return (Boolean)settleParam;
    }

    protected boolean getUnFreezeWhySysParam(long orgId) {
        Object settleParam = ArApHelper.getParameter(orgId, this.getUnFreezeWhySysParamEntity(), false);
        return (Boolean)settleParam;
    }

    protected abstract void beginHandelDataTransaction(FreezeVO var1);

    protected abstract void rollbackHandelData(FreezeVO var1);

    protected abstract void endHandelDataTransaction(FreezeVO var1);
}

