/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.freeze.template;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.enums.FreezeStateEnum;
import kd.fi.arapcommon.service.concurrency.ConcurrencyCtrlUtil;
import kd.fi.arapcommon.service.freeze.FreezeServiceHelper;
import kd.fi.arapcommon.service.freeze.vo.FreezeVO;

public abstract class AbstractBillFreezeList
extends AbstractListPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{this.getBarSearchLogEntity()});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if ("freeze".equals(key) || "unfreeze".equals(key)) {
            args.setCancel(this.freezeOpValidator(key));
        }
        if ("unaudit".equals(key) && this.getPageCache().get("operationConfirm") == null) {
            boolean cancel;
            if (this.freezeOpValidator(key)) {
                args.setCancel(true);
                return;
            }
            BillList billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            DynamicObjectCollection freezeBills = this.getFreezeBill(selectedRows.getPrimaryKeyValues(), billList.getEntityType().getName());
            boolean bl = cancel = !freezeBills.isEmpty();
            if (cancel) {
                FreezeServiceHelper freezeServiceHelper = new FreezeServiceHelper(this.getView());
                cancel = freezeServiceHelper.unAuditOpConfirm((IFormPlugin)this, freezeBills, this.getOrgEntity(), this.getFreezeStateEntity(), this.getUnAuditAutoUnFreezeSysParamEntity());
            }
            args.setCancel(cancel);
        }
    }

    protected DynamicObjectCollection getFreezeBill(Object[] selectedRowIds, String entityName) {
        String[] freezeStates = new String[]{FreezeStateEnum.ALLFREEZE.getValue(), FreezeStateEnum.PARTFREEZE.getValue()};
        return QueryServiceHelper.query((String)entityName, (String)("id,billno," + this.getOrgEntity() + "," + this.getFreezeStateEntity()), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)selectedRowIds), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()), new QFilter(this.getFreezeStateEntity(), "in", (Object)freezeStates)});
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        if ("unaudit".equals(key)) {
            this.getPageCache().remove("operationConfirm");
        }
        if (args.getOperationResult() == null || !"freeze".equals(key) && !"unfreeze".equals(key)) {
            return;
        }
        this.getView().showLoading(null);
        OperationResult operationResult = args.getOperationResult();
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection listSelectedRowCollection = listview.getSelectedRows();
        ArrayList<Object> ids = new ArrayList<Object>(listSelectedRowCollection.size());
        FreezeVO freezeVO = new FreezeVO();
        freezeVO.setEntryEntity(this.getEntryEntity());
        freezeVO.setOrgId((Long)this.getView().getFormShowParameter().getCustomParam("freezeOrgId"));
        if (!operationResult.isSuccess() && operationResult.getSuccessPkIds().size() < 1) {
            this.getView().hideLoading();
            return;
        }
        if (!operationResult.isSuccess() && operationResult.getSuccessPkIds().size() > 0) {
            ids.addAll(operationResult.getSuccessPkIds());
            freezeVO.setShowMessage(false);
        } else {
            ids.addAll(listSelectedRowCollection.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList()));
        }
        String billEntityNumber = listview.getBillFormId();
        String billFormId = FormMetadataCache.getFormConfig((String)billEntityNumber).getEntityTypeId();
        FreezeServiceHelper freezeServiceHelper = new FreezeServiceHelper(this.getView());
        freezeServiceHelper.convertFreezeVO(freezeVO, key, ids, billFormId);
        String message = this.autoFreezeValidator(key, freezeVO);
        if (message != null) {
            this.getView().hideLoading();
            return;
        }
        freezeServiceHelper.freezeDispose(freezeVO, this.getFreezeWhySysParamEntity(), this.getUnFreezeWhySysParamEntity(), operationResult, (IFormPlugin)this);
        if (!freezeVO.isNext()) {
            this.getView().hideLoading();
            return;
        }
        this.updateBillFreezeState(freezeVO);
    }

    protected abstract String autoFreezeValidator(String var1, FreezeVO var2);

    protected void updateBillFreezeState(FreezeVO freezeVO) {
        FreezeServiceHelper freezeServiceHelper = new FreezeServiceHelper(this.getView());
        freezeServiceHelper.reloadBill(freezeVO, this.getOrgEntity());
        try (TXHandle h = TX.required((String)"billFreeze");){
            this.beginHandelDataTransaction(freezeVO);
            if (!freezeVO.isNext() && !freezeVO.isSuccess()) {
                this.getView().hideLoading();
                this.getView().showErrorNotification(freezeVO.getMsg());
                return;
            }
            try {
                List<DynamicObject> freezeBills = freezeVO.getBills();
                Set<Long> billIds = freezeBills.stream().map(v -> v.getLong("id")).collect(Collectors.toSet());
                ConcurrencyCtrlUtil.addCtrlInTX(freezeVO.getBillEntity(), "freeze_lock", billIds, false);
                String freezeStatus = freezeVO.getFreezeState();
                String entity = freezeVO.getBillEntity();
                DynamicObjectCollection bills = QueryServiceHelper.query((String)entity, (String)"billno,freezestate", (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
                for (DynamicObject bill : bills) {
                    if (!bill.getString("freezestate").equals(freezeStatus)) continue;
                    String message = "allfreeze".equals(freezeStatus) ? String.format(ResManager.loadKDString((String)"\u5355\u636e%s\uff1a\u672a\u51bb\u7ed3\u7684\u6570\u636e\u624d\u53ef\u4ee5\u51bb\u7ed3\u3002", (String)"AbstractBillFreezeList_5", (String)"fi-arapcommon", (Object[])new Object[0]), bill.getString("billno")) : String.format(ResManager.loadKDString((String)"\u5355\u636e%s\uff1a\u5df2\u51bb\u7ed3\u7684\u6570\u636e\u624d\u53ef\u4ee5\u89e3\u51bb\u3002", (String)"AbstractBillFreezeList_6", (String)"fi-arapcommon", (Object[])new Object[0]), bill.getString("billno"));
                    throw new KDBizException(message);
                }
                freezeServiceHelper.setBillFeezeState(freezeVO, this.getFreezeStateEntity(), this.getEntryEntity(), this.getEntryFreezeStateEntity());
                freezeServiceHelper.updateBillAndSaveFreezeLog(freezeVO);
            }
            catch (Exception ex) {
                this.getView().hideLoading();
                this.rollbackHandelData(freezeVO);
                h.markRollback();
                throw ex;
            }
        }
        freezeVO.setMsg(ResManager.loadKDString((String)"\u51bb\u7ed3\u6210\u529f\u3002", (String)"AbstractBillFreezeEdit_1", (String)"fi-arapcommon", (Object[])new Object[0]));
        if (FreezeStateEnum.UNFREEZE.getValue().equals(freezeVO.getFreezeState())) {
            freezeVO.setMsg(ResManager.loadKDString((String)"\u89e3\u51bb\u6210\u529f\u3002", (String)"AbstractBillFreezeEdit_2", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        this.getView().showSuccessNotification(freezeVO.getMsg(), Integer.valueOf(5000));
        this.getView().invokeOperation("refresh");
        this.getView().hideLoading();
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (this.getBarSearchLogEntity().equals(key)) {
            IListView listview = (IListView)this.getView();
            ListSelectedRowCollection selectedRows = listview.getSelectedRows();
            if (selectedRows.size() == 0) {
                listview.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"AbstractBillFreezeList_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                return;
            }
            if (selectedRows.size() != 1) {
                listview.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u6761\u6570\u636e\u8054\u67e5\u3002", (String)"AbstractBillFreezeList_1", (String)"fi-arapcommon", (Object[])new Object[0]));
                return;
            }
            FreezeServiceHelper freezeServiceHelper = new FreezeServiceHelper(this.getView());
            freezeServiceHelper.searchFreezeLog(Collections.singletonList(String.valueOf(selectedRows.get(0).getPrimaryKeyValue())));
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (e.getReturnData() == null) {
            return;
        }
        if ("bar_freeze".equals(actionId)) {
            Map returnData = (Map)e.getReturnData();
            FreezeVO freezeVO = (FreezeVO)returnData.get("freezeVO");
            this.updateBillFreezeState(freezeVO);
        }
        if ("operationConfirm".equals(actionId)) {
            this.getView().getPageCache().put("operationConfirm", "ok");
            this.getView().invokeOperation("unaudit");
        }
    }

    private boolean freezeOpValidator(String key) {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] pks = selectedRows.getPrimaryKeyValues();
        if (pks.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"AbstractBillFreezeList_2", (String)"fi-arapcommon", (Object[])new Object[0]));
            return true;
        }
        if ("unaudit".equals(key)) {
            return false;
        }
        DynamicObject[] bills = BusinessDataServiceHelper.load((Object[])selectedRows.getPrimaryKeyValues(), (DynamicObjectType)billList.getEntityType());
        long orgId = bills[0].getLong(this.getOrgEntity() + ".id");
        for (DynamicObject bill : bills) {
            if (bill.getLong(this.getOrgEntity() + ".id") == orgId) continue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76f8\u540c\u7ec4\u7ec7\u7684\u5355\u636e\u3002", (String)"AbstractBillFreezeList_3", (String)"fi-arapcommon", (Object[])new Object[0]));
            return true;
        }
        this.getView().getFormShowParameter().setCustomParam("freezeOrgId", (Object)orgId);
        return false;
    }

    protected abstract String getBarFreezeEntity();

    protected abstract String getBarUnFreezeEntity();

    protected abstract String getBarSearchLogEntity();

    protected abstract String getOrgEntity();

    protected abstract String getFreezeStateEntity();

    protected abstract String getEntryFreezeStateEntity();

    protected abstract String getFreezeWhySysParamEntity();

    protected abstract String getUnFreezeWhySysParamEntity();

    protected abstract String getUnAuditAutoUnFreezeSysParamEntity();

    protected abstract String getEntryEntity();

    protected abstract void beginHandelDataTransaction(FreezeVO var1);

    protected abstract void rollbackHandelData(FreezeVO var1);
}

