/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.helper;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.LineTypeHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.service.plan.split.PlanSplitAndBuilder;
import kd.fi.arapcommon.service.plan.split.helper.ConditionServiceHelper;

public class APremiumConvertServiceHelper {
    private static final Log logger = LogFactory.getLog(APremiumConvertServiceHelper.class);

    public static void pushAndSave(DynamicObject apFinBill) {
        DynamicObject[] premiun;
        BigDecimal premiumAmt = apFinBill.getBigDecimal("premiumamt");
        if (premiumAmt.compareTo(BigDecimal.ZERO) != 0 && !apFinBill.getBoolean("ispremium") && (premiun = BOTPHelper.push("ap_finapbill", "ap_finapbill", "742441181224392704", apFinBill, false)).length > 0) {
            for (DynamicObject premiunBill : premiun) {
                long billTypeId;
                DynamicObject bizTypeDym;
                long orgId = premiunBill.getLong("org.id");
                Boolean isLineType = LineTypeHelper.getParam(orgId, false);
                if (isLineType.booleanValue() && (bizTypeDym = LineTypeHelper.getDefaultBizType(billTypeId = premiunBill.getLong("billtypeid.id"))) != null) {
                    premiunBill.set("biztype", (Object)bizTypeDym);
                    long lineTypeId = LineTypeHelper.getDefaultLineTypeId(bizTypeDym.getLong("id"));
                    DynamicObject lineType = LineTypeHelper.getLineTypebyId(lineTypeId);
                    DynamicObjectCollection entry = premiunBill.getDynamicObjectCollection("detailentry");
                    for (DynamicObject row : entry) {
                        row.set("linetype", (Object)lineType);
                    }
                }
                Date basicDate = ConditionServiceHelper.getBasicDate(premiunBill);
                premiunBill.set("termsdate", (Object)basicDate);
                APremiumConvertServiceHelper.setDetailEntry(premiunBill, apFinBill);
                APremiumConvertServiceHelper.setPlanEntry(premiunBill);
                APremiumConvertServiceHelper.setHeadDueDate(premiunBill);
            }
            long orgPk = apFinBill.getDynamicObject("org").getLong("id");
            boolean premiumCheck = SystemParameterHelper.getAPBooleanParam(orgPk, "ap_auditpre");
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"ap_finapbill", (DynamicObject[])premiun, (OperateOption)option);
            APremiumConvertServiceHelper.addAssertResult(saveResult, "save");
            if (premiumCheck) {
                OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"ap_finapbill", (Object[])saveResult.getSuccessPkIds().toArray(), (OperateOption)option);
                APremiumConvertServiceHelper.addAssertResult(submitResult, "submit");
                OperateOption auditOp = OperateOption.create();
                auditOp.setVariableValue("WF", "false");
                option.setVariableValue("ishasright", "true");
                OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"ap_finapbill", (Object[])submitResult.getSuccessPkIds().toArray(), (OperateOption)auditOp);
                APremiumConvertServiceHelper.addAssertResult(auditResult, "audit");
            }
        }
    }

    private static void setDetailEntry(DynamicObject premiunBill, DynamicObject apFinBill) {
        DynamicObjectCollection entries = premiunBill.getDynamicObjectCollection("detailentry");
        if (!ObjectUtils.isEmpty((Object)entries)) {
            Iterator iterator = entries.iterator();
            while (iterator.hasNext()) {
                DynamicObject entry = (DynamicObject)iterator.next();
                BigDecimal e_pricetaxtotal = entry.getBigDecimal("e_pricetaxtotal");
                if (e_pricetaxtotal.compareTo(BigDecimal.ZERO) != 0) continue;
                iterator.remove();
            }
        }
        DynamicObject srcEntry = (DynamicObject)apFinBill.getDynamicObjectCollection("detailentry").get(0);
        String coreBillType = srcEntry.getString("corebilltype");
        Long srcCoreBillId = srcEntry.getLong("corebillid");
        String coreBillNo = srcEntry.getString("corebillno");
        Long coreBillEntryId = srcEntry.getLong("corebillentryid");
        Long conBillId = srcEntry.getLong("e_conbillid");
        Long conBillEntryId = srcEntry.getLong("e_conbillentryid");
        DynamicObjectCollection preBillEntrys = premiunBill.getDynamicObjectCollection("detailentry");
        if (srcCoreBillId != 0L) {
            for (DynamicObject entry : preBillEntrys) {
                entry.set("corebilltype", (Object)coreBillType);
                entry.set("corebillid", (Object)srcCoreBillId);
                entry.set("corebillno", (Object)coreBillNo);
                entry.set("corebillentryid", (Object)coreBillEntryId);
            }
        }
        if (conBillId != 0L) {
            for (DynamicObject entry : preBillEntrys) {
                entry.set("e_conbillid", (Object)conBillId);
                entry.set("e_conbillentryid", (Object)conBillEntryId);
            }
        }
    }

    private static void setPlanEntry(DynamicObject premiunBill) {
        PlanSplitAndBuilder.splitAndBuild(premiunBill);
    }

    private static void setHeadDueDate(DynamicObject premiunBill) {
        Date planMaxDuedate = premiunBill.getDate("duedate");
        DynamicObjectCollection planEntries = premiunBill.getDynamicObjectCollection("planentity");
        for (DynamicObject planEntry : planEntries) {
            Date planEntryDueDate = planEntry.getDate("planduedate");
            if (planMaxDuedate == null) {
                planMaxDuedate = planEntryDueDate;
                continue;
            }
            if (planEntryDueDate == null) continue;
            planMaxDuedate = planEntryDueDate.after(planMaxDuedate) ? planEntryDueDate : planMaxDuedate;
        }
        premiunBill.set("duedate", (Object)planMaxDuedate);
    }

    public static void addAssertResult(OperationResult result, String operation) {
        List validateInfos = result.getAllErrorOrValidateInfo();
        StringBuilder sb = new StringBuilder();
        if (!result.isSuccess()) {
            try {
                OperationHelper.assertResult(result);
            }
            catch (Exception e) {
                if (validateInfos.isEmpty()) {
                    sb.append(result.getMessage());
                } else {
                    for (IOperateInfo err : validateInfos) {
                        sb.append(err.getMessage()).append('\n');
                    }
                }
                switch (operation) {
                    case "save": {
                        String errMsg = ResManager.loadKDString((String)"\u8d28\u4fdd\u91d1\u5355\u636e\u4fdd\u5b58\u5931\u8d25\uff1a%s", (String)"APremiumConvertServiceHelper_0", (String)"fi-arapcommon", (Object[])new Object[]{sb.toString()});
                        ErrorCode errorCode = new ErrorCode("save_err", errMsg);
                        throw new KDBizException(errorCode, new Object[0]);
                    }
                    case "submit": {
                        logger.info("\u8d28\u4fdd\u91d1\u63d0\u4ea4\u5931\u8d25:" + sb);
                        String errMsg = ResManager.loadKDString((String)"\u8d28\u4fdd\u91d1\u5355\u636e\u63d0\u4ea4\u5931\u8d25\uff1a%s", (String)"APremiumConvertServiceHelper_1", (String)"fi-arapcommon", (Object[])new Object[]{sb.toString()});
                        ErrorCode errorCode = new ErrorCode("submit_err", errMsg);
                        throw new KDBizException(errorCode, new Object[0]);
                    }
                    case "audit": {
                        logger.info("\u8d28\u4fdd\u91d1\u5ba1\u6838\u5931\u8d25:" + sb);
                        String errMsg = ResManager.loadKDString((String)"\u8d28\u4fdd\u91d1\u5355\u636e\u5ba1\u6838\u5931\u8d25\uff1a%s", (String)"APremiumConvertServiceHelper_2", (String)"fi-arapcommon", (Object[])new Object[]{sb.toString()});
                        ErrorCode errorCode = new ErrorCode("audit_err", errMsg);
                        throw new KDBizException(errorCode, new Object[0]);
                    }
                }
            }
        }
    }
}

