/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.dlock.DLock;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.service.concurrency.ConcurrencyCtrlUtil;
import kd.fi.arapcommon.service.concurrency.IBillConcurrencyCtrlStrategy;
import kd.fi.arapcommon.service.concurrency.SettleLockCtrlContext;
import kd.fi.arapcommon.service.helper.SettleRecordOpHelper;
import kd.fi.arapcommon.service.settle.SettleRecordManager;
import kd.fi.arapcommon.service.settle.SettleVersionServiceHelper;
import kd.fi.arapcommon.service.settle.convert.SettleRecordConverter;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StdConfig;
import kd.fi.arapcommon.util.StringUtils;
import kd.fi.arapcommon.vo.BillSettleVO;
import kd.fi.arapcommon.vo.SettleRecordEntryVO;
import kd.fi.arapcommon.vo.SettleRecordVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public class CommonSettleServiceHelper {
    private static final Log logger = LogFactory.getLog(CommonSettleServiceHelper.class);

    public static List<Object> saveSettleRecord(DynamicObject[] results, boolean isAr) {
        DynamicObject org;
        String settleRecordEntity = isAr ? "ar_settlerecord" : "ap_settlerecord";
        String settleSeq = CodeRuleServiceHelper.getNumber((String)settleRecordEntity, (DynamicObject)results[0], (String)(org = results[0].getDynamicObject("org")).getPkValue().toString());
        if (ObjectUtils.isEmpty((Object)settleSeq)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ed3\u7b97\u8bb0\u5f55\u6ca1\u6709\u542f\u7528\u7684\u7f16\u7801\u89c4\u5219\u3002", (String)"SettleServiceHelper_0", (String)"fi-ap-mservice", (Object[])new Object[0]));
        }
        String initEntity = isAr ? "ar_init" : "ap_init";
        DynamicObject init = BusinessDataServiceHelper.loadSingle((String)initEntity, (String)"id,standardcurrency,settleseq", (QFilter[])new QFilter[]{new QFilter("org", "=", org.getPkValue())});
        try {
            for (DynamicObject result : results) {
                result.set("settleseq", (Object)Integer.valueOf(settleSeq));
                result.set("basecurrency", (Object)init.getDynamicObject("standardcurrency"));
            }
        }
        catch (NumberFormatException e) {
            CommonSettleServiceHelper.errorMsg();
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("mutex_writeback", "false");
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)settleRecordEntity, (DynamicObject[])results, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(saveResult);
        boolean isSubmitSettle = isAr ? SystemParameterHelper.getARBooleanParam(org.getLong("id"), "ar_016") : SystemParameterHelper.getAPBooleanParam(org.getLong("id"), "ap_016");
        String settleRelation = results[0].getString("settlerelation");
        List<DynamicObject> resultList = CommonSettleServiceHelper.filterSubmitSettleRecord(saveResult.getSuccessPkIds(), isAr, isSubmitSettle, settleRelation);
        if (resultList.size() > 0) {
            SettleRecordOpHelper.auditSettleRecord(resultList, settleRecordEntity);
        }
        return saveResult.getSuccessPkIds();
    }

    private static void errorMsg() {
        throw new KDBizException(ResManager.loadKDString((String)"\u7ed3\u7b97\u8bb0\u5f55\u7f16\u7801\u89c4\u5219\u5df2\u88ab\u4fee\u6539\uff0c\u65e0\u6cd5\u7ed3\u7b97\u3002", (String)"SettleServiceHelper_1", (String)"fi-arapcommon", (Object[])new Object[0]));
    }

    private static List<DynamicObject> filterSubmitSettleRecord(List<Object> resultIds, boolean isAr, boolean isSubmitSettle, String settleRelation) {
        String settleRecordEntity = isAr ? "ar_settlerecord" : "ap_settlerecord";
        DynamicObject[] results = BusinessDataServiceHelper.load((String)settleRecordEntity, (String)"id,mainbillid", (QFilter[])new QFilter[]{new QFilter("id", "in", resultIds)});
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>(Arrays.asList(results));
        if (isSubmitSettle && (SettleRelationEnum.APPAYSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.RECSETTLE.getValue().equals(settleRelation))) {
            Long mainBillId;
            HashSet<Long> billIdSet = new HashSet<Long>(64);
            for (DynamicObject result : results) {
                mainBillId = result.getLong("mainbillid");
                billIdSet.add(mainBillId);
            }
            String mainEntity = isAr ? "ar_finarbill" : "ap_finapbill";
            List mainIds = QueryServiceHelper.queryPrimaryKeys((String)mainEntity, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)billIdSet.toArray()), new QFilter("billstatus", "=", (Object)"B")}, (String)"", (int)-1);
            Iterator iterator = resultList.iterator();
            while (iterator.hasNext()) {
                DynamicObject result;
                result = (DynamicObject)iterator.next();
                mainBillId = result.getLong("mainbillid");
                if (!mainIds.contains(mainBillId)) continue;
                iterator.remove();
            }
        }
        return resultList;
    }

    public static List<SettleRecordVO> settle(List<BillSettleVO> mainList, List<BillSettleVO> asstList, SettleSchemeVO scheme, String settleType) {
        ArrayList<SettleRecordVO> resultList = new ArrayList<SettleRecordVO>(mainList.size());
        ArrayList<BillSettleVO> oldList = new ArrayList<BillSettleVO>(mainList.size());
        ArrayList<BillSettleVO> newList = new ArrayList<BillSettleVO>(mainList.size());
        boolean allowNewSettleByOrg = SettleVersionServiceHelper.isAllowNewSettleByOrg(mainList.get(0).getOrgId());
        boolean newCustomerUseNewSettle = SettleVersionServiceHelper.isNewCustomerUseNewSettle();
        logger.info("CommonSettleServiceHelper.settle newCustomerUseNewSettle:" + newCustomerUseNewSettle);
        for (BillSettleVO billSettleVO : mainList) {
            if (newCustomerUseNewSettle) {
                newList.add(billSettleVO);
                continue;
            }
            if ("0".equals(billSettleVO.getSettleVersion()) || "".equals(billSettleVO.getSettleVersion())) {
                oldList.add(billSettleVO);
                continue;
            }
            if (allowNewSettleByOrg) {
                newList.add(billSettleVO);
                continue;
            }
            oldList.add(billSettleVO);
        }
        if (oldList.size() > 0) {
            List<SettleRecordVO> oldSettleRecords = SettleRecordManager.buildSettleRecord(oldList, asstList, scheme, settleType);
            resultList.addAll(oldSettleRecords);
        }
        if (newList.size() > 0) {
            List<SettleRecordVO> newSettleRecords = SettleRecordManager.buildSettleRecord(newList, asstList, scheme, settleType);
            resultList.addAll(newSettleRecords);
        }
        return resultList;
    }

    public static List<SettleRecordVO> settleSelf(List<BillSettleVO> mainList, List<BillSettleVO> asstList, SettleSchemeVO scheme, String settleType) {
        return CommonSettleServiceHelper.settle(mainList, asstList, scheme, settleType);
    }

    public static List<SettleRecordVO> diffCurrencySettle(List<BillSettleVO> mainList, List<BillSettleVO> asstList, SettleSchemeVO scheme, String settleType) {
        return SettleRecordManager.buildDiffCurrencySettleRecord(mainList, asstList, scheme, settleType);
    }

    public static DynamicObject[] converVO2Dyn(List<SettleRecordVO> resultList, boolean isAr) {
        return SettleRecordConverter.convertVO2Dyn(resultList, isAr);
    }

    public static SettleRecordVO converDyn2VO(DynamicObject result) {
        return SettleRecordConverter.convertDyn2VO(result);
    }

    public static void resolveSwapPL(SettleRecordVO settleRecord, SettleSchemeVO scheme) {
        boolean sameDirection = true;
        if (scheme.isSettleSelf()) {
            sameDirection = false;
        } else {
            String settleRelation = settleRecord.getSettleRela();
            if (SettleRelationEnum.ARPAYSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.APRECSETTLE.getValue().equals(settleRelation)) {
                sameDirection = false;
            }
        }
        BigDecimal mainLocalTotalSettleamt = settleRecord.getLocalTotalSettleamt();
        BigDecimal asstTotalLocSettleAmt = BigDecimal.ZERO;
        List<SettleRecordEntryVO> entrys = settleRecord.getEntrys();
        for (SettleRecordEntryVO entry : entrys) {
            BigDecimal localSettleAmt = entry.getLocalSettleAmt();
            asstTotalLocSettleAmt = asstTotalLocSettleAmt.add(localSettleAmt);
        }
        BigDecimal mainSwapPL = sameDirection ? asstTotalLocSettleAmt.subtract(mainLocalTotalSettleamt) : mainLocalTotalSettleamt.negate().subtract(asstTotalLocSettleAmt);
        settleRecord.setSwapPL(mainSwapPL);
        BigDecimal asstTotalSwapPL = mainSwapPL.negate();
        BigDecimal remainAsstTotalSwapPL = BigDecimal.ZERO;
        String mainQuotation = settleRecord.getQuotation();
        BigDecimal mainExchangeRate = settleRecord.getExchangeRate();
        int mainPrecision = settleRecord.getBasePrecision() == null ? 2 : settleRecord.getBasePrecision();
        int entryCount = 0;
        for (SettleRecordEntryVO entry : entrys) {
            if (++entryCount == entrys.size()) {
                entry.setSwapPL(asstTotalSwapPL.subtract(remainAsstTotalSwapPL));
                continue;
            }
            BigDecimal asstSettleAmt = entry.getSettleAmt();
            BigDecimal asstSettleAmtByMainExchange = CommonSettleServiceHelper.getLocamtByQuotation(mainQuotation, asstSettleAmt, mainExchangeRate, mainPrecision);
            BigDecimal asstSettleAmtByAsstExchange = CommonSettleServiceHelper.getLocamtByQuotation(entry.getQuotation(), asstSettleAmt, entry.getExchangeRate(), entry.getBasePrecision() == null ? 2 : entry.getBasePrecision());
            BigDecimal asstSwapPL = asstSettleAmtByMainExchange.subtract(asstSettleAmtByAsstExchange);
            entry.setSwapPL(asstSwapPL);
            remainAsstTotalSwapPL = remainAsstTotalSwapPL.add(asstSwapPL);
        }
    }

    public static void resolveSwapPLForDiffCurrencySettle(SettleRecordVO settleRecord, SettleSchemeVO scheme) {
        List<SettleRecordEntryVO> entrys = settleRecord.getEntrys();
        BigDecimal asstTotalLocalSettleAmt = BigDecimal.ZERO;
        for (SettleRecordEntryVO entry : entrys) {
            BigDecimal localSettleAmt = entry.getLocalSettleAmt();
            asstTotalLocalSettleAmt = asstTotalLocalSettleAmt.add(localSettleAmt);
        }
        BigDecimal mainTotalLocalSettleAmt = settleRecord.getLocalTotalSettleamt();
        boolean sameDirection = CommonSettleServiceHelper.isSameDirection(settleRecord, scheme);
        BigDecimal mainCurrentTotalSwapPL = sameDirection ? asstTotalLocalSettleAmt.subtract(mainTotalLocalSettleAmt) : mainTotalLocalSettleAmt.negate().subtract(asstTotalLocalSettleAmt);
        settleRecord.setSwapPL(mainCurrentTotalSwapPL);
        BigDecimal asstCurrentTotalSwapPL = mainCurrentTotalSwapPL.negate();
        BigDecimal asstRemainSwapPL = BigDecimal.ZERO;
        int entrySize = entrys.size();
        for (int i = 1; i <= entrySize; ++i) {
            BigDecimal proportionEntry;
            SettleRecordEntryVO entry = entrys.get(i - 1);
            BigDecimal entryLocalSettleAmt = entry.getLocalSettleAmt();
            BigDecimal bigDecimal = proportionEntry = asstTotalLocalSettleAmt.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : entryLocalSettleAmt.divide(asstTotalLocalSettleAmt, 12, RoundingMode.HALF_UP);
            if (i == entrySize) {
                entry.setSwapPL(asstCurrentTotalSwapPL.subtract(asstRemainSwapPL));
                continue;
            }
            BigDecimal asstCurrnetSwapPL = asstCurrentTotalSwapPL.multiply(proportionEntry).setScale((int)entry.getBasePrecision(), RoundingMode.HALF_UP);
            entry.setSwapPL(asstCurrnetSwapPL);
            asstRemainSwapPL = asstRemainSwapPL.add(asstCurrnetSwapPL);
        }
    }

    public static boolean isSameDirection(SettleRecordVO settleRecord, SettleSchemeVO scheme) {
        boolean sameDirection = true;
        if (scheme.isSettleSelf()) {
            sameDirection = false;
        } else {
            String settleRelation = settleRecord.getSettleRela();
            if (SettleRelationEnum.ARPAYSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.APRECSETTLE.getValue().equals(settleRelation)) {
                sameDirection = false;
            }
        }
        return sameDirection;
    }

    public static void settleAddMutexCtrl(Set<Long> billIds, String billEntity, boolean needWait) {
        if (billIds == null || billIds.isEmpty() || StringUtils.isEmpty(billEntity)) {
            return;
        }
        HashSet<Long> lockBillIds = new HashSet<Long>(billIds);
        Set<Long> currentLockIds = SettleLockCtrlContext.currentLockIds();
        if (!currentLockIds.isEmpty()) {
            lockBillIds.removeAll(currentLockIds);
        }
        if (lockBillIds.isEmpty()) {
            return;
        }
        IBillConcurrencyCtrlStrategy mainCtrl = ConcurrencyCtrlUtil.addCtrl(billEntity, "settle", lockBillIds, needWait);
        SettleLockCtrlContext.setSettleLockCtrl(mainCtrl);
    }

    public static void settleAddMutexCtrl(Set<Long> mainIds, String mainEntity, Set<Long> asstIds, String asstEntity, boolean needWait) {
        Set<Long> currentLockIds;
        if (mainIds == null || StringUtils.isEmpty(mainEntity) || asstIds == null || StringUtils.isEmpty(asstEntity)) {
            return;
        }
        if (mainIds.isEmpty() && asstIds.isEmpty()) {
            return;
        }
        HashSet<Long> lockMainIds = new HashSet<Long>(mainIds);
        HashSet<Long> lockAsstIds = new HashSet<Long>(asstIds);
        if (mainEntity.equals(asstEntity)) {
            lockAsstIds.removeAll(lockMainIds);
        }
        if (!(currentLockIds = SettleLockCtrlContext.currentLockIds()).isEmpty()) {
            lockMainIds.removeAll(currentLockIds);
            lockAsstIds.removeAll(currentLockIds);
        }
        if (lockMainIds.isEmpty() && lockAsstIds.isEmpty()) {
            return;
        }
        IBillConcurrencyCtrlStrategy ctrlStrategy = ConcurrencyCtrlUtil.addCtrl("settle", mainEntity, asstEntity, lockMainIds, lockAsstIds, needWait);
        SettleLockCtrlContext.setSettleLockCtrl(ctrlStrategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void settleReleaseMutexCtrl() {
        String lockKey = RequestContext.get().getAccountId() + "-settleReleaseMutexCtrl";
        DLock lock = DLock.createReentrant((String)lockKey);
        lock.fastMode();
        try {
            lock.lock();
            List<IBillConcurrencyCtrlStrategy> settleLockCtrlList = SettleLockCtrlContext.getSettleLockCtrl();
            if (!ObjectUtils.isEmpty(settleLockCtrlList)) {
                for (IBillConcurrencyCtrlStrategy ctrl : settleLockCtrlList) {
                    if (ctrl == null) continue;
                    ctrl.releaseCtrl();
                }
            }
            SettleLockCtrlContext.remove();
        }
        finally {
            lock.unlock();
        }
    }

    public static void settleAddMutexCtrlInTX(Set<Long> mainIds, String mainEntity, Set<Long> asstIds, String asstEntity, boolean needWait) {
        if (!TX.inTX()) {
            logger.info("\u672c\u5730\u4e8b\u52a1\u6ca1\u6709\u5f00\u542f");
            return;
        }
        TX.addCommitListener((CommitListener)new CommitListener(){

            public void onEnded(boolean rollbacked) {
                CommonSettleServiceHelper.settleReleaseMutexCtrl();
            }
        });
        CommonSettleServiceHelper.settleAddMutexCtrl(mainIds, mainEntity, asstIds, asstEntity, needWait);
    }

    public static void settleAddMutexCtrlInTX(Set<Long> billIds, String billEntity, boolean needWait) {
        if (!TX.inTX()) {
            logger.info("\u672c\u5730\u4e8b\u52a1\u6ca1\u6709\u5f00\u542f");
            return;
        }
        TX.addCommitListener((CommitListener)new CommitListener(){

            public void onEnded(boolean rollbacked) {
                CommonSettleServiceHelper.settleReleaseMutexCtrl();
            }
        });
        CommonSettleServiceHelper.settleAddMutexCtrl(billIds, billEntity, needWait);
    }

    @Deprecated
    public static String getSettleSeq(Set<Long> mainBillIds, Date createTime) {
        String settleSeq = null;
        QFilter mainBillIdFilter = new QFilter("mainbillid", "in", mainBillIds);
        QFilter createTimeFilter = new QFilter("createtime", ">=", (Object)createTime);
        DynamicObject settleRecord = BusinessDataServiceHelper.loadSingle((String)"ap_settlerecord", (String)"id,settleseq", (QFilter[])new QFilter[]{mainBillIdFilter, createTimeFilter});
        if (EmptyUtils.isNotEmpty(settleRecord)) {
            settleSeq = settleRecord.getString("settleseq");
        }
        return settleSeq;
    }

    public static Set<Long> getSettleSeqs(Set<Long> mainBillIds, Date createTime) {
        DynamicObject[] settleRecords;
        HashSet<Long> settleSeqs = new HashSet<Long>(1);
        QFilter mainBillIdFilter = new QFilter("mainbillid", "in", mainBillIds);
        QFilter createTimeFilter = new QFilter("createtime", ">=", (Object)createTime);
        for (DynamicObject settleRecord : settleRecords = BusinessDataServiceHelper.load((String)"ap_settlerecord", (String)"id,settleseq", (QFilter[])new QFilter[]{mainBillIdFilter, createTimeFilter})) {
            settleSeqs.add(settleRecord.getLong("settleseq"));
        }
        return settleSeqs;
    }

    public static ListShowParameter getViewCurrentSettleRecordParam(String entity, String orgId, String settleSeqJson) {
        ListShowParameter listShowParameter = null;
        if (EmptyUtils.isNotEmpty(settleSeqJson)) {
            listShowParameter = new ListShowParameter();
            listShowParameter.setCustomParam("org", (Object)orgId);
            listShowParameter.setBillFormId(entity);
            listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            listShowParameter.setCustomParam("settleseq", (Object)settleSeqJson);
        }
        return listShowParameter;
    }

    public static ListShowParameter getViewHistorySettleRecordParam(String entity, String orgId) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId(entity);
        listShowParameter.setCustomParam("org", (Object)orgId);
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        return listShowParameter;
    }

    public static BigDecimal getLocamtByQuotation(String quotation, BigDecimal srcAmt, BigDecimal exchangeRate, int amtprecision) {
        if ("1".equals(quotation)) {
            return srcAmt.divide(exchangeRate, amtprecision, RoundingMode.HALF_UP);
        }
        return srcAmt.multiply(exchangeRate).setScale(amtprecision, RoundingMode.HALF_UP);
    }

    public static String getSettleRecordSelector() {
        ArrayList<String> selector = new ArrayList<String>(50);
        selector.add("id");
        selector.add("billno");
        selector.add("org");
        selector.add("billstatus");
        selector.add("settleseq");
        selector.add("isvoucher");
        selector.add("settletype");
        selector.add("settledate");
        selector.add("mainbillid");
        selector.add("mainbilltype");
        selector.add("maincurrency");
        selector.add("mainbillentryid");
        selector.add("totalsettleamt");
        selector.add("localtotalsettleamt");
        selector.add("exchangerate");
        selector.add("quotation");
        selector.add("swappl");
        selector.add("corebillid");
        selector.add("autosettletype");
        selector.add("corebillentryid");
        selector.add("settleentry");
        selector.add("billentity");
        selector.add("mainpayableamt");
        selector.add("settlerelation");
        selector.add("iswrittenoff");
        selector.add("hadwrittenoff");
        selector.add("basecurrency");
        selector.add("entry.billtype");
        selector.add("entry.currency");
        selector.add("entry.settleamt");
        selector.add("entry.e_billentity");
        selector.add("entry.billid");
        selector.add("entry.billentryid");
        selector.add("entry.e_swappl");
        selector.add("entry.e_exchangerate");
        selector.add("entry.e_settleentry");
        selector.add("entry.e_quotation");
        selector.add("entry.billnum");
        selector.add("entry.e_hadwrittenoff");
        selector.add("entry.payableamt");
        selector.add("entry.localsettleamt");
        return String.join((CharSequence)",", selector);
    }

    public static boolean isRedAllSettleRecord() {
        String isRedAllSettleRecord = StdConfig.get("isRedAllSettleRecord");
        return "true".equals(isRedAllSettleRecord);
    }
}

