/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.fi.arapcommon.kdtx.ec.ECServiceHelper;
import kd.fi.arapcommon.service.concurrency.ConcurrencyCtrlUtil;
import kd.fi.arapcommon.service.concurrency.IBillConcurrencyCtrlStrategy;
import kd.fi.arapcommon.service.concurrency.VerifyLockCtrlContext;
import kd.fi.arapcommon.util.StdConfig;
import org.apache.commons.lang.StringUtils;

public class CommonVerifyServiceHelper {
    private static final Log logger = LogFactory.getLog(CommonVerifyServiceHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void verifyAddMutexCtrl(Set<Long> mainIds, String mainEntity, Set<Long> asstIds, String asstEntity, boolean needWait) {
        if (mainIds == null || StringUtils.isEmpty((String)mainEntity) || asstIds == null || StringUtils.isEmpty((String)asstEntity)) {
            return;
        }
        HashSet<Long> lockMainIds = new HashSet<Long>(mainIds);
        HashSet<Long> lockAsstIds = new HashSet<Long>(asstIds);
        if (mainEntity.equals(asstEntity)) {
            lockAsstIds.removeAll(lockMainIds);
        }
        String lockKey = RequestContext.get().getAccountId() + "-verifyAddMutexCtrl";
        DLock lock = DLock.createReentrant((String)lockKey);
        lock.fastMode();
        lock.lock();
        try {
            IBillConcurrencyCtrlStrategy mainCtrl = ConcurrencyCtrlUtil.addCtrl(mainEntity, "verify", lockMainIds, needWait);
            VerifyLockCtrlContext.setVerifyLockCtrl(mainCtrl);
            IBillConcurrencyCtrlStrategy asstCtrl = ConcurrencyCtrlUtil.addCtrl(asstEntity, "verify", lockAsstIds, needWait);
            VerifyLockCtrlContext.setVerifyLockCtrl(asstCtrl);
        }
        finally {
            lock.unlock();
        }
        CommonVerifyServiceHelper.verifyUnfinishedTx(mainIds, mainEntity, asstIds, asstEntity, needWait);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void verifyReleaseMutexCtrl() {
        String lockKey = RequestContext.get().getAccountId() + "-verifyReleaseMutexCtrl";
        DLock lock = DLock.createReentrant((String)lockKey);
        lock.fastMode();
        lock.lock();
        try {
            List<IBillConcurrencyCtrlStrategy> verifyLockCtrlList = VerifyLockCtrlContext.getVerifyLockCtrl();
            if (!ObjectUtils.isEmpty(verifyLockCtrlList)) {
                for (IBillConcurrencyCtrlStrategy ctrl : verifyLockCtrlList) {
                    if (ctrl == null) continue;
                    ctrl.releaseCtrl();
                }
            }
            VerifyLockCtrlContext.remove();
        }
        finally {
            lock.unlock();
        }
    }

    public static void verifyAddMutexCtrlInTX(Set<Long> mainIds, String mainEntity, Set<Long> asstIds, String asstEntity, boolean needWait) {
        if (!TX.inTX()) {
            logger.info("\u672c\u5730\u4e8b\u52a1\u6ca1\u6709\u5f00\u542f");
            return;
        }
        TX.addCommitListener((CommitListener)new CommitListener(){

            public void onEnded(boolean rollbacked) {
                CommonVerifyServiceHelper.verifyReleaseMutexCtrl();
            }
        });
        CommonVerifyServiceHelper.verifyAddMutexCtrl(mainIds, mainEntity, asstIds, asstEntity, needWait);
    }

    public static void addManualVerifyLockCtrl(String mainEntity, DynamicObject[] mainRows, String asstEntity, DynamicObject[] asstRows) {
        if (mainRows == null || asstRows == null || mainRows.length == 0 || asstRows.length == 0 || ObjectUtils.isEmpty((Object)mainEntity) || ObjectUtils.isEmpty((Object)asstEntity)) {
            return;
        }
        HashSet<Long> mainBillIdSet = new HashSet<Long>(mainRows.length);
        for (DynamicObject main : mainRows) {
            mainBillIdSet.add(main.getLong("main_id"));
        }
        HashSet<Long> asstBillIdSet = new HashSet<Long>(asstRows.length);
        for (DynamicObject asst : asstRows) {
            asstBillIdSet.add(asst.getLong("asst_id"));
        }
        CommonVerifyServiceHelper.verifyAddMutexCtrlInTX(mainBillIdSet, mainEntity, asstBillIdSet, asstEntity, false);
    }

    public static Map<String, Integer> getVerifySeqMap(DynamicObject[] results, String verifyRecordEntity) {
        HashMap<String, Integer> verifySeqMap = new HashMap<String, Integer>(64);
        ArrayList<String> verifySeqPks = new ArrayList<String>(results.length);
        for (DynamicObject result : results) {
            long mainBillId = result.getLong("billid");
            DynamicObjectCollection entry = result.getDynamicObjectCollection("entry");
            long asstBillId = ((DynamicObject)entry.get(0)).getLong("e_billid");
            String verifyNumber = mainBillId + "-" + asstBillId;
            if (verifySeqPks.contains(verifyNumber)) continue;
            verifySeqPks.add(verifyNumber);
        }
        DynamicObject org = results[0].getDynamicObject("org");
        Object[] batchVerifySeq = CodeRuleServiceHelper.getBatchNumber((String)verifyRecordEntity, (DynamicObject)results[0], (String)org.getPkValue().toString(), (int)verifySeqPks.size());
        if (ObjectUtils.isEmpty((Object[])batchVerifySeq)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6838\u9500\u8bb0\u5f55\u6ca1\u6709\u542f\u7528\u7684\u7f16\u7801\u89c4\u5219\u3002", (String)"CommonVerifyServiceHelper_0", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        try {
            for (int i = 0; i < verifySeqPks.size(); ++i) {
                verifySeqMap.put((String)verifySeqPks.get(i), Integer.valueOf((String)batchVerifySeq[i]));
            }
        }
        catch (NumberFormatException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6838\u9500\u8bb0\u5f55\u7f16\u7801\u89c4\u5219\u4e0d\u5141\u8bb8\u6269\u5c55\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CommonVerifyServiceHelper_1", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        return verifySeqMap;
    }

    private static void verifyUnfinishedTx(Set<Long> mainIds, String mainEntity, Set<Long> asstIds, String asstEntity, boolean needWait) {
        if (!"false".equals(StdConfig.get("verifyim_ec_enable")) && !"false".equals(StdConfig.get("verify_lock_ec"))) {
            String waittime;
            String businessType = "";
            businessType = "im_purinbill".equals(mainEntity) || "ap_finapbill".equals(mainEntity) ? "ap_verify" : "ar_verify";
            HashSet<Long> unionIds = new HashSet<Long>(8);
            unionIds.addAll(mainIds);
            unionIds.addAll(asstIds);
            int try_again = 1;
            int waitTime = 500;
            if (needWait && !StringUtils.isEmpty((String)(waittime = StdConfig.get("verify_lock_ec_waittime")))) {
                waitTime = Integer.parseInt(waittime);
            }
            CommonVerifyServiceHelper.checkUnFinishedIds(businessType, unionIds, needWait, try_again, waitTime);
        }
    }

    private static void checkUnFinishedIds(String businessType, Set<Long> unionIds, boolean needWait, int try_again, int waitTime) {
        List<String> unFinishedIds = ECServiceHelper.loadUnfinishedTx(businessType, unionIds);
        if (unFinishedIds != null && unFinishedIds.size() > 0) {
            if (needWait && try_again < 40) {
                try {
                    Thread.sleep(waitTime);
                }
                catch (InterruptedException e) {
                    logger.info(e.getMessage());
                }
                logger.info("-----try_again:" + ++try_again);
                CommonVerifyServiceHelper.checkUnFinishedIds(businessType, unionIds, needWait, try_again, waitTime);
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5b8c\u6210\u7684\u6838\u9500\u5206\u5e03\u5f0f\u4e8b\u52a1\uff0c\u4e0d\u80fd\u8fdb\u884c\u6838\u9500\uff0c\u8bf7\u901a\u8fc7\u2018\u8054\u67e5-\u8054\u67e5\u4e8b\u52a1\u65e5\u5fd7\u2019\u529f\u80fd\u67e5\u770b\u5bf9\u5e94\u7684\u4fe1\u606f\u6216\u5728\u2018\u5206\u5e03\u5f0f\u7ba1\u7406-\u5206\u5e03\u5f0f\u4e8b\u52a1-\u4e8b\u52a1\u67e5\u8be2\u2019\u83dc\u5355\u67e5\u770b\u76f8\u5173\u4fe1\u606f\u3002", (String)"CommonVerifyServiceHelper_2", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
        }
    }

    public static boolean isVerify() {
        QFilter filter = new QFilter("key", "=", (Object)"iswriteoffplan");
        DynamicObject verifyConfig = BusinessDataServiceHelper.loadSingleFromCache((String)"im_invdbparam", (QFilter[])new QFilter[]{filter});
        if (verifyConfig == null) {
            return true;
        }
        return verifyConfig.getString("value").equals("0");
    }

    public static List<DynamicObject> filterVerifyEntity(DynamicObject[] entities) {
        List<DynamicObject> bills = Arrays.stream(entities).collect(Collectors.toList());
        QFilter filter = new QFilter("key", "=", (Object)"iswriteoffplan");
        QFilter orgFilter = new QFilter("org", "=", (Object)0L);
        DynamicObject verifyConfig = BusinessDataServiceHelper.loadSingleFromCache((String)"im_invdbparam", (QFilter[])new QFilter[]{filter.and(orgFilter)});
        if (verifyConfig == null) {
            return bills;
        }
        if ("1".equals(verifyConfig.getString("value"))) {
            return new ArrayList<DynamicObject>();
        }
        HashSet<Long> orgIds = new HashSet<Long>(2);
        Map verifyOrgConfig = BusinessDataServiceHelper.loadFromCache((String)"im_invdbparam", (QFilter[])new QFilter[]{new QFilter("key", "=", (Object)"iswriteoffplan"), new QFilter("value", "=", (Object)"1")});
        for (Map.Entry entrySet : verifyOrgConfig.entrySet()) {
            orgIds.add(((DynamicObject)entrySet.getValue()).getLong("org"));
        }
        Iterator<DynamicObject> iterator = bills.iterator();
        while (iterator.hasNext()) {
            DynamicObject bill = iterator.next();
            Long orgId = bill.getDynamicObject("org").getLong("id");
            if (!orgIds.contains(orgId)) continue;
            iterator.remove();
        }
        return bills;
    }

    public static boolean filterManualVerifyEntity(Long orgId) {
        boolean isVerify = true;
        QFilter filter = new QFilter("key", "=", (Object)"iswriteoffplan");
        QFilter orgFilter = new QFilter("org", "in", (Object)new Long[]{0L, orgId});
        Map verifyConfig = BusinessDataServiceHelper.loadFromCache((String)"im_invdbparam", (QFilter[])new QFilter[]{filter.and(orgFilter)});
        if (verifyConfig != null) {
            for (Map.Entry entrySet : verifyConfig.entrySet()) {
                if (!((DynamicObject)entrySet.getValue()).getString("value").equals("1")) continue;
                isVerify = false;
                break;
            }
        }
        return isVerify;
    }

    public static boolean isFiVerifyRecord(Set<Long> vrPKs, boolean isAr) {
        boolean isFiverify = true;
        String pkFilter = StringUtils.join(vrPKs, (String)",");
        String sql = isAr ? "select fid,fwriteofftypeid from t_ar_verifyrecord where fid in(" + pkFilter + ")" : "select fid,fwriteofftypeid from t_ap_verifyrecord where fid in(" + pkFilter + ")";
        DataSet verifyRecords = DB.queryDataSet((String)"verifyrecord", (DBRoute)DBRoute.of((String)"fi"), (String)sql);
        if (!verifyRecords.isEmpty()) {
            for (Row row : verifyRecords) {
                Long recordTypeId = row.getLong("fwriteofftypeid");
                if (recordTypeId == null || recordTypeId == 0L) continue;
                isFiverify = false;
                break;
            }
        }
        return isFiverify;
    }
}

