/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;

public class DisposeMaterialHelper {
    public static void disposeApMaterial(Object billId, BigDecimal lockedamt) {
        DBRoute DBKey = new DBRoute("ap");
        if (ObjectUtils.isEmpty((Object)billId)) {
            return;
        }
        long modifierId = RequestContext.get().getCurrUserId();
        Date modifyTime = Date.from(Instant.now());
        if (lockedamt.compareTo(BigDecimal.ZERO) > 0) {
            Object material;
            DynamicObjectCollection materialColl = null;
            materialColl = QueryServiceHelper.query((String)"ap_finapbill", (String)"id,exchangerate,currency.amtprecision,pricetaxtotal,detailentry.id,detailentry.seq,detailentry.e_pricetaxtotal,detailentry.lockedamt,detailentry.unlockamt", (QFilter[])new QFilter[]{new QFilter("id", "=", billId), new QFilter("detailentry.unlockamt", ">", (Object)BigDecimal.ZERO)}, (String)"detailentry.seq asc");
            if (materialColl.size() == 0) {
                return;
            }
            int amtprecision = ((DynamicObject)materialColl.get(0)).getInt("currency.amtprecision");
            BigDecimal rate = lockedamt.divide(((DynamicObject)materialColl.get(0)).getBigDecimal("pricetaxtotal"), 10, RoundingMode.HALF_UP);
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            for (int i = 0; i < materialColl.size(); ++i) {
                material = (DynamicObject)materialColl.get(i);
                if (lockedamt.compareTo(BigDecimal.ZERO) == 0) break;
                BigDecimal unlockamt = material.getBigDecimal("detailentry.e_pricetaxtotal");
                BigDecimal curlockAmt = unlockamt.multiply(rate).setScale(amtprecision, RoundingMode.HALF_UP);
                if (i == materialColl.size() - 1) {
                    curlockAmt = unlockamt.compareTo(lockedamt) >= 0 ? lockedamt : unlockamt;
                }
                lockedamt = lockedamt.subtract(curlockAmt);
                Object[] objArr = new Object[]{curlockAmt, curlockAmt, modifierId, modifyTime, material.getLong("detailentry.id"), billId};
                paramList.add(objArr);
            }
            if (paramList.size() == 0) {
                return;
            }
            ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_ap_finapbill", (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.eq, billId)});
            material = null;
            try {
                String sql = "update t_ap_finapbilldetailentry set flockedamt = flockedamt+?,funlockamt = funlockamt-?,fmodifierid = ?,fmodifytime = ?  where fentryid=? and fid = ?";
                DB.executeBatch((DBRoute)DBKey, (String)sql, paramList);
            }
            catch (Throwable sql) {
                material = sql;
                throw sql;
            }
            finally {
                if (ctx != null) {
                    if (material != null) {
                        try {
                            ctx.close();
                        }
                        catch (Throwable sql) {
                            ((Throwable)material).addSuppressed(sql);
                        }
                    } else {
                        ctx.close();
                    }
                }
            }
        }
        DynamicObjectCollection materialColl = null;
        materialColl = QueryServiceHelper.query((String)"ap_finapbill", (String)"id,exchangerate,currency.amtprecision,pricetaxtotal,detailentry.id,detailentry.e_pricetaxtotal,detailentry.seq,detailentry.lockedamt,detailentry.unlockamt", (QFilter[])new QFilter[]{new QFilter("id", "=", billId), new QFilter("detailentry.lockedamt", ">", (Object)BigDecimal.ZERO)}, (String)"detailentry.seq asc");
        if (materialColl.size() == 0) {
            return;
        }
        lockedamt = lockedamt.negate();
        int amtprecision = ((DynamicObject)materialColl.get(0)).getInt("currency.amtprecision");
        BigDecimal rate = lockedamt.divide(((DynamicObject)materialColl.get(0)).getBigDecimal("pricetaxtotal"), 10, RoundingMode.HALF_UP);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        for (int i = 0; i < materialColl.size(); ++i) {
            DynamicObject material = (DynamicObject)materialColl.get(i);
            if (lockedamt.compareTo(BigDecimal.ZERO) == 0) break;
            BigDecimal lockamt = material.getBigDecimal("detailentry.e_pricetaxtotal");
            BigDecimal curlockAmt = lockamt.multiply(rate).setScale(amtprecision, RoundingMode.HALF_UP);
            if (i == materialColl.size() - 1) {
                curlockAmt = lockamt.compareTo(lockedamt) >= 0 ? lockedamt : lockamt;
            }
            lockedamt = lockedamt.subtract(curlockAmt);
            Object[] objArr = new Object[]{curlockAmt, curlockAmt, modifierId, modifyTime, material.getLong("detailentry.id"), billId};
            paramList.add(objArr);
        }
        if (paramList.size() == 0) {
            return;
        }
        try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_ap_finapbill", (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.eq, billId)});){
            String sql = "update t_ap_finapbilldetailentry set flockedamt = flockedamt-?,funlockamt = funlockamt+?,fmodifierid = ?,fmodifytime = ?  where fentryid=? and fid = ?";
            DB.executeBatch((DBRoute)DBKey, (String)sql, paramList);
        }
    }

    public static void disposeMaterial(Object billId, BigDecimal lockedamt, String entity) {
        if (ObjectUtils.isEmpty((Object)billId)) {
            return;
        }
        if (entity.equals("ap_finapbill")) {
            DisposeMaterialHelper.disposeApMaterial(billId, lockedamt);
        } else {
            DisposeMaterialHelper.disposeArMaterial(billId, lockedamt);
        }
    }

    private static void disposeArMaterial(Object billId, BigDecimal lockedamt) {
        DBRoute DBKey = new DBRoute("ar");
        if (ObjectUtils.isEmpty((Object)billId)) {
            return;
        }
        long modifierId = RequestContext.get().getCurrUserId();
        Date modifyTime = Date.from(Instant.now());
        if (lockedamt.compareTo(BigDecimal.ZERO) > 0) {
            Object material;
            DynamicObjectCollection materialColl = null;
            materialColl = QueryServiceHelper.query((String)"ar_finarbill", (String)"id,exchangerate,recamount,currency.amtprecision,entry.id,entry.seq,entry.e_lockedamt,entry.e_unlockamt,entry.e_recamount", (QFilter[])new QFilter[]{new QFilter("id", "=", billId), new QFilter("entry.e_unlockamt", ">", (Object)BigDecimal.ZERO)}, (String)"entry.seq asc");
            if (materialColl.size() == 0) {
                return;
            }
            int amtprecision = ((DynamicObject)materialColl.get(0)).getInt("currency.amtprecision");
            BigDecimal rate = lockedamt.divide(((DynamicObject)materialColl.get(0)).getBigDecimal("recamount"), 10, RoundingMode.HALF_UP);
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            for (int i = 0; i < materialColl.size(); ++i) {
                material = (DynamicObject)materialColl.get(i);
                if (lockedamt.compareTo(BigDecimal.ZERO) == 0) break;
                BigDecimal unlockamt = material.getBigDecimal("entry.e_recamount");
                BigDecimal curlockAmt = unlockamt.multiply(rate).setScale(amtprecision, RoundingMode.HALF_UP);
                if (i == materialColl.size() - 1) {
                    curlockAmt = unlockamt.compareTo(lockedamt) >= 0 ? lockedamt : unlockamt;
                }
                lockedamt = lockedamt.subtract(curlockAmt);
                Object[] objArr = new Object[]{curlockAmt, curlockAmt, modifierId, modifyTime, material.getLong("entry.id"), billId};
                paramList.add(objArr);
            }
            if (paramList.size() == 0) {
                return;
            }
            ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_ar_finarbill", (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.eq, billId)});
            material = null;
            try {
                String sql = "update t_ar_finarbillentry set flockedamt = flockedamt+?,funlockamt = funlockamt-?,fmodifierid = ?,fmodifytime = ?  where fentryid=? and fid = ?";
                DB.executeBatch((DBRoute)DBKey, (String)sql, paramList);
            }
            catch (Throwable sql) {
                material = sql;
                throw sql;
            }
            finally {
                if (ctx != null) {
                    if (material != null) {
                        try {
                            ctx.close();
                        }
                        catch (Throwable sql) {
                            ((Throwable)material).addSuppressed(sql);
                        }
                    } else {
                        ctx.close();
                    }
                }
            }
        }
        DynamicObjectCollection materialColl = null;
        materialColl = QueryServiceHelper.query((String)"ar_finarbill", (String)"id,exchangerate,recamount,currency.amtprecision,entry.id,entry.seq,entry.e_lockedamt,entry.e_unlockamt,entry.e_recamount", (QFilter[])new QFilter[]{new QFilter("id", "=", billId), new QFilter("entry.e_lockedamt", ">", (Object)BigDecimal.ZERO)}, (String)"entry.seq asc");
        if (materialColl.size() == 0) {
            return;
        }
        lockedamt = lockedamt.negate();
        int amtprecision = ((DynamicObject)materialColl.get(0)).getInt("currency.amtprecision");
        BigDecimal rate = lockedamt.divide(((DynamicObject)materialColl.get(0)).getBigDecimal("recamount"), 10, RoundingMode.HALF_UP);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        for (int i = 0; i < materialColl.size(); ++i) {
            DynamicObject material = (DynamicObject)materialColl.get(i);
            if (lockedamt.compareTo(BigDecimal.ZERO) == 0) break;
            BigDecimal lockamt = material.getBigDecimal("entry.e_recamount");
            BigDecimal curlockAmt = lockamt.multiply(rate).setScale(amtprecision, RoundingMode.HALF_UP);
            if (i == materialColl.size() - 1) {
                curlockAmt = lockamt.compareTo(lockedamt) >= 0 ? lockedamt : lockamt;
            }
            lockedamt = lockedamt.subtract(curlockAmt);
            Object[] objArr = new Object[]{curlockAmt, curlockAmt, modifierId, modifyTime, material.getLong("entry.id"), billId};
            paramList.add(objArr);
        }
        if (paramList.size() == 0) {
            return;
        }
        try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_ar_finarbill", (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.eq, billId)});){
            String sql = "update t_ar_finarbillentry set flockedamt = flockedamt-?,funlockamt = funlockamt+?,fmodifierid = ?,fmodifytime = ?  where fentryid=? and fid = ?";
            DB.executeBatch((DBRoute)DBKey, (String)sql, paramList);
        }
    }

    public static void disposeMaterialByAmount(long billId, BigDecimal lockedamt) {
        DBRoute DBKey = new DBRoute("ap");
        if (ObjectUtils.isEmpty((Object)billId)) {
            return;
        }
        if (lockedamt.compareTo(BigDecimal.ZERO) > 0) {
            Object material;
            DynamicObjectCollection materialColl = null;
            materialColl = QueryServiceHelper.query((String)"ap_finapbill", (String)"id,exchangerate,currency.amtprecision,pricetaxtotal,amount,detailentry.id,detailentry.seq,detailentry.e_amount,detailentry.e_pricetaxtotal,detailentry.lockedamt,detailentry.unlockamt", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)billId), new QFilter("detailentry.unlockamt", ">", (Object)BigDecimal.ZERO)}, (String)"detailentry.seq asc");
            if (materialColl.size() == 0) {
                return;
            }
            int amtprecision = ((DynamicObject)materialColl.get(0)).getInt("currency.amtprecision");
            BigDecimal rate = lockedamt.divide(((DynamicObject)materialColl.get(0)).getBigDecimal("amount"), 10, RoundingMode.HALF_UP);
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            for (int i = 0; i < materialColl.size(); ++i) {
                material = (DynamicObject)materialColl.get(i);
                if (lockedamt.compareTo(BigDecimal.ZERO) == 0) break;
                BigDecimal unlockamt = material.getBigDecimal("detailentry.e_amount");
                BigDecimal curlockAmt = unlockamt.multiply(rate).setScale(amtprecision, RoundingMode.HALF_UP);
                if (i == materialColl.size() - 1) {
                    curlockAmt = unlockamt.compareTo(lockedamt) >= 0 ? lockedamt : unlockamt;
                }
                lockedamt = lockedamt.subtract(curlockAmt);
                Object[] objArr = new Object[]{curlockAmt, curlockAmt, material.getLong("detailentry.id"), billId};
                paramList.add(objArr);
            }
            if (paramList.size() == 0) {
                return;
            }
            ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_ap_finapbill", (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.eq, (Object)billId)});
            material = null;
            try {
                String sql = "update t_ap_finapbilldetailentry set flockedamt = flockedamt+?,funlockamt = funlockamt-?  where fentryid=? and fid = ?";
                DB.executeBatch((DBRoute)DBKey, (String)sql, paramList);
            }
            catch (Throwable sql) {
                material = sql;
                throw sql;
            }
            finally {
                if (ctx != null) {
                    if (material != null) {
                        try {
                            ctx.close();
                        }
                        catch (Throwable sql) {
                            ((Throwable)material).addSuppressed(sql);
                        }
                    } else {
                        ctx.close();
                    }
                }
            }
        }
        DynamicObjectCollection materialColl = null;
        materialColl = QueryServiceHelper.query((String)"ap_finapbill", (String)"id,exchangerate,currency.amtprecision,pricetaxtotal,amount,detailentry.id,detailentry.e_amount,detailentry.e_pricetaxtotal,detailentry.seq,detailentry.lockedamt,detailentry.unlockamt", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)billId), new QFilter("detailentry.lockedamt", ">", (Object)BigDecimal.ZERO)}, (String)"detailentry.seq asc");
        if (materialColl.size() == 0) {
            return;
        }
        lockedamt = lockedamt.negate();
        int amtprecision = ((DynamicObject)materialColl.get(0)).getInt("currency.amtprecision");
        BigDecimal rate = lockedamt.divide(((DynamicObject)materialColl.get(0)).getBigDecimal("amount"), 10, RoundingMode.HALF_UP);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        for (int i = 0; i < materialColl.size(); ++i) {
            DynamicObject material = (DynamicObject)materialColl.get(i);
            if (lockedamt.compareTo(BigDecimal.ZERO) == 0) break;
            BigDecimal lockamt = material.getBigDecimal("detailentry.e_amount");
            BigDecimal curlockAmt = lockamt.multiply(rate).setScale(amtprecision, RoundingMode.HALF_UP);
            if (i == materialColl.size() - 1) {
                curlockAmt = lockamt.compareTo(lockedamt) >= 0 ? lockedamt : lockamt;
            }
            lockedamt = lockedamt.subtract(curlockAmt);
            Object[] objArr = new Object[]{curlockAmt, curlockAmt, material.getLong("detailentry.id"), billId};
            paramList.add(objArr);
        }
        if (paramList.size() == 0) {
            return;
        }
        try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_ap_finapbill", (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.eq, (Object)billId)});){
            String sql = "update t_ap_finapbilldetailentry set flockedamt = flockedamt-?,funlockamt = funlockamt+?  where fentryid=? and fid = ?";
            DB.executeBatch((DBRoute)DBKey, (String)sql, paramList);
        }
    }
}

