/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class DisposeUnlock4RedBillHelper {
    public static void disposeMaterial(Object srcBillId, BigDecimal lockedamt, String entity, boolean isAmtSameDir) {
        if (ObjectUtils.isEmpty((Object)srcBillId)) {
            return;
        }
        switch (entity) {
            case "ar_finarbill": {
                DisposeUnlock4RedBillHelper.disposeMaterial4Ar(srcBillId, lockedamt, isAmtSameDir);
                break;
            }
            case "ap_finapbill": {
                DisposeUnlock4RedBillHelper.disposeMaterial4Ap(srcBillId, lockedamt, isAmtSameDir);
                break;
            }
        }
    }

    private static void disposeMaterial4Ap(Object srcBillId, BigDecimal lockedamt, boolean isAmtSameDir) {
        String qcpStr;
        boolean flag;
        if (isAmtSameDir) {
            flag = lockedamt.compareTo(BigDecimal.ZERO) > 0;
            qcpStr = ">";
        } else {
            flag = (lockedamt = lockedamt.negate()).compareTo(BigDecimal.ZERO) < 0;
            qcpStr = "<";
        }
        DBRoute DBKey = new DBRoute("ap");
        if (flag) {
            DynamicObjectCollection materialColl = null;
            materialColl = QueryServiceHelper.query((String)"ap_finapbill", (String)"id,exchangerate,currency.amtprecision,pricetaxtotal,detailentry.id,detailentry.seq,detailentry.e_pricetaxtotal,detailentry.lockedamt,detailentry.unlockamt", (QFilter[])new QFilter[]{new QFilter("id", "=", srcBillId), new QFilter("detailentry.unlockamt", qcpStr, (Object)BigDecimal.ZERO)}, (String)"detailentry.seq asc");
            if (materialColl.size() == 0) {
                return;
            }
            int amtprecision = ((DynamicObject)materialColl.get(0)).getInt("currency.amtprecision");
            BigDecimal rate = lockedamt.divide(((DynamicObject)materialColl.get(0)).getBigDecimal("pricetaxtotal"), 10, RoundingMode.HALF_UP);
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            for (int i = 0; i < materialColl.size(); ++i) {
                DynamicObject material = (DynamicObject)materialColl.get(i);
                if (lockedamt.compareTo(BigDecimal.ZERO) == 0) break;
                BigDecimal unlockamt = material.getBigDecimal("detailentry.e_pricetaxtotal");
                BigDecimal curlockAmt = unlockamt.multiply(rate).setScale(amtprecision, RoundingMode.HALF_UP);
                if (i == materialColl.size() - 1) {
                    curlockAmt = unlockamt.abs().compareTo(lockedamt.abs()) >= 0 ? lockedamt : unlockamt;
                }
                lockedamt = lockedamt.subtract(curlockAmt);
                Object[] objArr = new Object[]{curlockAmt, curlockAmt, material.getLong("detailentry.id")};
                paramList.add(objArr);
            }
            if (paramList.size() == 0) {
                return;
            }
            String sql = "update t_ap_finapbilldetailentry set flockedamt = flockedamt+?,funlockamt = funlockamt-?  where fentryid=?";
            DB.executeBatch((DBRoute)DBKey, (String)sql, paramList);
        } else {
            DynamicObjectCollection materialColl = null;
            materialColl = QueryServiceHelper.query((String)"ap_finapbill", (String)"id,exchangerate,currency.amtprecision,pricetaxtotal,detailentry.id,detailentry.e_pricetaxtotal,detailentry.seq,detailentry.lockedamt,detailentry.unlockamt", (QFilter[])new QFilter[]{new QFilter("id", "=", srcBillId), new QFilter("detailentry.lockedamt", qcpStr, (Object)BigDecimal.ZERO)}, (String)"detailentry.seq asc");
            if (materialColl.size() == 0) {
                return;
            }
            lockedamt = lockedamt.negate();
            int amtprecision = ((DynamicObject)materialColl.get(0)).getInt("currency.amtprecision");
            BigDecimal rate = lockedamt.divide(((DynamicObject)materialColl.get(0)).getBigDecimal("pricetaxtotal"), 10, RoundingMode.HALF_UP);
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            for (int i = 0; i < materialColl.size(); ++i) {
                DynamicObject material = (DynamicObject)materialColl.get(i);
                if (lockedamt.compareTo(BigDecimal.ZERO) == 0) break;
                BigDecimal lockamt = material.getBigDecimal("detailentry.e_pricetaxtotal");
                BigDecimal curlockAmt = lockamt.multiply(rate).setScale(amtprecision, RoundingMode.HALF_UP);
                if (i == materialColl.size() - 1) {
                    curlockAmt = lockamt.abs().compareTo(lockedamt.abs()) >= 0 ? lockedamt : lockamt;
                }
                lockedamt = lockedamt.subtract(curlockAmt);
                Object[] objArr = new Object[]{curlockAmt, curlockAmt, material.getLong("detailentry.id")};
                paramList.add(objArr);
            }
            if (paramList.size() == 0) {
                return;
            }
            String sql = "update t_ap_finapbilldetailentry set flockedamt = flockedamt-?,funlockamt = funlockamt+?  where fentryid=?";
            DB.executeBatch((DBRoute)DBKey, (String)sql, paramList);
        }
    }

    private static void disposeMaterial4Ar(Object srcBillId, BigDecimal lockedamt, boolean isAmtSameDir) {
        String qcpStr;
        boolean flag;
        if (isAmtSameDir) {
            flag = lockedamt.compareTo(BigDecimal.ZERO) > 0;
            qcpStr = ">";
        } else {
            flag = (lockedamt = lockedamt.negate()).compareTo(BigDecimal.ZERO) < 0;
            qcpStr = "<";
        }
        DBRoute DBKey = new DBRoute("ar");
        if (flag) {
            DynamicObjectCollection materialColl = null;
            materialColl = QueryServiceHelper.query((String)"ar_finarbill", (String)"id,exchangerate,recamount,currency.amtprecision,entry.id,entry.seq,entry.e_lockedamt,entry.e_unlockamt,entry.e_recamount", (QFilter[])new QFilter[]{new QFilter("id", "=", srcBillId), new QFilter("entry.e_unlockamt", qcpStr, (Object)BigDecimal.ZERO)}, (String)"entry.seq asc");
            if (materialColl.size() == 0) {
                return;
            }
            int amtprecision = ((DynamicObject)materialColl.get(0)).getInt("currency.amtprecision");
            BigDecimal rate = lockedamt.divide(((DynamicObject)materialColl.get(0)).getBigDecimal("recamount"), 10, RoundingMode.HALF_UP);
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            for (int i = 0; i < materialColl.size(); ++i) {
                DynamicObject material = (DynamicObject)materialColl.get(i);
                if (lockedamt.compareTo(BigDecimal.ZERO) == 0) break;
                BigDecimal unlockamt = material.getBigDecimal("entry.e_recamount");
                BigDecimal curlockAmt = unlockamt.multiply(rate).setScale(amtprecision, RoundingMode.HALF_UP);
                if (i == materialColl.size() - 1) {
                    curlockAmt = unlockamt.abs().compareTo(lockedamt.abs()) >= 0 ? lockedamt : unlockamt;
                }
                lockedamt = lockedamt.subtract(curlockAmt);
                Object[] objArr = new Object[]{curlockAmt, curlockAmt, material.getLong("entry.id")};
                paramList.add(objArr);
            }
            if (paramList.size() == 0) {
                return;
            }
            String sql = "update t_ar_finarbillentry set flockedamt = flockedamt+?,funlockamt = funlockamt-?  where fentryid=?";
            DB.executeBatch((DBRoute)DBKey, (String)sql, paramList);
        } else {
            DynamicObjectCollection materialColl = null;
            materialColl = QueryServiceHelper.query((String)"ar_finarbill", (String)"id,exchangerate,recamount,currency.amtprecision,entry.id,entry.seq,entry.e_lockedamt,entry.e_unlockamt,entry.e_recamount", (QFilter[])new QFilter[]{new QFilter("id", "=", srcBillId), new QFilter("entry.e_lockedamt", qcpStr, (Object)BigDecimal.ZERO)}, (String)"entry.seq asc");
            if (materialColl.size() == 0) {
                return;
            }
            lockedamt = lockedamt.negate();
            int amtprecision = ((DynamicObject)materialColl.get(0)).getInt("currency.amtprecision");
            BigDecimal rate = lockedamt.divide(((DynamicObject)materialColl.get(0)).getBigDecimal("recamount"), 10, RoundingMode.HALF_UP);
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            for (int i = 0; i < materialColl.size(); ++i) {
                DynamicObject material = (DynamicObject)materialColl.get(i);
                if (lockedamt.compareTo(BigDecimal.ZERO) == 0) break;
                BigDecimal lockamt = material.getBigDecimal("entry.e_recamount");
                BigDecimal curlockAmt = lockamt.multiply(rate).setScale(amtprecision, RoundingMode.HALF_UP);
                if (i == materialColl.size() - 1) {
                    curlockAmt = lockamt.abs().compareTo(lockedamt.abs()) >= 0 ? lockedamt : lockamt;
                }
                lockedamt = lockedamt.subtract(curlockAmt);
                Object[] objArr = new Object[]{curlockAmt, curlockAmt, material.getLong("entry.id")};
                paramList.add(objArr);
            }
            if (paramList.size() == 0) {
                return;
            }
            String sql = "update t_ar_finarbillentry set flockedamt = flockedamt-?,funlockamt = funlockamt+?  where fentryid=?";
            DB.executeBatch((DBRoute)DBKey, (String)sql, paramList);
        }
    }

    public static void disposePlan(Object srcBillId, BigDecimal lockedamt, String entity, boolean isAmtSameDir) {
        String qcpStr;
        boolean flag;
        if (ObjectUtils.isEmpty((Object)srcBillId)) {
            return;
        }
        if (isAmtSameDir) {
            flag = lockedamt.compareTo(BigDecimal.ZERO) > 0;
            qcpStr = ">";
        } else {
            flag = (lockedamt = lockedamt.negate()).compareTo(BigDecimal.ZERO) < 0;
            qcpStr = "<";
        }
        String table = null;
        DBRoute DBKey = new DBRoute("ap");
        if (entity.equals("ap_finapbill")) {
            table = "t_ap_finapplanentry";
        } else {
            table = "t_ar_finarplanentry";
            DBKey = new DBRoute("ar");
        }
        if (flag) {
            DynamicObjectCollection planColl = QueryServiceHelper.query((String)entity, (String)"id,exchangerate,planentity.id,planentity.seq,planentity.planduedate,planentity.planpricetax,planentity.planlockedamt,planentity.unplanlockamt", (QFilter[])new QFilter[]{new QFilter("id", "=", srcBillId), new QFilter("planentity.unplanlockamt", qcpStr, (Object)BigDecimal.ZERO)}, (String)"planentity.seq asc");
            if (planColl.size() == 0) {
                return;
            }
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            for (DynamicObject plan : planColl) {
                if (lockedamt.compareTo(BigDecimal.ZERO) == 0) break;
                BigDecimal unPlanlockamt = plan.getBigDecimal("planentity.unplanlockamt");
                BigDecimal curlockAmt = unPlanlockamt.abs().compareTo(lockedamt.abs()) >= 0 ? lockedamt : unPlanlockamt;
                lockedamt = lockedamt.subtract(curlockAmt);
                Object[] objArr = new Object[]{curlockAmt, curlockAmt, plan.getLong("planentity.id")};
                paramList.add(objArr);
            }
            if (paramList.size() == 0) {
                return;
            }
            String sql = "update " + table + " set fplanlockedamt = fplanlockedamt+?,funplanlockamt = funplanlockamt-?  where fentryid=?";
            DB.executeBatch((DBRoute)DBKey, (String)sql, paramList);
        } else {
            DynamicObjectCollection planColl = QueryServiceHelper.query((String)entity, (String)"id,exchangerate,planentity.id,planentity.seq,planentity.planduedate,planentity.planpricetax,planentity.planlockedamt,planentity.unplanlockamt", (QFilter[])new QFilter[]{new QFilter("id", "=", srcBillId), new QFilter("planentity.planlockedamt", qcpStr, (Object)BigDecimal.ZERO)}, (String)"planentity.seq desc");
            if (planColl.size() == 0) {
                return;
            }
            lockedamt = lockedamt.negate();
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            for (DynamicObject plan : planColl) {
                if (lockedamt.compareTo(BigDecimal.ZERO) == 0) break;
                BigDecimal Planlockamt = plan.getBigDecimal("planentity.planlockedamt");
                BigDecimal curlockAmt = Planlockamt.abs().compareTo(lockedamt.abs()) >= 0 ? lockedamt : Planlockamt;
                lockedamt = lockedamt.subtract(curlockAmt);
                Object[] objArr = new Object[]{curlockAmt, curlockAmt, plan.getLong("planentity.id")};
                paramList.add(objArr);
            }
            if (paramList.size() == 0) {
                return;
            }
            String sql = "update " + table + " set fplanlockedamt = fplanlockedamt-?,funplanlockamt = funplanlockamt+?  where fentryid=?";
            DB.executeBatch((DBRoute)DBKey, (String)sql, paramList);
        }
    }
}

