/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.helper;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.fi.arapcommon.util.EmptyUtils;

public class ImageServiceHelper {
    private static Log logger = LogFactory.getLog(ImageServiceHelper.class);

    public static String getImgNum(DynamicObject dataEntry, Long orgId) {
        String billNumber = dataEntry.getString("billno");
        if (StringUtils.isEmpty((String)billNumber)) {
            return "";
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"task_billimagemap");
        DynamicObject getImgNumParam = new DynamicObject((DynamicObjectType)type);
        DynamicObject creator = dataEntry.getDynamicObject("creator");
        DynamicObject modifier = dataEntry.getDynamicObject("modifier");
        Date createTime = dataEntry.getDate("createtime");
        Date modifyTime = dataEntry.getDate("modifytime");
        Long billId = dataEntry.getLong("id");
        getImgNumParam.set("billid", (Object)billId);
        getImgNumParam.set("billnumber", (Object)billNumber);
        getImgNumParam.set("billtype", (Object)dataEntry.getDataEntityType().getName());
        getImgNumParam.set("imagestate", (Object)"0");
        getImgNumParam.set("creator", creator == null ? null : creator.getPkValue());
        getImgNumParam.set("createtime", (Object)createTime);
        getImgNumParam.set("modifier", modifier == null ? null : modifier.getPkValue());
        getImgNumParam.set("modifytime", (Object)modifyTime);
        String imageNo = null;
        try {
            imageNo = kd.bos.servicehelper.image.ImageServiceHelper.excuteImageStrategy((DynamicObject)getImgNumParam, (Long)orgId);
            logger.info("billNumber and imageNo:" + billNumber + "/" + imageNo);
            return imageNo;
        }
        catch (Exception ex) {
            logger.error("error generate imageno:", (Throwable)ex);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u751f\u6210\u5f71\u50cf\u7f16\u7801\u5931\u8d25\uff1a%s", (String)"ImageServiceHelper_0", (String)"fi-arapcommon", (Object[])new Object[0]), ex.getMessage()));
        }
    }

    public static void deleteImage(DynamicObject[] bills) {
        ArrayList<String> imageNos = new ArrayList<String>();
        for (DynamicObject bill : bills) {
            String imageNo = bill.getString("imageno");
            if (EmptyUtils.isEmpty(imageNo) || imageNos.contains(imageNo)) continue;
            imageNos.add(imageNo);
        }
        if (!imageNos.isEmpty()) {
            String userName = RequestContext.get().getUserName();
            ThreadPools.executeOnceIncludeRequestContext((String)"deleteImage", () -> {
                for (String imageNo : imageNos) {
                    try {
                        String delState = kd.bos.servicehelper.image.ImageServiceHelper.deleteImage((String)imageNo, (String)userName, null);
                        if ("success".equals(delState)) continue;
                        throw new KDBizException(ResManager.loadKDString((String)"\u5220\u9664\u5f71\u50cf\u7f16\u7801\u5931\u8d25\u3002", (String)"ImageServiceHelper_1", (String)"fi-arapcommon", (Object[])new Object[0]));
                    }
                    catch (Exception exc) {
                        logger.info("deleteImage imageNo:" + imageNo + ", " + exc.getMessage());
                    }
                }
            });
        }
    }

    public static String viewPhoto(String imageNumber, String userID, String userName) {
        return kd.bos.servicehelper.image.ImageServiceHelper.viewPhoto((String)imageNumber, (String)userID, (String)userName);
    }
}

