/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.enums.SettleTypeEnum;
import kd.fi.arapcommon.helper.ArApXDBHelper;
import kd.fi.arapcommon.service.ext.SettleExtDataLoader;
import kd.fi.arapcommon.service.helper.FinApBillHandleHelper;
import kd.fi.arapcommon.service.helper.FinArBillHandleHelper;
import kd.fi.arapcommon.service.helper.PayBillHandleHelper;
import kd.fi.arapcommon.service.helper.RecBillHandlerHelper;
import kd.fi.arapcommon.service.helper.TxSettleServiceHelper;
import kd.fi.arapcommon.util.StdConfig;

public class LoadBillForSettleSchemeHelper {
    private static final Log logger = LogFactory.getLog(LoadBillForSettleSchemeHelper.class);
    public static final Integer param_ONE = 1;
    public static final Integer param_TWO = 2;
    public static final Integer param_THREE = 3;
    public static final Integer param_FOUR = 4;

    public static String getMainNumber(String settleRelation, String settleType) {
        String number = null;
        if (SettleTypeEnum.MATCH.getValue().equals(settleType)) {
            if (SettleRelationEnum.APPAYSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.APSELF.getValue().equals(settleRelation) || SettleRelationEnum.PAYTRANS.getValue().equals(settleRelation) || SettleRelationEnum.APARSETTLE.getValue().equals(settleRelation)) {
                number = "ap_finapbill";
            } else if (SettleRelationEnum.PAYSELF.getValue().equals(settleRelation) || SettleRelationEnum.PAYRECSETTLE.getValue().equals(settleRelation)) {
                number = "cas_paybill";
            } else if (SettleRelationEnum.RECSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.ARAPSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.ARSELF.getValue().equals(settleRelation) || SettleRelationEnum.ARTRANSFER.getValue().equals(settleRelation)) {
                number = "ar_finarbill";
            } else if (SettleRelationEnum.RECSELF.getValue().equals(settleRelation) || SettleRelationEnum.RECPAYSETTLE.getValue().equals(settleRelation)) {
                number = "cas_recbill";
            }
        }
        return number;
    }

    public static String getAsstNumber(String settleRelation, String settleType, Object ... param) {
        String number = null;
        if (SettleTypeEnum.MATCH.getValue().equals(settleType)) {
            if (SettleRelationEnum.APPAYSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.PAYSELF.getValue().equals(settleRelation)) {
                number = param.length == 5 && !ObjectUtils.isEmpty((Object)param[param_FOUR]) && "ap_paidbill".equals(param[param_FOUR]) ? "ap_paidbill" : "cas_paybill";
            } else if (SettleRelationEnum.RECSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.RECSELF.getValue().equals(settleRelation)) {
                number = param.length == 5 && !ObjectUtils.isEmpty((Object)param[param_FOUR]) && "ar_receivedbill".equals(param[param_FOUR]) ? "ar_receivedbill" : "cas_recbill";
            } else if (SettleRelationEnum.APARSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.ARSELF.getValue().equals(settleRelation)) {
                number = "ar_finarbill";
            } else if (SettleRelationEnum.ARAPSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.APSELF.getValue().equals(settleRelation)) {
                number = "ap_finapbill";
            } else if (SettleRelationEnum.PAYRECSETTLE.getValue().equals(settleRelation)) {
                number = "cas_recbill";
            } else if (SettleRelationEnum.RECPAYSETTLE.getValue().equals(settleRelation)) {
                number = "cas_paybill";
            }
        }
        return number;
    }

    public static List<Object> getPks(String entityNumber, QFilter qFilter) {
        return QueryServiceHelper.queryPrimaryKeys((String)entityNumber, (QFilter[])qFilter.toArray(), (String)"bizdate desc", (int)-1);
    }

    public static Map<String, List<EntryInfo>> getBillMapByAsstactId(String entityNumber, QFilter qFilter, boolean isLoadPartner, String timeOrder) {
        String orderBy = "bizdate asc";
        if (timeOrder != null) {
            orderBy = "bizdate " + timeOrder;
        }
        HashMap<String, List<EntryInfo>> billMap = new HashMap<String, List<EntryInfo>>(8);
        DataSet dataSet = ArApXDBHelper.queryDataSet(entityNumber, "id,bizdate," + LoadBillForSettleSchemeHelper.getAsstactKey(entityNumber), qFilter, orderBy, "settleschemequery");
        List<Map<String, Object>> dataList = LoadBillForSettleSchemeHelper.dataSet2List(dataSet);
        dataSet.close();
        if (dataList.size() == 0) {
            return billMap;
        }
        if (isLoadPartner) {
            LoadBillForSettleSchemeHelper.repairDataListByPartner(dataList);
        } else {
            LoadBillForSettleSchemeHelper.repairDataListByMaster(dataList);
        }
        if (dataList.size() == 0) {
            return billMap;
        }
        HashMap<Long, Long> unFinishedIdMap = new HashMap<Long, Long>(1);
        if ("cas_recbill".equals(entityNumber) || "cas_paybill".equals(entityNumber)) {
            String schemeSettleLoadUnfinishedId = StdConfig.get("SchemeSettleLoadUnfinishedId");
            if (schemeSettleLoadUnfinishedId == null || "true".equals(schemeSettleLoadUnfinishedId)) {
                logger.info("schemeSettleLoadUnfinishedId : true");
                HashSet<Long> billIds = new HashSet<Long>(8);
                for (Map<String, Object> map : dataList) {
                    billIds.add((Long)map.get("id"));
                }
                List<String> unFinishedIds = "cas_recbill".equals(entityNumber) ? TxSettleServiceHelper.loadRecBillSettleUnfinishedTxBillIds(billIds.stream().map(String::valueOf).collect(Collectors.toList())) : TxSettleServiceHelper.loadPayBillSettleUnfinishedTxBillIds(billIds.stream().map(String::valueOf).collect(Collectors.toList()));
                if (!unFinishedIds.isEmpty()) {
                    for (String unFinishedId : unFinishedIds) {
                        unFinishedIdMap.put(Long.valueOf(unFinishedId), Long.valueOf(unFinishedId));
                    }
                }
            }
            logger.info("exist unfinished billIds size:" + unFinishedIdMap.size());
        }
        for (Map<String, Object> rowData : dataList) {
            Long id = (Long)rowData.get("id");
            if (unFinishedIdMap.get(id) != null) continue;
            Long l = (Long)rowData.get("entry.id");
            String key = ((Long)rowData.get("asstact.id")).toString();
            EntryInfo info = new EntryInfo(id, l);
            if (billMap.get(key) != null) {
                ((List)billMap.get(key)).add(info);
                continue;
            }
            ArrayList<EntryInfo> entryInfos = new ArrayList<EntryInfo>(10);
            entryInfos.add(info);
            billMap.put(key, entryInfos);
        }
        return billMap;
    }

    @Deprecated
    public static Map<String, List<EntryInfo>> getBillMapByAsstactId(String entityNumber, QFilter qFilter, boolean isLoadPartner) {
        HashMap<String, List<EntryInfo>> billMap = new HashMap<String, List<EntryInfo>>();
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryBill", (String)entityNumber, (String)("id," + LoadBillForSettleSchemeHelper.getAsstactKey(entityNumber)), (QFilter[])qFilter.toArray(), (String)"bizdate desc");
        List<Map<String, Object>> dataList = LoadBillForSettleSchemeHelper.dataSet2List(dataSet);
        dataSet.close();
        if (isLoadPartner) {
            LoadBillForSettleSchemeHelper.repairDataListByPartner(dataList);
        } else {
            LoadBillForSettleSchemeHelper.repairDataListByMaster(dataList);
        }
        for (Map<String, Object> rowData : dataList) {
            Long id = (Long)rowData.get("id");
            Long entryId = (Long)rowData.get("entry.id");
            String key = ((Long)rowData.get("asstact.id")).toString();
            EntryInfo info = new EntryInfo(id, entryId);
            if (billMap.get(key) != null) {
                ((List)billMap.get(key)).add(info);
                continue;
            }
            ArrayList<EntryInfo> entryInfos = new ArrayList<EntryInfo>(10);
            entryInfos.add(info);
            billMap.put(key, entryInfos);
        }
        return billMap;
    }

    private static List<Map<String, Object>> dataSet2List(DataSet dataSet) {
        RowMeta rowMeta = dataSet.getRowMeta();
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(64);
        for (Row row : dataSet) {
            HashMap<String, Object> rowMap = new HashMap<String, Object>(8);
            int fieldCount = rowMeta.getFieldCount();
            for (int i = 0; i < fieldCount; ++i) {
                String fieldName = rowMeta.getFieldName(i);
                Object value = row.get(i);
                rowMap.put(fieldName, value);
            }
            dataList.add(rowMap);
        }
        return dataList;
    }

    private static void repairDataListByPartner(List<Map<String, Object>> dataList) {
        HashSet<Long> asstactIds = new HashSet<Long>(8);
        for (Map<String, Object> row : dataList) {
            Long asstactId = (Long)row.get("asstact.id");
            asstactIds.add(asstactId);
        }
        Map customers = BusinessDataServiceHelper.loadFromCache((String)"bd_customer", (String)"id,bizpartner.id", (QFilter[])new QFilter[]{new QFilter("id", "in", asstactIds)});
        Map suppliers = BusinessDataServiceHelper.loadFromCache((String)"bd_supplier", (String)"id,bizpartner.id", (QFilter[])new QFilter[]{new QFilter("id", "in", asstactIds)});
        Iterator<Map<String, Object>> dataListItr = dataList.iterator();
        while (dataListItr.hasNext()) {
            Map<String, Object> data = dataListItr.next();
            Object asstactId = data.get("asstact.id");
            DynamicObject customer = (DynamicObject)customers.get(asstactId);
            if (customer != null && customer.getLong("bizpartner.id") != 0L) {
                data.put("asstact.id", customer.getLong("bizpartner.id"));
                continue;
            }
            DynamicObject supplier = (DynamicObject)suppliers.get(asstactId);
            if (supplier != null && supplier.getLong("bizpartner.id") != 0L) {
                data.put("asstact.id", supplier.getLong("bizpartner.id"));
                continue;
            }
            dataListItr.remove();
        }
    }

    private static void repairDataListByMaster(List<Map<String, Object>> dataList) {
        HashSet<Long> asstactIds = new HashSet<Long>(8);
        for (Map<String, Object> row : dataList) {
            Long asstactId = (Long)row.get("asstact.id");
            asstactIds.add(asstactId);
        }
        Map customers = BusinessDataServiceHelper.loadFromCache((String)"bd_customer", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", asstactIds)});
        Map suppliers = BusinessDataServiceHelper.loadFromCache((String)"bd_supplier", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", asstactIds)});
        for (Map<String, Object> data : dataList) {
            Object asstactId = data.get("asstact.id");
            DynamicObject customer = (DynamicObject)customers.get(asstactId);
            if (customer != null) {
                data.put("asstact.id", customer.getLong("masterid"));
                continue;
            }
            DynamicObject supplier = (DynamicObject)suppliers.get(asstactId);
            if (supplier == null) continue;
            data.put("asstact.id", supplier.getLong("masterid"));
        }
    }

    private static String getAsstactKey(String entityNumber) {
        String asstactKey = null;
        switch (entityNumber) {
            case "ar_finarbill": {
                asstactKey = "asstact.id as asstact.id,entry.id";
                break;
            }
            case "ap_finapbill": {
                asstactKey = "asstact.id as asstact.id,detailentry.id as entry.id";
                break;
            }
            case "cas_recbill": {
                asstactKey = "payer as asstact.id,entry.id";
                break;
            }
            case "cas_paybill": {
                asstactKey = "payee as asstact.id,entry.id";
                break;
            }
            case "ar_receivedbill": {
                asstactKey = "asstact.id as asstact.id,entry.id";
                break;
            }
            case "ap_paidbill": {
                asstactKey = "payee.id as asstact.id,entry.id";
            }
        }
        return asstactKey;
    }

    public static DynamicObject[] getBill(String entityNumber, String selector, Set<Object> ids, List<Object> entryIds) {
        DynamicObject[] bills;
        QFilter qFilter = new QFilter("id", "in", ids);
        String entryIdKey = "entry.id";
        if ("ap_finapbill".equals(entityNumber)) {
            entryIdKey = "detailentry.id";
        }
        qFilter.and(entryIdKey, "in", entryIds);
        HashMap<Long, Long> entryIdMap = new HashMap<Long, Long>(entryIds.size());
        for (Object entryId : entryIds) {
            entryIdMap.put((Long)entryId, (Long)entryId);
        }
        String entryKey = "entry";
        if ("ap_finapbill".equals(entityNumber)) {
            entryKey = "detailentry";
        }
        for (DynamicObject bill : bills = BusinessDataServiceHelper.load((String)entityNumber, (String)selector, (QFilter[])qFilter.toArray())) {
            DynamicObjectCollection entries = bill.getDynamicObjectCollection(entryKey);
            Iterator iterator = entries.iterator();
            while (iterator.hasNext()) {
                DynamicObject entry = (DynamicObject)iterator.next();
                long entryId = entry.getLong("id");
                if (entryIdMap.get(entryId) != null) continue;
                iterator.remove();
            }
        }
        return bills;
    }

    public static DynamicObjectCollection getBillEntryInfo(String entityNumber, String selector, List<Object> entryIds) {
        String entryIdKey = "entry.id";
        if ("ap_finapbill".equals(entityNumber)) {
            entryIdKey = "detailentry.id";
        }
        QFilter qFilter = new QFilter(entryIdKey, "in", entryIds);
        return QueryServiceHelper.query((String)entityNumber, (String)selector, (QFilter[])qFilter.toArray());
    }

    private static List<String> getHeadFields(String entityNumber, Set<String> mainMatchFields) {
        ArrayList<String> fields = new ArrayList<String>(10);
        for (String field : mainMatchFields) {
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            DynamicProperty property = mainType.getProperty(field.split("\\.")[0]);
            if (property == null) continue;
            fields.add(field);
        }
        return fields;
    }

    public static QFilter buildQFilter(String entityNumber, Object ... param) {
        QFilter qFilter = null;
        switch (entityNumber) {
            case "ar_finarbill": {
                qFilter = LoadBillForSettleSchemeHelper.buildFinArBillQFilter(param);
                break;
            }
            case "ap_finapbill": {
                qFilter = LoadBillForSettleSchemeHelper.buildFinApBillQFilter(param);
                break;
            }
            case "cas_recbill": {
                qFilter = LoadBillForSettleSchemeHelper.buildRecBillQFilter(param);
                break;
            }
            case "cas_paybill": {
                qFilter = LoadBillForSettleSchemeHelper.buildPayBillQFilter(param);
                break;
            }
            case "ar_receivedbill": {
                qFilter = LoadBillForSettleSchemeHelper.buildRecedBillQFilter(param);
                break;
            }
            case "ap_paidbill": {
                qFilter = LoadBillForSettleSchemeHelper.buildPaidBillQFilter(param);
            }
        }
        return qFilter;
    }

    public static String buildSelector(String entityNumber, Object ... param) {
        String selector = "";
        switch (entityNumber) {
            case "ar_finarbill": {
                selector = String.join((CharSequence)",", FinArBillHandleHelper.getSelector()) + "," + LoadBillForSettleSchemeHelper.processMatchField(param[param_TWO], "entry", "planentity");
                break;
            }
            case "ap_finapbill": {
                selector = String.join((CharSequence)",", FinApBillHandleHelper.getSelector()) + "," + LoadBillForSettleSchemeHelper.processMatchField(param[param_TWO], "detailentry", "planentity");
                break;
            }
            case "cas_recbill": {
                selector = RecBillHandlerHelper.getSeletorOfRec() + "," + LoadBillForSettleSchemeHelper.processMatchField(param[param_TWO], "entry");
                break;
            }
            case "cas_paybill": {
                selector = PayBillHandleHelper.getSelectorOfPay() + "," + LoadBillForSettleSchemeHelper.processMatchField(param[param_TWO], "entry");
                break;
            }
            case "ar_receivedbill": {
                selector = RecBillHandlerHelper.getSeletorOfReced() + "," + LoadBillForSettleSchemeHelper.processMatchField(param[param_TWO], "entry");
                break;
            }
            case "ap_paidbill": {
                selector = PayBillHandleHelper.getSelectorOfPaid() + "," + LoadBillForSettleSchemeHelper.processMatchField(param[param_TWO], "entry");
            }
        }
        return selector;
    }

    private static QFilter buildFinArBillQFilter(Object[] param) {
        QFilter filterScheme;
        long orgId = (Long)param[param_ONE];
        boolean isSubmitSettle = (Boolean)param[param.length - 1];
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        QFilter filter = SettleExtDataLoader.loadSchemeSettleDefaultFilterKeys("ar_finarbill");
        if (isSubmitSettle) {
            LoadBillForSettleSchemeHelper.generateNewQFilter(filter);
        }
        if (filter != null) {
            qFilter.and(filter);
        }
        if ((filterScheme = LoadBillForSettleSchemeHelper.getSchemeFilter((String)param[param_THREE], "ar_finarbill")) != null) {
            qFilter.and(filterScheme);
        }
        qFilter.and("hadwrittenoff", "=", (Object)Boolean.FALSE);
        qFilter.and("iswrittenoff", "=", (Object)Boolean.FALSE);
        return qFilter;
    }

    private static void generateNewQFilter(QFilter filter) {
        if ("billstatus".equals(filter.getProperty())) {
            filter.__setCP("<>");
            filter.__setValue((Object)"A");
        } else {
            List filterNest = filter.getNests(true);
            for (QFilter.QFilterNest nest : filterNest) {
                QFilter filterInner = nest.getFilter();
                String innerProperty = filterInner.getProperty();
                if (!"billstatus".equals(innerProperty)) continue;
                filterInner.__setCP("<>");
                filterInner.__setValue((Object)"A");
                break;
            }
        }
    }

    private static QFilter buildFinApBillQFilter(Object[] param) {
        long orgId = (Long)param[param_ONE];
        boolean isSubmitSettle = (Boolean)param[param.length - 1];
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        QFilter filterScheme = LoadBillForSettleSchemeHelper.getSchemeFilter((String)param[param_THREE], "ap_finapbill");
        if (filterScheme != null) {
            qFilter.and(filterScheme);
        }
        QFilter filter = SettleExtDataLoader.loadSchemeSettleDefaultFilterKeys("ap_finapbill");
        if (isSubmitSettle) {
            LoadBillForSettleSchemeHelper.generateNewQFilter(filter);
        }
        if (filter != null) {
            qFilter.and(filter);
        }
        qFilter.and("hadwrittenoff", "=", (Object)Boolean.FALSE);
        qFilter.and("iswrittenoff", "=", (Object)Boolean.FALSE);
        return qFilter;
    }

    private static QFilter buildRecBillQFilter(Object[] param) {
        QFilter filter;
        long orgId = (Long)param[param_ONE];
        QFilter qFilter = new QFilter("entry.e_settleorg", "=", (Object)orgId);
        QFilter filterScheme = LoadBillForSettleSchemeHelper.getSchemeFilter((String)param[param_THREE], "cas_recbill");
        if (filterScheme != null) {
            qFilter.and(filterScheme);
        }
        if ((filter = SettleExtDataLoader.loadSchemeSettleDefaultFilterKeys("cas_recbill")) != null) {
            filter.and(new QFilter("entry.e_receivingtype.ispartreceivable", "=", (Object)Boolean.TRUE));
            qFilter.and(filter);
        }
        return qFilter;
    }

    private static QFilter buildPayBillQFilter(Object[] param) {
        QFilter filter;
        long orgId = (Long)param[param_ONE];
        QFilter qFilter = new QFilter("entry.settleorg", "=", (Object)orgId);
        QFilter filterScheme = LoadBillForSettleSchemeHelper.getSchemeFilter((String)param[param_THREE], "cas_paybill");
        if (filterScheme != null) {
            qFilter.and(filterScheme);
        }
        if ((filter = SettleExtDataLoader.loadSchemeSettleDefaultFilterKeys("cas_paybill")) != null) {
            filter.and(new QFilter("entry.e_paymenttype.ispartpayment", "=", (Object)Boolean.TRUE));
            qFilter.and(filter);
        }
        return qFilter;
    }

    private static QFilter buildRecedBillQFilter(Object[] param) {
        QFilter filterScheme;
        long orgId = (Long)param[param_ONE];
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        QFilter filter = SettleExtDataLoader.loadSchemeSettleDefaultFilterKeys("ar_receivedbill");
        if (filter != null) {
            qFilter.and(filter);
        }
        if ((filterScheme = LoadBillForSettleSchemeHelper.getSchemeFilter((String)param[param_THREE], "ar_receivedbill")) != null) {
            qFilter.and(filterScheme);
        }
        return qFilter;
    }

    private static QFilter buildPaidBillQFilter(Object[] param) {
        QFilter filterScheme;
        long orgId = (Long)param[param_ONE];
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        qFilter.and("paymenttype.ispartpayment", "=", (Object)Boolean.TRUE);
        QFilter filter = SettleExtDataLoader.loadSchemeSettleDefaultFilterKeys("ap_paidbill");
        if (filter != null) {
            qFilter.and(filter);
        }
        if ((filterScheme = LoadBillForSettleSchemeHelper.getSchemeFilter((String)param[param_THREE], "ap_paidbill")) != null) {
            qFilter.and(filterScheme);
        }
        return qFilter;
    }

    private static String processMatchField(Object matchFieldSelector, String ... entryKeys) {
        StringBuilder selector = new StringBuilder();
        String s = "";
        if (!ObjectUtils.isEmpty((Object)matchFieldSelector)) {
            String[] fields;
            for (String field : fields = matchFieldSelector.toString().split(",")) {
                boolean entryField = false;
                for (String entryKey : entryKeys) {
                    if (!field.startsWith(entryKey)) continue;
                    entryField = true;
                    field = field.substring(entryKey.length() + 1);
                    selector.append(field).append(',');
                    break;
                }
                if (entryField) continue;
                selector.append(field).append(',');
            }
            s = selector.toString();
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    private static QFilter getSchemeFilter(String condition, String number) {
        if (StringUtils.isBlank((String)condition)) {
            return null;
        }
        CRCondition formula = (CRCondition)SerializationUtils.fromJsonString((String)condition, CRCondition.class);
        FilterCondition filterCondition = formula.getFilterCondition();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)number);
        FilterBuilder filterBuilder = new FilterBuilder(dataEntityType, filterCondition, true);
        filterBuilder.buildFilter(false);
        return filterBuilder.getQFilter();
    }

    public static class EntryInfo {
        private Long id;
        private Long entryId;

        public EntryInfo(Long id, Long entryId) {
            this.id = id;
            this.entryId = entryId;
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public Long getEntryId() {
            return this.entryId;
        }

        public void setEntryId(Long entryId) {
            this.entryId = entryId;
        }
    }
}

