/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.LineTypeHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.model.BillModel;
import kd.fi.arapcommon.model.BillModelFactory;
import kd.fi.arapcommon.service.plan.split.PlanSplitAndBuilder;

public class PremiumConvertServiceHelper {
    private static final String AR_RULE = "1854435828927840256";
    private static final String AP_RULE = "742441181224392704";
    private static final String AR_PREMPARAM = "ar_auditpre";
    private static final String AP_PREMPARAM = "ap_auditpre";
    private static final Log logger = LogFactory.getLog(PremiumConvertServiceHelper.class);
    private static boolean isAr;
    private static BillModel billModel;

    public static void pushAndSave(Map<Long, DynamicObject> finBillMap, String billEntity) {
        PremiumConvertServiceHelper.initHelper(billEntity);
        ArrayList<Long> finBillIds = new ArrayList<Long>(finBillMap.keySet());
        ArrayList<Long> orgIds = new ArrayList<Long>(2);
        List<DynamicObject> premiun = BOTPHelper.push(billEntity, billEntity, isAr ? AR_RULE : AP_RULE, finBillIds);
        if (premiun.size() > 0) {
            for (DynamicObject dynamicObject : premiun) {
                long orgId = dynamicObject.getLong(PremiumConvertServiceHelper.billModel.HEAD_ORG + ".id");
                orgIds.add(orgId);
            }
            Map<Long, Object> lineTypeCheck = LineTypeHelper.batchGetParam(orgIds, isAr);
            for (DynamicObject premiumBill : premiun) {
                long billTypeId;
                DynamicObject bizTypeDym;
                DynamicObject finBill = finBillMap.get(premiumBill.getLong(PremiumConvertServiceHelper.billModel.HEAD_SOURCEBILLID));
                if (ObjectUtils.isEmpty((Object)finBill)) continue;
                long orgId = premiumBill.getLong(PremiumConvertServiceHelper.billModel.HEAD_ORG + ".id");
                Boolean isLineType = (Boolean)lineTypeCheck.get(orgId);
                if (isLineType != null && isLineType.booleanValue() && (bizTypeDym = LineTypeHelper.getDefaultBizType(billTypeId = premiumBill.getLong(PremiumConvertServiceHelper.billModel.HEAD_BILLTYPE + ".id"))) != null) {
                    premiumBill.set(PremiumConvertServiceHelper.billModel.HEAD_BIZTYPE, (Object)bizTypeDym);
                    long lineTypeId = LineTypeHelper.getDefaultLineTypeId(bizTypeDym.getLong("id"));
                    DynamicObject lineType = LineTypeHelper.getLineTypebyId(lineTypeId);
                    DynamicObjectCollection entry = premiumBill.getDynamicObjectCollection(PremiumConvertServiceHelper.billModel.ENTRY);
                    for (DynamicObject row : entry) {
                        row.set(PremiumConvertServiceHelper.billModel.E_LINETYPE, (Object)lineType);
                    }
                }
                PremiumConvertServiceHelper.setDetailEntry(premiumBill, finBill);
                PremiumConvertServiceHelper.setHeadAmt(premiumBill);
                PremiumConvertServiceHelper.setPlanEntry(premiumBill);
                PremiumConvertServiceHelper.setHeadDueDate(premiumBill);
            }
            Map<Long, Object> map = SystemParameterHelper.batchGetAppParameter(isAr, orgIds, isAr ? AR_PREMPARAM : AP_PREMPARAM);
            ArrayList<Long> canAuditBills = new ArrayList<Long>(premiun.size());
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)billEntity, (DynamicObject[])premiun.toArray(new DynamicObject[0]), (OperateOption)option);
            PremiumConvertServiceHelper.addAssertResult(saveResult, "save");
            for (DynamicObject bill : premiun) {
                boolean canAudit = false;
                Object orgCanAudit = map.get(bill.getLong(PremiumConvertServiceHelper.billModel.HEAD_ORG + ".id"));
                if (!ObjectUtils.isEmpty((Object)orgCanAudit)) {
                    canAudit = (Boolean)orgCanAudit;
                }
                if (!saveResult.getSuccessPkIds().contains(bill.getLong("id")) || !canAudit) continue;
                canAuditBills.add(bill.getLong("id"));
            }
            if (canAuditBills.size() > 0) {
                OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)billEntity, (Object[])canAuditBills.toArray(), (OperateOption)option);
                PremiumConvertServiceHelper.addAssertResult(submitResult, "submit");
                OperateOption auditOp = OperateOption.create();
                auditOp.setVariableValue("WF", "false");
                auditOp.setVariableValue("ishasright", "true");
                OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)billEntity, (Object[])canAuditBills.toArray(), (OperateOption)auditOp);
                PremiumConvertServiceHelper.addAssertResult(auditResult, "audit");
            }
        }
    }

    private static void initHelper(String billEntity) {
        isAr = billEntity.startsWith("ar_");
        billModel = BillModelFactory.getModel(billEntity);
    }

    private static void setDetailEntry(DynamicObject premiumBill, DynamicObject finBill) {
        DynamicObjectCollection entry = premiumBill.getDynamicObjectCollection(PremiumConvertServiceHelper.billModel.ENTRY);
        if (!ObjectUtils.isEmpty((Object)entry)) {
            Iterator iterator = entry.iterator();
            while (iterator.hasNext()) {
                DynamicObject row = (DynamicObject)iterator.next();
                BigDecimal e_pricetaxtotal = row.getBigDecimal(PremiumConvertServiceHelper.billModel.E_PRICETAXTOTAL);
                if (e_pricetaxtotal.compareTo(BigDecimal.ZERO) != 0) continue;
                iterator.remove();
            }
        }
        DynamicObject srcEntry = (DynamicObject)finBill.getDynamicObjectCollection(PremiumConvertServiceHelper.billModel.ENTRY).get(0);
        String coreBillType = srcEntry.getString(PremiumConvertServiceHelper.billModel.E_COREBILLTYPE);
        Long srcCoreBillId = srcEntry.getLong(PremiumConvertServiceHelper.billModel.E_COREBILLID);
        String coreBillNo = srcEntry.getString(PremiumConvertServiceHelper.billModel.E_COREBILLNO);
        Long coreBillEntryId = srcEntry.getLong(PremiumConvertServiceHelper.billModel.E_COREBILLENTRYID);
        Long conBillId = srcEntry.getLong(PremiumConvertServiceHelper.billModel.E_CONBILLID);
        Long conBillEntryId = srcEntry.getLong(PremiumConvertServiceHelper.billModel.E_CONBILLENTRYID);
        DynamicObjectCollection premBillEntry = premiumBill.getDynamicObjectCollection(PremiumConvertServiceHelper.billModel.ENTRY);
        if (srcCoreBillId != 0L) {
            for (DynamicObject row : premBillEntry) {
                row.set(PremiumConvertServiceHelper.billModel.E_COREBILLTYPE, (Object)coreBillType);
                row.set(PremiumConvertServiceHelper.billModel.E_COREBILLID, (Object)srcCoreBillId);
                row.set(PremiumConvertServiceHelper.billModel.E_COREBILLNO, (Object)coreBillNo);
                row.set(PremiumConvertServiceHelper.billModel.E_COREBILLENTRYID, (Object)coreBillEntryId);
            }
        }
        if (conBillId != 0L) {
            for (DynamicObject row : premBillEntry) {
                row.set(PremiumConvertServiceHelper.billModel.E_CONBILLID, (Object)conBillId);
                row.set(PremiumConvertServiceHelper.billModel.E_CONBILLENTRYID, (Object)conBillEntryId);
            }
        }
    }

    private static void setPlanEntry(DynamicObject premiumBill) {
        PlanSplitAndBuilder.splitAndBuild(premiumBill);
    }

    private static void setHeadAmt(DynamicObject premiumBill) {
        BigDecimal pricetaxtotal = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal pricetaxtotalLoc = BigDecimal.ZERO;
        BigDecimal amountLoc = BigDecimal.ZERO;
        BigDecimal taxLoc = BigDecimal.ZERO;
        BigDecimal adjustAmt = BigDecimal.ZERO;
        BigDecimal adjustAmtLoc = BigDecimal.ZERO;
        DynamicObjectCollection detailEntry = premiumBill.getDynamicObjectCollection(PremiumConvertServiceHelper.billModel.ENTRY);
        for (DynamicObject detailRow : detailEntry) {
            pricetaxtotal = pricetaxtotal.add(detailRow.getBigDecimal(PremiumConvertServiceHelper.billModel.E_PRICETAXTOTAL));
            pricetaxtotalLoc = pricetaxtotalLoc.add(detailRow.getBigDecimal(PremiumConvertServiceHelper.billModel.E_PRICETAXTOTALLOC));
            amount = amount.add(detailRow.getBigDecimal(PremiumConvertServiceHelper.billModel.E_AMOUNT));
            amountLoc = amountLoc.add(detailRow.getBigDecimal(PremiumConvertServiceHelper.billModel.E_LOCALAMT));
            tax = tax.add(detailRow.getBigDecimal(PremiumConvertServiceHelper.billModel.E_TAX));
            taxLoc = taxLoc.add(detailRow.getBigDecimal(PremiumConvertServiceHelper.billModel.E_TAXLOCALAMT));
            adjustAmt = adjustAmt.add(detailRow.getBigDecimal("e_adjustamount"));
            adjustAmtLoc = adjustAmtLoc.add(detailRow.getBigDecimal("e_adjustlocalamt"));
        }
        premiumBill.set(PremiumConvertServiceHelper.billModel.HEAD_PRICETAXTOTAL, (Object)pricetaxtotal);
        premiumBill.set(PremiumConvertServiceHelper.billModel.HEAD_PRICETAXTOTALLOC, (Object)pricetaxtotalLoc);
        premiumBill.set(PremiumConvertServiceHelper.billModel.HEAD_AMOUNT, (Object)amount);
        premiumBill.set(PremiumConvertServiceHelper.billModel.HEAD_LOCALAMT, (Object)amountLoc);
        premiumBill.set(PremiumConvertServiceHelper.billModel.HEAD_TAX, (Object)tax);
        premiumBill.set(PremiumConvertServiceHelper.billModel.HEAD_TAXLOCAMT, (Object)taxLoc);
        premiumBill.set(PremiumConvertServiceHelper.billModel.HEAD_UNVERIFYAMOUNT, (Object)amount);
        premiumBill.set(PremiumConvertServiceHelper.billModel.HEAD_UNSETTLEAMOUNT, (Object)pricetaxtotal);
        premiumBill.set(PremiumConvertServiceHelper.billModel.HEAD_UNSETTLELOCALAMT, (Object)pricetaxtotalLoc);
        premiumBill.set("adjustamount", (Object)adjustAmt);
        premiumBill.set("adjustlocalamt", (Object)adjustAmtLoc);
        premiumBill.set(PremiumConvertServiceHelper.billModel.HEAD_UNINVOICEDAMT, (Object)pricetaxtotal);
        if (isAr) {
            premiumBill.set("uninvoicedlocalamt", (Object)pricetaxtotalLoc);
        }
        premiumBill.set("premiumamt", (Object)BigDecimal.ZERO);
    }

    private static void setHeadDueDate(DynamicObject premiumBill) {
        Date planMaxDueDate = premiumBill.getDate(PremiumConvertServiceHelper.billModel.HEAD_DUEDATE);
        DynamicObjectCollection planEntry = premiumBill.getDynamicObjectCollection(PremiumConvertServiceHelper.billModel.P_ENTRY);
        for (DynamicObject row : planEntry) {
            Date planEntryDueDate = row.getDate(PremiumConvertServiceHelper.billModel.P_PLANDUEDATE);
            if (planMaxDueDate == null) {
                planMaxDueDate = planEntryDueDate;
                continue;
            }
            if (planEntryDueDate == null) continue;
            planMaxDueDate = planEntryDueDate.after(planMaxDueDate) ? planEntryDueDate : planMaxDueDate;
        }
        premiumBill.set(PremiumConvertServiceHelper.billModel.HEAD_DUEDATE, (Object)planMaxDueDate);
    }

    public static void addAssertResult(OperationResult result, String operation) {
        List validateInfos = result.getAllErrorOrValidateInfo();
        StringBuilder sb = new StringBuilder();
        if (!result.isSuccess()) {
            try {
                OperationHelper.assertResult(result);
            }
            catch (Exception e) {
                if (validateInfos.isEmpty()) {
                    sb.append(result.getMessage());
                } else {
                    for (IOperateInfo err : validateInfos) {
                        sb.append(err.getMessage()).append('\n');
                    }
                }
                switch (operation) {
                    case "save": {
                        String errMsg = ResManager.loadKDString((String)"\u8d28\u4fdd\u91d1\u5355\u636e\u4fdd\u5b58\u5931\u8d25\uff1a%s", (String)"PremiumConvertServiceHelper_0", (String)"fi-arapcommon", (Object[])new Object[]{sb.toString()});
                        ErrorCode errorCode = new ErrorCode("save_err", errMsg);
                        throw new KDBizException(errorCode, new Object[0]);
                    }
                    case "submit": {
                        logger.info("\u8d28\u4fdd\u91d1\u63d0\u4ea4\u5931\u8d25:" + sb);
                        String errMsg = ResManager.loadKDString((String)"\u8d28\u4fdd\u91d1\u5355\u636e\u63d0\u4ea4\u5931\u8d25\uff1a%s\u3002", (String)"PremiumConvertServiceHelper_1", (String)"fi-arapcommon", (Object[])new Object[]{sb.toString()});
                        ErrorCode errorCode = new ErrorCode("submit_err", errMsg);
                        throw new KDBizException(errorCode, new Object[0]);
                    }
                    case "audit": {
                        logger.info("\u8d28\u4fdd\u91d1\u5ba1\u6838\u5931\u8d25:" + sb);
                        String errMsg = ResManager.loadKDString((String)"\u8d28\u4fdd\u91d1\u5355\u636e\u5ba1\u6838\u5931\u8d25\uff1a%s\u3002", (String)"PremiumConvertServiceHelper_2", (String)"fi-arapcommon", (Object[])new Object[]{sb.toString()});
                        ErrorCode errorCode = new ErrorCode("audit_err", errMsg);
                        throw new KDBizException(errorCode, new Object[0]);
                    }
                }
            }
        }
    }
}

