/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class SettleHelper {
    private static final String PARTNER = "bizpartner";

    public static boolean isAsstMatch(IDataModel dataModel, boolean mailBill, int[] selectRows, Map<String, List<DynamicObject>> asstTypeToAsstListMap) {
        int matchType = SettleHelper.getMatchType(dataModel, mailBill, selectRows);
        if (matchType == 1) {
            return SettleHelper.isPartnerAsstMatch(asstTypeToAsstListMap.get("bd_customer"), asstTypeToAsstListMap.get("bd_supplier"));
        }
        if (matchType == 2) {
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(16);
            asstTypeToAsstListMap.forEach((key, value) -> {
                if (EmptyUtils.isNotEmpty(value)) {
                    list.addAll((Collection<DynamicObject>)value);
                }
            });
            return SettleHelper.isAsstMatch(list);
        }
        return SettleHelper.isAsstNameMatch(dataModel, mailBill, selectRows);
    }

    public static boolean isAsstMatch(IDataModel dataModel, int[] mainSelectRows, Map<String, List<DynamicObject>> mainAsstTypeToAsstListMap, int[] asstSelectRows, Map<String, List<DynamicObject>> asstTypeToAsstListMap) {
        int asstMatchType;
        int mainMatchType = SettleHelper.getMatchType(dataModel, true, mainSelectRows);
        if (mainMatchType != (asstMatchType = SettleHelper.getMatchType(dataModel, false, asstSelectRows))) {
            return false;
        }
        Object mainMatchValue = SettleHelper.getMatchValue(dataModel, true, mainMatchType, mainSelectRows, mainAsstTypeToAsstListMap);
        Object asstMatchValue = SettleHelper.getMatchValue(dataModel, false, asstMatchType, asstSelectRows, asstTypeToAsstListMap);
        if (EmptyUtils.isEmpty(mainMatchType) || EmptyUtils.isEmpty(asstMatchType)) {
            return false;
        }
        return mainMatchValue.equals(asstMatchValue);
    }

    private static Object getMatchValue(IDataModel dataModel, boolean mainBill, int mainMatchType, int[] mainSelectRows, Map<String, List<DynamicObject>> mainAsstTypeToAsstListMap) {
        if (mainMatchType == 3) {
            return dataModel.getEntryRowEntity(mainBill ? "mainbill" : "asstbill", mainSelectRows[0]).getString(mainBill ? "asstactname" : "asst_asstactname");
        }
        List<DynamicObject> supplierList = mainAsstTypeToAsstListMap.get("bd_supplier");
        List<DynamicObject> customerList = mainAsstTypeToAsstListMap.get("bd_customer");
        if (mainMatchType == 1) {
            return EmptyUtils.isEmpty(supplierList) ? customerList.get(0).getLong(PARTNER) : supplierList.get(0).getLong(PARTNER);
        }
        for (Map.Entry<String, List<DynamicObject>> entry : mainAsstTypeToAsstListMap.entrySet()) {
            List<DynamicObject> asstList = entry.getValue();
            if (EmptyUtils.isEmpty(asstList)) continue;
            return asstList.get(0).getLong("id");
        }
        return "";
    }

    private static boolean isPartnerAsstMatch(List<DynamicObject> customerList, List<DynamicObject> supplierList) {
        List result;
        ArrayList<DynamicObject> mergeList = new ArrayList<DynamicObject>(16);
        if (EmptyUtils.isNotEmpty(customerList)) {
            mergeList.addAll(customerList);
        }
        if (EmptyUtils.isNotEmpty(supplierList)) {
            mergeList.addAll(supplierList);
        }
        return (result = mergeList.stream().map(entity -> entity.getLong(PARTNER)).distinct().collect(Collectors.toList())).size() == 1;
    }

    private static boolean isAsstMatch(List<DynamicObject> asstList) {
        List result = asstList.stream().map(entity -> entity.getLong("id")).distinct().collect(Collectors.toList());
        return result.size() == 1;
    }

    private static boolean isAsstNameMatch(IDataModel dataModel, boolean mainBill, int[] selectRows) {
        String asstName = dataModel.getEntryRowEntity(mainBill ? "mainbill" : "asstbill", selectRows[0]).getString(mainBill ? "asstactname" : "asst_asstactname");
        for (int i = 1; i < selectRows.length; ++i) {
            String currentAsstName = dataModel.getEntryRowEntity(mainBill ? "mainbill" : "asstbill", selectRows[i]).getString(mainBill ? "asstactname" : "asst_asstactname");
            if (asstName.equals(currentAsstName)) continue;
            return false;
        }
        return true;
    }

    private static int getMatchType(IDataModel dataModel, boolean mainBill, int[] selectRows) {
        int partnerCount = 0;
        int[] nArray = selectRows;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int row;
            DynamicObject selectRow = dataModel.getEntryRowEntity(mainBill ? "mainbill" : "asstbill", row = nArray[i]);
            DynamicObject asst = selectRow.getDynamicObject(mainBill ? "asstact" : "asst_asstact");
            if (EmptyUtils.isEmpty(asst)) {
                return 3;
            }
            String asstType = selectRow.getString(mainBill ? "asstacttype" : "asst_asstacttype");
            if (!"bd_supplier".equals(asstType) && !"bd_customer".equals(asstType)) continue;
            ++partnerCount;
        }
        if (partnerCount == selectRows.length) {
            return 1;
        }
        return 2;
    }

    public static Map<String, List<DynamicObject>> getAsstTypeToAssListMap(IDataModel dataModel, boolean mainBill, int[] selectRows) {
        HashMap<String, List<DynamicObject>> asstTypeToAssListMap = new HashMap<String, List<DynamicObject>>(16);
        Map<String, List<Long>> mainBillAsstTpeToAsstIdListMap = SettleHelper.getAsstTypeToAssIdListMap(dataModel, mainBill, selectRows);
        for (Map.Entry<String, List<Long>> entry : mainBillAsstTpeToAsstIdListMap.entrySet()) {
            String selectField = "id,number";
            if ("bd_supplier".equals(entry.getKey()) || "bd_customer".equals(entry.getKey())) {
                selectField = "id,number,bizpartner";
            }
            if (EmptyUtils.isEmpty(entry.getValue())) continue;
            DynamicObjectCollection collection = QueryServiceHelper.query((String)entry.getKey(), (String)selectField, (QFilter[])new QFilter[]{new QFilter("id", "in", entry.getValue())});
            asstTypeToAssListMap.put(entry.getKey(), (List<DynamicObject>)collection);
        }
        return asstTypeToAssListMap;
    }

    private static Map<String, List<Long>> getAsstTypeToAssIdListMap(IDataModel dataModel, boolean mainBill, int[] selectRows) {
        HashMap<String, List<Long>> asstTypeToAsstIdListMap = new HashMap<String, List<Long>>(16);
        int[] nArray = selectRows;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            DynamicObject asst;
            int row;
            DynamicObject selectRow = dataModel.getEntryRowEntity(mainBill ? "mainbill" : "asstbill", row = nArray[i]);
            String asstType = selectRow.getString(mainBill ? "asstacttype" : "asst_asstacttype");
            if (EmptyUtils.isEmpty(asstType) || EmptyUtils.isEmpty(asst = selectRow.getDynamicObject(mainBill ? "asstact" : "asst_asstact"))) continue;
            List asstIdList = asstTypeToAsstIdListMap.getOrDefault(asstType, new ArrayList(16));
            asstIdList.add(asst.getLong("id"));
            asstTypeToAsstIdListMap.put(asstType, asstIdList);
        }
        return asstTypeToAsstIdListMap;
    }
}

