/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.log;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.arapcommon.service.helper.SettleLogHelper;
import kd.fi.arapcommon.service.log.BillLogHelper;
import kd.fi.arapcommon.service.log.OpLogInfo;
import kd.fi.arapcommon.util.EntityMetadataUtils;

public class OpLogConsumer
implements MessageConsumer {
    private static Log logger = LogFactory.getLog(OpLogConsumer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Object body, String messageId, boolean resend, MessageAcker acker) {
        List logList = null;
        if (!(body instanceof List)) {
            logger.info("OpLogConsumer:body param error");
            acker.ack(messageId);
            return;
        }
        try {
            logList = (List)body;
            int size = logList.size();
            OpLogInfo firstLog = (OpLogInfo)logList.get(0);
            String entity = firstLog.getEntity();
            ArrayList<DynamicObject> logObjList = new ArrayList<DynamicObject>(size);
            HashMap<String, DynamicObject> reloadObjMap = new HashMap<String, DynamicObject>(size);
            ArrayList<Object> pkList = new ArrayList<Object>(size);
            for (OpLogInfo logInfo : logList) {
                if (!logInfo.isSaveJson() || !logInfo.isNeedReload()) continue;
                pkList.add(logInfo.getObj().getPkValue());
            }
            if (!pkList.isEmpty()) {
                String billSelector = BillLogHelper.getBillSelector(entity);
                DynamicObject[] reloadObjs = StringUtils.isEmpty((String)billSelector) ? BusinessDataServiceHelper.load((Object[])pkList.toArray(), (DynamicObjectType)firstLog.getObj().getDynamicObjectType()) : BusinessDataServiceHelper.load((String)entity, (String)billSelector, (QFilter[])new QFilter[]{new QFilter("id", "in", pkList)});
                for (DynamicObject reloadObj : reloadObjs) {
                    reloadObjMap.put(reloadObj.getPkValue().toString(), reloadObj);
                }
            }
            for (OpLogInfo logInfo : logList) {
                DynamicObject logObj = BusinessDataServiceHelper.newDynamicObject((String)"ap_oplog");
                logObj.set("bizobj", (Object)entity);
                logObj.set("user", (Object)logInfo.getUserID());
                logObj.set("optime", (Object)logInfo.getOpTime());
                logObj.set("opname", (Object)logInfo.getOpName());
                logObj.set("opdesc_tag", logInfo.getOpDescription());
                logObj.set("clientip", (Object)logInfo.getClientIP());
                if (logInfo.isSaveJson()) {
                    DynamicObject obj;
                    if (logInfo.isNeedReload()) {
                        logInfo.setObj((DynamicObject)reloadObjMap.get(logInfo.getObj().getPkValue().toString()));
                    }
                    if ((obj = logInfo.getObj()) != null) {
                        if (EntityMetadataUtils.isExistProperty(obj, "billno")) {
                            logObj.set("billno", obj.get("billno"));
                        }
                        if (logInfo.getObjJsonStr() == null) {
                            String jsonString = SerializationUtils.toJsonString((Object)obj);
                            logObj.set("billinfo_tag", (Object)jsonString);
                        }
                    } else {
                        logObj.set("billno", (Object)logInfo.getBillNo());
                        logObj.set("billinfo_tag", (Object)logInfo.getObjJsonStr());
                    }
                } else {
                    logObj.set("billno", (Object)logInfo.getBillNo());
                }
                logObj.set("traceid", (Object)logInfo.getTraceId());
                if (StringUtils.isEmpty((String)logObj.getString("billno"))) {
                    logObj.set("billno", (Object)logInfo.getTraceId());
                }
                logObjList.add(logObj);
            }
            SaveServiceHelper.save((DynamicObject[])logObjList.toArray(new DynamicObject[0]));
        }
        catch (Exception e) {
            logger.info(SettleLogHelper.getStackTraceMessage(e));
        }
        finally {
            acker.ack(messageId);
        }
    }
}

