/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.manualsettle;

import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.service.manualsettle.AbstractSettleBillProvider;
import kd.fi.arapcommon.service.manualsettle.IManualSettleBillProvider;
import kd.fi.arapcommon.service.manualsettle.ManualProviderParam;
import kd.fi.arapcommon.service.manualsettle.ManualSettleFinApBillProvider;
import kd.fi.arapcommon.service.manualsettle.ManualSettleFinApRedBillProvider;
import kd.fi.arapcommon.service.manualsettle.ManualSettleFinArBillProvider;
import kd.fi.arapcommon.service.manualsettle.ManualSettleFinArRedBillProvider;
import kd.fi.arapcommon.service.manualsettle.ManualSettleLossBillProvider;
import kd.fi.arapcommon.service.manualsettle.ManualSettlePayBillProvider;
import kd.fi.arapcommon.service.manualsettle.ManualSettlePayFundBillProvider;
import kd.fi.arapcommon.service.manualsettle.ManualSettleRecBillProvider;
import kd.fi.arapcommon.service.manualsettle.ManualSettleRecFundBillProvider;

public class ManualSettleBillProviderFactory {
    public static IManualSettleBillProvider getMainBillProvider(ManualProviderParam param) {
        AbstractSettleBillProvider provider = null;
        String settleRelation = param.getSettleRelation();
        if (SettleRelationEnum.APPAYSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.APARSETTLE.getValue().equals(settleRelation)) {
            provider = new ManualSettleFinApBillProvider(param);
        } else if (SettleRelationEnum.RECSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.ARAPSETTLE.getValue().equals(settleRelation)) {
            provider = new ManualSettleFinArBillProvider(param);
        } else if (SettleRelationEnum.BADDEBTRECOVERY.getValue().equals(settleRelation)) {
            provider = new ManualSettleLossBillProvider(param);
        } else if (SettleRelationEnum.RECPAYSETTLE.getValue().equals(settleRelation)) {
            provider = new ManualSettleRecBillProvider(param);
        } else if (SettleRelationEnum.PAYRECSETTLE.getValue().equals(settleRelation)) {
            provider = new ManualSettlePayBillProvider(param);
        } else if (SettleRelationEnum.ARPAYSETTLE.getValue().equals(settleRelation)) {
            provider = new ManualSettleFinArRedBillProvider(param);
        } else if (SettleRelationEnum.APRECSETTLE.getValue().equals(settleRelation)) {
            provider = new ManualSettleFinApRedBillProvider(param);
        } else if (SettleRelationEnum.APSELF.getValue().equals(settleRelation)) {
            param.setFilterType(1);
            provider = new ManualSettleFinApBillProvider(param);
        } else if (SettleRelationEnum.PAYSELF.getValue().equals(settleRelation)) {
            param.setFilterType(1);
            provider = new ManualSettlePayBillProvider(param);
        } else if (SettleRelationEnum.ARSELF.getValue().equals(settleRelation)) {
            param.setFilterType(1);
            provider = new ManualSettleFinArBillProvider(param);
        } else if (SettleRelationEnum.RECSELF.getValue().equals(settleRelation)) {
            param.setFilterType(1);
            provider = new ManualSettleRecBillProvider(param);
        } else if (SettleRelationEnum.RECCLEARINGSETTLE.getValue().equals(settleRelation)) {
            param.setFilterType(1);
            provider = new ManualSettleRecBillProvider(param);
        } else if (SettleRelationEnum.PAYCLEARINGSETTLE.getValue().equals(settleRelation)) {
            param.setFilterType(1);
            provider = new ManualSettlePayBillProvider(param);
        }
        return provider;
    }

    public static IManualSettleBillProvider getAsstBillProvider(ManualProviderParam param) {
        AbstractSettleBillProvider provider = null;
        String settleRelation = param.getSettleRelation();
        if (SettleRelationEnum.APPAYSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.RECPAYSETTLE.getValue().equals(settleRelation)) {
            provider = new ManualSettlePayBillProvider(param);
        } else if (SettleRelationEnum.ARAPSETTLE.getValue().equals(settleRelation)) {
            provider = new ManualSettleFinApBillProvider(param);
        } else if (SettleRelationEnum.APARSETTLE.getValue().equals(settleRelation)) {
            provider = new ManualSettleFinArBillProvider(param);
        } else if (SettleRelationEnum.RECSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.BADDEBTRECOVERY.getValue().equals(settleRelation) || SettleRelationEnum.PAYRECSETTLE.getValue().equals(settleRelation)) {
            provider = new ManualSettleRecBillProvider(param);
        } else if (SettleRelationEnum.ARPAYSETTLE.getValue().equals(settleRelation)) {
            provider = new ManualSettlePayFundBillProvider(param);
        } else if (SettleRelationEnum.APRECSETTLE.getValue().equals(settleRelation)) {
            provider = new ManualSettleRecFundBillProvider(param);
        } else if (SettleRelationEnum.APSELF.getValue().equals(settleRelation)) {
            param.setFilterType(-1);
            provider = new ManualSettleFinApBillProvider(param);
        } else if (SettleRelationEnum.PAYSELF.getValue().equals(settleRelation)) {
            param.setFilterType(-1);
            provider = new ManualSettlePayBillProvider(param);
        } else if (SettleRelationEnum.ARSELF.getValue().equals(settleRelation)) {
            param.setFilterType(-1);
            provider = new ManualSettleFinArBillProvider(param);
        } else if (SettleRelationEnum.RECSELF.getValue().equals(settleRelation)) {
            param.setFilterType(-1);
            provider = new ManualSettleRecBillProvider(param);
        }
        return provider;
    }
}

