/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.manualsettle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.orm.query.QFilter;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.service.manualsettle.AbstractSettleBillProvider;
import kd.fi.arapcommon.service.manualsettle.ManualProviderParam;
import kd.fi.arapcommon.service.manualsettle.ManualSettleRecedBillProvider;

public class ManualSettleRecBillProvider
extends AbstractSettleBillProvider {
    protected ManualSettleRecedBillProvider recedProvider;

    public ManualSettleRecBillProvider(ManualProviderParam param) {
        super(param);
    }

    @Override
    public FilterCondition getDefaultFilter() {
        DynamicObject currency;
        FilterCondition fc = new FilterCondition();
        ArrayList<SimpleFilterRow> rows = new ArrayList<SimpleFilterRow>();
        SimpleFilterRow bizDateRow = new SimpleFilterRow();
        bizDateRow.setCompareType("63");
        bizDateRow.setFieldName("bizdate");
        bizDateRow.setLogic("0");
        ArrayList<FilterValue> dateValues = new ArrayList<FilterValue>();
        FilterValue dateValue = new FilterValue();
        dateValue.setValue((Object)"");
        dateValues.add(dateValue);
        bizDateRow.setValue(dateValues);
        rows.add(bizDateRow);
        fc.setFilterRow(rows);
        SimpleFilterRow asstActTypeRow = new SimpleFilterRow();
        asstActTypeRow.setCompareType("105");
        asstActTypeRow.setFieldName("itempayertype");
        asstActTypeRow.setLogic("0");
        ArrayList<FilterValue> asstActTypeValues = new ArrayList<FilterValue>();
        FilterValue asstActTypeValue = new FilterValue();
        asstActTypeValue.setValue((Object)"bd_customer");
        asstActTypeValues.add(asstActTypeValue);
        asstActTypeRow.setValue(asstActTypeValues);
        rows.add(asstActTypeRow);
        SimpleFilterRow asstActRow = new SimpleFilterRow();
        asstActRow.setCompareType("800");
        asstActRow.setFieldName("itempayer.name");
        asstActRow.setLogic("0");
        rows.add(asstActRow);
        if (this.orgPk != null && (currency = this.getStandardCurrency("cas_cashmgtinit")) != null) {
            SimpleFilterRow currencyRow = new SimpleFilterRow();
            currencyRow.setCompareType("67");
            currencyRow.setFieldName("currency.name");
            currencyRow.setLogic("0");
            ArrayList<FilterValue> currencyValues = new ArrayList<FilterValue>();
            FilterValue currencyValue = new FilterValue();
            currencyValue.setValue((Object)currency.getString("name"));
            currencyValues.add(currencyValue);
            currencyRow.setValue(currencyValues);
            rows.add(currencyRow);
        }
        return fc;
    }

    @Override
    public List<String> getSelector(boolean totalDisplay) {
        List<String> selector = super.getSelector(totalDisplay);
        selector.add("id");
        selector.add("billno");
        selector.add("bizdate");
        selector.add("'" + this.getEntityNumber() + "' billtype");
        selector.add("payertype asstacttype");
        selector.add("itempayer asstact");
        selector.add("payertype asstacttypeenum");
        selector.add("payername asstactname");
        selector.add("currency");
        selector.add("quotation");
        selector.add("exchangerate");
        if (totalDisplay) {
            selector.add("receivingtype receivetype");
            selector.add("receivingtype paymenttype");
            selector.add("entry.e_actamt pricetaxtotal");
            selector.add("entry.id entryid");
            selector.add("0 e_pricetaxtotal");
            selector.add("entry.e_unsettledamt unsettleamt");
            selector.add("entry.e_unsettledamt enableamt");
            selector.add("entry.e_unsettledamt cursettleamt");
        } else {
            selector.add("0 pricetaxtotal");
            selector.add("entry.e_receivingtype receivetype");
            selector.add("entry.e_receivingtype paymenttype");
            selector.add("entry.id entryid");
            selector.add("entry.e_material material");
            selector.add("entry.e_expenseitem expenseitem");
            selector.add("entry.e_actamt e_pricetaxtotal");
            selector.add("entry.e_unsettledamt unsettleamt");
            selector.add("entry.e_unsettledamt enableamt");
            selector.add("entry.e_unsettledamt cursettleamt");
            selector.add("entry.e_corebillno corebillno");
        }
        return selector;
    }

    @Override
    public QFilter getQueryFilter(QFilter gridFilter) {
        QFilter filter = new QFilter("entry.e_settleorg", "=", this.orgPk);
        if (gridFilter != null) {
            filter.and(gridFilter);
        }
        if (SettleRelationEnum.RECCLEARINGSETTLE.getValue().equals(this.param.getSettleRelation())) {
            List<String> asstTypeList = Arrays.asList("bos_org", "other");
            filter.and(new QFilter("payertype", "not in", asstTypeList));
        }
        if (this.asstact != null) {
            if ("payrecsettle".equals(this.param.getSettleRelation()) || "recpaysettle".equals(this.param.getSettleRelation())) {
                filter.and("payername", "=", (Object)this.asstact.getString("name"));
            } else {
                filter.and("itempayer", "in", BaseDataHelper.getBaseDataIds(this.asstact.getDataEntityType().getName(), this.asstact.getLong("masterid")));
            }
        }
        String sign = this.filterType == 0 ? "<>" : (this.filterType == 1 ? ">" : "<");
        filter.and("billstatus", "=", (Object)"D").and("entry.e_receivingtype.ispartreceivable", "=", (Object)Boolean.TRUE).and("entry.e_unsettledamt", sign, (Object)0);
        return filter;
    }

    @Override
    public List<Object[]> getBillDataRows(boolean totalDisplay, QFilter gridFilter) {
        List<Object[]> recRows = super.getBillDataRows(totalDisplay, gridFilter);
        if (!SettleRelationEnum.APRECSETTLE.getValue().equals(this.param.getSettleRelation())) {
            if (this.recedProvider == null) {
                this.recedProvider = new ManualSettleRecedBillProvider(this.param);
            }
            List<Object[]> recedRows = this.recedProvider.getBillDataRows(totalDisplay, gridFilter);
            recRows.addAll(recedRows);
        }
        return recRows;
    }

    @Override
    public LocaleString getAmtColumnName() {
        return new LocaleString(ResManager.loadKDString((String)"\u6536\u6b3e\u91d1\u989d", (String)"ManualSettleRecBillProvider_0", (String)"fi-arapcommon", (Object[])new Object[0]));
    }

    @Override
    public String getEntityNumber() {
        return "cas_recbill";
    }

    @Override
    public FilterCondition getServletFilter(DynamicObject finarbill) {
        return null;
    }
}

