/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.manualsettle;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.service.ext.SettleExtDataFilterKeyVO;
import kd.fi.arapcommon.service.ext.SettleExtDataLoader;
import kd.fi.arapcommon.service.manualsettle.AbstractSettleBillProvider;
import kd.fi.arapcommon.service.manualsettle.ManualProviderParam;

public class ManualSettleRecedBillProvider
extends AbstractSettleBillProvider {
    public ManualSettleRecedBillProvider(ManualProviderParam param) {
        super(param);
    }

    @Override
    public List<String> getFilterFieldKeys() {
        return null;
    }

    @Override
    public FilterCondition getDefaultFilter() {
        return null;
    }

    @Override
    public List<String> getSelector(boolean totalDisplay) {
        List<String> selector = super.getSelector(totalDisplay);
        selector.add("id");
        selector.add("billno");
        selector.add("bizdate");
        selector.add("rectype paymenttype");
        selector.add("'" + this.getEntityNumber() + "' billtype");
        selector.add("asstacttype");
        selector.add("asstact");
        selector.add("asstacttype asstacttypeenum");
        selector.add("asstact.name asstactname");
        selector.add("currency");
        selector.add("quotation");
        selector.add("exchangerate");
        if (totalDisplay) {
            selector.add("entry.e_amount pricetaxtotal");
            selector.add("entry.id entryid");
            selector.add("0 e_pricetaxtotal");
            selector.add("entry.e_unsettledamt unsettleamt");
            selector.add("entry.e_unsettledamt enableamt");
            selector.add("entry.e_unsettledamt cursettleamt");
        } else {
            selector.add("0 pricetaxtotal");
            selector.add("entry.id entryid");
            selector.add("entry.e_material material");
            selector.add("entry.e_expenseitem expenseitem");
            selector.add("entry.e_amount e_pricetaxtotal");
            selector.add("entry.e_unsettledamt unsettleamt");
            selector.add("entry.e_unsettledamt enableamt");
            selector.add("entry.e_unsettledamt cursettleamt");
            selector.add("entry.e_corebillno corebillno");
        }
        return selector;
    }

    @Override
    public QFilter getQueryFilter(QFilter gridFilter) {
        QFilter filter = new QFilter("org", "=", this.orgPk);
        if (gridFilter != null) {
            filter.and(gridFilter);
        }
        if (this.asstact != null) {
            filter.and("asstact", "in", BaseDataHelper.getBaseDataIds(this.asstact.getDataEntityType().getName(), this.asstact.getLong("masterid")));
        }
        this.replaceFilterProp("txt_description", "description", filter);
        this.replaceFilterProp("itempayertype", "asstacttype", filter);
        this.replaceFilterPropForMulti("itempayer", "asstact", filter);
        this.replaceFilterProp("actrecamt", "recamount", filter);
        this.replaceFilterProp("entry.e_unlockamt", "entry.e_unsettledamt", filter);
        this.replaceFilterProp("entry.e_settleorg", "org", filter);
        List<SettleExtDataFilterKeyVO> vos = SettleExtDataLoader.loadManualSettleFilterInfo("cas_recbill");
        for (SettleExtDataFilterKeyVO vo : vos) {
            String matchFieldKey = vo.getMatchFieldKey();
            if (!StringUtils.isNotEmpty((String)matchFieldKey)) continue;
            String filedKey = vo.getFiledKey().split("\\.")[0];
            DynamicProperty property = EntityMetadataCache.getDataEntityType((String)"cas_recbill").getProperty(filedKey);
            filedKey = vo.getFiledKey();
            if (property == null) {
                filedKey = "entry." + filedKey;
            }
            this.replaceFilterProp(filedKey, matchFieldKey, filter);
        }
        String sign = this.filterType == 0 ? "<>" : (this.filterType == 1 ? ">" : "<");
        filter.and("billstatus", "=", (Object)"C").and("rectype.ispartreceivable", "=", (Object)Boolean.TRUE).and("entry.e_unsettledamt", sign, (Object)0);
        return filter;
    }

    @Override
    public LocaleString getAmtColumnName() {
        return null;
    }

    @Override
    public String getEntityNumber() {
        return "ar_receivedbill";
    }

    @Override
    public FilterCondition getServletFilter(DynamicObject finarbill) {
        return null;
    }
}

