/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.plan;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.dev.beanfactory.Scope;
import kd.fi.arapcommon.dev.beanfactory.Service;

@Service(scope=Scope.Singleton)
public class PlanRowDataCalculator {
    private static final Log log = LogFactory.getLog(PlanRowDataCalculator.class);

    public List<Map<String, Object>> getPayPlanData(DynamicObject condition, Date billDate, BigDecimal totalAmount, int precision) {
        if (condition == null) {
            return null;
        }
        Object[] args = new Object[]{condition.getLong("id"), billDate, totalAmount, precision};
        String conditionType = condition.getDynamicObjectType().getName();
        log.info("\u83b7\u53d6\u4ed8\u6b3e\u8ba1\u5212\u5206\u5f55\u6570\u636e\u7684\u63a5\u53e3\u53c2\u6570:-->" + Arrays.toString(args));
        DynamicObject dyn = BusinessDataServiceHelper.loadSingleFromCache((Object)condition.getLong("id"), (String)conditionType);
        if (dyn == null) {
            log.info("\u83b7\u53d6\u4ed8\u6b3e\u8ba1\u5212\u5206\u5f55\u6570\u636e\u7684\u63a5\u53e3\u53c2\u6570\u4ed8\u6b3e\u6761\u4ef6ID(payConditionId)\u4e0d\u5b58\u5728");
            return null;
        }
        log.info("\u83b7\u53d6\u4ed8\u6b3e\u8ba1\u5212\u5206\u5f55\u6570\u636e\u7684\u63a5\u53e3\u53c2\u6570\u4ed8\u6b3e\u6761\u4ef6ID\u83b7\u53d6\u7684\u4ed8\u6b3e\u6761\u4ef6:-->" + dyn);
        String basis = dyn.getString("basis");
        DynamicObjectCollection entrys = dyn.getDynamicObjectCollection("entry");
        if (entrys == null || entrys.size() == 0) {
            log.info("\u6839\u636e\u53c2\u6570\u83b7\u53d6\u7684\u4ed8\u6b3e\u6761\u4ef6\u6ca1\u6709\u5206\u5f55\u660e\u7ec6");
            return null;
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(64);
        for (int i = 0; i < entrys.size(); ++i) {
            Map data;
            Map detail;
            HashMap confirmTypeJson;
            HashMap<String, Object> map = new HashMap<String, Object>();
            DynamicObject entry = (DynamicObject)entrys.get(i);
            DynamicObject itemName = entry.getDynamicObject("itemname");
            BigDecimal rate = entry.getBigDecimal("rate");
            BigDecimal amount = entry.getBigDecimal("amount");
            boolean ispre = entry.getBoolean("ispre");
            IDataEntityType entityType = dyn.getDataEntityType();
            Map types = ((MainEntityType)entityType).getAllEntities();
            EntityType type = (EntityType)types.get("entry");
            if (type != null) {
                Map fields = type.getFields();
                for (Map.Entry field : fields.entrySet()) {
                    if (!"isretention".equals(field.getKey())) continue;
                    boolean isretention = entry.getBoolean("isretention");
                    map.put("isretention", isretention);
                    break;
                }
            }
            String confirmType = entry.getString("confirmtype");
            String confirmTypeData = entry.getString("confirmtypedata");
            map.put("itemname", itemName == null ? null : itemName.getPkValue());
            map.put("ispre", ispre);
            if ("A".equals(basis)) {
                map.put("rate", rate);
                if (rate != null && totalAmount != null) {
                    map.put("amount", totalAmount.multiply(rate).divide(new BigDecimal(100)).setScale(precision, RoundingMode.HALF_UP));
                } else {
                    map.put("amount", null);
                }
            } else if ("B".equals(basis)) {
                map.put("amount", amount);
                if (amount != null && totalAmount != null && totalAmount.compareTo(BigDecimal.ZERO) != 0) {
                    map.put("rate", amount.divide(totalAmount, 4, 4).multiply(new BigDecimal(100)));
                } else {
                    map.put("rate", null);
                }
            }
            Date date = null;
            HashMap hashMap = confirmTypeJson = StringUtils.isBlank((CharSequence)confirmTypeData) ? null : (HashMap)SerializationUtils.fromJsonString((String)confirmTypeData, Map.class);
            if (billDate != null && confirmTypeJson != null && StringUtils.isNotBlank((CharSequence)confirmType) && (detail = (Map)confirmTypeJson.get("DETAIL")) != null && (data = (Map)detail.get("DATA")) != null) {
                switch (confirmType) {
                    case "A": {
                        date = billDate;
                        break;
                    }
                    case "B": {
                        int odmonth = (Integer)data.get("odmonth");
                        int odday = (Integer)data.get("odday");
                        Calendar c = Calendar.getInstance();
                        c.setTime(billDate);
                        c.add(2, odmonth);
                        c.add(5, odday);
                        date = c.getTime();
                        break;
                    }
                    case "C": {
                        int actualMaximum;
                        int settleDay = (Integer)data.get("monsettlementday");
                        int monodmonth = (Integer)data.get("monodmonth");
                        int monodday = (Integer)data.get("monodday");
                        Calendar c1 = Calendar.getInstance();
                        c1.setTime(billDate);
                        c1.add(2, monodmonth);
                        c1.add(5, monodday);
                        int day1 = c1.get(5);
                        if (settleDay < day1) {
                            c1.add(2, 1);
                        }
                        if (settleDay <= (actualMaximum = c1.getActualMaximum(5))) {
                            c1.set(5, settleDay);
                        } else {
                            c1.set(5, actualMaximum);
                        }
                        date = c1.getTime();
                        break;
                    }
                    case "D": {
                        break;
                    }
                }
            }
            map.put("date", date);
            list.add(map);
        }
        log.info("\u83b7\u53d6\u4ed8\u6b3e\u8ba1\u5212\u5206\u5f55\u6570\u636e\u7684\u63a5\u53e3\u7684\u8fd4\u56de\u503c\uff1a-->" + list);
        return list;
    }
}

