/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.plan.split;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.model.BillModel;
import kd.fi.arapcommon.model.BillModelFactory;
import kd.fi.arapcommon.service.plan.split.PlanSplitService;
import kd.fi.arapcommon.service.plan.split.entity.DetailGroupData;
import kd.fi.arapcommon.service.plan.split.entity.PlanRowData;
import kd.fi.arapcommon.service.plan.split.helper.PlanSplitSchemeServiceHelper;
import kd.fi.arapcommon.service.plan.split.helper.PlanSplitServiceHelper;
import kd.fi.arapcommon.util.StdConfig;

public class PlanSplitAndFiller {
    public static void splitAndFill(IFormView view) {
        Map<String, String> dimensionMap;
        IDataModel model = view.getModel();
        model.beginInit();
        DynamicObject dataEntity = model.getDataEntity(true);
        String entityName = dataEntity.getDataEntityType().getName();
        BillModel billModel = BillModelFactory.getModel(entityName);
        DynamicObject splitScheme = (DynamicObject)model.getValue(billModel.HEAD_SPLITSCHEME);
        ArrayList<String> dimensions = new ArrayList<String>(8);
        HashMap<String, String> dimensionMappings = new HashMap<String, String>(8);
        DynamicObject org = (DynamicObject)model.getValue(billModel.HEAD_ORG);
        if (org == null) {
            return;
        }
        long orgId = (Long)org.getPkValue();
        boolean isPlanSettle = SystemParameterHelper.isPlanSettle(orgId, "ar_finarbill".equals(entityName));
        boolean allowMaterialSplitPlanEntry = PlanSplitServiceHelper.allowMaterialSplitPlanEntry();
        if (!isPlanSettle) {
            if (allowMaterialSplitPlanEntry) {
                if (PlanSplitServiceHelper.isSplitByCoreBill()) {
                    dimensions.add(billModel.E_COREBILLNO);
                    dimensions.add(billModel.E_COREBILLID);
                    dimensionMappings.put(billModel.E_COREBILLNO, billModel.P_COREBILLNO);
                    dimensionMappings.put(billModel.E_COREBILLID, billModel.P_COREBILLID);
                }
                if (splitScheme != null) {
                    dimensionMap = PlanSplitSchemeServiceHelper.getDimensionMapBySchemeId(splitScheme.getLong("id"), splitScheme.getDynamicObjectType());
                    dimensions.addAll(dimensionMap.keySet());
                    dimensionMappings.putAll(dimensionMap);
                }
            } else {
                model.setValue(billModel.HEAD_SPLITSCHEME, null);
            }
        } else {
            if (PlanSplitServiceHelper.isSplitByCoreBill()) {
                dimensions.add(billModel.E_COREBILLNO);
                dimensions.add(billModel.E_COREBILLID);
                dimensionMappings.put(billModel.E_COREBILLNO, billModel.P_COREBILLNO);
                dimensionMappings.put(billModel.E_COREBILLID, billModel.P_COREBILLID);
            }
            if (splitScheme != null) {
                dimensionMap = PlanSplitSchemeServiceHelper.getDimensionMapBySchemeId(splitScheme.getLong("id"), splitScheme.getDynamicObjectType());
                dimensions.addAll(dimensionMap.keySet());
                dimensionMappings.putAll(dimensionMap);
            }
        }
        PlanSplitService splitService = new PlanSplitService(dataEntity, dimensions);
        List<PlanRowData> planRowDatas = splitService.execute();
        int currentPlanRowCount = model.getEntryRowCount(billModel.P_ENTRY);
        int diffRowCount = planRowDatas.size() - currentPlanRowCount;
        if (diffRowCount > 0) {
            model.batchCreateNewEntryRow(billModel.P_ENTRY, diffRowCount);
        } else if (diffRowCount < 0) {
            int[] deleteRowIndexs = new int[Math.abs(diffRowCount)];
            for (int i = 0; i < Math.abs(diffRowCount); ++i) {
                deleteRowIndexs[i] = currentPlanRowCount - i - 1;
            }
            model.deleteEntryRows(billModel.P_ENTRY, deleteRowIndexs);
        }
        DynamicObject settlementType = (DynamicObject)model.getValue(billModel.HEAD_SETTLEMENTTYPE);
        Long settleTypeId = settlementType == null ? 0L : settlementType.getLong("id");
        int size = planRowDatas.size();
        for (int i = 0; i < size; ++i) {
            PlanRowData planRowData = planRowDatas.get(i);
            DetailGroupData groupData = planRowData.getGroupData();
            Map<String, Object> dimensionMap2 = groupData.getDimensionMap();
            for (Map.Entry dimensionMapping : dimensionMappings.entrySet()) {
                String detailKey = (String)dimensionMapping.getKey();
                String planKey = (String)dimensionMapping.getValue();
                Object dimensionValue = dimensionMap2.get(detailKey);
                model.setValue(planKey, dimensionValue, i);
            }
            BigDecimal priceTaxTotal = groupData.getPriceTaxTotal();
            model.setValue(billModel.P_PLANPRICETAX, (Object)priceTaxTotal, i);
            model.setValue(billModel.P_UNPLANLOCKAMT, (Object)priceTaxTotal, i);
            model.setValue(billModel.P_UNPLANSETTLEAMT, (Object)priceTaxTotal, i);
            BigDecimal priceTaxTotalLocal = groupData.getPriceTaxTotalLocal();
            model.setValue(billModel.P_PLANPRICETAXLOC, (Object)priceTaxTotalLocal, i);
            model.setValue(billModel.P_UNPLANSETTLELOCAMT, (Object)priceTaxTotalLocal, i);
            model.setValue(billModel.P_PLANDUEDATE, (Object)planRowData.getDueDate(), i);
            if (model.getValue(billModel.P_PLANSETTLETYPE, i) == null) {
                model.setValue(billModel.P_PLANSETTLETYPE, (Object)settleTypeId, i);
            }
            model.setValue(billModel.P_RECORPAY_RATE, (Object)planRowData.getRate(), i);
            model.setValue(billModel.P_SPLITDIMENSION_ID, (Object)groupData.getSplitDimensionId(), i);
        }
        HashMap<Integer, Boolean> isUpdateSplitDimensionId = new HashMap<Integer, Boolean>(8);
        int detailEntrySize = model.getEntryRowCount(billModel.ENTRY);
        if (dimensions.size() == 0) {
            for (int i = 0; i < detailEntrySize; ++i) {
                Object oldValue = model.getValue(billModel.E_SPLITDIMENSION_ID, i);
                Integer newValue = 0;
                if (oldValue == null || oldValue.equals(newValue)) continue;
                model.setValue(billModel.E_SPLITDIMENSION_ID, (Object)newValue, i);
                isUpdateSplitDimensionId.put(i, Boolean.TRUE);
            }
        } else {
            Map<Integer, Integer> detailEntryToSplitDimensionId = PlanRowData.convertDetailSplitDimension(planRowDatas);
            for (int i = 0; i < detailEntrySize; ++i) {
                Object oldValue = model.getValue(billModel.E_SPLITDIMENSION_ID, i);
                Integer newValue = detailEntryToSplitDimensionId.get(i);
                if (oldValue == null || oldValue.equals(newValue)) continue;
                model.setValue(billModel.E_SPLITDIMENSION_ID, (Object)newValue, i);
                isUpdateSplitDimensionId.put(i, Boolean.TRUE);
            }
        }
        model.endInit();
        if (!isPlanSettle && !allowMaterialSplitPlanEntry) {
            view.updateView(billModel.HEAD_SPLITSCHEME);
        }
        view.updateView(billModel.P_ENTRY);
        for (int i = 0; i < detailEntrySize; ++i) {
            if (isUpdateSplitDimensionId.get(i) == null || !((Boolean)isUpdateSplitDimensionId.get(i)).booleanValue()) continue;
            view.updateView(billModel.E_SPLITDIMENSION_ID, i);
        }
    }

    public static void calAmountPlanForView(IFormView view, int rowIndex) {
        String isAutoCreatePlanEntry = StdConfig.get("isAutoCreatePlanEntry");
        if ("false".equals(isAutoCreatePlanEntry)) {
            return;
        }
        IDataModel model = view.getModel();
        DynamicObject finBill = view.getModel().getDataEntity(true);
        BigDecimal hundred = new BigDecimal(100);
        String entityName = finBill.getDataEntityType().getName();
        BillModel billModel = BillModelFactory.getModel(entityName);
        DynamicObjectCollection firstPlanEntry = finBill.getDynamicObjectCollection(billModel.P_ENTRY);
        DynamicObjectCollection detailEntrys = finBill.getDynamicObjectCollection(billModel.ENTRY);
        int p_splitdimensionid = ((DynamicObject)firstPlanEntry.get(rowIndex)).getInt("p_splitdimensionid");
        DynamicObjectCollection firstDimePlanEntry = PlanSplitAndFiller.getPlanEntrysBySplitdimensionid(firstPlanEntry, p_splitdimensionid);
        if (firstDimePlanEntry.isEmpty()) {
            return;
        }
        BigDecimal totalAllAmount = BigDecimal.ZERO;
        BigDecimal totalAllAmountloc = BigDecimal.ZERO;
        for (DynamicObject detailEntry : detailEntrys) {
            int e_splitdimensionid = detailEntry.getInt("e_splitdimensionid");
            if (e_splitdimensionid != p_splitdimensionid) continue;
            totalAllAmount = totalAllAmount.add(detailEntry.getBigDecimal(billModel.E_PRICETAXTOTAL));
            totalAllAmountloc = totalAllAmountloc.add(detailEntry.getBigDecimal(billModel.E_PRICETAXTOTALLOC));
        }
        boolean isPayRate = finBill.getBoolean(billModel.HEAD_ISBYRECORPAY_RATE);
        if (isPayRate) {
            BigDecimal rateTotal = BigDecimal.ZERO;
            for (DynamicObject entry : firstDimePlanEntry) {
                BigDecimal rate = entry.getBigDecimal(billModel.P_RECORPAY_RATE);
                rateTotal = rateTotal.add(rate);
            }
            BigDecimal currentRowIndexRate = (BigDecimal)model.getValue(billModel.P_RECORPAY_RATE, rowIndex);
            if (rateTotal.compareTo(hundred) < 0 && currentRowIndexRate.compareTo(BigDecimal.ZERO) > 0) {
                int i = model.insertEntryRow(billModel.P_ENTRY, rowIndex + 1);
                MainEntityType entityType = model.getDataEntityType();
                EntityType type = (EntityType)entityType.getAllEntities().get(billModel.P_ENTRY);
                Set planEntryFields = type.getFields().keySet();
                model.beginInit();
                for (String field : planEntryFields) {
                    model.setValue(field, model.getValue(field, rowIndex), i);
                }
                model.setValue(billModel.P_RECORPAY_RATE, (Object)hundred.subtract(rateTotal), i);
                model.endInit();
                rateTotal = hundred;
            } else if (rateTotal.compareTo(hundred) > 0) {
                String fieldName = model.getProperty(billModel.P_RECORPAY_RATE).getDisplayName().getLocaleValue();
                String entryName = model.getProperty(billModel.P_ENTRY).getDisplayName().getLocaleValue();
                view.showTipNotification(ResManager.loadKDString((String)"\u76f8\u540c\u62c6\u5206\u7ef4\u5ea6\u7684%1$s\u884c%2$s\u4e4b\u548c\u4e0d\u5141\u8bb8\u5927\u4e8e100%%\u3002", (String)"PlanSplitAndFiller_0", (String)"fi-arapcommon", (Object[])new Object[]{entryName, fieldName}), Integer.valueOf(5000));
            }
            DynamicObjectCollection secondPlanEntry = finBill.getDynamicObjectCollection(billModel.P_ENTRY);
            DynamicObjectCollection secondDimePlanEntry = PlanSplitAndFiller.getPlanEntrysBySplitdimensionid(secondPlanEntry, p_splitdimensionid);
            PlanSplitAndFiller.reCaculatePayPlanEntryByRate(secondDimePlanEntry, rateTotal, totalAllAmount, totalAllAmountloc, finBill);
        } else {
            BigDecimal currentDimeTotalAmount = BigDecimal.ZERO;
            BigDecimal currentDimeTotalAmountLoc = BigDecimal.ZERO;
            for (DynamicObject entry : firstDimePlanEntry) {
                currentDimeTotalAmount = currentDimeTotalAmount.add(entry.getBigDecimal(billModel.P_PLANPRICETAX));
                currentDimeTotalAmountLoc = currentDimeTotalAmountLoc.add(entry.getBigDecimal(billModel.P_PLANPRICETAXLOC));
            }
            if (currentDimeTotalAmount.abs().compareTo(totalAllAmount.abs()) < 0) {
                int i = model.insertEntryRow(billModel.P_ENTRY, rowIndex + 1);
                MainEntityType entityType = model.getDataEntityType();
                EntityType type = (EntityType)entityType.getAllEntities().get(billModel.P_ENTRY);
                Set planEntryFields = type.getFields().keySet();
                model.beginInit();
                for (String field : planEntryFields) {
                    model.setValue(field, model.getValue(field, rowIndex), i);
                }
                model.setValue(billModel.P_PLANPRICETAX, (Object)totalAllAmount.subtract(currentDimeTotalAmount), i);
                model.setValue(billModel.P_UNPLANLOCKAMT, (Object)totalAllAmount.subtract(currentDimeTotalAmount), i);
                model.setValue(billModel.P_UNPLANSETTLEAMT, (Object)totalAllAmount.subtract(currentDimeTotalAmount), i);
                BigDecimal diffLocPriceTaxToatalAmt = totalAllAmountloc.subtract(currentDimeTotalAmountLoc);
                if (diffLocPriceTaxToatalAmt.multiply(totalAllAmountloc).compareTo(BigDecimal.ZERO) > 0) {
                    model.setValue(billModel.P_PLANPRICETAXLOC, (Object)diffLocPriceTaxToatalAmt, i);
                    model.setValue(billModel.P_UNPLANSETTLELOCAMT, (Object)diffLocPriceTaxToatalAmt, i);
                } else {
                    model.setValue(billModel.P_PLANPRICETAXLOC, (Object)BigDecimal.ZERO, i);
                    model.setValue(billModel.P_UNPLANSETTLELOCAMT, (Object)BigDecimal.ZERO, i);
                    BigDecimal upRowLocAmt = (BigDecimal)model.getValue(billModel.P_PLANPRICETAXLOC, i - 1);
                    model.setValue(billModel.P_PLANPRICETAXLOC, (Object)upRowLocAmt.add(diffLocPriceTaxToatalAmt), i - 1);
                    model.setValue(billModel.P_UNPLANSETTLELOCAMT, (Object)upRowLocAmt.add(diffLocPriceTaxToatalAmt), i - 1);
                }
                model.endInit();
            } else if (currentDimeTotalAmount.abs().compareTo(totalAllAmount.abs()) > 0) {
                String fieldName = model.getProperty(billModel.P_PLANPRICETAX).getDisplayName().getLocaleValue();
                String entryName = model.getProperty(billModel.P_ENTRY).getDisplayName().getLocaleValue();
                view.showTipNotification(String.format(ResManager.loadKDString((String)"\u76f8\u540c\u62c6\u5206\u7ef4\u5ea6\u7684%1$s\u884c%2$s\u4e4b\u548c\u4e0d\u5141\u8bb8\u5927\u4e8e\u5bf9\u5e94\u62c6\u5206\u7ef4\u5ea6\u7684\u660e\u7ec6\u884c%3$s\u4e4b\u548c\u3002", (String)"PlanSplitAndFiller_1", (String)"fi-arapcommon", (Object[])new Object[0]), entryName, fieldName, fieldName), Integer.valueOf(5000));
            } else {
                BigDecimal currentPriceTaxLoc = (BigDecimal)model.getValue(billModel.P_PLANPRICETAXLOC, rowIndex);
                model.setValue(billModel.P_PLANPRICETAXLOC, (Object)totalAllAmountloc.subtract(currentDimeTotalAmountLoc.subtract(currentPriceTaxLoc)), rowIndex);
                model.setValue(billModel.P_UNPLANSETTLELOCAMT, (Object)totalAllAmountloc.subtract(currentDimeTotalAmountLoc.subtract(currentPriceTaxLoc)), rowIndex);
            }
            DynamicObjectCollection secondPlanEntry = finBill.getDynamicObjectCollection(billModel.P_ENTRY);
            DynamicObjectCollection secondDimePlanEntry = PlanSplitAndFiller.getPlanEntrysBySplitdimensionid(secondPlanEntry, p_splitdimensionid);
            PlanSplitAndFiller.reCaculatePlanEntryByAmount(secondDimePlanEntry, totalAllAmount, finBill);
        }
        view.updateView(billModel.P_ENTRY);
    }

    private static DynamicObjectCollection getPlanEntrysBySplitdimensionid(DynamicObjectCollection planEntry, int p_splitdimensionid) {
        DynamicObjectCollection dimePlanEntry = new DynamicObjectCollection();
        for (DynamicObject entry : planEntry) {
            if (p_splitdimensionid != entry.getInt("p_splitdimensionid")) continue;
            dimePlanEntry.add((Object)entry);
        }
        return dimePlanEntry;
    }

    private static void reCaculatePlanEntryByAmount(DynamicObjectCollection dimePlanEntry, BigDecimal totalAllAmount, DynamicObject finBill) {
        BigDecimal hundred = new BigDecimal(100);
        int precision = PlanSplitAndFiller.getPrecision(finBill);
        String entityName = finBill.getDataEntityType().getName();
        BillModel billModel = BillModelFactory.getModel(entityName);
        BigDecimal amountTotal = BigDecimal.ZERO;
        for (DynamicObject entry : dimePlanEntry) {
            BigDecimal amount = entry.getBigDecimal(billModel.P_PLANPRICETAX);
            if (amount == null) continue;
            amount = amount.setScale(precision, RoundingMode.HALF_UP);
            amountTotal = amountTotal.add(amount);
        }
        BigDecimal rateTotal = BigDecimal.ZERO;
        for (int i = 0; i < dimePlanEntry.size(); ++i) {
            BigDecimal rate;
            DynamicObject entry = (DynamicObject)dimePlanEntry.get(i);
            BigDecimal amount = entry.getBigDecimal(billModel.P_PLANPRICETAX);
            if (amountTotal.compareTo(totalAllAmount) == 0 && i == dimePlanEntry.size() - 1) {
                rate = hundred.subtract(rateTotal);
            } else {
                amount = amount.setScale(precision, RoundingMode.HALF_UP);
                rate = totalAllAmount.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : amount.multiply(hundred).divide(totalAllAmount, 2, RoundingMode.HALF_UP);
            }
            rateTotal = rateTotal.add(rate);
            entry.set(billModel.P_RECORPAY_RATE, (Object)rate);
        }
    }

    private static void reCaculatePayPlanEntryByRate(DynamicObjectCollection dimePlanEntry, BigDecimal rateTotal, BigDecimal totalAllAmount, BigDecimal totalAllAmountLoc, DynamicObject finBill) {
        BigDecimal hundred = new BigDecimal(100);
        BigDecimal amountTotal = BigDecimal.ZERO;
        BigDecimal amountTotalLocal = BigDecimal.ZERO;
        int precision = PlanSplitAndFiller.getPrecision(finBill);
        int basePrecision = PlanSplitAndFiller.getBasePrecision(finBill);
        String entityName = finBill.getDataEntityType().getName();
        BillModel billModel = BillModelFactory.getModel(entityName);
        String quotation = finBill.getString(billModel.HEAD_QUOTATION);
        BigDecimal exchange = finBill.getBigDecimal(billModel.HEAD_EXCHANGERATE);
        for (int i = 0; i < dimePlanEntry.size(); ++i) {
            BigDecimal upRowPriceTaxLocal;
            DynamicObject upRowEntry;
            BigDecimal diffPriceTaxTotalLocal;
            BigDecimal priceTaxTotalLocal;
            BigDecimal priceTaxTotal;
            DynamicObject entry = (DynamicObject)dimePlanEntry.get(i);
            BigDecimal rate = entry.getBigDecimal(billModel.P_RECORPAY_RATE);
            if (rate == null || BigDecimal.ZERO.compareTo(rate) == 0) {
                priceTaxTotal = BigDecimal.ZERO;
                priceTaxTotalLocal = BigDecimal.ZERO;
            } else if (rateTotal.compareTo(hundred) == 0 && i == dimePlanEntry.size() - 1) {
                priceTaxTotal = totalAllAmount.subtract(amountTotal);
                diffPriceTaxTotalLocal = totalAllAmountLoc.subtract(amountTotalLocal);
                if (diffPriceTaxTotalLocal.multiply(totalAllAmountLoc).compareTo(BigDecimal.ZERO) > 0) {
                    priceTaxTotalLocal = diffPriceTaxTotalLocal;
                } else {
                    upRowEntry = (DynamicObject)dimePlanEntry.get(i - 1);
                    priceTaxTotalLocal = BigDecimal.ZERO;
                    upRowPriceTaxLocal = upRowEntry.getBigDecimal(billModel.P_PLANPRICETAXLOC);
                    upRowEntry.set(billModel.P_PLANPRICETAXLOC, (Object)upRowPriceTaxLocal);
                    upRowEntry.set(billModel.P_UNPLANSETTLELOCAMT, (Object)upRowPriceTaxLocal);
                }
            } else {
                priceTaxTotal = totalAllAmount.multiply(rate).divide(hundred, precision, RoundingMode.HALF_UP);
                priceTaxTotalLocal = PlanSplitAndFiller.getLocalAmt(priceTaxTotal, quotation, exchange, basePrecision);
                diffPriceTaxTotalLocal = totalAllAmountLoc.subtract(amountTotalLocal);
                if (diffPriceTaxTotalLocal.multiply(totalAllAmountLoc).compareTo(BigDecimal.ZERO) <= 0) {
                    priceTaxTotalLocal = BigDecimal.ZERO;
                    if (i >= 1) {
                        upRowEntry = (DynamicObject)dimePlanEntry.get(i - 1);
                        upRowPriceTaxLocal = upRowEntry.getBigDecimal(billModel.P_PLANPRICETAXLOC);
                        upRowEntry.set(billModel.P_PLANPRICETAXLOC, (Object)upRowPriceTaxLocal);
                        upRowEntry.set(billModel.P_UNPLANSETTLELOCAMT, (Object)upRowPriceTaxLocal);
                    }
                } else if (priceTaxTotalLocal.abs().compareTo(diffPriceTaxTotalLocal.abs()) >= 0) {
                    priceTaxTotalLocal = diffPriceTaxTotalLocal;
                }
            }
            amountTotal = amountTotal.add(priceTaxTotal);
            amountTotalLocal = amountTotalLocal.add(priceTaxTotalLocal);
            entry.set(billModel.P_PLANPRICETAX, (Object)priceTaxTotal);
            entry.set(billModel.P_UNPLANLOCKAMT, (Object)priceTaxTotal);
            entry.set(billModel.P_UNPLANSETTLEAMT, (Object)priceTaxTotal);
            entry.set(billModel.P_PLANPRICETAXLOC, (Object)priceTaxTotalLocal);
            entry.set(billModel.P_UNPLANSETTLELOCAMT, (Object)priceTaxTotalLocal);
        }
    }

    private static int getPrecision(DynamicObject finBill) {
        int precision = 2;
        DynamicObject currency = finBill.getDynamicObject("currency");
        if (!ObjectUtils.isEmpty((Object)currency)) {
            precision = currency.getInt("amtprecision");
        }
        return precision;
    }

    private static int getBasePrecision(DynamicObject finBill) {
        int basePrecision = 2;
        DynamicObject basecurrency = finBill.getDynamicObject("basecurrency");
        if (!ObjectUtils.isEmpty((Object)basecurrency)) {
            basePrecision = basecurrency.getInt("amtprecision");
        }
        return basePrecision;
    }

    private static BigDecimal getLocalAmt(BigDecimal amount, String quotation, BigDecimal exchange, int precision) {
        if (BigDecimal.ZERO.compareTo(exchange) == 0) {
            return amount.multiply(BigDecimal.ZERO).setScale(precision, RoundingMode.HALF_UP);
        }
        if ("1".equals(quotation)) {
            return amount.divide(exchange, precision, RoundingMode.HALF_UP);
        }
        return amount.multiply(exchange).setScale(precision, RoundingMode.HALF_UP);
    }
}

