/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.plan.split.entity;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.fi.arapcommon.service.plan.split.entity.DetailGroupData;

public class PlanRowData {
    private DetailGroupData groupData;
    private BigDecimal rate;
    private Date dueDate;

    public PlanRowData() {
    }

    public PlanRowData(DetailGroupData groupData, Date dueDate) {
        this.groupData = groupData;
        this.dueDate = dueDate;
        this.rate = new BigDecimal("100.00");
    }

    public PlanRowData(DetailGroupData groupData, BigDecimal rate, Date dueDate) {
        this.groupData = groupData;
        this.rate = rate;
        this.dueDate = dueDate;
    }

    public BigDecimal getRate() {
        return this.rate;
    }

    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }

    public DetailGroupData getGroupData() {
        return this.groupData;
    }

    public void setGroupData(DetailGroupData groupData) {
        this.groupData = groupData;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public static Map<Integer, Integer> convertDetailSplitDimension(List<PlanRowData> planRowDatas) {
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>(8);
        for (PlanRowData planRowData : planRowDatas) {
            DetailGroupData groupData = planRowData.getGroupData();
            int splitDimensionId = groupData.getSplitDimensionId();
            List<Integer> detailEntryIndexs = groupData.getDetailEntryIndexs();
            for (Integer detailEntryIndex : detailEntryIndexs) {
                result.put(detailEntryIndex, splitDimensionId);
            }
        }
        return result;
    }
}

